/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.s3;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.hive.containers.HiveMinioDataLake;
import io.trino.plugin.hive.s3.S3HiveQueryRunner;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveS3MinioQueries
extends AbstractTestQueryFramework {
    private HiveMinioDataLake hiveMinioDataLake;
    private String bucketName;

    protected QueryRunner createQueryRunner() throws Exception {
        this.bucketName = "test-hive-minio-queries-" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake = (HiveMinioDataLake)this.closeAfterClass(new HiveMinioDataLake(this.bucketName));
        this.hiveMinioDataLake.start();
        return ((S3HiveQueryRunner.Builder)((Object)S3HiveQueryRunner.builder(this.hiveMinioDataLake).setHiveProperties((Map<String, String>)ImmutableMap.builder().put((Object)"hive.non-managed-table-writes-enabled", (Object)"true").buildOrThrow()))).build();
    }

    @Test
    public void testTableLocationTopOfTheBucket() {
        String bucketName = "test-bucket-" + TestingNames.randomNameSuffix();
        this.hiveMinioDataLake.getMinio().createBucket(bucketName);
        this.hiveMinioDataLake.getMinio().writeFile("We are\nawesome at\nmultiple slashes.".getBytes(StandardCharsets.UTF_8), bucketName, "a_file");
        this.assertQueryFails("CREATE TABLE %s (a varchar) WITH (\n    format='TEXTFILE',\n    external_location='%s'\n)\n".formatted("test_table_top_of_bucket_" + TestingNames.randomNameSuffix(), "s3://" + bucketName), "External location is not a valid file system URI: s3://" + bucketName);
        String location = "s3://%s/".formatted(bucketName);
        String tableName = "test_table_top_of_bucket_%s".formatted(TestingNames.randomNameSuffix());
        String create = "CREATE TABLE %s (a varchar) WITH (format='TEXTFILE', external_location='%s')".formatted(tableName, location);
        this.assertUpdate(create);
        Assertions.assertThat((String)this.getDeclaredTableLocation(tableName)).isEqualTo(location);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE " + tableName))).matches("VALUES VARCHAR 'We are', 'awesome at', 'multiple slashes.'");
        this.assertUpdate("INSERT INTO " + tableName + " VALUES 'Aren''t we?'", 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("TABLE " + tableName))).matches("VALUES VARCHAR 'We are', 'awesome at', 'multiple slashes.', 'Aren''t we?'");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private String getDeclaredTableLocation(String tableName) {
        Object result;
        Pattern locationPattern = Pattern.compile(".*external_location = '(.*?)'.*", 32);
        Matcher matcher = locationPattern.matcher((String)(result = this.computeScalar("SHOW CREATE TABLE " + tableName)));
        if (matcher.find()) {
            String location = matcher.group(1);
            Verify.verify((!matcher.find() ? 1 : 0) != 0, (String)"Unexpected second match", (Object[])new Object[0]);
            return location;
        }
        throw new IllegalStateException("Location not found in: " + String.valueOf(result));
    }

    @Test
    public void testPathContainsSpecialCharacter() {
        String tableName = "test_path_special_character" + TestingNames.randomNameSuffix();
        String location = "s3://%s/%s/".formatted(this.bucketName, tableName);
        this.assertUpdate(String.format("CREATE TABLE %s (id bigint, part varchar) WITH (partitioned_by = ARRAY['part'], external_location='%s')", tableName, location));
        String values = "(1, 'with-hyphen'),(2, 'with.dot'),(3, 'with:colon'),(4, 'with/slash'),(5, 'with\\\\backslashes'),(6, 'with\\backslash'),(7, 'with=equal'),(8, 'with?question'),(9, 'with!exclamation'),(10, 'with%percent'),(11, 'with%%percents'),(12, 'with space')";
        this.assertUpdate("INSERT INTO " + tableName + " VALUES " + values, 12L);
        this.assertQuery("SELECT * FROM " + tableName, "VALUES " + values);
        this.assertUpdate("DROP TABLE " + tableName);
    }
}

