/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.trino.plugin.hive.util.AcidBucketCodec;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestAcidBucketCodec {
    @Test
    public void testGetBucketCodecVersion0() {
        AcidBucketCodec codec = AcidBucketCodec.forBucket((int)0);
        Assertions.assertThat((Comparable)codec).isEqualTo((Object)AcidBucketCodec.V0);
        Assertions.assertThat((int)codec.decodeWriterId(7)).isEqualTo(7);
        Assertions.assertThat((int)codec.decodeStatementId(100)).isEqualTo(0);
        Assertions.assertThat((int)codec.decodeStatementId(-10)).isEqualTo(0);
    }

    @Test
    public void testGetBucketCodecVersion1() {
        AcidBucketCodec codec = AcidBucketCodec.forBucket((int)0x20000000);
        Assertions.assertThat((Comparable)codec).isEqualTo((Object)AcidBucketCodec.V1);
        Assertions.assertThat((int)codec.decodeWriterId(180092928)).isEqualTo(2748);
        Assertions.assertThat((int)codec.decodeStatementId(2748)).isEqualTo(2748);
    }

    @Test
    public void testGetBucketCodecInvalidVersion() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> AcidBucketCodec.forBucket((int)0x60000000)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid bucket 0x60000000. Version=3");
    }
}

