/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.plugin.hive.util.HiveBlockEncodingSerde;
import io.trino.spi.block.Block;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveBlockEncodingSerde {
    @Test
    public void testSerialization() {
        this.testSerialization((Type)BooleanType.BOOLEAN);
        this.testSerialization((Type)TinyintType.TINYINT);
        this.testSerialization((Type)SmallintType.SMALLINT);
        this.testSerialization((Type)IntegerType.INTEGER);
        this.testSerialization((Type)BigintType.BIGINT);
        this.testSerialization((Type)RealType.REAL);
        this.testSerialization((Type)DoubleType.DOUBLE);
        this.testSerialization((Type)DecimalType.createDecimalType((int)7, (int)2));
        this.testSerialization((Type)DecimalType.createDecimalType((int)37, (int)2));
        this.testSerialization((Type)CharType.createCharType((int)10));
        this.testSerialization((Type)VarcharType.createVarcharType((int)10));
        this.testSerialization((Type)VarcharType.createUnboundedVarcharType());
        this.testSerialization((Type)DateType.DATE);
        this.testSerialization((Type)TimeType.createTimeType((int)0));
        this.testSerialization((Type)TimeType.createTimeType((int)3));
        this.testSerialization((Type)TimeType.createTimeType((int)12));
        this.testSerialization((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)0));
        this.testSerialization((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)3));
        this.testSerialization((Type)TimeWithTimeZoneType.createTimeWithTimeZoneType((int)12));
        this.testSerialization((Type)TimestampType.createTimestampType((int)0));
        this.testSerialization((Type)TimestampType.createTimestampType((int)3));
        this.testSerialization((Type)TimestampType.createTimestampType((int)12));
        this.testSerialization((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)0));
        this.testSerialization((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)3));
        this.testSerialization((Type)TimestampWithTimeZoneType.createTimestampWithTimeZoneType((int)12));
    }

    private void testSerialization(Type type) {
        Slice serialized;
        try (DynamicSliceOutput sliceOutput = new DynamicSliceOutput(0);){
            Block block = type.createBlockBuilder(null, 0).build();
            new HiveBlockEncodingSerde().writeBlock((SliceOutput)sliceOutput, block);
            serialized = sliceOutput.slice();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        try (BasicSliceInput input = serialized.getInput();){
            Block read = new HiveBlockEncodingSerde().readBlock((SliceInput)input);
            Assertions.assertThat((int)read.getPositionCount()).isEqualTo(0);
        }
    }
}

