/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metastore.HiveType;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.ErrorCode;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class TestHiveTypeTranslator {
    private static final Map<Type, HiveType> TRANSLATION_MAP = ImmutableMap.builder().put((Object)BigintType.BIGINT, (Object)HiveType.HIVE_LONG).put((Object)IntegerType.INTEGER, (Object)HiveType.HIVE_INT).put((Object)SmallintType.SMALLINT, (Object)HiveType.HIVE_SHORT).put((Object)TinyintType.TINYINT, (Object)HiveType.HIVE_BYTE).put((Object)DoubleType.DOUBLE, (Object)HiveType.HIVE_DOUBLE).put((Object)VarcharType.createVarcharType((int)3), (Object)HiveType.valueOf((String)"varchar(3)")).put((Object)VarcharType.VARCHAR, (Object)HiveType.HIVE_STRING).put((Object)DateType.DATE, (Object)HiveType.HIVE_DATE).put((Object)TimestampType.TIMESTAMP_MILLIS, (Object)HiveType.HIVE_TIMESTAMP).put((Object)DecimalType.createDecimalType((int)5, (int)3), (Object)HiveType.valueOf((String)"decimal(5,3)")).put((Object)VarbinaryType.VARBINARY, (Object)HiveType.HIVE_BINARY).put((Object)new ArrayType((Type)TimestampType.TIMESTAMP_MILLIS), (Object)HiveType.valueOf((String)"array<timestamp>")).put((Object)InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)BooleanType.BOOLEAN.getTypeSignature(), (TypeSignature)VarbinaryType.VARBINARY.getTypeSignature())), (Object)HiveType.valueOf((String)"map<boolean,binary>")).put((Object)RowType.from(List.of(RowType.field((String)"col0", (Type)IntegerType.INTEGER), RowType.field((String)"col1", (Type)VarbinaryType.VARBINARY))), (Object)HiveType.valueOf((String)"struct<col0:int,col1:binary>")).buildOrThrow();

    @Test
    public void testTypeTranslator() {
        TRANSLATION_MAP.forEach(TestHiveTypeTranslator::assertTypeTranslation);
        TestHiveTypeTranslator.assertInvalidTypeTranslation((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarbinaryType.VARBINARY)), StandardErrorCode.NOT_SUPPORTED.toErrorCode(), "Anonymous row type is not supported in Hive. Please give each field a name: row(integer, varbinary)");
    }

    private static void assertTypeTranslation(Type type, HiveType hiveType) {
        Assertions.assertThat((Object)HiveTypeTranslator.toHiveType((Type)type)).isEqualTo((Object)hiveType);
    }

    private static void assertInvalidTypeTranslation(Type type, ErrorCode errorCode, String message) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> HiveTypeTranslator.toHiveType((Type)type)).isInstanceOf(TrinoException.class)).satisfies(new ThrowingConsumer[]{e -> {
            TrinoException trinoException = (TrinoException)e;
            Assertions.assertThat((Object)trinoException.getErrorCode()).isEqualTo((Object)errorCode);
            Assertions.assertThat((Throwable)trinoException).hasMessageContaining(message);
        }});
    }
}

