/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.reflect.Reflection;
import io.trino.hive.thrift.metastore.ThriftHiveMetastore;
import io.trino.plugin.base.util.LoggingInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

public class TestLoggingInvocationHandlerWithHiveMetastore {
    private static final String DURATION_PATTERN = "\\d+(\\.\\d+)?\\w{1,2}";

    @Test
    public void testWithThriftHiveMetastoreClient() throws Exception {
        ArrayList messages = new ArrayList();
        ThriftHiveMetastore.Iface proxy = (ThriftHiveMetastore.Iface)Reflection.newProxy(ThriftHiveMetastore.Iface.class, (InvocationHandler)new LoggingInvocationHandler((Object)TestLoggingInvocationHandlerWithHiveMetastore.dummyThriftHiveMetastoreClient(), messages::add));
        proxy.getTable("some_database", "some_table_name");
        ((AbstractStringAssert)((ObjectAssert)((ListAssert)Assertions.assertThat(messages).hasSize(1)).element(0)).asInstanceOf(InstanceOfAssertFactories.STRING)).matches((CharSequence)"\\QInvocation of getTable(dbname='some_database', tbl_name='some_table_name') succeeded in\\E \\d+(\\.\\d+)?\\w{1,2}");
    }

    private static ThriftHiveMetastore.Iface dummyThriftHiveMetastoreClient() {
        return (ThriftHiveMetastore.Iface)Proxy.newProxyInstance(TestLoggingInvocationHandlerWithHiveMetastore.class.getClassLoader(), new Class[]{ThriftHiveMetastore.Iface.class}, (proxy, method, args) -> null);
    }
}

