/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import io.airlift.units.DataSize;
import io.trino.plugin.hive.util.SizeBasedSplitWeightProvider;
import io.trino.spi.SplitWeight;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestSizeBasedSplitWeightProvider {
    @Test
    public void testSimpleProportions() {
        SizeBasedSplitWeightProvider provider = new SizeBasedSplitWeightProvider(0.01, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE));
        Assertions.assertThat((Object)provider.weightForSplitSizeInBytes(DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes())).isEqualTo((Object)SplitWeight.fromProportion((double)1.0));
        Assertions.assertThat((Object)provider.weightForSplitSizeInBytes(DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes())).isEqualTo((Object)SplitWeight.fromProportion((double)0.5));
        Assertions.assertThat((Object)provider.weightForSplitSizeInBytes(DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes())).isEqualTo((Object)SplitWeight.fromProportion((double)0.25));
    }

    @Test
    public void testMinimumAndMaximumSplitWeightHandling() {
        double minimumWeight = 0.05;
        DataSize targetSplitSize = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
        SizeBasedSplitWeightProvider provider = new SizeBasedSplitWeightProvider(minimumWeight, targetSplitSize);
        Assertions.assertThat((Object)provider.weightForSplitSizeInBytes(1L)).isEqualTo((Object)SplitWeight.fromProportion((double)minimumWeight));
        DataSize largerThanTarget = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
        Assertions.assertThat((Object)provider.weightForSplitSizeInBytes(largerThanTarget.toBytes())).isEqualTo((Object)SplitWeight.standard());
    }

    @Test
    public void testInvalidMinimumWeight() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SizeBasedSplitWeightProvider(1.01, DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("^minimumWeight must be > 0 and <= 1, found: 1\\.01$");
    }

    @Test
    public void testInvalidTargetSplitSize() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new SizeBasedSplitWeightProvider(0.01, DataSize.ofBytes((long)0L))).isInstanceOf(IllegalArgumentException.class)).hasMessageMatching("^targetSplitSize must be > 0, found:.*$");
    }
}

