/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Type;

public class IntegerNumberToDoubleCoercer<F extends Type>
extends TypeCoercer<F, DoubleType> {
    private static final long MIN_EXACT_DOUBLE = -4503599627370496L;
    private static final long MAX_EXACT_DOUBLE = 0xFFFFFFFFFFFFFL;

    public IntegerNumberToDoubleCoercer(F fromType) {
        super(fromType, DoubleType.DOUBLE);
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        long value = this.fromType.getLong(block, position);
        if (IntegerNumberToDoubleCoercer.overflow(value)) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "Cannot read value '%s' as DOUBLE".formatted(value));
        }
        DoubleType.DOUBLE.writeDouble(blockBuilder, (double)value);
    }

    private static boolean overflow(long value) {
        return value < -4503599627370496L || value > 0xFFFFFFFFFFFFFL;
    }
}

