/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import jakarta.validation.constraints.NotNull;

@DefunctConfig(value={"hive.metastore.assume-canonical-partition-keys"})
public class FileHiveMetastoreConfig {
    public static final String VERSION_COMPATIBILITY_CONFIG = "hive.metastore.version-compatibility";
    private String catalogDirectory;
    private VersionCompatibility versionCompatibility = VersionCompatibility.NOT_SUPPORTED;
    private boolean disableLocationChecks;
    private String metastoreUser = "presto";

    @NotNull
    public String getCatalogDirectory() {
        return this.catalogDirectory;
    }

    @Config(value="hive.metastore.catalog.dir")
    @ConfigDescription(value="Hive file-based metastore catalog directory")
    public FileHiveMetastoreConfig setCatalogDirectory(String catalogDirectory) {
        this.catalogDirectory = catalogDirectory;
        return this;
    }

    @NotNull
    public VersionCompatibility getVersionCompatibility() {
        return this.versionCompatibility;
    }

    @Config(value="hive.metastore.version-compatibility")
    public FileHiveMetastoreConfig setVersionCompatibility(VersionCompatibility versionCompatibility) {
        this.versionCompatibility = versionCompatibility;
        return this;
    }

    public boolean isDisableLocationChecks() {
        return this.disableLocationChecks;
    }

    @Config(value="hive.metastore.disable-location-checks")
    public FileHiveMetastoreConfig setDisableLocationChecks(boolean disableLocationChecks) {
        this.disableLocationChecks = disableLocationChecks;
        return this;
    }

    @NotNull
    public String getMetastoreUser() {
        return this.metastoreUser;
    }

    @Config(value="hive.metastore.user")
    @ConfigDescription(value="Hive file-based metastore username for file access")
    public FileHiveMetastoreConfig setMetastoreUser(String metastoreUser) {
        this.metastoreUser = metastoreUser;
        return this;
    }

    public static enum VersionCompatibility {
        NOT_SUPPORTED,
        UNSAFE_ASSUME_COMPATIBILITY;

    }
}

