/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.Singleton;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import com.google.inject.multibindings.ProvidesIntoOptional;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.units.Duration;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.awssdk.v2_2.AwsSdkTelemetry;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.metastore.cache.CachingHiveMetastoreConfig;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.hive.AllowHiveTableRename;
import io.trino.plugin.hive.HideDeltaLakeTables;
import io.trino.plugin.hive.metastore.glue.ForGlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueCache;
import io.trino.plugin.hive.metastore.glue.GlueContext;
import io.trino.plugin.hive.metastore.glue.GlueHiveExecutionInterceptor;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastore;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.glue.InMemoryGlueCache;
import io.trino.spi.NodeManager;
import io.trino.spi.catalog.CatalogName;
import java.net.URI;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.weakref.jmx.guice.ExportBinder;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.GlueClientBuilder;
import software.amazon.awssdk.services.glue.model.ConcurrentModificationException;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.auth.StsWebIdentityTokenFileCredentialsProvider;

public class GlueMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(GlueHiveMetastoreConfig.class);
        binder.bind(GlueHiveMetastoreFactory.class).in(Scopes.SINGLETON);
        binder.bind(GlueHiveMetastore.class).in(Scopes.SINGLETON);
        binder.bind(GlueContext.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(GlueHiveMetastore.class).withGeneratedName();
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(HiveMetastoreFactory.class, RawHiveMetastoreFactory.class)).setDefault().to(GlueHiveMetastoreFactory.class).in(Scopes.SINGLETON);
        binder.bind(Key.get(Boolean.TYPE, AllowHiveTableRename.class)).toInstance((Object)false);
        Multibinder executionInterceptorMultibinder = Multibinder.newSetBinder((Binder)binder, ExecutionInterceptor.class, ForGlueHiveMetastore.class);
        executionInterceptorMultibinder.addBinding().toProvider(TelemetryExecutionInterceptorProvider.class).in(Scopes.SINGLETON);
        executionInterceptorMultibinder.addBinding().to(GlueHiveExecutionInterceptor.class).in(Scopes.SINGLETON);
        ClosingBinder.closingBinder((Binder)binder).registerCloseable(GlueClient.class);
    }

    @ProvidesIntoOptional(value=ProvidesIntoOptional.Type.DEFAULT)
    @Singleton
    public static Set<GlueHiveMetastore.TableKind> getTableKinds(@HideDeltaLakeTables boolean hideDeltaLakeTables) {
        if (hideDeltaLakeTables) {
            return EnumSet.complementOf(EnumSet.of(GlueHiveMetastore.TableKind.DELTA));
        }
        return EnumSet.allOf(GlueHiveMetastore.TableKind.class);
    }

    @Provides
    @Singleton
    public static GlueCache createGlueCache(CachingHiveMetastoreConfig config, CatalogName catalogName, NodeManager nodeManager) {
        Duration metadataCacheTtl = config.getMetastoreCacheTtl();
        Duration statsCacheTtl = config.getStatsCacheTtl();
        boolean enabled = nodeManager.getCurrentNode().isCoordinator() && (metadataCacheTtl.toMillis() > 0L || statsCacheTtl.toMillis() > 0L);
        Preconditions.checkState((boolean)config.isPartitionCacheEnabled(), (Object)"Disabling partitions cache is not supported with Glue v2");
        Preconditions.checkState((boolean)config.isCacheMissing(), (Object)"Disabling cache missing is not supported with Glue v2");
        Preconditions.checkState((boolean)config.isCacheMissingPartitions(), (Object)"Disabling cache missing partitions is not supported with Glue v2");
        Preconditions.checkState((boolean)config.isCacheMissingStats(), (Object)"Disabling cache missing stats is not supported with Glue v2");
        if (enabled) {
            return new InMemoryGlueCache(catalogName, metadataCacheTtl, statsCacheTtl, config.getMetastoreRefreshInterval(), config.getMaxMetastoreRefreshThreads(), config.getMetastoreCacheMaximumSize());
        }
        return GlueCache.NOOP;
    }

    @Provides
    @Singleton
    public static GlueClient createGlueClient(GlueHiveMetastoreConfig config, @ForGlueHiveMetastore Set<ExecutionInterceptor> executionInterceptors) {
        GlueClientBuilder glue = GlueClient.builder();
        glue.overrideConfiguration(builder -> builder.executionInterceptors((List)ImmutableList.copyOf((Collection)executionInterceptors)).retryStrategy(retryBuilder -> retryBuilder.retryOnException(throwable -> throwable instanceof ConcurrentModificationException).backoffStrategy(BackoffStrategy.exponentialDelay((java.time.Duration)java.time.Duration.ofMillis(20L), (java.time.Duration)java.time.Duration.ofMillis(1500L))).maxAttempts(config.getMaxGlueErrorRetries())));
        Optional<StaticCredentialsProvider> staticCredentialsProvider = GlueMetastoreModule.getStaticCredentialsProvider(config);
        if (config.isUseWebIdentityTokenCredentialsProvider()) {
            glue.credentialsProvider((AwsCredentialsProvider)((StsWebIdentityTokenFileCredentialsProvider.Builder)StsWebIdentityTokenFileCredentialsProvider.builder().stsClient(GlueMetastoreModule.getStsClient(config, staticCredentialsProvider)).asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build());
        } else if (config.getIamRole().isPresent()) {
            glue.credentialsProvider((AwsCredentialsProvider)((StsAssumeRoleCredentialsProvider.Builder)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().refreshRequest(request -> request.roleArn(config.getIamRole().get()).roleSessionName("trino-session").externalId((String)config.getExternalId().orElse(null))).stsClient(GlueMetastoreModule.getStsClient(config, staticCredentialsProvider))).asyncCredentialUpdateEnabled(Boolean.valueOf(true))).build());
        } else {
            staticCredentialsProvider.ifPresent(arg_0 -> ((GlueClientBuilder)glue).credentialsProvider(arg_0));
        }
        ApacheHttpClient.Builder httpClient = ApacheHttpClient.builder().maxConnections(Integer.valueOf(config.getMaxGlueConnections()));
        if (config.getGlueEndpointUrl().isPresent()) {
            Preconditions.checkArgument((boolean)config.getGlueRegion().isPresent(), (Object)"Glue region must be set when Glue endpoint URL is set");
            glue.region(Region.of((String)config.getGlueRegion().get()));
            httpClient.proxyConfiguration((ProxyConfiguration)ProxyConfiguration.builder().endpoint(URI.create(config.getGlueEndpointUrl().get())).build());
        } else if (config.getGlueRegion().isPresent()) {
            glue.region(Region.of((String)config.getGlueRegion().get()));
        } else if (config.getPinGlueClientToCurrentRegion()) {
            glue.region(DefaultAwsRegionProviderChain.builder().build().getRegion());
        }
        glue.httpClientBuilder((SdkHttpClient.Builder)httpClient);
        return (GlueClient)glue.build();
    }

    private static Optional<StaticCredentialsProvider> getStaticCredentialsProvider(GlueHiveMetastoreConfig config) {
        if (config.getAwsAccessKey().isPresent() && config.getAwsSecretKey().isPresent()) {
            return Optional.of(StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)config.getAwsAccessKey().get(), (String)config.getAwsSecretKey().get())));
        }
        return Optional.empty();
    }

    private static StsClient getStsClient(GlueHiveMetastoreConfig config, Optional<StaticCredentialsProvider> staticCredentialsProvider) {
        StsClientBuilder sts = StsClient.builder();
        staticCredentialsProvider.ifPresent(arg_0 -> ((StsClientBuilder)sts).credentialsProvider(arg_0));
        if (config.getGlueStsEndpointUrl().isPresent() && config.getGlueStsRegion().isPresent()) {
            ((StsClientBuilder)sts.endpointOverride(URI.create(config.getGlueStsEndpointUrl().get()))).region(Region.of((String)config.getGlueStsRegion().get()));
        } else if (config.getGlueStsRegion().isPresent()) {
            sts.region(Region.of((String)config.getGlueStsRegion().get()));
        } else if (config.getPinGlueClientToCurrentRegion()) {
            sts.region(DefaultAwsRegionProviderChain.builder().build().getRegion());
        }
        return (StsClient)sts.build();
    }

    private static class TelemetryExecutionInterceptorProvider
    implements Provider<ExecutionInterceptor> {
        private final OpenTelemetry openTelemetry;

        @Inject
        public TelemetryExecutionInterceptorProvider(OpenTelemetry openTelemetry) {
            this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
        }

        public ExecutionInterceptor get() {
            return AwsSdkTelemetry.builder((OpenTelemetry)this.openTelemetry).setCaptureExperimentalSpanAttributes(true).setRecordIndividualHttpError(true).build().newExecutionInterceptor();
        }
    }
}

