/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public final class Memoizers {
    private Memoizers() {
    }

    public static <T> UnaryOperator<T> memoizeLast() {
        return new Simple();
    }

    public static <I, O> Function<I, O> memoizeLast(Function<I, O> transform) {
        return new Transforming<I, O>(transform);
    }

    public static <T, U, R> BiFunction<T, U, R> memoizeLast(BiFunction<T, U, R> transform) {
        Objects.requireNonNull(transform, "transform is null");
        Function<Pair, Object> memoized = Memoizers.memoizeLast((I pair) -> transform.apply(pair.first, pair.second));
        return (a, b) -> memoized.apply(new Pair<Object, Object>(a, b));
    }

    private static final class Simple<T>
    implements UnaryOperator<T> {
        private T lastInput;

        private Simple() {
        }

        @Override
        public T apply(T input) {
            if (!Objects.equals(this.lastInput, input)) {
                this.lastInput = input;
            }
            return this.lastInput;
        }
    }

    private static final class Transforming<I, O>
    implements Function<I, O> {
        private final Function<I, O> transform;
        private I lastInput;
        private O lastOutput;
        private boolean inputSeen;

        private Transforming(Function<I, O> transform) {
            this.transform = Objects.requireNonNull(transform, "transform is null");
        }

        @Override
        public O apply(I input) {
            if (!this.inputSeen || !Objects.equals(this.lastInput, input)) {
                this.lastOutput = this.transform.apply(input);
                this.lastInput = input;
                this.inputSeen = true;
            }
            return this.lastOutput;
        }
    }

    private record Pair<T, U>(T first, U second) {
    }
}

