/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.apachehttpclient.v5_2.ApacheHttpClientTelemetry;
import io.trino.plugin.hive.metastore.thrift.MetastoreSupportsDateStatistics;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftHttpMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClient;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import io.trino.spi.NodeManager;
import java.net.URI;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.DefaultHostnameVerifier;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.thrift.transport.THttpClient;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HttpThriftMetastoreClientFactory
implements ThriftMetastoreClientFactory {
    private final int readTimeoutMillis;
    private final String hostname;
    private final Optional<ThriftHttpMetastoreConfig.AuthenticationMode> authenticationMode;
    private final Optional<String> token;
    private final Map<String, String> additionalHeaders;
    private final OpenTelemetry openTelemetry;
    private final AtomicInteger chosenGetTableAlternative = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger chosenGetTableParamAlternative = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger chosenAlterTransactionalTableAlternative = new AtomicInteger(Integer.MAX_VALUE);
    private final AtomicInteger chosenAlterPartitionsAlternative = new AtomicInteger(Integer.MAX_VALUE);

    @Inject
    public HttpThriftMetastoreClientFactory(ThriftHttpMetastoreConfig httpMetastoreConfig, NodeManager nodeManager, OpenTelemetry openTelemetry) {
        this.readTimeoutMillis = Math.toIntExact(httpMetastoreConfig.getReadTimeout().toMillis());
        this.hostname = Objects.requireNonNull(nodeManager.getCurrentNode().getHost(), "hostname is null");
        this.authenticationMode = httpMetastoreConfig.getAuthenticationMode();
        this.token = httpMetastoreConfig.getHttpBearerToken();
        this.additionalHeaders = ImmutableMap.copyOf(httpMetastoreConfig.getAdditionalHeaders());
        this.openTelemetry = Objects.requireNonNull(openTelemetry, "openTelemetry is null");
    }

    @Override
    public ThriftMetastoreClient create(URI uri, Optional<String> delegationToken) throws TTransportException {
        return new ThriftHiveMetastoreClient(() -> this.createHttpTransport(uri), this.hostname, Optional.empty(), new MetastoreSupportsDateStatistics(), false, this.chosenGetTableAlternative, this.chosenGetTableParamAlternative, this.chosenAlterTransactionalTableAlternative, this.chosenAlterPartitionsAlternative);
    }

    private TTransport createHttpTransport(URI uri) throws TTransportException {
        HttpClientBuilder httpClientBuilder = ApacheHttpClientTelemetry.builder((OpenTelemetry)this.openTelemetry).build().newHttpClientBuilder();
        if ("https".equals(uri.getScheme().toLowerCase(Locale.ENGLISH))) {
            DefaultClientTlsStrategy tlsStrategy;
            Preconditions.checkArgument((boolean)this.token.isPresent(), (Object)"'hive.metastore.http.client.bearer-token' must be set while using https metastore URIs in 'hive.metastore.uri'");
            Preconditions.checkArgument((boolean)this.authenticationMode.isPresent(), (Object)"'hive.metastore.http.client.authentication.type' must be set while using http/https metastore URIs in 'hive.metastore.uri'");
            try {
                tlsStrategy = new DefaultClientTlsStrategy(SSLContext.getDefault(), (HostnameVerifier)new DefaultHostnameVerifier());
            }
            catch (NoSuchAlgorithmException e) {
                throw new TTransportException((Throwable)e);
            }
            Registry registry = RegistryBuilder.create().register("https", (Object)tlsStrategy).build();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)BasicHttpClientConnectionManager.create((Lookup)registry));
            httpClientBuilder.addRequestInterceptorFirst((httpRequest, entityDetails, httpContext) -> httpRequest.addHeader("Authorization", (Object)("Bearer " + this.token.get())));
        } else {
            Preconditions.checkArgument((boolean)this.token.isEmpty(), (Object)"'hive.metastore.http.client.bearer-token' must not be set while using http metastore URIs in 'hive.metastore.uri'");
        }
        httpClientBuilder.addRequestInterceptorFirst((httpRequest, entityDetails, httpContext) -> this.additionalHeaders.forEach((arg_0, arg_1) -> ((HttpRequest)httpRequest).addHeader(arg_0, arg_1)));
        httpClientBuilder.setDefaultRequestConfig(RequestConfig.custom().setResponseTimeout((long)this.readTimeoutMillis, TimeUnit.MILLISECONDS).build());
        return new THttpClient(uri.toString(), (HttpClient)httpClientBuilder.build());
    }
}

