/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.trino.orc.OrcColumn;
import io.trino.orc.metadata.OrcType;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.coercions.BooleanCoercer;
import io.trino.plugin.hive.coercions.CoercionUtils;
import io.trino.plugin.hive.coercions.DateCoercer;
import io.trino.plugin.hive.coercions.DecimalCoercers;
import io.trino.plugin.hive.coercions.DoubleToFloatCoercer;
import io.trino.plugin.hive.coercions.DoubleToVarcharCoercers;
import io.trino.plugin.hive.coercions.FloatToDoubleCoercer;
import io.trino.plugin.hive.coercions.FloatToVarcharCoercers;
import io.trino.plugin.hive.coercions.IntegerNumberToDoubleCoercer;
import io.trino.plugin.hive.coercions.IntegerNumberToVarcharCoercer;
import io.trino.plugin.hive.coercions.IntegerNumberUpscaleCoercer;
import io.trino.plugin.hive.coercions.TimestampCoercer;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.coercions.VarbinaryToVarcharCoercers;
import io.trino.plugin.hive.coercions.VarcharToDoubleCoercer;
import io.trino.plugin.hive.coercions.VarcharToFloatCoercer;
import io.trino.plugin.hive.coercions.VarcharToIntegralNumericCoercers;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarcharType;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class OrcTypeTranslator {
    private OrcTypeTranslator() {
    }

    public static Optional<TypeCoercer<? extends Type, ? extends Type>> createCoercer(OrcType fromOrcType, List<OrcColumn> nestedColumns, Type toTrinoType) {
        OrcType.OrcTypeKind fromOrcTypeKind = fromOrcType.getOrcTypeKind();
        if (fromOrcTypeKind == OrcType.OrcTypeKind.BOOLEAN) {
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type type2 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarcharType.class}, (Type)type2, n)) {
                case 0 -> {
                    VarcharType varcharType = (VarcharType)type2;
                    yield Optional.of(new BooleanCoercer.BooleanToVarcharCoercer(varcharType));
                }
                default -> Optional.empty();
            };
        }
        if (fromOrcTypeKind == OrcType.OrcTypeKind.BYTE) {
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type type3 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SmallintType.class, IntegerType.class, BigintType.class, DoubleType.class, DecimalType.class, VarcharType.class}, (Type)type3, n)) {
                case 0 -> {
                    SmallintType smallintType = (SmallintType)type3;
                    yield Optional.of(new IntegerNumberUpscaleCoercer<TinyintType, SmallintType>(TinyintType.TINYINT, smallintType));
                }
                case 1 -> {
                    IntegerType integerType = (IntegerType)type3;
                    yield Optional.of(new IntegerNumberUpscaleCoercer<TinyintType, IntegerType>(TinyintType.TINYINT, integerType));
                }
                case 2 -> {
                    BigintType bigintType = (BigintType)type3;
                    yield Optional.of(new IntegerNumberUpscaleCoercer<TinyintType, BigintType>(TinyintType.TINYINT, bigintType));
                }
                case 3 -> {
                    DoubleType ignored = (DoubleType)type3;
                    yield Optional.of(new IntegerNumberToDoubleCoercer<TinyintType>(TinyintType.TINYINT));
                }
                case 4 -> {
                    DecimalType decimalType = (DecimalType)type3;
                    yield Optional.of(DecimalCoercers.createIntegerNumberToDecimalCoercer(TinyintType.TINYINT, decimalType));
                }
                case 5 -> {
                    VarcharType varcharType = (VarcharType)type3;
                    yield Optional.of(new IntegerNumberToVarcharCoercer<TinyintType>(TinyintType.TINYINT, varcharType));
                }
                default -> Optional.empty();
            };
        }
        if (fromOrcTypeKind == OrcType.OrcTypeKind.SHORT) {
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type type4 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntegerType.class, BigintType.class, DoubleType.class, DecimalType.class, VarcharType.class}, (Type)type4, n)) {
                case 0 -> {
                    IntegerType integerType = (IntegerType)type4;
                    yield Optional.of(new IntegerNumberUpscaleCoercer<SmallintType, IntegerType>(SmallintType.SMALLINT, integerType));
                }
                case 1 -> {
                    BigintType bigintType = (BigintType)type4;
                    yield Optional.of(new IntegerNumberUpscaleCoercer<SmallintType, BigintType>(SmallintType.SMALLINT, bigintType));
                }
                case 2 -> {
                    DoubleType ignored = (DoubleType)type4;
                    yield Optional.of(new IntegerNumberToDoubleCoercer<SmallintType>(SmallintType.SMALLINT));
                }
                case 3 -> {
                    DecimalType decimalType = (DecimalType)type4;
                    yield Optional.of(DecimalCoercers.createIntegerNumberToDecimalCoercer(SmallintType.SMALLINT, decimalType));
                }
                case 4 -> {
                    VarcharType varcharType = (VarcharType)type4;
                    yield Optional.of(new IntegerNumberToVarcharCoercer<SmallintType>(SmallintType.SMALLINT, varcharType));
                }
                default -> Optional.empty();
            };
        }
        if (fromOrcTypeKind == OrcType.OrcTypeKind.INT) {
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type type5 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BigintType.class, DoubleType.class, DecimalType.class, VarcharType.class}, (Type)type5, n)) {
                case 0 -> {
                    BigintType bigintType = (BigintType)type5;
                    yield Optional.of(new IntegerNumberUpscaleCoercer<IntegerType, BigintType>(IntegerType.INTEGER, bigintType));
                }
                case 1 -> {
                    DoubleType ignored = (DoubleType)type5;
                    yield Optional.of(new IntegerNumberToDoubleCoercer<IntegerType>(IntegerType.INTEGER));
                }
                case 2 -> {
                    DecimalType decimalType = (DecimalType)type5;
                    yield Optional.of(DecimalCoercers.createIntegerNumberToDecimalCoercer(IntegerType.INTEGER, decimalType));
                }
                case 3 -> {
                    VarcharType varcharType = (VarcharType)type5;
                    yield Optional.of(new IntegerNumberToVarcharCoercer<IntegerType>(IntegerType.INTEGER, varcharType));
                }
                default -> Optional.empty();
            };
        }
        if (fromOrcTypeKind == OrcType.OrcTypeKind.LONG) {
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type type6 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DoubleType.class, DecimalType.class, VarcharType.class}, (Type)type6, n)) {
                case 0 -> {
                    DoubleType ignored = (DoubleType)type6;
                    yield Optional.of(new IntegerNumberToDoubleCoercer<BigintType>(BigintType.BIGINT));
                }
                case 1 -> {
                    DecimalType decimalType = (DecimalType)type6;
                    yield Optional.of(DecimalCoercers.createIntegerNumberToDecimalCoercer(BigintType.BIGINT, decimalType));
                }
                case 2 -> {
                    VarcharType varcharType = (VarcharType)type6;
                    yield Optional.of(new IntegerNumberToVarcharCoercer<BigintType>(BigintType.BIGINT, varcharType));
                }
                default -> Optional.empty();
            };
        }
        if (fromOrcTypeKind == OrcType.OrcTypeKind.FLOAT) {
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type type7 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DoubleType.class, DecimalType.class, VarcharType.class}, (Type)type7, n)) {
                case 0 -> {
                    DoubleType ignored = (DoubleType)type7;
                    yield Optional.of(new FloatToDoubleCoercer());
                }
                case 1 -> {
                    DecimalType decimalType = (DecimalType)type7;
                    yield Optional.of(DecimalCoercers.createRealToDecimalCoercer(decimalType));
                }
                case 2 -> {
                    VarcharType varcharType = (VarcharType)type7;
                    yield Optional.of(FloatToVarcharCoercers.createFloatToVarcharCoercer(varcharType, true));
                }
                default -> Optional.empty();
            };
        }
        if (fromOrcTypeKind == OrcType.OrcTypeKind.DOUBLE) {
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type type8 = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RealType.class, DecimalType.class, VarcharType.class}, (Type)type8, n)) {
                case 0 -> {
                    RealType ignored = (RealType)type8;
                    yield Optional.of(new DoubleToFloatCoercer());
                }
                case 1 -> {
                    DecimalType decimalType = (DecimalType)type8;
                    yield Optional.of(DecimalCoercers.createDoubleToDecimalCoercer(decimalType));
                }
                case 2 -> {
                    VarcharType varcharType = (VarcharType)type8;
                    yield Optional.of(DoubleToVarcharCoercers.createDoubleToVarcharCoercer(varcharType, true));
                }
                default -> Optional.empty();
            };
        }
        if (fromOrcTypeKind == OrcType.OrcTypeKind.DECIMAL) {
            DecimalType sourceType = DecimalType.createDecimalType((int)((Integer)fromOrcType.getPrecision().orElseThrow()), (int)((Integer)fromOrcType.getScale().orElseThrow()));
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type type9 = type;
            int ignored = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TinyintType.class, SmallintType.class, IntegerType.class, BigintType.class, RealType.class, DoubleType.class, DecimalType.class, VarcharType.class}, (Type)type9, ignored)) {
                case 0 -> {
                    TinyintType tinyintType = (TinyintType)type9;
                    yield Optional.of(DecimalCoercers.createDecimalToInteger(sourceType, tinyintType));
                }
                case 1 -> {
                    SmallintType smallintType = (SmallintType)type9;
                    yield Optional.of(DecimalCoercers.createDecimalToInteger(sourceType, smallintType));
                }
                case 2 -> {
                    IntegerType integerType = (IntegerType)type9;
                    yield Optional.of(DecimalCoercers.createDecimalToInteger(sourceType, integerType));
                }
                case 3 -> {
                    BigintType bigintType = (BigintType)type9;
                    yield Optional.of(DecimalCoercers.createDecimalToInteger(sourceType, bigintType));
                }
                case 4 -> {
                    RealType ignored = (RealType)type9;
                    yield Optional.of(DecimalCoercers.createDecimalToRealCoercer(sourceType));
                }
                case 5 -> {
                    DoubleType ignored = (DoubleType)type9;
                    yield Optional.of(DecimalCoercers.createDecimalToDoubleCoercer(sourceType));
                }
                case 6 -> {
                    DecimalType decimalType = (DecimalType)type9;
                    yield Optional.of(DecimalCoercers.createDecimalToDecimalCoercer(sourceType, decimalType));
                }
                case 7 -> {
                    VarcharType varcharType = (VarcharType)type9;
                    yield Optional.of(DecimalCoercers.createDecimalToVarcharCoercer(sourceType, varcharType));
                }
                default -> Optional.empty();
            };
        }
        if (fromOrcTypeKind == OrcType.OrcTypeKind.DATE) {
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type sourceType = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarcharType.class}, (Type)sourceType, n)) {
                case 0 -> {
                    VarcharType varcharType = (VarcharType)sourceType;
                    yield Optional.of(new DateCoercer.DateToVarcharCoercer(varcharType));
                }
                default -> Optional.empty();
            };
        }
        if (fromOrcTypeKind == OrcType.OrcTypeKind.TIMESTAMP) {
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type sourceType = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DateType.class, VarcharType.class}, (Type)sourceType, n)) {
                case 0 -> {
                    DateType dateType = (DateType)sourceType;
                    yield Optional.of(new TimestampCoercer.LongTimestampToDateCoercer(TimestampType.TIMESTAMP_NANOS, dateType));
                }
                case 1 -> {
                    VarcharType varcharType = (VarcharType)sourceType;
                    yield Optional.of(new TimestampCoercer.LongTimestampToVarcharCoercer(TimestampType.TIMESTAMP_NANOS, varcharType));
                }
                default -> Optional.empty();
            };
        }
        if (OrcTypeTranslator.isVarcharType(fromOrcTypeKind)) {
            Type type = toTrinoType;
            Objects.requireNonNull(type);
            Type sourceType = type;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BooleanType.class, TinyintType.class, SmallintType.class, IntegerType.class, BigintType.class, RealType.class, DoubleType.class, DateType.class, TimestampType.class}, (Type)sourceType, n)) {
                case 0 -> {
                    BooleanType ignored = (BooleanType)sourceType;
                    yield Optional.of(new BooleanCoercer.OrcVarcharToBooleanCoercer(VarcharType.VARCHAR));
                }
                case 1 -> {
                    TinyintType tinyintType = (TinyintType)sourceType;
                    yield Optional.of(new VarcharToIntegralNumericCoercers.OrcVarcharToIntegralNumericCoercer<TinyintType>(VarcharType.VARCHAR, tinyintType));
                }
                case 2 -> {
                    SmallintType smallintType = (SmallintType)sourceType;
                    yield Optional.of(new VarcharToIntegralNumericCoercers.OrcVarcharToIntegralNumericCoercer<SmallintType>(VarcharType.VARCHAR, smallintType));
                }
                case 3 -> {
                    IntegerType integerType = (IntegerType)sourceType;
                    yield Optional.of(new VarcharToIntegralNumericCoercers.OrcVarcharToIntegralNumericCoercer<IntegerType>(VarcharType.VARCHAR, integerType));
                }
                case 4 -> {
                    BigintType bigintType = (BigintType)sourceType;
                    yield Optional.of(new VarcharToIntegralNumericCoercers.OrcVarcharToIntegralNumericCoercer<BigintType>(VarcharType.VARCHAR, bigintType));
                }
                case 5 -> {
                    RealType ignored = (RealType)sourceType;
                    yield Optional.of(new VarcharToFloatCoercer(VarcharType.VARCHAR, true));
                }
                case 6 -> {
                    DoubleType ignored = (DoubleType)sourceType;
                    yield Optional.of(new VarcharToDoubleCoercer(VarcharType.VARCHAR, true));
                }
                case 7 -> {
                    DateType dateType = (DateType)sourceType;
                    yield Optional.of(new DateCoercer.VarcharToDateCoercer(VarcharType.VARCHAR, dateType));
                }
                case 8 -> {
                    TimestampType timestampType = (TimestampType)sourceType;
                    yield Optional.of(timestampType.isShort() ? new TimestampCoercer.VarcharToShortTimestampCoercer(VarcharType.VARCHAR, timestampType) : new TimestampCoercer.VarcharToLongTimestampCoercer(VarcharType.VARCHAR, timestampType));
                }
                default -> Optional.empty();
            };
        }
        if (fromOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.STRUCT && toTrinoType instanceof RowType) {
            RowType rowType = (RowType)toTrinoType;
            ImmutableList.Builder coercersBuilder = ImmutableList.builder();
            ImmutableList.Builder fromField = ImmutableList.builder();
            ImmutableList.Builder toField = ImmutableList.builder();
            List fromStructFieldName = fromOrcType.getFieldNames();
            List toStructFieldNames = (List)rowType.getFields().stream().map(RowType.Field::getName).map(Optional::get).collect(ImmutableList.toImmutableList());
            for (int i = 0; i < toStructFieldNames.size(); ++i) {
                if (i >= fromStructFieldName.size()) {
                    toField.add((Object)new RowType.Field(Optional.of((String)toStructFieldNames.get(i)), ((RowType.Field)rowType.getFields().get(i)).getType()));
                    coercersBuilder.add(Optional.empty());
                    continue;
                }
                if (!((String)fromStructFieldName.get(i)).equalsIgnoreCase((String)toStructFieldNames.get(i))) {
                    return Optional.empty();
                }
                Optional<TypeCoercer<? extends Type, ? extends Type>> coercer = OrcTypeTranslator.createCoercer(nestedColumns.get(i).getColumnType(), nestedColumns.get(i).getNestedColumns(), ((RowType.Field)rowType.getFields().get(i)).getType());
                coercersBuilder.add(coercer);
                Type rowFieldType = ((RowType.Field)rowType.getFields().get(i)).getType();
                fromField.add((Object)new RowType.Field(Optional.of((String)fromStructFieldName.get(i)), coercer.map(TypeCoercer::getFromType).orElse(rowFieldType)));
                toField.add((Object)new RowType.Field(Optional.of((String)toStructFieldNames.get(i)), coercer.map(TypeCoercer::getToType).orElse(rowFieldType)));
            }
            ImmutableList coercers = coercersBuilder.build();
            if (coercers.stream().anyMatch(Optional::isPresent)) {
                return Optional.of(new CoercionUtils.StructCoercer(RowType.from((List)fromField.build()), RowType.from((List)toField.build()), (List<Optional<TypeCoercer<? extends Type, ? extends Type>>>)coercers));
            }
            return Optional.empty();
        }
        if (fromOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.LIST && toTrinoType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)toTrinoType;
            return OrcTypeTranslator.createCoercer(((OrcColumn)Iterables.getOnlyElement(nestedColumns)).getColumnType(), ((OrcColumn)Iterables.getOnlyElement(nestedColumns)).getNestedColumns(), arrayType.getElementType()).map(elementCoercer -> new CoercionUtils.ListCoercer(new ArrayType(elementCoercer.getFromType()), new ArrayType(elementCoercer.getToType()), (TypeCoercer<? extends Type, ? extends Type>)elementCoercer));
        }
        if (fromOrcType.getOrcTypeKind() == OrcType.OrcTypeKind.MAP && toTrinoType instanceof MapType) {
            MapType mapType = (MapType)toTrinoType;
            Optional<TypeCoercer<? extends Type, ? extends Type>> keyCoercer = OrcTypeTranslator.createCoercer(nestedColumns.get(0).getColumnType(), nestedColumns.get(0).getNestedColumns(), mapType.getKeyType());
            Optional<TypeCoercer<? extends Type, ? extends Type>> valueCoercer = OrcTypeTranslator.createCoercer(nestedColumns.get(1).getColumnType(), nestedColumns.get(1).getNestedColumns(), mapType.getValueType());
            TypeOperators typeOperators = new TypeOperators();
            MapType fromType = new MapType(keyCoercer.map(TypeCoercer::getFromType).orElseGet(() -> ((MapType)mapType).getKeyType()), valueCoercer.map(TypeCoercer::getFromType).orElseGet(() -> ((MapType)mapType).getValueType()), typeOperators);
            MapType toType = new MapType(keyCoercer.map(TypeCoercer::getToType).orElseGet(() -> ((MapType)mapType).getKeyType()), valueCoercer.map(TypeCoercer::getToType).orElseGet(() -> ((MapType)mapType).getKeyType()), typeOperators);
            if (keyCoercer.isPresent() || valueCoercer.isPresent()) {
                return Optional.of(new CoercionUtils.MapCoercer(fromType, toType, keyCoercer, valueCoercer));
            }
            return Optional.empty();
        }
        if (fromOrcTypeKind == OrcType.OrcTypeKind.BINARY && toTrinoType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)toTrinoType;
            return Optional.of(VarbinaryToVarcharCoercers.createVarbinaryToVarcharCoercer(varcharType, HiveStorageFormat.ORC));
        }
        return Optional.empty();
    }

    private static boolean isVarcharType(OrcType.OrcTypeKind orcTypeKind) {
        return orcTypeKind == OrcType.OrcTypeKind.STRING || orcTypeKind == OrcType.OrcTypeKind.VARCHAR;
    }
}

