/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.metastore.HivePartition;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveTablePartitioning;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.predicate.TupleDomain;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HivePartitionResult {
    private final List<HiveColumnHandle> partitionColumns;
    private final Iterable<HivePartition> partitions;
    private final TupleDomain<ColumnHandle> effectivePredicate;
    private final TupleDomain<HiveColumnHandle> compactEffectivePredicate;
    private final Optional<HiveTablePartitioning> tablePartitioning;
    private final Optional<HiveBucketing.HiveBucketFilter> bucketFilter;
    private final Optional<List<String>> partitionNames;

    public HivePartitionResult(List<HiveColumnHandle> partitionColumns, Optional<List<String>> partitionNames, Iterable<HivePartition> partitions, TupleDomain<ColumnHandle> effectivePredicate, TupleDomain<HiveColumnHandle> compactEffectivePredicate, Optional<HiveTablePartitioning> tablePartitioning, Optional<HiveBucketing.HiveBucketFilter> bucketFilter) {
        this.partitionColumns = Objects.requireNonNull(partitionColumns, "partitionColumns is null");
        this.partitionNames = partitionNames.map(ImmutableList::copyOf);
        this.partitions = Objects.requireNonNull(partitions, "partitions is null");
        this.effectivePredicate = Objects.requireNonNull(effectivePredicate, "effectivePredicate is null");
        this.compactEffectivePredicate = Objects.requireNonNull(compactEffectivePredicate, "compactEffectivePredicate is null");
        this.tablePartitioning = Objects.requireNonNull(tablePartitioning, "tablePartitioning is null");
        this.bucketFilter = Objects.requireNonNull(bucketFilter, "bucketFilter is null");
    }

    public List<HiveColumnHandle> getPartitionColumns() {
        return this.partitionColumns;
    }

    public Optional<List<String>> getPartitionNames() {
        return this.partitionNames;
    }

    public Iterator<HivePartition> getPartitions() {
        return this.partitions.iterator();
    }

    public TupleDomain<ColumnHandle> getEffectivePredicate() {
        return this.effectivePredicate;
    }

    public TupleDomain<HiveColumnHandle> getCompactEffectivePredicate() {
        return this.compactEffectivePredicate;
    }

    public Optional<HiveTablePartitioning> getTablePartitioning() {
        return this.tablePartitioning;
    }

    public Optional<HiveBucketing.HiveBucketFilter> getBucketFilter() {
        return this.bucketFilter;
    }
}

