/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.line;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.DynamicSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import io.trino.hive.formats.line.LineSerializer;
import io.trino.hive.formats.line.LineWriter;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.Type;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class LineFileWriter
implements FileWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(LineFileWriter.class);
    private final LineWriter lineWriter;
    private final LineSerializer serializer;
    private final Closeable rollbackAction;
    private final int[] fileInputColumnIndexes;
    private final List<Block> nullBlocks;
    private final DynamicSliceOutput sliceOutput = new DynamicSliceOutput(1024);

    public LineFileWriter(LineWriter lineWriter, LineSerializer serializer, Closeable rollbackAction, int[] fileInputColumnIndexes) {
        this.lineWriter = Objects.requireNonNull(lineWriter, "lineWriter is null");
        this.serializer = Objects.requireNonNull(serializer, "serializer is null");
        this.rollbackAction = Objects.requireNonNull(rollbackAction, "rollbackAction is null");
        this.fileInputColumnIndexes = Objects.requireNonNull(fileInputColumnIndexes, "fileInputColumnIndexes is null");
        ImmutableList.Builder nullBlocks = ImmutableList.builder();
        for (Type fileColumnType : serializer.getTypes()) {
            nullBlocks.add((Object)fileColumnType.createNullBlock());
        }
        this.nullBlocks = nullBlocks.build();
    }

    @Override
    public long getWrittenBytes() {
        return this.lineWriter.getWrittenBytes();
    }

    @Override
    public long getMemoryUsage() {
        return (long)INSTANCE_SIZE + this.lineWriter.getRetainedSizeInBytes() + this.sliceOutput.getRetainedSize();
    }

    @Override
    public void appendRows(Page dataPage) {
        Block[] blocks = new Block[this.fileInputColumnIndexes.length];
        for (int i = 0; i < this.fileInputColumnIndexes.length; ++i) {
            int inputColumnIndex = this.fileInputColumnIndexes[i];
            blocks[i] = inputColumnIndex < 0 ? RunLengthEncodedBlock.create((Block)this.nullBlocks.get(i), (int)dataPage.getPositionCount()) : dataPage.getBlock(inputColumnIndex);
        }
        Page page = new Page(dataPage.getPositionCount(), blocks);
        try {
            for (int position = 0; position < page.getPositionCount(); ++position) {
                this.sliceOutput.reset();
                this.serializer.write(page, position, (SliceOutput)this.sliceOutput);
                this.lineWriter.write(this.sliceOutput.slice());
            }
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, (Throwable)e);
        }
    }

    @Override
    public Closeable commit() {
        try {
            this.lineWriter.close();
        }
        catch (Exception e) {
            try {
                this.rollbackAction.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error committing write to Hive", (Throwable)e);
        }
        return this.rollbackAction;
    }

    @Override
    public void rollback() {
        try (Closeable closeable = this.rollbackAction;){
            this.lineWriter.close();
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, "Error rolling back write to Hive", (Throwable)e);
        }
    }

    @Override
    public long getValidationCpuNanos() {
        return 0L;
    }
}

