/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import com.amazonaws.services.glue.AWSGlueAsync;
import com.google.inject.Inject;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.v1.DefaultGlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.v1.ForGlueColumnStatisticsRead;
import io.trino.plugin.hive.metastore.glue.v1.ForGlueColumnStatisticsWrite;
import io.trino.plugin.hive.metastore.glue.v1.GlueColumnStatisticsProvider;
import io.trino.plugin.hive.metastore.glue.v1.GlueColumnStatisticsProviderFactory;
import java.util.Objects;
import java.util.concurrent.Executor;

public class DefaultGlueColumnStatisticsProviderFactory
implements GlueColumnStatisticsProviderFactory {
    private final Executor statisticsReadExecutor;
    private final Executor statisticsWriteExecutor;

    @Inject
    public DefaultGlueColumnStatisticsProviderFactory(@ForGlueColumnStatisticsRead Executor statisticsReadExecutor, @ForGlueColumnStatisticsWrite Executor statisticsWriteExecutor) {
        this.statisticsReadExecutor = Objects.requireNonNull(statisticsReadExecutor, "statisticsReadExecutor is null");
        this.statisticsWriteExecutor = Objects.requireNonNull(statisticsWriteExecutor, "statisticsWriteExecutor is null");
    }

    @Override
    public GlueColumnStatisticsProvider createGlueColumnStatisticsProvider(AWSGlueAsync glueClient, GlueMetastoreStats stats) {
        return new DefaultGlueColumnStatisticsProvider(glueClient, this.statisticsReadExecutor, this.statisticsWriteExecutor, stats);
    }
}

