/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue.v1;

import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.DatabaseInput;
import com.amazonaws.services.glue.model.Order;
import com.amazonaws.services.glue.model.PartitionInput;
import com.amazonaws.services.glue.model.PrincipalType;
import com.amazonaws.services.glue.model.ResourceType;
import com.amazonaws.services.glue.model.ResourceUri;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.Table;
import com.amazonaws.services.glue.model.TableInput;
import com.amazonaws.services.glue.model.UserDefinedFunctionInput;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.trino.metastore.Database;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.Partition;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.PartitionWithStatistics;
import io.trino.metastore.Storage;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.glue.v1.GlueToTrinoConverter;
import io.trino.spi.function.LanguageFunction;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public final class GlueInputConverter {
    static final JsonCodec<LanguageFunction> LANGUAGE_FUNCTION_CODEC = JsonCodec.jsonCodec(LanguageFunction.class);

    private GlueInputConverter() {
    }

    public static DatabaseInput convertDatabase(Database database) {
        DatabaseInput input = new DatabaseInput();
        input.setName(database.getDatabaseName());
        input.setParameters(database.getParameters());
        database.getComment().ifPresent(arg_0 -> ((DatabaseInput)input).setDescription(arg_0));
        database.getLocation().ifPresent(arg_0 -> ((DatabaseInput)input).setLocationUri(arg_0));
        return input;
    }

    public static TableInput convertTable(io.trino.metastore.Table table) {
        Map tableParameters = table.getParameters();
        Optional<Object> comment = Optional.empty();
        if (!ViewReaderUtil.isTrinoView(table) && !ViewReaderUtil.isTrinoMaterializedView(table)) {
            comment = Optional.ofNullable((String)tableParameters.get("comment"));
            tableParameters = (Map)tableParameters.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("comment")).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        TableInput input = new TableInput();
        input.setName(table.getTableName());
        input.setOwner((String)table.getOwner().orElse(null));
        input.setTableType(table.getTableType());
        input.setStorageDescriptor(GlueInputConverter.convertStorage(table.getStorage(), table.getDataColumns()));
        input.setPartitionKeys((Collection)table.getPartitionColumns().stream().map(GlueInputConverter::convertColumn).collect(ImmutableList.toImmutableList()));
        input.setParameters(tableParameters);
        table.getViewOriginalText().ifPresent(arg_0 -> ((TableInput)input).setViewOriginalText(arg_0));
        table.getViewExpandedText().ifPresent(arg_0 -> ((TableInput)input).setViewExpandedText(arg_0));
        comment.ifPresent(arg_0 -> ((TableInput)input).setDescription(arg_0));
        return input;
    }

    public static TableInput convertGlueTableToTableInput(Table glueTable) {
        return new TableInput().withName(glueTable.getName()).withDescription(glueTable.getDescription()).withOwner(glueTable.getOwner()).withLastAccessTime(glueTable.getLastAccessTime()).withLastAnalyzedTime(glueTable.getLastAnalyzedTime()).withRetention(glueTable.getRetention()).withStorageDescriptor((StorageDescriptor)GlueToTrinoConverter.getStorageDescriptor(glueTable).orElse(null)).withPartitionKeys((Collection)glueTable.getPartitionKeys()).withViewOriginalText(glueTable.getViewOriginalText()).withViewExpandedText(glueTable.getViewExpandedText()).withTableType(GlueToTrinoConverter.getTableTypeNullable(glueTable)).withTargetTable(glueTable.getTargetTable()).withParameters(GlueToTrinoConverter.getTableParameters(glueTable));
    }

    public static PartitionInput convertPartition(PartitionWithStatistics partitionWithStatistics) {
        PartitionInput input = GlueInputConverter.convertPartition(partitionWithStatistics.getPartition());
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        input.setParameters(MetastoreUtil.updateStatisticsParameters(input.getParameters(), statistics.basicStatistics()));
        return input;
    }

    public static PartitionInput convertPartition(Partition partition) {
        PartitionInput input = new PartitionInput();
        input.setValues((Collection)partition.getValues());
        input.setStorageDescriptor(GlueInputConverter.convertStorage(partition.getStorage(), partition.getColumns()));
        input.setParameters(partition.getParameters());
        return input;
    }

    private static StorageDescriptor convertStorage(Storage storage, List<io.trino.metastore.Column> columns) {
        if (storage.isSkewed()) {
            throw new IllegalArgumentException("Writing to skewed table/partition is not supported");
        }
        SerDeInfo serdeInfo = new SerDeInfo().withSerializationLibrary(storage.getStorageFormat().getSerDeNullable()).withParameters(storage.getSerdeParameters());
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation(storage.getLocation());
        sd.setColumns((Collection)columns.stream().map(GlueInputConverter::convertColumn).collect(ImmutableList.toImmutableList()));
        sd.setSerdeInfo(serdeInfo);
        sd.setInputFormat(storage.getStorageFormat().getInputFormatNullable());
        sd.setOutputFormat(storage.getStorageFormat().getOutputFormatNullable());
        sd.setParameters((Map)ImmutableMap.of());
        Optional bucketProperty = storage.getBucketProperty();
        if (bucketProperty.isPresent()) {
            sd.setNumberOfBuckets(Integer.valueOf(((HiveBucketProperty)bucketProperty.get()).bucketCount()));
            sd.setBucketColumns((Collection)((HiveBucketProperty)bucketProperty.get()).bucketedBy());
            if (!((HiveBucketProperty)bucketProperty.get()).sortedBy().isEmpty()) {
                sd.setSortColumns((Collection)((HiveBucketProperty)bucketProperty.get()).sortedBy().stream().map(column -> new Order().withColumn(column.columnName()).withSortOrder(Integer.valueOf(column.order().getHiveOrder()))).collect(ImmutableList.toImmutableList()));
            }
        }
        return sd;
    }

    private static Column convertColumn(io.trino.metastore.Column trinoColumn) {
        return new Column().withName(trinoColumn.getName()).withType(trinoColumn.getType().toString()).withComment((String)trinoColumn.getComment().orElse(null)).withParameters(trinoColumn.getProperties());
    }

    public static UserDefinedFunctionInput convertFunction(String functionName, LanguageFunction function) {
        return new UserDefinedFunctionInput().withFunctionName(MetastoreUtil.metastoreFunctionName(functionName, function.signatureToken())).withClassName("TrinoFunction").withOwnerType(PrincipalType.USER).withOwnerName((String)function.owner().orElse(null)).withResourceUris(MetastoreUtil.toResourceUris(LANGUAGE_FUNCTION_CODEC.toJsonBytes((Object)function)).stream().map(uri -> new ResourceUri().withResourceType(ResourceType.FILE).withUri(uri.getUri())).toList());
    }
}

