/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.SliceInput;
import io.airlift.slice.Slices;
import io.trino.hive.formats.ReadWriteUtils;
import io.trino.plugin.base.authentication.CachingKerberosAuthentication;
import io.trino.plugin.hive.metastore.thrift.ForHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.HiveMetastoreAuthentication;
import io.trino.plugin.hive.metastore.thrift.MetastoreKerberosConfig;
import io.trino.plugin.hive.metastore.thrift.TSubjectAssumingTransport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import org.apache.thrift.transport.TSaslClientTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class KerberosHiveMetastoreAuthentication
implements HiveMetastoreAuthentication {
    private final String hiveMetastoreServicePrincipal;
    private final CachingKerberosAuthentication authentication;

    @Inject
    public KerberosHiveMetastoreAuthentication(MetastoreKerberosConfig config, @ForHiveMetastore CachingKerberosAuthentication authentication) {
        this(config.getHiveMetastoreServicePrincipal(), authentication);
    }

    public KerberosHiveMetastoreAuthentication(String hiveMetastoreServicePrincipal, CachingKerberosAuthentication authentication) {
        this.hiveMetastoreServicePrincipal = Objects.requireNonNull(hiveMetastoreServicePrincipal, "hiveMetastoreServicePrincipal is null");
        this.authentication = Objects.requireNonNull(authentication, "authentication is null");
    }

    @Override
    public TTransport authenticate(TTransport rawTransport, String hiveMetastoreHost, Optional<String> delegationToken) {
        try {
            TSaslClientTransport saslTransport;
            ImmutableMap saslProps = ImmutableMap.of((Object)"javax.security.sasl.qop", (Object)"auth-conf,auth", (Object)"javax.security.sasl.server.authentication", (Object)"true");
            if (delegationToken.isPresent()) {
                saslTransport = new TSaslClientTransport("DIGEST-MD5", null, null, "default", (Map)saslProps, (CallbackHandler)new SaslClientCallbackHandler(delegationToken.get()), rawTransport);
            } else {
                String[] names = this.hiveMetastoreServicePrincipal.split("[/@]");
                Preconditions.checkArgument((names.length == 3 ? 1 : 0) != 0, (String)"Kerberos principal name does not have the expected hostname part: %s", (Object)this.hiveMetastoreServicePrincipal);
                if (names[1].equals("_HOST")) {
                    names[1] = hiveMetastoreHost.toLowerCase(Locale.ENGLISH);
                }
                saslTransport = new TSaslClientTransport("GSSAPI", null, names[0], names[1], (Map)saslProps, null, rawTransport);
            }
            return new TSubjectAssumingTransport((TTransport)saslTransport, this.authentication.getSubject());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (TTransportException e) {
            throw new RuntimeException(e);
        }
    }

    private static class SaslClientCallbackHandler
    implements CallbackHandler {
        private final String username;
        private final String password;

        public SaslClientCallbackHandler(String token) {
            byte[] decoded = Base64.getUrlDecoder().decode(token);
            BasicSliceInput in = new BasicSliceInput(Slices.wrappedBuffer((byte[])decoded));
            byte[] username = new byte[Math.toIntExact(ReadWriteUtils.readVInt((SliceInput)in))];
            in.readFully(username);
            byte[] password = new byte[Math.toIntExact(ReadWriteUtils.readVInt((SliceInput)in))];
            in.readFully(password);
            this.username = Base64.getEncoder().encodeToString(username);
            this.password = Base64.getEncoder().encodeToString(password);
        }

        @Override
        public void handle(Callback[] callbacks) {
            for (Callback callback : callbacks) {
                if (callback instanceof NameCallback) {
                    NameCallback nameCallback = (NameCallback)callback;
                    nameCallback.setName(this.username);
                }
                if (callback instanceof PasswordCallback) {
                    PasswordCallback passwordCallback = (PasswordCallback)callback;
                    passwordCallback.setPassword(this.password.toCharArray());
                }
                if (!(callback instanceof RealmCallback)) continue;
                RealmCallback realmCallback = (RealmCallback)callback;
                realmCallback.setText(realmCallback.getDefaultText());
            }
        }
    }
}

