/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.orc.HdfsOrcDataSource;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.security.ConnectorIdentity;
import java.util.Collection;

public final class OriginalFilesUtils {
    private OriginalFilesUtils() {
    }

    public static long getPrecedingRowCount(Collection<AcidInfo.OriginalFileInfo> originalFileInfos, Location splitPath, TrinoFileSystemFactory fileSystemFactory, ConnectorIdentity identity, OrcReaderOptions options, FileFormatDataSourceStats stats) {
        long rowCount = 0L;
        for (AcidInfo.OriginalFileInfo originalFileInfo : originalFileInfos) {
            if (originalFileInfo.getName().compareTo(splitPath.fileName()) >= 0) continue;
            Location path = splitPath.sibling(originalFileInfo.getName());
            TrinoInputFile inputFile = fileSystemFactory.create(identity).newInputFile(path, originalFileInfo.getFileSize());
            rowCount += OriginalFilesUtils.getRowsInFile(inputFile, options, stats).longValue();
        }
        return rowCount;
    }

    private static Long getRowsInFile(TrinoInputFile inputFile, OrcReaderOptions options, FileFormatDataSourceStats stats) {
        Long l;
        HdfsOrcDataSource orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(inputFile.location().toString()), inputFile.length(), options, inputFile, stats);
        try {
            OrcReader reader = (OrcReader)OrcReader.createOrcReader((OrcDataSource)orcDataSource, (OrcReaderOptions)options).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Could not read ORC footer from empty file: " + String.valueOf(inputFile.location())));
            l = reader.getFooter().getNumberOfRows();
        }
        catch (Throwable throwable) {
            try {
                try {
                    orcDataSource.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (TrinoException e) {
                throw e;
            }
            catch (Exception e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, "Could not read ORC footer from file: " + String.valueOf(inputFile.location()), (Throwable)e);
            }
        }
        orcDataSource.close();
        return l;
    }
}

