/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.metastore.HiveType;
import io.trino.metastore.type.Category;
import io.trino.parquet.Column;
import io.trino.parquet.Field;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderOptions;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.ParquetWriteValidation;
import io.trino.parquet.metadata.FileMetadata;
import io.trino.parquet.metadata.ParquetMetadata;
import io.trino.parquet.predicate.PredicateUtils;
import io.trino.parquet.predicate.TupleDomainParquetPredicate;
import io.trino.parquet.reader.MetadataReader;
import io.trino.parquet.reader.ParquetReader;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.ReaderColumns;
import io.trino.plugin.hive.ReaderPageSource;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.parquet.MemoryParquetDataSource;
import io.trino.plugin.hive.parquet.ParquetPageSource;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetTypeTranslator;
import io.trino.plugin.hive.parquet.TrinoParquetDataSource;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.ColumnIO;
import org.apache.parquet.io.GroupColumnIO;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;

public class ParquetPageSourceFactory
implements HivePageSourceFactory {
    public static final HiveColumnHandle PARQUET_ROW_INDEX_COLUMN = new HiveColumnHandle("$parquet$row_index", -1, HiveType.HIVE_LONG, (io.trino.spi.type.Type)BigintType.BIGINT, Optional.empty(), HiveColumnHandle.ColumnType.SYNTHESIZED, Optional.empty());
    private static final Set<String> PARQUET_SERDE_CLASS_NAMES = ImmutableSet.builder().add((Object)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe").add((Object)"parquet.hive.serde.ParquetHiveSerDe").build();
    private final TrinoFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats stats;
    private final ParquetReaderOptions options;
    private final DateTimeZone timeZone;
    private final int domainCompactionThreshold;

    @Inject
    public ParquetPageSourceFactory(TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats stats, ParquetReaderConfig config, HiveConfig hiveConfig) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.options = config.toParquetReaderOptions();
        this.timeZone = hiveConfig.getParquetDateTimeZone();
        this.domainCompactionThreshold = hiveConfig.getDomainCompactionThreshold();
    }

    public static boolean stripUnnecessaryProperties(String serializationLibraryName) {
        return PARQUET_SERDE_CLASS_NAMES.contains(serializationLibraryName);
    }

    @Override
    public Optional<ReaderPageSource> createPageSource(ConnectorSession session, Location path, long start, long length, long estimatedFileSize, long fileModifiedTime, Schema schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction) {
        if (!PARQUET_SERDE_CLASS_NAMES.contains(schema.serializationLibraryName())) {
            return Optional.empty();
        }
        Preconditions.checkArgument((boolean)acidInfo.isEmpty(), (Object)"Acid is not supported");
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        TrinoInputFile inputFile = fileSystem.newInputFile(path, estimatedFileSize, Instant.ofEpochMilli(fileModifiedTime));
        return Optional.of(ParquetPageSourceFactory.createPageSource(inputFile, start, length, columns, (List<TupleDomain<HiveColumnHandle>>)ImmutableList.of(effectivePredicate), HiveSessionProperties.isUseParquetColumnNames(session), this.timeZone, this.stats, this.options.withIgnoreStatistics(HiveSessionProperties.isParquetIgnoreStatistics(session)).withMaxReadBlockSize(HiveSessionProperties.getParquetMaxReadBlockSize(session)).withMaxReadBlockRowCount(HiveSessionProperties.getParquetMaxReadBlockRowCount(session)).withSmallFileThreshold(HiveSessionProperties.getParquetSmallFileThreshold(session)).withUseColumnIndex(HiveSessionProperties.isParquetUseColumnIndex(session)).withBloomFilter(HiveSessionProperties.useParquetBloomFilter(session)).withVectorizedDecodingEnabled(HiveSessionProperties.isParquetVectorizedDecodingEnabled(session)), Optional.empty(), this.domainCompactionThreshold, OptionalLong.of(estimatedFileSize)));
    }

    public static ReaderPageSource createPageSource(TrinoInputFile inputFile, long start, long length, List<HiveColumnHandle> columns, List<TupleDomain<HiveColumnHandle>> disjunctTupleDomains, boolean useColumnNames, DateTimeZone timeZone, FileFormatDataSourceStats stats, ParquetReaderOptions options, Optional<ParquetWriteValidation> parquetWriteValidation, int domainCompactionThreshold, OptionalLong estimatedFileSize) {
        ParquetDataSource dataSource = null;
        try {
            ImmutableList parquetPredicates;
            ImmutableList parquetTupleDomains;
            AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
            dataSource = ParquetPageSourceFactory.createDataSource(inputFile, estimatedFileSize, options, memoryContext, stats);
            ParquetMetadata parquetMetadata = MetadataReader.readFooter((ParquetDataSource)dataSource, parquetWriteValidation);
            FileMetadata fileMetaData = parquetMetadata.getFileMetaData();
            MessageType fileSchema = fileMetaData.getSchema();
            Optional<MessageType> message = ParquetPageSourceFactory.getParquetMessageType(columns, useColumnNames, fileSchema);
            MessageType requestedSchema = message.orElse(new MessageType(fileSchema.getName(), (List)ImmutableList.of()));
            MessageColumnIO messageColumn = ParquetTypeUtils.getColumnIO((MessageType)fileSchema, (MessageType)requestedSchema);
            Map descriptorsByPath = ParquetTypeUtils.getDescriptors((MessageType)fileSchema, (MessageType)requestedSchema);
            if (options.isIgnoreStatistics()) {
                parquetTupleDomains = ImmutableList.of((Object)TupleDomain.all());
                parquetPredicates = ImmutableList.of((Object)PredicateUtils.buildPredicate((MessageType)requestedSchema, (TupleDomain)TupleDomain.all(), (Map)descriptorsByPath, (DateTimeZone)timeZone));
            } else {
                ImmutableList.Builder parquetTupleDomainsBuilder = ImmutableList.builderWithExpectedSize((int)disjunctTupleDomains.size());
                ImmutableList.Builder parquetPredicatesBuilder = ImmutableList.builderWithExpectedSize((int)disjunctTupleDomains.size());
                for (TupleDomain<HiveColumnHandle> tupleDomain : disjunctTupleDomains) {
                    TupleDomain<ColumnDescriptor> parquetTupleDomain = ParquetPageSourceFactory.getParquetTupleDomain(descriptorsByPath, tupleDomain, fileSchema, useColumnNames);
                    parquetTupleDomainsBuilder.add(parquetTupleDomain);
                    parquetPredicatesBuilder.add((Object)PredicateUtils.buildPredicate((MessageType)requestedSchema, parquetTupleDomain, (Map)descriptorsByPath, (DateTimeZone)timeZone));
                }
                parquetTupleDomains = parquetTupleDomainsBuilder.build();
                parquetPredicates = parquetPredicatesBuilder.build();
            }
            List rowGroups = PredicateUtils.getFilteredRowGroups((long)start, (long)length, (ParquetDataSource)dataSource, (ParquetMetadata)parquetMetadata, (List)parquetTupleDomains, (List)parquetPredicates, (Map)descriptorsByPath, (DateTimeZone)timeZone, (int)domainCompactionThreshold, (ParquetReaderOptions)options);
            Optional<ReaderColumns> readerProjections = HivePageSourceProvider.projectBaseColumns(columns, useColumnNames);
            List<HiveColumnHandle> baseColumns = readerProjections.map(projection -> projection.get().stream().map(HiveColumnHandle.class::cast).collect(Collectors.toUnmodifiableList())).orElse(columns);
            ParquetDataSourceId dataSourceId = dataSource.getId();
            ParquetDataSource finalDataSource = dataSource;
            ParquetReaderProvider parquetReaderProvider = arg_0 -> ParquetPageSourceFactory.lambda$createPageSource$2(fileMetaData, rowGroups, finalDataSource, timeZone, memoryContext, options, dataSourceId, (List)parquetPredicates, parquetWriteValidation, arg_0);
            ConnectorPageSource parquetPageSource = ParquetPageSourceFactory.createParquetPageSource(baseColumns, fileSchema, messageColumn, useColumnNames, parquetReaderProvider);
            return new ReaderPageSource(parquetPageSource, readerProjections);
        }
        catch (Exception e) {
            try {
                if (dataSource != null) {
                    dataSource.close();
                }
            }
            catch (IOException parquetMetadata) {
                // empty catch block
            }
            if (e instanceof TrinoException) {
                throw (TrinoException)((Object)e);
            }
            if (e instanceof ParquetCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
            }
            String message = String.format("Error opening Hive split %s (offset=%s, length=%s): %s", inputFile.location(), start, length, e.getMessage());
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, message, (Throwable)e);
        }
    }

    public static ParquetDataSource createDataSource(TrinoInputFile inputFile, OptionalLong estimatedFileSize, ParquetReaderOptions options, AggregatedMemoryContext memoryContext, FileFormatDataSourceStats stats) throws IOException {
        if (estimatedFileSize.isEmpty() || estimatedFileSize.getAsLong() > options.getSmallFileThreshold().toBytes()) {
            return new TrinoParquetDataSource(inputFile, options, stats);
        }
        return new MemoryParquetDataSource(inputFile, memoryContext, stats);
    }

    public static Optional<MessageType> getParquetMessageType(List<HiveColumnHandle> columns, boolean useColumnNames, MessageType fileSchema) {
        Optional<MessageType> message = HivePageSourceProvider.projectSufficientColumns(columns).map(projection -> projection.get().stream().map(HiveColumnHandle.class::cast).collect(Collectors.toUnmodifiableList())).orElse(columns).stream().filter(column -> column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR).map(column -> ParquetPageSourceFactory.getColumnType(column, fileSchema, useColumnNames)).filter(Optional::isPresent).map(Optional::get).map(type -> new MessageType(fileSchema.getName(), new Type[]{type})).reduce(MessageType::union);
        return message;
    }

    public static Optional<Type> getColumnType(HiveColumnHandle column, MessageType messageType, boolean useParquetColumnNames) {
        Optional<Type> baseColumnType = ParquetPageSourceFactory.getBaseColumnParquetType(column, messageType, useParquetColumnNames);
        if (baseColumnType.isEmpty() || column.getHiveColumnProjectionInfo().isEmpty()) {
            return baseColumnType;
        }
        GroupType baseType = baseColumnType.get().asGroupType();
        Optional<List<Type>> subFieldTypesOptional = ParquetPageSourceFactory.dereferenceSubFieldTypes(baseType, column.getHiveColumnProjectionInfo().get());
        if (subFieldTypesOptional.isEmpty()) {
            return Optional.empty();
        }
        List<Type> subfieldTypes = subFieldTypesOptional.get();
        Type type = subfieldTypes.getLast();
        for (int i = subfieldTypes.size() - 2; i >= 0; --i) {
            GroupType groupType = subfieldTypes.get(i).asGroupType();
            type = new GroupType(groupType.getRepetition(), groupType.getName(), (List)ImmutableList.of((Object)type));
        }
        return Optional.of(new GroupType(baseType.getRepetition(), baseType.getName(), (List)ImmutableList.of((Object)type)));
    }

    public static TupleDomain<ColumnDescriptor> getParquetTupleDomain(Map<List<String>, ColumnDescriptor> descriptorsByPath, TupleDomain<HiveColumnHandle> effectivePredicate, MessageType fileSchema, boolean useColumnNames) {
        if (effectivePredicate.isNone()) {
            return TupleDomain.none();
        }
        ImmutableMap.Builder predicate = ImmutableMap.builder();
        for (Map.Entry entry : ((Map)effectivePredicate.getDomains().get()).entrySet()) {
            ColumnDescriptor descriptor;
            Optional<Type> baseColumnType;
            HiveColumnHandle columnHandle = (HiveColumnHandle)entry.getKey();
            if (columnHandle.getHiveType().getCategory() != Category.PRIMITIVE || columnHandle.getColumnType() != HiveColumnHandle.ColumnType.REGULAR || (baseColumnType = ParquetPageSourceFactory.getBaseColumnParquetType(columnHandle, fileSchema, useColumnNames)).isEmpty()) continue;
            if (baseColumnType.get().isPrimitive()) {
                descriptor = descriptorsByPath.get(ImmutableList.of((Object)baseColumnType.get().getName()));
            } else {
                Optional<List<Type>> subfieldTypes;
                if (columnHandle.getHiveColumnProjectionInfo().isEmpty() || (subfieldTypes = ParquetPageSourceFactory.dereferenceSubFieldTypes(baseColumnType.get().asGroupType(), columnHandle.getHiveColumnProjectionInfo().get())).isEmpty()) continue;
                descriptor = descriptorsByPath.get(ImmutableList.builder().add((Object)baseColumnType.get().getName()).addAll((Iterable)subfieldTypes.get().stream().map(Type::getName).collect(ImmutableList.toImmutableList())).build());
            }
            if (descriptor == null) continue;
            predicate.put((Object)descriptor, (Object)((Domain)entry.getValue()));
        }
        return TupleDomain.withColumnDomains((Map)predicate.buildOrThrow());
    }

    public static ConnectorPageSource createParquetPageSource(List<HiveColumnHandle> baseColumns, MessageType fileSchema, MessageColumnIO messageColumn, boolean useColumnNames, ParquetReaderProvider parquetReaderProvider) throws IOException {
        ParquetPageSource.Builder pageSourceBuilder = ParquetPageSource.builder();
        ImmutableList.Builder parquetColumnFieldsBuilder = ImmutableList.builder();
        int sourceChannel = 0;
        for (HiveColumnHandle column : baseColumns) {
            io.trino.spi.type.Type readType;
            Optional field;
            if (column == PARQUET_ROW_INDEX_COLUMN) {
                pageSourceBuilder.addRowIndexColumn();
                continue;
            }
            Preconditions.checkArgument((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (String)"column type must be REGULAR: %s", (Object)column);
            Optional<Type> parquetType = ParquetPageSourceFactory.getBaseColumnParquetType(column, fileSchema, useColumnNames);
            if (parquetType.isEmpty()) {
                pageSourceBuilder.addNullColumn(column.getBaseType());
                continue;
            }
            String columnName = useColumnNames ? column.getBaseColumnName() : ((Type)fileSchema.getFields().get(column.getBaseHiveColumnIndex())).getName();
            Optional<Object> coercer = Optional.empty();
            ColumnIO columnIO = ParquetTypeUtils.lookupColumnByName((GroupColumnIO)messageColumn, (String)columnName);
            if (columnIO != null && columnIO.getType().isPrimitive()) {
                PrimitiveType primitiveType = columnIO.getType().asPrimitiveType();
                coercer = ParquetTypeTranslator.createCoercer(primitiveType.getPrimitiveTypeName(), primitiveType.getLogicalTypeAnnotation(), column.getBaseType());
            }
            if ((field = ParquetTypeUtils.constructField((io.trino.spi.type.Type)(readType = coercer.map(TypeCoercer::getFromType).orElseGet(column::getBaseType)), (ColumnIO)columnIO)).isEmpty()) {
                pageSourceBuilder.addNullColumn(readType);
                continue;
            }
            parquetColumnFieldsBuilder.add((Object)new Column(columnName, (Field)field.get()));
            if (coercer.isPresent()) {
                pageSourceBuilder.addCoercedColumn(sourceChannel, (TypeCoercer)coercer.get());
            } else {
                pageSourceBuilder.addSourceColumn(sourceChannel);
            }
            ++sourceChannel;
        }
        return pageSourceBuilder.build(parquetReaderProvider.createParquetReader((List<Column>)parquetColumnFieldsBuilder.build()));
    }

    private static Optional<Type> getBaseColumnParquetType(HiveColumnHandle column, MessageType messageType, boolean useParquetColumnNames) {
        if (useParquetColumnNames) {
            return Optional.ofNullable(ParquetTypeUtils.getParquetTypeByName((String)column.getBaseColumnName(), (GroupType)messageType));
        }
        if (column.getBaseHiveColumnIndex() < messageType.getFieldCount()) {
            return Optional.of(messageType.getType(column.getBaseHiveColumnIndex()));
        }
        return Optional.empty();
    }

    private static Optional<List<Type>> dereferenceSubFieldTypes(GroupType baseType, HiveColumnProjectionInfo projectionInfo) {
        Preconditions.checkArgument((baseType != null ? 1 : 0) != 0, (Object)"base type cannot be null when dereferencing");
        Preconditions.checkArgument((projectionInfo != null ? 1 : 0) != 0, (Object)"hive column projection info cannot be null when doing dereferencing");
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        GroupType parentType = baseType;
        for (String name : projectionInfo.getDereferenceNames()) {
            Type childType = ParquetTypeUtils.getParquetTypeByName((String)name, (GroupType)parentType.asGroupType());
            if (childType == null) {
                return Optional.empty();
            }
            typeBuilder.add((Object)childType);
            parentType = childType;
        }
        return Optional.of(typeBuilder.build());
    }

    private static /* synthetic */ ParquetReader lambda$createPageSource$2(FileMetadata fileMetaData, List rowGroups, ParquetDataSource finalDataSource, DateTimeZone timeZone, AggregatedMemoryContext memoryContext, ParquetReaderOptions options, ParquetDataSourceId dataSourceId, List parquetPredicates, Optional parquetWriteValidation, List fields) throws IOException {
        return new ParquetReader(Optional.ofNullable(fileMetaData.getCreatedBy()), fields, rowGroups, finalDataSource, timeZone, memoryContext, options, exception -> ParquetPageSource.handleException(dataSourceId, exception), parquetPredicates.size() == 1 ? Optional.of((TupleDomainParquetPredicate)parquetPredicates.get(0)) : Optional.empty(), parquetWriteValidation);
    }

    public static interface ParquetReaderProvider {
        public ParquetReader createParquetReader(List<Column> var1) throws IOException;
    }
}

