/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.security;

import com.google.inject.Inject;
import io.trino.metastore.Database;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HivePrivilegeInfo;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.spi.connector.ConnectorSecurityContext;
import io.trino.spi.security.RoleGrant;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class SqlStandardAccessControlMetastore {
    private final HiveTransactionManager transactionManager;

    @Inject
    public SqlStandardAccessControlMetastore(HiveTransactionManager transactionManager) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
    }

    public Set<RoleGrant> listRoleGrants(ConnectorSecurityContext context, HivePrincipal principal) {
        return this.metastore(context).listRoleGrants(principal);
    }

    public Set<HivePrivilegeInfo> listTablePrivileges(ConnectorSecurityContext context, String databaseName, String tableName, Optional<HivePrincipal> principal) {
        return this.metastore(context).listTablePrivileges(databaseName, tableName, principal);
    }

    public Optional<Database> getDatabase(ConnectorSecurityContext context, String databaseName) {
        return this.metastore(context).getDatabase(databaseName);
    }

    private SemiTransactionalHiveMetastore metastore(ConnectorSecurityContext context) {
        return this.transactionManager.get(context.getTransactionHandle(), context.getIdentity()).getMetastore();
    }
}

