/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Streams;
import com.google.inject.Inject;
import io.airlift.concurrent.BoundedExecutor;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.metastore.Column;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.HivePartition;
import io.trino.metastore.HiveType;
import io.trino.metastore.HiveTypeName;
import io.trino.metastore.Partition;
import io.trino.metastore.SortingColumn;
import io.trino.metastore.Table;
import io.trino.plugin.hive.BackgroundHiveSplitLoader;
import io.trino.plugin.hive.ForHiveSplitManager;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveNotReadableException;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.HivePartitionMetadata;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveSplitSource;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTableHandle;
import io.trino.plugin.hive.HiveTablePartitioning;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.HiveTransactionManager;
import io.trino.plugin.hive.TransactionalMetadata;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.SemiTransactionalHiveMetastore;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveCoercionPolicy;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.VersionEmbedder;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.TypeManager;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.stream.Stream;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class HiveSplitManager
implements ConnectorSplitManager {
    public static final String PRESTO_OFFLINE = "presto_offline";
    public static final String OBJECT_NOT_READABLE = "object_not_readable";
    private final HiveTransactionManager transactionManager;
    private final HivePartitionManager partitionManager;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final Executor executor;
    private final int maxOutstandingSplits;
    private final DataSize maxOutstandingSplitsSize;
    private final int minPartitionBatchSize;
    private final int maxPartitionBatchSize;
    private final int maxInitialSplits;
    private final int splitLoaderConcurrency;
    private final int maxSplitsPerSecond;
    private final boolean recursiveDfsWalkerEnabled;
    private final CounterStat highMemorySplitSourceCounter;
    private final TypeManager typeManager;
    private final CachingHostAddressProvider cachingHostAddressProvider;
    private final int maxPartitionsPerScan;

    @Inject
    public HiveSplitManager(HiveConfig hiveConfig, HiveTransactionManager transactionManager, HivePartitionManager partitionManager, TrinoFileSystemFactory fileSystemFactory, @ForHiveSplitManager ExecutorService executorService, VersionEmbedder versionEmbedder, TypeManager typeManager, CachingHostAddressProvider cachingHostAddressProvider) {
        this(transactionManager, partitionManager, fileSystemFactory, versionEmbedder.embedVersion((Executor)new BoundedExecutor((Executor)executorService, hiveConfig.getMaxSplitIteratorThreads())), new CounterStat(), hiveConfig.getMaxOutstandingSplits(), hiveConfig.getMaxOutstandingSplitsSize(), hiveConfig.getMinPartitionBatchSize(), hiveConfig.getMaxPartitionBatchSize(), hiveConfig.getMaxInitialSplits(), hiveConfig.getSplitLoaderConcurrency(), hiveConfig.getMaxSplitsPerSecond(), hiveConfig.getRecursiveDirWalkerEnabled(), typeManager, cachingHostAddressProvider, hiveConfig.getMaxPartitionsPerScan());
    }

    public HiveSplitManager(HiveTransactionManager transactionManager, HivePartitionManager partitionManager, TrinoFileSystemFactory fileSystemFactory, Executor executor, CounterStat highMemorySplitSourceCounter, int maxOutstandingSplits, DataSize maxOutstandingSplitsSize, int minPartitionBatchSize, int maxPartitionBatchSize, int maxInitialSplits, int splitLoaderConcurrency, @Nullable Integer maxSplitsPerSecond, boolean recursiveDfsWalkerEnabled, TypeManager typeManager, CachingHostAddressProvider cachingHostAddressProvider, int maxPartitionsPerScan) {
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.partitionManager = Objects.requireNonNull(partitionManager, "partitionManager is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.executor = new ErrorCodedExecutor(executor);
        this.highMemorySplitSourceCounter = Objects.requireNonNull(highMemorySplitSourceCounter, "highMemorySplitSourceCounter is null");
        Preconditions.checkArgument((maxOutstandingSplits >= 1 ? 1 : 0) != 0, (Object)"maxOutstandingSplits must be at least 1");
        this.maxOutstandingSplits = maxOutstandingSplits;
        this.maxOutstandingSplitsSize = maxOutstandingSplitsSize;
        this.minPartitionBatchSize = minPartitionBatchSize;
        this.maxPartitionBatchSize = maxPartitionBatchSize;
        this.maxInitialSplits = maxInitialSplits;
        this.splitLoaderConcurrency = splitLoaderConcurrency;
        this.maxSplitsPerSecond = (Integer)MoreObjects.firstNonNull((Object)maxSplitsPerSecond, (Object)Integer.MAX_VALUE);
        this.recursiveDfsWalkerEnabled = recursiveDfsWalkerEnabled;
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.cachingHostAddressProvider = Objects.requireNonNull(cachingHostAddressProvider, "cachingHostAddressProvider is null");
        this.maxPartitionsPerScan = maxPartitionsPerScan;
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle tableHandle, DynamicFilter dynamicFilter, Constraint constraint) {
        HiveTableHandle hiveTable = (HiveTableHandle)tableHandle;
        SchemaTableName tableName = hiveTable.getSchemaTableName();
        TransactionalMetadata transactionalMetadata = this.transactionManager.get(transaction, session.getIdentity());
        SemiTransactionalHiveMetastore metastore = transactionalMetadata.getMetastore();
        if (!metastore.isReadableWithinTransaction(tableName.getSchemaName(), tableName.getTableName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Cannot read from a table %s that was modified within transaction, you need to commit the transaction first", tableName));
        }
        Table table = metastore.getTable(tableName.getSchemaName(), tableName.getTableName()).orElseThrow(() -> new TableNotFoundException(tableName));
        String tableNotReadable = (String)table.getParameters().get(OBJECT_NOT_READABLE);
        if (!Strings.isNullOrEmpty((String)tableNotReadable)) {
            throw new HiveNotReadableException(tableName, Optional.empty(), tableNotReadable);
        }
        Optional<HiveBucketing.HiveBucketFilter> bucketFilter = hiveTable.getBucketFilter();
        Optional<HiveTablePartitioning> tablePartitioning = hiveTable.getTablePartitioning();
        tablePartitioning.ifPresent(bucketing -> Verify.verify((bucketing.partitioningHandle().getBucketCount() <= bucketing.tableBucketCount() ? 1 : 0) != 0, (String)"readBucketCount (%s) is greater than the tableBucketCount (%s) which generally points to an issue in plan generation", (int)bucketing.partitioningHandle().getBucketCount(), (int)bucketing.tableBucketCount()));
        Iterator<HivePartition> partitions = this.partitionManager.getPartitions(metastore, hiveTable);
        if (!partitions.hasNext()) {
            if (hiveTable.isRecordScannedFiles()) {
                return new FixedSplitSource((Iterable)ImmutableList.of(), (List)ImmutableList.of());
            }
            return FixedSplitSource.emptySplitSource();
        }
        Set neededColumnNames = (Set)Streams.concat((Stream[])new Stream[]{hiveTable.getProjectedColumns().stream(), hiveTable.getConstraintColumns().stream()}).map(columnHandle -> columnHandle.getBaseColumnName()).map(columnName -> columnName.toLowerCase(Locale.ENGLISH)).collect(ImmutableSet.toImmutableSet());
        Iterator<HivePartitionMetadata> hivePartitions = this.getPartitionMetadata(session, metastore, table, (PeekingIterator<HivePartition>)Iterators.peekingIterator(partitions), tablePartitioning.map(HiveTablePartitioning::toTableBucketProperty), neededColumnNames, dynamicFilter, hiveTable);
        BackgroundHiveSplitLoader hiveSplitLoader = new BackgroundHiveSplitLoader(table, hivePartitions, hiveTable.getCompactEffectivePredicate(), dynamicFilter, HiveSessionProperties.getDynamicFilteringWaitTimeout(session), this.typeManager, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(tablePartitioning, bucketFilter), session, this.fileSystemFactory, transactionalMetadata.getDirectoryLister(), this.executor, this.splitLoaderConcurrency, this.recursiveDfsWalkerEnabled, !hiveTable.getPartitionColumns().isEmpty() && HiveSessionProperties.isIgnoreAbsentPartitions(session), metastore.getValidWriteIds(session, hiveTable).map(value -> value.getTableValidWriteIdList(table.getDatabaseName() + "." + table.getTableName())), hiveTable.getMaxScannedFileSize(), this.maxPartitionsPerScan);
        HiveSplitSource splitSource = HiveSplitSource.allAtOnce(session, table.getDatabaseName(), table.getTableName(), this.maxInitialSplits, this.maxOutstandingSplits, this.maxOutstandingSplitsSize, this.maxSplitsPerSecond, hiveSplitLoader, this.executor, this.highMemorySplitSourceCounter, this.cachingHostAddressProvider, hiveTable.isRecordScannedFiles());
        hiveSplitLoader.start(splitSource);
        return splitSource;
    }

    @Managed
    @Nested
    public CounterStat getHighMemorySplitSource() {
        return this.highMemorySplitSourceCounter;
    }

    private Iterator<HivePartitionMetadata> getPartitionMetadata(ConnectorSession session, SemiTransactionalHiveMetastore metastore, Table table, PeekingIterator<HivePartition> hivePartitions, Optional<HiveBucketProperty> bucketProperty, Set<String> neededColumnNames, DynamicFilter dynamicFilter, HiveTableHandle tableHandle) {
        if (!hivePartitions.hasNext()) {
            return Collections.emptyIterator();
        }
        HivePartition firstPartition = (HivePartition)hivePartitions.peek();
        if (firstPartition.getPartitionId().equals("<UNPARTITIONED>")) {
            hivePartitions.next();
            Preconditions.checkArgument((!hivePartitions.hasNext() ? 1 : 0) != 0, (Object)"single partition is expected for unpartitioned table");
            return Iterators.singletonIterator((Object)new HivePartitionMetadata(firstPartition, Optional.empty(), (Map<Integer, HiveTypeName>)ImmutableMap.of()));
        }
        HiveTimestampPrecision hiveTimestampPrecision = HiveSessionProperties.getTimestampPrecision(session);
        boolean propagateTableScanSortingProperties = HiveSessionProperties.isPropagateTableScanSortingProperties(session);
        boolean usePartitionColumnNames = HiveSplitManager.isPartitionUsesColumnNames(session, HiveStorageFormat.getHiveStorageFormat(table.getStorage().getStorageFormat()));
        Iterator<List<HivePartition>> partitionNameBatches = HiveSplitManager.partitionExponentially(hivePartitions, this.minPartitionBatchSize, this.maxPartitionBatchSize);
        Iterator partitionBatches = Iterators.transform(partitionNameBatches, partitionBatch -> {
            TupleDomain currentDynamicFilter = dynamicFilter.getCurrentPredicate();
            if (!currentDynamicFilter.isAll()) {
                TupleDomain partitionsFilter = currentDynamicFilter.intersect(tableHandle.getCompactEffectivePredicate());
                partitionBatch = (List)partitionBatch.stream().filter(hivePartition -> HivePartitionManager.partitionMatches(tableHandle.getPartitionColumns(), (TupleDomain<ColumnHandle>)partitionsFilter, hivePartition)).collect(ImmutableList.toImmutableList());
            }
            SchemaTableName tableName = table.getSchemaTableName();
            Map<String, Optional<Partition>> partitions = metastore.getPartitionsByNames(tableName.getSchemaName(), tableName.getTableName(), Lists.transform((List)partitionBatch, HivePartition::getPartitionId));
            if (partitionBatch.size() != partitions.size()) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Expected %s partitions but found %s", partitionBatch.size(), partitions.size()));
            }
            ImmutableList.Builder results = ImmutableList.builderWithExpectedSize((int)partitionBatch.size());
            for (HivePartition hivePartition2 : partitionBatch) {
                Optional<Partition> partition = partitions.get(hivePartition2.getPartitionId());
                if (partition == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, "Partition not loaded: " + String.valueOf(hivePartition2));
                }
                if (partition.isEmpty()) {
                    throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_DROPPED_DURING_QUERY, "Partition no longer exists: " + hivePartition2.getPartitionId());
                }
                results.add((Object)HiveSplitManager.toPartitionMetadata(this.typeManager, hiveTimestampPrecision, propagateTableScanSortingProperties, usePartitionColumnNames, table, bucketProperty, hivePartition2, partition.get(), neededColumnNames));
            }
            return results.build();
        });
        return Streams.stream((Iterator)partitionBatches).flatMap(Collection::stream).iterator();
    }

    private static HivePartitionMetadata toPartitionMetadata(TypeManager typeManager, HiveTimestampPrecision hiveTimestampPrecision, boolean propagateTableScanSortingProperties, boolean usePartitionColumnNames, Table table, Optional<HiveBucketProperty> bucketProperty, HivePartition hivePartition, Partition partition, Set<String> neededColumnNames) {
        SchemaTableName tableName = table.getSchemaTableName();
        String partName = MetastoreUtil.makePartitionName(table, partition);
        MetastoreUtil.verifyOnline(tableName, Optional.of(partName), MetastoreUtil.getProtectMode(partition), partition.getParameters());
        String partitionNotReadable = (String)partition.getParameters().get(OBJECT_NOT_READABLE);
        if (!Strings.isNullOrEmpty((String)partitionNotReadable)) {
            throw new HiveNotReadableException(tableName, Optional.of(partName), partitionNotReadable);
        }
        List tableColumns = table.getDataColumns();
        List partitionColumns = partition.getColumns();
        if (tableColumns == null || partitionColumns == null) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, String.format("Table '%s' or partition '%s' has null columns", tableName, partName));
        }
        Map<Integer, HiveTypeName> hiveColumnCoercions = HiveSplitManager.getHiveColumnCoercions(usePartitionColumnNames, typeManager, hiveTimestampPrecision, tableName, partName, tableColumns, partitionColumns, neededColumnNames);
        if (bucketProperty.isPresent()) {
            List partitionSortedColumns;
            List tableSortedColumns;
            List partitionBucketColumns;
            HiveBucketProperty partitionBucketProperty = (HiveBucketProperty)partition.getStorage().getBucketProperty().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) is bucketed but partition (%s) is not bucketed", tableName, partName)));
            int tableBucketCount = bucketProperty.get().bucketCount();
            int partitionBucketCount = partitionBucketProperty.bucketCount();
            List tableBucketColumns = bucketProperty.get().bucketedBy();
            if (!tableBucketColumns.equals(partitionBucketColumns = partitionBucketProperty.bucketedBy()) || !HiveSplitManager.isBucketCountCompatible(tableBucketCount, partitionBucketCount)) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) bucketing (columns=%s, buckets=%s) is not compatible with partition (%s) bucketing (columns=%s, buckets=%s)", tableName, tableBucketColumns, tableBucketCount, partName, partitionBucketColumns, partitionBucketCount));
            }
            if (propagateTableScanSortingProperties && !HiveSplitManager.isSortingCompatible(tableSortedColumns = bucketProperty.get().sortedBy(), partitionSortedColumns = partitionBucketProperty.sortedBy())) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("Hive table (%s) sorting by %s is not compatible with partition (%s) sorting by %s. This restriction can be avoided by disabling propagate_table_scan_sorting_properties.", tableName, tableSortedColumns.stream().map(HiveUtil::sortingColumnToString).collect(ImmutableList.toImmutableList()), partName, partitionSortedColumns.stream().map(HiveUtil::sortingColumnToString).collect(ImmutableList.toImmutableList())));
            }
        }
        return new HivePartitionMetadata(hivePartition, Optional.of(partition), hiveColumnCoercions);
    }

    private static Map<Integer, HiveTypeName> getHiveColumnCoercions(boolean usePartitionColumnNames, TypeManager typeManager, HiveTimestampPrecision hiveTimestampPrecision, SchemaTableName tableName, String partName, List<Column> tableColumns, List<Column> partitionColumns, Set<String> neededColumnNames) {
        if (usePartitionColumnNames) {
            return HiveSplitManager.getHiveColumnCoercionsByColumnNames(typeManager, tableName, partName, tableColumns, partitionColumns, neededColumnNames, hiveTimestampPrecision);
        }
        ImmutableMap.Builder columnCoercions = ImmutableMap.builder();
        for (int i = 0; i < Math.min(partitionColumns.size(), tableColumns.size()); ++i) {
            HiveType partitionType;
            HiveType tableType;
            if (!neededColumnNames.contains(tableColumns.get(i).getName().toLowerCase(Locale.ENGLISH)) || (tableType = tableColumns.get(i).getType()).equals((Object)(partitionType = partitionColumns.get(i).getType()))) continue;
            if (!HiveCoercionPolicy.canCoerce(typeManager, partitionType, tableType, hiveTimestampPrecision)) {
                throw HiveSplitManager.tablePartitionColumnMismatchException(tableName, partName, tableColumns.get(i).getName(), tableType, partitionColumns.get(i).getName(), partitionType);
            }
            columnCoercions.put((Object)i, (Object)partitionType.getHiveTypeName());
        }
        return columnCoercions.buildOrThrow();
    }

    private static boolean isPartitionUsesColumnNames(ConnectorSession session, Optional<HiveStorageFormat> storageFormat) {
        if (storageFormat.isEmpty()) {
            return false;
        }
        return switch (storageFormat.get()) {
            case HiveStorageFormat.AVRO, HiveStorageFormat.JSON -> true;
            case HiveStorageFormat.ORC -> HiveSessionProperties.isUseOrcColumnNames(session);
            case HiveStorageFormat.PARQUET -> HiveSessionProperties.isUseParquetColumnNames(session);
            default -> false;
        };
    }

    private static Map<Integer, HiveTypeName> getHiveColumnCoercionsByColumnNames(TypeManager typeManager, SchemaTableName tableName, String partName, List<Column> tableColumns, List<Column> partitionColumns, Set<String> neededColumnNames, HiveTimestampPrecision hiveTimestampPrecision) {
        ImmutableMap.Builder partitionColumnIndexesBuilder = ImmutableMap.builderWithExpectedSize((int)partitionColumns.size());
        for (int i = 0; i < partitionColumns.size(); ++i) {
            String columnName = partitionColumns.get(i).getName().toLowerCase(Locale.ENGLISH);
            if (!neededColumnNames.contains(columnName)) continue;
            partitionColumnIndexesBuilder.put((Object)columnName, (Object)i);
        }
        ImmutableMap partitionColumnsByIndex = partitionColumnIndexesBuilder.buildOrThrow();
        ImmutableMap.Builder columnCoercions = ImmutableMap.builder();
        for (int tableColumnIndex = 0; tableColumnIndex < tableColumns.size(); ++tableColumnIndex) {
            Column partitionColumn;
            HiveType partitionType;
            Column tableColumn = tableColumns.get(tableColumnIndex);
            HiveType tableType = tableColumn.getType();
            Integer partitionColumnIndex = (Integer)partitionColumnsByIndex.get(tableColumn.getName().toLowerCase(Locale.ENGLISH));
            if (partitionColumnIndex == null || tableType.equals((Object)(partitionType = (partitionColumn = partitionColumns.get(partitionColumnIndex)).getType()))) continue;
            if (!HiveCoercionPolicy.canCoerce(typeManager, partitionType, tableType, hiveTimestampPrecision)) {
                throw HiveSplitManager.tablePartitionColumnMismatchException(tableName, partName, tableColumn.getName(), tableType, partitionColumn.getName(), partitionType);
            }
            columnCoercions.put((Object)tableColumnIndex, (Object)partitionType.getHiveTypeName());
        }
        return columnCoercions.buildOrThrow();
    }

    private static TrinoException tablePartitionColumnMismatchException(SchemaTableName tableName, String partName, String tableColumnName, HiveType tableType, String partitionColumnName, HiveType partitionType) {
        return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_PARTITION_SCHEMA_MISMATCH, String.format("There is a mismatch between the table and partition schemas. The types are incompatible and cannot be coerced. The column '%s' in table '%s' is declared as type '%s', but partition '%s' declared column '%s' as type '%s'.", tableColumnName, tableName, tableType, partName, partitionColumnName, partitionType));
    }

    static boolean isBucketCountCompatible(int tableBucketCount, int partitionBucketCount) {
        Preconditions.checkArgument((tableBucketCount > 0 && partitionBucketCount > 0 ? 1 : 0) != 0);
        int larger = Math.max(tableBucketCount, partitionBucketCount);
        int smaller = Math.min(tableBucketCount, partitionBucketCount);
        if (larger % smaller != 0) {
            return false;
        }
        return Integer.bitCount(larger / smaller) == 1;
    }

    private static boolean isSortingCompatible(List<SortingColumn> tableSortedColumns, List<SortingColumn> partitionSortedColumns) {
        if (tableSortedColumns.size() > partitionSortedColumns.size()) {
            return false;
        }
        for (int i = 0; i < tableSortedColumns.size(); ++i) {
            SortingColumn partitionSortingColumn;
            SortingColumn tableSortingColumn = tableSortedColumns.get(i);
            if (tableSortingColumn.equals((Object)(partitionSortingColumn = partitionSortedColumns.get(i)))) continue;
            return false;
        }
        return true;
    }

    private static <T> Iterator<List<T>> partitionExponentially(final Iterator<T> values, final int minBatchSize, final int maxBatchSize) {
        return new AbstractIterator<List<T>>(){
            private int currentSize;
            {
                this.currentSize = minBatchSize;
            }

            protected List<T> computeNext() {
                if (!values.hasNext()) {
                    return (List)this.endOfData();
                }
                ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.currentSize);
                for (int count = 0; values.hasNext() && count < this.currentSize; ++count) {
                    builder.add(values.next());
                }
                this.currentSize = Math.min(maxBatchSize, this.currentSize * 2);
                return builder.build();
            }
        };
    }

    private static class ErrorCodedExecutor
    implements Executor {
        private final Executor delegate;

        private ErrorCodedExecutor(Executor delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void execute(Runnable command) {
            try {
                this.delegate.execute(command);
            }
            catch (RejectedExecutionException e) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN, "Server is shutting down", (Throwable)e);
            }
        }
    }
}

