/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.avro;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.hive.formats.avro.NativeLogicalTypesAvroTypeManager;
import io.trino.metastore.HiveType;
import io.trino.metastore.type.Category;
import io.trino.metastore.type.CharTypeInfo;
import io.trino.metastore.type.DecimalTypeInfo;
import io.trino.metastore.type.ListTypeInfo;
import io.trino.metastore.type.MapTypeInfo;
import io.trino.metastore.type.PrimitiveCategory;
import io.trino.metastore.type.PrimitiveTypeInfo;
import io.trino.metastore.type.StructTypeInfo;
import io.trino.metastore.type.TypeInfo;
import io.trino.metastore.type.UnionTypeInfo;
import io.trino.metastore.type.VarcharTypeInfo;
import io.trino.plugin.hive.util.HiveUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;

public final class AvroHiveFileUtils {
    private final AtomicInteger recordNameSuffix = new AtomicInteger(0);

    private AvroHiveFileUtils() {
    }

    public static Schema determineSchemaOrThrowException(TrinoFileSystem fileSystem, Map<String, String> properties) throws IOException {
        String schemaString = properties.getOrDefault("avro.schema.literal", "");
        if (!schemaString.isBlank() && !schemaString.equals("none")) {
            return AvroHiveFileUtils.getSchemaParser().parse(schemaString);
        }
        String schemaURL = properties.getOrDefault("avro.schema.url", "");
        if (!schemaURL.isBlank()) {
            Schema schema;
            block11: {
                TrinoInputFile schemaFile = fileSystem.newInputFile(Location.of((String)schemaURL));
                if (!schemaFile.exists()) {
                    throw new IOException("No avro schema file not found at " + schemaURL);
                }
                TrinoInputStream inputStream = schemaFile.newStream();
                try {
                    schema = AvroHiveFileUtils.getSchemaParser().parse((InputStream)inputStream);
                    if (inputStream == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new IOException("Unable to read avro schema file from given path: " + schemaURL, e);
                    }
                }
                inputStream.close();
            }
            return schema;
        }
        return AvroHiveFileUtils.getSchemaFromProperties(properties);
    }

    private static Schema getSchemaFromProperties(Map<String, String> schema) throws IOException {
        List<String> columnNames = HiveUtil.getColumnNames(schema);
        List<HiveType> columnTypes = HiveUtil.getColumnTypes(schema);
        if (columnNames.isEmpty() || columnTypes.isEmpty()) {
            throw new IOException("Unable to parse column names or column types from schema to create Avro Schema");
        }
        if (columnNames.size() != columnTypes.size()) {
            throw new IllegalArgumentException("Avro Schema initialization failed. Number of column name and column type differs. columnNames = %s, columnTypes = %s".formatted(columnNames, columnTypes));
        }
        List<String> columnComments = Optional.ofNullable(schema.get("columns.comments")).filter(Predicate.not(String::isBlank)).map(arg_0 -> ((Splitter)Splitter.on((char)'\u0000')).splitToList(arg_0)).orElse(Collections.emptyList());
        String tableName = schema.get("name");
        String tableComment = schema.get("comment");
        return AvroHiveFileUtils.constructSchemaFromParts(columnNames, columnTypes, columnComments, Optional.ofNullable(schema.get("avro.schema.namespace")), Optional.ofNullable(schema.getOrDefault("avro.schema.name", tableName)), Optional.ofNullable(schema.getOrDefault("avro.schema.doc", tableComment)));
    }

    private static Schema constructSchemaFromParts(List<String> columnNames, List<HiveType> columnTypes, List<String> columnComments, Optional<String> namespace, Optional<String> name, Optional<String> doc) {
        AvroHiveFileUtils recordIncrementingUtil = new AvroHiveFileUtils();
        SchemaBuilder.RecordBuilder schemaBuilder = SchemaBuilder.record((String)name.orElse("baseRecord"));
        namespace.ifPresent(arg_0 -> ((SchemaBuilder.RecordBuilder)schemaBuilder).namespace(arg_0));
        doc.ifPresent(arg_0 -> ((SchemaBuilder.RecordBuilder)schemaBuilder).doc(arg_0));
        SchemaBuilder.FieldAssembler fieldBuilder = schemaBuilder.fields();
        for (int i = 0; i < columnNames.size(); ++i) {
            String comment = columnComments.size() > i ? columnComments.get(i) : null;
            Schema fieldSchema = recordIncrementingUtil.avroSchemaForHiveType(columnTypes.get(i));
            fieldBuilder = ((SchemaBuilder.FieldBuilder)fieldBuilder.name(columnNames.get(i)).doc(comment)).type(fieldSchema).withDefault(null);
        }
        return (Schema)fieldBuilder.endRecord();
    }

    private Schema avroSchemaForHiveType(HiveType hiveType) {
        Schema schema = switch (hiveType.getCategory()) {
            default -> throw new MatchException(null, null);
            case Category.PRIMITIVE -> AvroHiveFileUtils.createAvroPrimitive(hiveType);
            case Category.LIST -> {
                ListTypeInfo listTypeInfo = (ListTypeInfo)hiveType.getTypeInfo();
                yield Schema.createArray((Schema)this.avroSchemaForHiveType(HiveType.fromTypeInfo((TypeInfo)listTypeInfo.getListElementTypeInfo())));
            }
            case Category.MAP -> {
                PrimitiveTypeInfo primitiveKeyTypeInfo;
                MapTypeInfo mapTypeInfo = (MapTypeInfo)hiveType.getTypeInfo();
                TypeInfo keyTypeInfo = mapTypeInfo.getMapKeyTypeInfo();
                if (!(keyTypeInfo instanceof PrimitiveTypeInfo) || (primitiveKeyTypeInfo = (PrimitiveTypeInfo)keyTypeInfo).getPrimitiveCategory() != PrimitiveCategory.STRING) {
                    throw new UnsupportedOperationException("Key of Map must be a String");
                }
                TypeInfo valueTypeInfo = mapTypeInfo.getMapValueTypeInfo();
                yield Schema.createMap((Schema)this.avroSchemaForHiveType(HiveType.fromTypeInfo((TypeInfo)valueTypeInfo)));
            }
            case Category.STRUCT -> this.createAvroRecord(hiveType);
            case Category.UNION -> {
                ArrayList<Schema> childSchemas = new ArrayList<Schema>();
                for (TypeInfo childTypeInfo : ((UnionTypeInfo)hiveType.getTypeInfo()).getAllUnionObjectTypeInfos()) {
                    Schema childSchema = this.avroSchemaForHiveType(HiveType.fromTypeInfo((TypeInfo)childTypeInfo));
                    if (childSchema.getType() == Schema.Type.UNION) {
                        childSchemas.addAll(childSchema.getTypes());
                        continue;
                    }
                    childSchemas.add(childSchema);
                }
                yield Schema.createUnion(AvroHiveFileUtils.removeDuplicateNullSchemas(childSchemas));
            }
        };
        return AvroHiveFileUtils.wrapInUnionWithNull(schema);
    }

    private static Schema createAvroPrimitive(HiveType hiveType) {
        TypeInfo typeInfo = hiveType.getTypeInfo();
        if (!(typeInfo instanceof PrimitiveTypeInfo)) {
            throw new IllegalStateException("HiveType in primitive category must have PrimitiveTypeInfo");
        }
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
        return switch (primitiveTypeInfo.getPrimitiveCategory()) {
            case PrimitiveCategory.STRING -> Schema.create((Schema.Type)Schema.Type.STRING);
            case PrimitiveCategory.CHAR -> {
                Schema charSchema = (Schema)SchemaBuilder.builder().type(Schema.create((Schema.Type)Schema.Type.STRING));
                charSchema.addProp("logicalType", "char");
                charSchema.addProp("maxLength", (Object)((CharTypeInfo)hiveType.getTypeInfo()).getLength());
                yield charSchema;
            }
            case PrimitiveCategory.VARCHAR -> {
                Schema varcharSchema = (Schema)SchemaBuilder.builder().type(Schema.create((Schema.Type)Schema.Type.STRING));
                varcharSchema.addProp("logicalType", "varchar");
                varcharSchema.addProp("maxLength", (Object)((VarcharTypeInfo)hiveType.getTypeInfo()).getLength());
                yield varcharSchema;
            }
            case PrimitiveCategory.BINARY -> Schema.create((Schema.Type)Schema.Type.BYTES);
            case PrimitiveCategory.BYTE, PrimitiveCategory.SHORT, PrimitiveCategory.INT -> Schema.create((Schema.Type)Schema.Type.INT);
            case PrimitiveCategory.LONG -> Schema.create((Schema.Type)Schema.Type.LONG);
            case PrimitiveCategory.FLOAT -> Schema.create((Schema.Type)Schema.Type.FLOAT);
            case PrimitiveCategory.DOUBLE -> Schema.create((Schema.Type)Schema.Type.DOUBLE);
            case PrimitiveCategory.BOOLEAN -> Schema.create((Schema.Type)Schema.Type.BOOLEAN);
            case PrimitiveCategory.DECIMAL -> {
                DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)hiveType.getTypeInfo();
                LogicalTypes.Decimal decimalLogicalType = LogicalTypes.decimal((int)decimalTypeInfo.precision(), (int)decimalTypeInfo.scale());
                yield decimalLogicalType.addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
            }
            case PrimitiveCategory.DATE -> NativeLogicalTypesAvroTypeManager.DATE_SCHEMA;
            case PrimitiveCategory.TIMESTAMP -> NativeLogicalTypesAvroTypeManager.TIMESTAMP_MILLIS_SCHEMA;
            case PrimitiveCategory.VOID -> Schema.create((Schema.Type)Schema.Type.NULL);
            default -> throw new UnsupportedOperationException(String.valueOf(hiveType) + " is not supported.");
        };
    }

    private Schema createAvroRecord(HiveType hiveType) {
        TypeInfo typeInfo = hiveType.getTypeInfo();
        if (!(typeInfo instanceof StructTypeInfo)) {
            throw new IllegalStateException("HiveType type info must be Struct Type info to make Avro Record");
        }
        StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
        List allStructFieldNames = structTypeInfo.getAllStructFieldNames();
        List allStructFieldTypeInfo = structTypeInfo.getAllStructFieldTypeInfos();
        if (allStructFieldNames.size() != allStructFieldTypeInfo.size()) {
            throw new IllegalArgumentException("Failed to generate avro schema from hive schema. name and column type differs. names = " + String.valueOf(allStructFieldNames) + ", types = " + String.valueOf(allStructFieldTypeInfo));
        }
        SchemaBuilder.FieldAssembler fieldAssembler = ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)("record_" + this.recordNameSuffix.getAndIncrement())).doc(structTypeInfo.toString())).fields();
        for (int i = 0; i < allStructFieldNames.size(); ++i) {
            TypeInfo childTypeInfo = (TypeInfo)allStructFieldTypeInfo.get(i);
            Schema fieldSchema = this.avroSchemaForHiveType(HiveType.fromTypeInfo((TypeInfo)childTypeInfo));
            fieldAssembler = ((SchemaBuilder.FieldBuilder)fieldAssembler.name((String)allStructFieldNames.get(i)).doc(childTypeInfo.toString())).type(fieldSchema).withDefault(null);
        }
        return (Schema)fieldAssembler.endRecord();
    }

    public static Schema wrapInUnionWithNull(Schema schema) {
        return switch (schema.getType()) {
            case Schema.Type.NULL -> schema;
            case Schema.Type.UNION -> Schema.createUnion(AvroHiveFileUtils.removeDuplicateNullSchemas(schema.getTypes()));
            default -> Schema.createUnion(Arrays.asList(Schema.create((Schema.Type)Schema.Type.NULL), schema));
        };
    }

    private static List<Schema> removeDuplicateNullSchemas(List<Schema> childSchemas) {
        ArrayList<Schema> prunedSchemas = new ArrayList<Schema>();
        boolean isNullPresent = false;
        for (Schema schema : childSchemas) {
            if (schema.getType() == Schema.Type.NULL) {
                isNullPresent = true;
                continue;
            }
            prunedSchemas.add(schema);
        }
        if (isNullPresent) {
            prunedSchemas.add(0, Schema.create((Schema.Type)Schema.Type.NULL));
        }
        return prunedSchemas;
    }

    static Map<String, String> getCanonicalToGivenFieldName(Schema schema) {
        return (Map)schema.getFields().stream().map(Schema.Field::name).collect(ImmutableMap.toImmutableMap(fieldName -> fieldName.toLowerCase(Locale.ENGLISH), UnaryOperator.identity()));
    }

    private static Schema.Parser getSchemaParser() {
        return new Schema.Parser().setValidateDefaults(false);
    }
}

