/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.file;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.metastore.Column;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.Partition;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.PartitionWithStatistics;
import io.trino.metastore.Storage;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.Table;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.file.ColumnStatistics;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PartitionMetadata {
    private final List<Column> columns;
    private final Map<String, String> parameters;
    private final Optional<HiveStorageFormat> storageFormat;
    private final Optional<HiveBucketProperty> bucketProperty;
    private final Map<String, String> serdeParameters;
    private final Optional<String> externalLocation;
    private final Map<String, ColumnStatistics> columnStatistics;

    @JsonCreator
    public PartitionMetadata(@JsonProperty(value="columns") List<Column> columns, @JsonProperty(value="parameters") Map<String, String> parameters, @JsonProperty(value="storageFormat") Optional<HiveStorageFormat> storageFormat, @JsonProperty(value="bucketProperty") Optional<HiveBucketProperty> bucketProperty, @JsonProperty(value="serdeParameters") Map<String, String> serdeParameters, @JsonProperty(value="externalLocation") Optional<String> externalLocation, @JsonProperty(value="columnStatistics") Map<String, ColumnStatistics> columnStatistics) {
        this.columns = ImmutableList.copyOf((Collection)Objects.requireNonNull(columns, "columns is null"));
        this.parameters = ImmutableMap.copyOf(Objects.requireNonNull(parameters, "parameters is null"));
        this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
        this.bucketProperty = Objects.requireNonNull(bucketProperty, "bucketProperty is null");
        this.serdeParameters = Objects.requireNonNull(serdeParameters, "serdeParameters is null");
        this.externalLocation = Objects.requireNonNull(externalLocation, "externalLocation is null");
        this.columnStatistics = ImmutableMap.copyOf(Objects.requireNonNull(columnStatistics, "columnStatistics is null"));
    }

    public PartitionMetadata(Table table, PartitionWithStatistics partitionWithStatistics) {
        Partition partition = partitionWithStatistics.getPartition();
        PartitionStatistics statistics = partitionWithStatistics.getStatistics();
        this.columns = partition.getColumns();
        this.parameters = MetastoreUtil.updateStatisticsParameters(partition.getParameters(), statistics.basicStatistics());
        StorageFormat tableFormat = partition.getStorage().getStorageFormat();
        this.storageFormat = Arrays.stream(HiveStorageFormat.values()).filter(format -> tableFormat.equals((Object)format.toStorageFormat())).findFirst();
        this.externalLocation = table.getTableType().equals(TableType.EXTERNAL_TABLE.name()) ? Optional.of(partition.getStorage().getLocation()) : Optional.empty();
        this.bucketProperty = partition.getStorage().getBucketProperty();
        this.serdeParameters = partition.getStorage().getSerdeParameters();
        this.columnStatistics = (Map)statistics.columnStatistics().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> ColumnStatistics.fromHiveColumnStatistics((HiveColumnStatistics)entry.getValue())));
    }

    @JsonProperty
    public List<Column> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @JsonProperty
    public Optional<HiveStorageFormat> getStorageFormat() {
        return this.storageFormat;
    }

    @JsonProperty
    public Optional<HiveBucketProperty> getBucketProperty() {
        return this.bucketProperty;
    }

    @JsonProperty
    public Map<String, String> getSerdeParameters() {
        return this.serdeParameters;
    }

    @JsonProperty
    public Optional<String> getExternalLocation() {
        return this.externalLocation;
    }

    @JsonProperty
    public Map<String, ColumnStatistics> getColumnStatistics() {
        return this.columnStatistics;
    }

    public PartitionMetadata withParameters(Map<String, String> parameters) {
        return new PartitionMetadata(this.columns, parameters, this.storageFormat, this.bucketProperty, this.serdeParameters, this.externalLocation, this.columnStatistics);
    }

    public PartitionMetadata withColumnStatistics(Map<String, ColumnStatistics> columnStatistics) {
        return new PartitionMetadata(this.columns, this.parameters, this.storageFormat, this.bucketProperty, this.serdeParameters, this.externalLocation, columnStatistics);
    }

    public Partition toPartition(String databaseName, String tableName, List<String> values, String location) {
        return new Partition(databaseName, tableName, values, Storage.builder().setLocation(this.externalLocation.orElse(location)).setStorageFormat(this.storageFormat.map(HiveStorageFormat::toStorageFormat).orElse(StorageFormat.VIEW_STORAGE_FORMAT)).setBucketProperty(this.bucketProperty).setSerdeParameters(this.serdeParameters).build(), this.columns, this.parameters);
    }
}

