/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import io.trino.hive.thrift.metastore.ResourceType;
import io.trino.metastore.BooleanStatistics;
import io.trino.metastore.DateStatistics;
import io.trino.metastore.DecimalStatistics;
import io.trino.metastore.DoubleStatistics;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HiveType;
import io.trino.metastore.IntegerStatistics;
import io.trino.metastore.Partition;
import io.trino.metastore.SortingColumn;
import io.trino.metastore.Storage;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.type.PrimitiveCategory;
import io.trino.metastore.type.PrimitiveTypeInfo;
import io.trino.metastore.type.TypeInfo;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.ViewReaderUtil;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.security.PrincipalType;
import jakarta.annotation.Nullable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.concurrent.TimeUnit;
import org.gaul.modernizer_maven_annotations.SuppressModernizer;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.glue.model.BinaryColumnStatisticsData;
import software.amazon.awssdk.services.glue.model.BooleanColumnStatisticsData;
import software.amazon.awssdk.services.glue.model.Column;
import software.amazon.awssdk.services.glue.model.ColumnStatistics;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsData;
import software.amazon.awssdk.services.glue.model.ColumnStatisticsType;
import software.amazon.awssdk.services.glue.model.Database;
import software.amazon.awssdk.services.glue.model.DatabaseInput;
import software.amazon.awssdk.services.glue.model.DateColumnStatisticsData;
import software.amazon.awssdk.services.glue.model.DecimalColumnStatisticsData;
import software.amazon.awssdk.services.glue.model.DecimalNumber;
import software.amazon.awssdk.services.glue.model.DoubleColumnStatisticsData;
import software.amazon.awssdk.services.glue.model.LongColumnStatisticsData;
import software.amazon.awssdk.services.glue.model.Order;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.services.glue.model.ResourceUri;
import software.amazon.awssdk.services.glue.model.SerDeInfo;
import software.amazon.awssdk.services.glue.model.StorageDescriptor;
import software.amazon.awssdk.services.glue.model.StringColumnStatisticsData;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.model.UserDefinedFunction;
import software.amazon.awssdk.services.glue.model.UserDefinedFunctionInput;

public final class GlueConverter {
    static final String PUBLIC_OWNER = "PUBLIC";
    private static final Storage FAKE_PARQUET_STORAGE = new Storage(StorageFormat.create((String)"org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", (String)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat", (String)"org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat"), Optional.empty(), Optional.empty(), false, (Map)ImmutableMap.of());
    private static final io.trino.metastore.Column FAKE_COLUMN = new io.trino.metastore.Column("ignored", HiveType.HIVE_INT, Optional.empty(), (Map)ImmutableMap.of());
    private static final long SECONDS_PER_DAY = TimeUnit.DAYS.toSeconds(1L);
    private static final JsonCodec<LanguageFunction> LANGUAGE_FUNCTION_CODEC = JsonCodec.jsonCodec(LanguageFunction.class);

    private GlueConverter() {
    }

    public static String getTableType(Table glueTable) {
        return (String)MoreObjects.firstNonNull((Object)GlueConverter.getTableTypeNullable(glueTable), (Object)TableType.EXTERNAL_TABLE.name());
    }

    @Nullable
    @SuppressModernizer
    public static String getTableTypeNullable(Table glueTable) {
        return glueTable.tableType();
    }

    public static io.trino.metastore.Database fromGlueDatabase(Database glueDb) {
        return new io.trino.metastore.Database(glueDb.name(), Optional.ofNullable(Strings.emptyToNull((String)glueDb.locationUri())), Optional.of(PUBLIC_OWNER), Optional.of(PrincipalType.ROLE), Optional.ofNullable(glueDb.description()), glueDb.parameters());
    }

    public static DatabaseInput toGlueDatabaseInput(io.trino.metastore.Database database) {
        return (DatabaseInput)DatabaseInput.builder().name(database.getDatabaseName()).parameters(database.getParameters()).description((String)database.getComment().orElse(null)).locationUri((String)database.getLocation().orElse(null)).build();
    }

    public static io.trino.metastore.Table fromGlueTable(Table glueTable, String databaseName) {
        Storage storage;
        Object partitionColumns;
        Object dataColumns;
        StorageDescriptor sd;
        String tableType = GlueConverter.getTableType(glueTable);
        LinkedHashMap<String, String> tableParameters = glueTable.parameters();
        if (glueTable.description() != null) {
            tableParameters = new LinkedHashMap<String, String>(tableParameters);
            tableParameters.put("comment", glueTable.description());
        }
        if ((sd = glueTable.storageDescriptor()) == null) {
            if (!(HiveUtil.isIcebergTable(tableParameters) || HiveUtil.isDeltaLakeTable(tableParameters) || ViewReaderUtil.isTrinoMaterializedView(tableType, tableParameters))) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_UNSUPPORTED_FORMAT, "Table StorageDescriptor is null for table '%s' %s".formatted(databaseName, glueTable.name()));
            }
            dataColumns = ImmutableList.of((Object)FAKE_COLUMN);
            partitionColumns = ImmutableList.of();
            storage = FAKE_PARQUET_STORAGE;
        } else if (HiveUtil.isIcebergTable(tableParameters)) {
            dataColumns = sd.columns() == null ? ImmutableList.of((Object)FAKE_COLUMN) : GlueConverter.fromGlueColumns(sd.columns(), ColumnType.DATA, false);
            partitionColumns = ImmutableList.of();
            storage = FAKE_PARQUET_STORAGE;
        } else if (HiveUtil.isDeltaLakeTable(tableParameters)) {
            dataColumns = ImmutableList.of((Object)FAKE_COLUMN);
            partitionColumns = ImmutableList.of();
            storage = GlueConverter.fromGlueStorage(sd, databaseName + "." + glueTable.name());
        } else {
            boolean isCsv = sd.serdeInfo() != null && HiveStorageFormat.CSV.getSerde().equals(sd.serdeInfo().serializationLibrary());
            dataColumns = GlueConverter.fromGlueColumns(sd.columns(), ColumnType.DATA, isCsv);
            partitionColumns = glueTable.partitionKeys() != null ? GlueConverter.fromGlueColumns(glueTable.partitionKeys(), ColumnType.PARTITION, isCsv) : ImmutableList.of();
            storage = GlueConverter.fromGlueStorage(sd, databaseName + "." + glueTable.name());
        }
        return new io.trino.metastore.Table(databaseName, glueTable.name(), Optional.ofNullable(glueTable.owner()), tableType, storage, (List)dataColumns, (List)partitionColumns, tableParameters, Optional.ofNullable(glueTable.viewOriginalText()), Optional.ofNullable(glueTable.viewExpandedText()), OptionalLong.empty());
    }

    public static TableInput toGlueTableInput(io.trino.metastore.Table table) {
        Map tableParameters = table.getParameters();
        Optional<Object> comment = Optional.empty();
        if (!ViewReaderUtil.isTrinoView(table.getTableType(), table.getParameters()) && !ViewReaderUtil.isTrinoMaterializedView(table.getTableType(), table.getParameters())) {
            comment = Optional.ofNullable((String)tableParameters.get("comment"));
            tableParameters = (Map)tableParameters.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("comment")).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        return (TableInput)TableInput.builder().name(table.getTableName()).owner((String)table.getOwner().orElse(null)).tableType(table.getTableType()).storageDescriptor(GlueConverter.toGlueStorage(table.getStorage(), table.getDataColumns())).partitionKeys((Collection)table.getPartitionColumns().stream().map(GlueConverter::toGlueColumn).collect(ImmutableList.toImmutableList())).parameters(tableParameters).viewOriginalText((String)table.getViewOriginalText().orElse(null)).viewExpandedText((String)table.getViewExpandedText().orElse(null)).description((String)comment.orElse(null)).build();
    }

    public static Partition fromGluePartition(String databaseName, String tableName, software.amazon.awssdk.services.glue.model.Partition gluePartition) {
        Objects.requireNonNull(gluePartition.storageDescriptor(), "Partition StorageDescriptor is null");
        if (!databaseName.equals(gluePartition.databaseName())) {
            throw new IllegalArgumentException("Unexpected databaseName, expected: %s, but found: %s".formatted(databaseName, gluePartition.databaseName()));
        }
        if (!tableName.equals(gluePartition.tableName())) {
            throw new IllegalArgumentException("Unexpected tableName, expected: %s, but found: %s".formatted(tableName, gluePartition.tableName()));
        }
        StorageDescriptor sd = gluePartition.storageDescriptor();
        boolean isCsv = sd.serdeInfo() != null && HiveStorageFormat.CSV.getSerde().equals(sd.serdeInfo().serializationLibrary());
        List partitionName = gluePartition.values();
        return new Partition(databaseName, tableName, partitionName, GlueConverter.fromGlueStorage(sd, databaseName + "." + tableName + "/" + String.valueOf(partitionName)), GlueConverter.fromGlueColumns(sd.columns(), ColumnType.DATA, isCsv), gluePartition.parameters());
    }

    public static PartitionInput toGluePartitionInput(Partition partition) {
        return (PartitionInput)PartitionInput.builder().values((Collection)partition.getValues()).storageDescriptor(GlueConverter.toGlueStorage(partition.getStorage(), partition.getColumns())).parameters(partition.getParameters()).build();
    }

    private static List<io.trino.metastore.Column> fromGlueColumns(List<Column> glueColumns, ColumnType columnType, boolean isCsv) {
        return (List)glueColumns.stream().map(glueColumn -> GlueConverter.fromGlueColumn(glueColumn, columnType, isCsv)).collect(ImmutableList.toImmutableList());
    }

    private static io.trino.metastore.Column fromGlueColumn(Column glueColumn, ColumnType columnType, boolean isCsv) {
        if (columnType == ColumnType.DATA && isCsv) {
            return new io.trino.metastore.Column(glueColumn.name(), HiveType.HIVE_STRING, Optional.ofNullable(glueColumn.comment()), glueColumn.parameters());
        }
        return new io.trino.metastore.Column(glueColumn.name(), HiveType.valueOf((String)glueColumn.type().toLowerCase(Locale.ROOT)), Optional.ofNullable(glueColumn.comment()), glueColumn.parameters());
    }

    private static Column toGlueColumn(io.trino.metastore.Column trinoColumn) {
        return (Column)Column.builder().name(trinoColumn.getName()).type(trinoColumn.getType().toString()).comment((String)trinoColumn.getComment().orElse(null)).parameters(trinoColumn.getProperties()).build();
    }

    private static Storage fromGlueStorage(StorageDescriptor sd, String tablePartitionName) {
        Optional<Object> bucketProperty = Optional.empty();
        if (sd.numberOfBuckets() != null && sd.numberOfBuckets() > 0) {
            if (sd.bucketColumns().isEmpty()) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has 'numBuckets' set, but 'bucketCols' is not set: " + tablePartitionName);
            }
            Object sortBy = ImmutableList.of();
            if (!sd.sortColumns().isEmpty()) {
                sortBy = (List)sd.sortColumns().stream().map(order -> new SortingColumn(order.column(), GlueConverter.fromGlueSortOrder(order.sortOrder(), tablePartitionName))).collect(ImmutableList.toImmutableList());
            }
            bucketProperty = Optional.of(new HiveBucketProperty(sd.bucketColumns(), sd.numberOfBuckets().intValue(), (List)sortBy));
        }
        SerDeInfo serdeInfo = Objects.requireNonNull(sd.serdeInfo(), () -> "StorageDescriptor SerDeInfo is null: " + tablePartitionName);
        return new Storage(StorageFormat.createNullable((String)serdeInfo.serializationLibrary(), (String)sd.inputFormat(), (String)sd.outputFormat()), Optional.ofNullable(sd.location()), bucketProperty, sd.skewedInfo() != null && !sd.skewedInfo().skewedColumnNames().isEmpty(), serdeInfo.parameters());
    }

    private static StorageDescriptor toGlueStorage(Storage storage, List<io.trino.metastore.Column> columns) {
        if (storage.isSkewed()) {
            throw new IllegalArgumentException("Writing to skewed table/partition is not supported");
        }
        SerDeInfo serdeInfo = (SerDeInfo)SerDeInfo.builder().serializationLibrary(storage.getStorageFormat().getSerDeNullable()).parameters(storage.getSerdeParameters()).build();
        StorageDescriptor.Builder builder = StorageDescriptor.builder().location(storage.getLocation()).columns((Collection)columns.stream().map(GlueConverter::toGlueColumn).collect(ImmutableList.toImmutableList())).serdeInfo(serdeInfo).inputFormat(storage.getStorageFormat().getInputFormatNullable()).outputFormat(storage.getStorageFormat().getOutputFormatNullable()).parameters((Map)ImmutableMap.of());
        Optional bucketProperty = storage.getBucketProperty();
        if (bucketProperty.isPresent()) {
            builder.numberOfBuckets(Integer.valueOf(((HiveBucketProperty)bucketProperty.get()).bucketCount()));
            builder.bucketColumns((Collection)((HiveBucketProperty)bucketProperty.get()).bucketedBy());
            if (!((HiveBucketProperty)bucketProperty.get()).sortedBy().isEmpty()) {
                builder.sortColumns((Collection)((HiveBucketProperty)bucketProperty.get()).sortedBy().stream().map(GlueConverter::toGlueSortOrder).collect(ImmutableList.toImmutableList()));
            }
        }
        return (StorageDescriptor)builder.build();
    }

    private static SortingColumn.Order fromGlueSortOrder(Integer value, String tablePartitionName) {
        if (value == 0) {
            return SortingColumn.Order.DESCENDING;
        }
        if (value == 1) {
            return SortingColumn.Order.ASCENDING;
        }
        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_METADATA, "Table/partition metadata has invalid sorting order: " + tablePartitionName);
    }

    private static Order toGlueSortOrder(SortingColumn column) {
        Order.Builder builder = Order.builder().column(column.columnName());
        return (Order)builder.sortOrder(switch (column.order()) {
            default -> throw new MatchException(null, null);
            case SortingColumn.Order.ASCENDING -> 1;
            case SortingColumn.Order.DESCENDING -> 0;
        }).build();
    }

    public static Map<String, HiveColumnStatistics> fromGlueStatistics(List<List<ColumnStatistics>> glueColumnStatistics) {
        ImmutableMap.Builder columnStatistics = ImmutableMap.builder();
        for (List<ColumnStatistics> columns : glueColumnStatistics) {
            for (ColumnStatistics column : columns) {
                GlueConverter.fromGlueColumnStatistics(column.statisticsData()).ifPresent(stats -> columnStatistics.put((Object)column.columnName(), stats));
            }
        }
        return columnStatistics.buildOrThrow();
    }

    private static Optional<HiveColumnStatistics> fromGlueColumnStatistics(ColumnStatisticsData catalogColumnStatisticsData) {
        return switch (catalogColumnStatisticsData.type()) {
            default -> throw new MatchException(null, null);
            case ColumnStatisticsType.BINARY -> {
                BinaryColumnStatisticsData data = catalogColumnStatisticsData.binaryColumnStatisticsData();
                yield Optional.of(HiveColumnStatistics.createBinaryColumnStatistics((OptionalLong)OptionalLong.of(data.maximumLength()), (OptionalDouble)OptionalDouble.of(data.averageLength()), (OptionalLong)ThriftMetastoreUtil.fromMetastoreNullsCount(data.numberOfNulls())));
            }
            case ColumnStatisticsType.BOOLEAN -> {
                BooleanColumnStatisticsData catalogBooleanData = catalogColumnStatisticsData.booleanColumnStatisticsData();
                yield Optional.of(HiveColumnStatistics.createBooleanColumnStatistics((OptionalLong)OptionalLong.of(catalogBooleanData.numberOfTrues()), (OptionalLong)OptionalLong.of(catalogBooleanData.numberOfFalses()), (OptionalLong)ThriftMetastoreUtil.fromMetastoreNullsCount(catalogBooleanData.numberOfNulls())));
            }
            case ColumnStatisticsType.DATE -> {
                DateColumnStatisticsData data = catalogColumnStatisticsData.dateColumnStatisticsData();
                yield Optional.of(HiveColumnStatistics.createDateColumnStatistics(GlueConverter.dateToLocalDate(data.minimumValue()), GlueConverter.dateToLocalDate(data.maximumValue()), (OptionalLong)ThriftMetastoreUtil.fromMetastoreNullsCount(data.numberOfNulls()), (OptionalLong)OptionalLong.of(data.numberOfDistinctValues())));
            }
            case ColumnStatisticsType.DECIMAL -> {
                DecimalColumnStatisticsData data = catalogColumnStatisticsData.decimalColumnStatisticsData();
                yield Optional.of(HiveColumnStatistics.createDecimalColumnStatistics(GlueConverter.fromGlueDecimal(data.minimumValue()), GlueConverter.fromGlueDecimal(data.maximumValue()), (OptionalLong)ThriftMetastoreUtil.fromMetastoreNullsCount(data.numberOfNulls()), (OptionalLong)OptionalLong.of(data.numberOfDistinctValues())));
            }
            case ColumnStatisticsType.DOUBLE -> {
                DoubleColumnStatisticsData data = catalogColumnStatisticsData.doubleColumnStatisticsData();
                yield Optional.of(HiveColumnStatistics.createDoubleColumnStatistics((OptionalDouble)OptionalDouble.of(data.minimumValue()), (OptionalDouble)OptionalDouble.of(data.maximumValue()), (OptionalLong)ThriftMetastoreUtil.fromMetastoreNullsCount(data.numberOfNulls()), (OptionalLong)OptionalLong.of(data.numberOfDistinctValues())));
            }
            case ColumnStatisticsType.LONG -> {
                LongColumnStatisticsData data = catalogColumnStatisticsData.longColumnStatisticsData();
                yield Optional.of(HiveColumnStatistics.createIntegerColumnStatistics((OptionalLong)OptionalLong.of(data.minimumValue()), (OptionalLong)OptionalLong.of(data.maximumValue()), (OptionalLong)ThriftMetastoreUtil.fromMetastoreNullsCount(data.numberOfNulls()), (OptionalLong)OptionalLong.of(data.numberOfDistinctValues())));
            }
            case ColumnStatisticsType.STRING -> {
                StringColumnStatisticsData data = catalogColumnStatisticsData.stringColumnStatisticsData();
                yield Optional.of(HiveColumnStatistics.createStringColumnStatistics((OptionalLong)OptionalLong.of(data.maximumLength()), (OptionalDouble)OptionalDouble.of(data.averageLength()), (OptionalLong)ThriftMetastoreUtil.fromMetastoreNullsCount(data.numberOfNulls()), (OptionalLong)OptionalLong.of(data.numberOfDistinctValues())));
            }
            case ColumnStatisticsType.UNKNOWN_TO_SDK_VERSION -> Optional.empty();
        };
    }

    public static List<ColumnStatistics> toGlueColumnStatistics(Map<io.trino.metastore.Column, HiveColumnStatistics> columnStatistics) {
        return (List)columnStatistics.entrySet().stream().map(e -> GlueConverter.toGlueColumnStatistics((io.trino.metastore.Column)e.getKey(), (HiveColumnStatistics)e.getValue())).flatMap(Optional::stream).collect(ImmutableList.toImmutableList());
    }

    private static Optional<ColumnStatistics> toGlueColumnStatistics(io.trino.metastore.Column column, HiveColumnStatistics statistics) {
        return GlueConverter.toGlueColumnStatisticsData(statistics, column.getType()).map(columnStatisticsData -> (ColumnStatistics)ColumnStatistics.builder().columnName(column.getName()).columnType(column.getType().toString()).statisticsData(columnStatisticsData).analyzedTime(Instant.now()).build());
    }

    private static Optional<ColumnStatisticsData> toGlueColumnStatisticsData(HiveColumnStatistics statistics, HiveType columnType) {
        if (!GlueConverter.isGlueWritable(statistics)) {
            return Optional.empty();
        }
        if (statistics.getBooleanStatistics().isPresent()) {
            BooleanStatistics booleanStatistics = (BooleanStatistics)statistics.getBooleanStatistics().get();
            return Optional.ofNullable((ColumnStatisticsData)ColumnStatisticsData.builder().type(ColumnStatisticsType.BOOLEAN).booleanColumnStatisticsData(builder -> builder.numberOfTrues(GlueConverter.boxedValue(booleanStatistics.getTrueCount())).numberOfFalses(GlueConverter.boxedValue(booleanStatistics.getFalseCount())).numberOfNulls(GlueConverter.boxedValue(statistics.getNullsCount()))).build());
        }
        if (statistics.getDateStatistics().isPresent()) {
            DateStatistics dateStatistics = (DateStatistics)statistics.getDateStatistics().get();
            return Optional.ofNullable((ColumnStatisticsData)ColumnStatisticsData.builder().type(ColumnStatisticsType.DATE).dateColumnStatisticsData(builder -> builder.minimumValue((Instant)dateStatistics.getMin().map(GlueConverter::localDateToDate).orElse(null)).maximumValue((Instant)dateStatistics.getMax().map(GlueConverter::localDateToDate).orElse(null)).numberOfNulls(GlueConverter.boxedValue(statistics.getNullsCount())).numberOfDistinctValues(GlueConverter.boxedValue(statistics.getDistinctValuesWithNullCount()))).build());
        }
        if (statistics.getDecimalStatistics().isPresent()) {
            DecimalStatistics decimalStatistics = (DecimalStatistics)statistics.getDecimalStatistics().get();
            return Optional.ofNullable((ColumnStatisticsData)ColumnStatisticsData.builder().type(ColumnStatisticsType.DECIMAL).decimalColumnStatisticsData(builder -> builder.minimumValue(GlueConverter.toGlueDecimal(decimalStatistics.getMin())).maximumValue(GlueConverter.toGlueDecimal(decimalStatistics.getMax())).numberOfNulls(GlueConverter.boxedValue(statistics.getNullsCount())).numberOfDistinctValues(GlueConverter.boxedValue(statistics.getDistinctValuesWithNullCount()))).build());
        }
        if (statistics.getDoubleStatistics().isPresent()) {
            DoubleStatistics doubleStatistics = (DoubleStatistics)statistics.getDoubleStatistics().get();
            return Optional.ofNullable((ColumnStatisticsData)ColumnStatisticsData.builder().type(ColumnStatisticsType.DOUBLE).doubleColumnStatisticsData(builder -> builder.minimumValue(GlueConverter.boxedValue(doubleStatistics.getMin())).maximumValue(GlueConverter.boxedValue(doubleStatistics.getMax())).numberOfNulls(GlueConverter.boxedValue(statistics.getNullsCount())).numberOfDistinctValues(GlueConverter.boxedValue(statistics.getDistinctValuesWithNullCount()))).build());
        }
        if (statistics.getIntegerStatistics().isPresent()) {
            IntegerStatistics integerStatistics = (IntegerStatistics)statistics.getIntegerStatistics().get();
            return Optional.ofNullable((ColumnStatisticsData)ColumnStatisticsData.builder().type(ColumnStatisticsType.LONG).longColumnStatisticsData(builder -> builder.minimumValue(GlueConverter.boxedValue(integerStatistics.getMin())).maximumValue(GlueConverter.boxedValue(integerStatistics.getMax())).numberOfNulls(GlueConverter.boxedValue(statistics.getNullsCount())).numberOfDistinctValues(GlueConverter.boxedValue(statistics.getDistinctValuesWithNullCount()))).build());
        }
        TypeInfo typeInfo = columnType.getTypeInfo();
        if (!(typeInfo instanceof PrimitiveTypeInfo)) {
            throw new IllegalArgumentException(Strings.lenientFormat((String)"Unsupported statistics type: %s", (Object[])new Object[]{columnType}));
        }
        PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
        PrimitiveCategory primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
        if (PrimitiveCategory.BINARY == primitiveCategory) {
            return Optional.ofNullable((ColumnStatisticsData)ColumnStatisticsData.builder().type(ColumnStatisticsType.BINARY).binaryColumnStatisticsData(builder -> builder.maximumLength(Long.valueOf(statistics.getMaxValueSizeInBytes().orElse(0L))).numberOfNulls(GlueConverter.boxedValue(statistics.getNullsCount())).averageLength(GlueConverter.boxedValue(statistics.getAverageColumnLength()))).build());
        }
        if (PrimitiveCategory.VARCHAR == primitiveCategory || PrimitiveCategory.CHAR == primitiveCategory || PrimitiveCategory.STRING == primitiveCategory) {
            OptionalLong distinctValuesCount = statistics.getDistinctValuesWithNullCount();
            return Optional.ofNullable((ColumnStatisticsData)ColumnStatisticsData.builder().type(ColumnStatisticsType.STRING).stringColumnStatisticsData(builder -> builder.numberOfNulls(GlueConverter.boxedValue(statistics.getNullsCount())).numberOfDistinctValues(GlueConverter.boxedValue(distinctValuesCount)).maximumLength(Long.valueOf(statistics.getMaxValueSizeInBytes().orElse(0L))).averageLength(GlueConverter.boxedValue(statistics.getAverageColumnLength()))).build());
        }
        return Optional.empty();
    }

    private static boolean isGlueWritable(HiveColumnStatistics columnStatistics) {
        if (columnStatistics.getDateStatistics().isPresent()) {
            DateStatistics dateStatistics = (DateStatistics)columnStatistics.getDateStatistics().get();
            return dateStatistics.getMin().isPresent() && dateStatistics.getMax().isPresent();
        }
        if (columnStatistics.getDecimalStatistics().isPresent()) {
            DecimalStatistics decimalStatistics = (DecimalStatistics)columnStatistics.getDecimalStatistics().get();
            return decimalStatistics.getMin().isPresent() && decimalStatistics.getMax().isPresent();
        }
        if (columnStatistics.getDoubleStatistics().isPresent()) {
            DoubleStatistics doubleStatistics = (DoubleStatistics)columnStatistics.getDoubleStatistics().get();
            return doubleStatistics.getMin().isPresent() && doubleStatistics.getMax().isPresent();
        }
        if (columnStatistics.getIntegerStatistics().isPresent()) {
            IntegerStatistics integerStatistics = (IntegerStatistics)columnStatistics.getIntegerStatistics().get();
            return integerStatistics.getMin().isPresent() && integerStatistics.getMax().isPresent();
        }
        return true;
    }

    private static Long boxedValue(OptionalLong optionalLong) {
        return optionalLong.isPresent() ? Long.valueOf(optionalLong.getAsLong()) : null;
    }

    private static Double boxedValue(OptionalDouble optionalDouble) {
        return optionalDouble.isPresent() ? Double.valueOf(optionalDouble.getAsDouble()) : null;
    }

    private static Optional<BigDecimal> fromGlueDecimal(DecimalNumber number) {
        if (number == null) {
            return Optional.empty();
        }
        return Optional.of(new BigDecimal(new BigInteger(number.unscaledValue().asByteArray()), number.scale()));
    }

    private static DecimalNumber toGlueDecimal(Optional<BigDecimal> optionalDecimal) {
        if (optionalDecimal.isEmpty()) {
            return null;
        }
        BigDecimal decimal = optionalDecimal.get();
        return (DecimalNumber)DecimalNumber.builder().unscaledValue(SdkBytes.fromByteArray((byte[])decimal.unscaledValue().toByteArray())).scale(Integer.valueOf(decimal.scale())).build();
    }

    private static Optional<LocalDate> dateToLocalDate(Instant date) {
        if (date == null) {
            return Optional.empty();
        }
        long daysSinceEpoch = date.getEpochSecond() / SECONDS_PER_DAY;
        return Optional.of(LocalDate.ofEpochDay(daysSinceEpoch));
    }

    private static Instant localDateToDate(LocalDate date) {
        long secondsSinceEpoch = date.toEpochDay() * SECONDS_PER_DAY;
        return Instant.ofEpochSecond(secondsSinceEpoch);
    }

    public static LanguageFunction fromGlueFunction(UserDefinedFunction function) {
        List uris = (List)function.resourceUris().stream().map(uri -> new io.trino.hive.thrift.metastore.ResourceUri(ResourceType.FILE, uri.uri())).collect(ImmutableList.toImmutableList());
        LanguageFunction result = ThriftMetastoreUtil.decodeFunction(function.functionName(), uris);
        return new LanguageFunction(result.signatureToken(), result.sql(), result.path(), Optional.ofNullable(function.ownerName()));
    }

    public static UserDefinedFunctionInput toGlueFunctionInput(String functionName, LanguageFunction function) {
        return (UserDefinedFunctionInput)UserDefinedFunctionInput.builder().functionName(MetastoreUtil.metastoreFunctionName(functionName, function.signatureToken())).className("TrinoFunction").ownerType(software.amazon.awssdk.services.glue.model.PrincipalType.USER).ownerName((String)function.owner().orElse(null)).resourceUris(MetastoreUtil.toResourceUris(LANGUAGE_FUNCTION_CODEC.toJsonBytes((Object)function)).stream().map(uri -> (ResourceUri)ResourceUri.builder().resourceType(software.amazon.awssdk.services.glue.model.ResourceType.FILE).uri(uri.getUri()).build()).toList()).build();
    }

    private static enum ColumnType {
        DATA,
        PARTITION;

    }
}

