/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.concurrent.Threads;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.metastore.HiveMetastoreFactory;
import io.trino.metastore.RawHiveMetastoreFactory;
import io.trino.plugin.base.ClosingBinder;
import io.trino.plugin.base.security.UserNameProvider;
import io.trino.plugin.hive.AllowHiveTableRename;
import io.trino.plugin.hive.metastore.thrift.BridgingHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.DefaultThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ForHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.StaticMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.StaticTokenAwareMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftHiveWriteStatisticsExecutor;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreAuthenticationModule;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreClientFactory;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreConfig;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreFactory;
import io.trino.plugin.hive.metastore.thrift.TokenAwareMetastoreClientFactory;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.weakref.jmx.guice.ExportBinder;

public final class ThriftMetastoreModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        StaticMetastoreConfig staticMetastoreConfig = (StaticMetastoreConfig)this.buildConfigObject(StaticMetastoreConfig.class);
        Objects.requireNonNull(staticMetastoreConfig.getMetastoreUris(), "metastoreUris is null");
        OptionalBinder.newOptionalBinder((Binder)binder, ThriftMetastoreClientFactory.class).setDefault().to(DefaultThriftMetastoreClientFactory.class).in(Scopes.SINGLETON);
        binder.bind(TokenAwareMetastoreClientFactory.class).to(StaticTokenAwareMetastoreClientFactory.class).in(Scopes.SINGLETON);
        ConfigBinder.configBinder((Binder)binder).bindConfig(ThriftMetastoreConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get((TypeLiteral)new TypeLiteral<ExecutorService>(this){}, ThriftHiveWriteStatisticsExecutor.class)).setDefault().toProvider(ThriftHiveMetastoreStatisticExecutorProvider.class).in(Scopes.SINGLETON);
        this.install((Module)new ThriftMetastoreAuthenticationModule());
        binder.bind(ThriftMetastoreFactory.class).to(ThriftHiveMetastoreFactory.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(ThriftMetastoreFactory.class).as(generator -> generator.generatedNameOf(ThriftHiveMetastore.class));
        binder.bind(HiveMetastoreFactory.class).annotatedWith(RawHiveMetastoreFactory.class).to(BridgingHiveMetastoreFactory.class).in(Scopes.SINGLETON);
        OptionalBinder.newOptionalBinder((Binder)binder, (Key)Key.get(UserNameProvider.class, ForHiveMetastore.class)).setDefault().toInstance((Object)UserNameProvider.SIMPLE_USER_NAME_PROVIDER);
        binder.bind(Key.get(Boolean.TYPE, AllowHiveTableRename.class)).toInstance((Object)true);
        ClosingBinder.closingBinder((Binder)binder).registerExecutor(Key.get(ExecutorService.class, ThriftHiveWriteStatisticsExecutor.class));
    }

    public boolean equals(Object obj) {
        return obj instanceof ThriftMetastoreModule;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    private static class ThriftHiveMetastoreStatisticExecutorProvider
    implements Provider<ExecutorService> {
        private final int numWriteStatisticsThreads;

        @Inject
        private ThriftHiveMetastoreStatisticExecutorProvider(ThriftMetastoreConfig thriftMetastoreConfig) {
            this.numWriteStatisticsThreads = thriftMetastoreConfig.getWriteStatisticsThreads();
        }

        public ExecutorService get() {
            return Executors.newFixedThreadPool(this.numWriteStatisticsThreads, Threads.threadsNamed((String)"hive-thrift-statistics-write-%s"));
        }
    }
}

