/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import io.trino.metastore.HiveType;
import io.trino.metastore.type.TypeInfo;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SourcePage;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import jakarta.annotation.Nullable;
import java.util.List;

public class BucketAdapter {
    private final int[] bucketColumns;
    private final HiveBucketing.BucketingVersion bucketingVersion;
    private final int bucketToKeep;
    private final int tableBucketCount;
    private final int partitionBucketCount;
    private final List<TypeInfo> typeInfoList;

    public BucketAdapter(HivePageSourceProvider.BucketAdaptation bucketAdaptation) {
        this.bucketColumns = bucketAdaptation.getBucketColumnIndices();
        this.bucketingVersion = bucketAdaptation.getBucketingVersion();
        this.bucketToKeep = bucketAdaptation.getBucketToKeep();
        this.typeInfoList = (List)bucketAdaptation.getBucketColumnHiveTypes().stream().map(HiveType::getTypeInfo).collect(ImmutableList.toImmutableList());
        this.tableBucketCount = bucketAdaptation.getTableBucketCount();
        this.partitionBucketCount = bucketAdaptation.getPartitionBucketCount();
    }

    @Nullable
    public SourcePage filterPageToEligibleRowsOrDiscard(SourcePage page) {
        IntArrayList ids = new IntArrayList(page.getPositionCount());
        Page bucketColumnsPage = page.getColumns(this.bucketColumns);
        for (int position = 0; position < page.getPositionCount(); ++position) {
            int bucket = HiveBucketing.getHiveBucket(this.bucketingVersion, this.tableBucketCount, this.typeInfoList, bucketColumnsPage, position);
            if ((bucket - this.bucketToKeep) % this.partitionBucketCount != 0) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_INVALID_BUCKET_FILES, String.format("A row that is supposed to be in bucket %s is encountered. Only rows in bucket %s (modulo %s) are expected", bucket, this.bucketToKeep % this.partitionBucketCount, this.partitionBucketCount));
            }
            if (bucket != this.bucketToKeep) continue;
            ids.add(position);
        }
        int retainedRowCount = ids.size();
        if (retainedRowCount == 0) {
            return null;
        }
        if (retainedRowCount == page.getPositionCount()) {
            return page;
        }
        page.selectPositions(ids.elements(), 0, retainedRowCount);
        return page;
    }
}

