/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaTableName;
import java.util.Optional;

public class HiveReadOnlyException
extends TrinoException {
    public HiveReadOnlyException(SchemaTableName tableName, Optional<String> partition) {
        super((ErrorCodeSupplier)(partition.isPresent() ? HiveErrorCode.HIVE_PARTITION_READ_ONLY : HiveErrorCode.HIVE_TABLE_READ_ONLY), HiveReadOnlyException.composeMessage(tableName, partition));
    }

    private static String composeMessage(SchemaTableName tableName, Optional<String> partition) {
        return partition.isPresent() ? String.format("Table '%s' partition '%s' is read-only", tableName, partition.get()) : String.format("Table '%s' is read-only", tableName);
    }
}

