/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.glue;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.opentelemetry.context.Context;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.metastore.Column;
import io.trino.metastore.HiveBasicStatistics;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HivePrivilegeInfo;
import io.trino.metastore.HiveType;
import io.trino.metastore.Partition;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.PartitionWithStatistics;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.SchemaAlreadyExistsException;
import io.trino.metastore.StatisticsUpdateMode;
import io.trino.metastore.TableAlreadyExistsException;
import io.trino.metastore.TableInfo;
import io.trino.plugin.base.util.ExecutorUtil;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartitionManager;
import io.trino.plugin.hive.PartitionNotFoundException;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.glue.GlueCache;
import io.trino.plugin.hive.metastore.glue.GlueContext;
import io.trino.plugin.hive.metastore.glue.GlueConverter;
import io.trino.plugin.hive.metastore.glue.GlueExpressionUtil;
import io.trino.plugin.hive.metastore.glue.GlueHiveMetastoreConfig;
import io.trino.plugin.hive.metastore.glue.GlueMetastoreStats;
import io.trino.plugin.hive.metastore.glue.PartitionName;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.ErrorType;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.catalog.CatalogName;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import jakarta.annotation.Nullable;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.AccessDeniedException;
import software.amazon.awssdk.services.glue.model.AlreadyExistsException;
import software.amazon.awssdk.services.glue.model.BatchCreatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchGetPartitionResponse;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.BatchUpdatePartitionRequestEntry;
import software.amazon.awssdk.services.glue.model.ColumnStatistics;
import software.amazon.awssdk.services.glue.model.CreateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.CreateTableRequest;
import software.amazon.awssdk.services.glue.model.CreateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.Database;
import software.amazon.awssdk.services.glue.model.DatabaseInput;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.DeleteColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteDatabaseRequest;
import software.amazon.awssdk.services.glue.model.DeletePartitionRequest;
import software.amazon.awssdk.services.glue.model.DeleteTableRequest;
import software.amazon.awssdk.services.glue.model.DeleteUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.EntityNotFoundException;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseRequest;
import software.amazon.awssdk.services.glue.model.GetDatabaseResponse;
import software.amazon.awssdk.services.glue.model.GetDatabasesResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionResponse;
import software.amazon.awssdk.services.glue.model.GetPartitionsRequest;
import software.amazon.awssdk.services.glue.model.GetPartitionsResponse;
import software.amazon.awssdk.services.glue.model.GetTableRequest;
import software.amazon.awssdk.services.glue.model.GetTableResponse;
import software.amazon.awssdk.services.glue.model.GetTablesRequest;
import software.amazon.awssdk.services.glue.model.GetTablesResponse;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsRequest;
import software.amazon.awssdk.services.glue.model.GetUserDefinedFunctionsResponse;
import software.amazon.awssdk.services.glue.model.PartitionInput;
import software.amazon.awssdk.services.glue.model.PartitionValueList;
import software.amazon.awssdk.services.glue.model.Segment;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.TableInput;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForPartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdateColumnStatisticsForTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateDatabaseRequest;
import software.amazon.awssdk.services.glue.model.UpdatePartitionRequest;
import software.amazon.awssdk.services.glue.model.UpdateTableRequest;
import software.amazon.awssdk.services.glue.model.UpdateUserDefinedFunctionRequest;
import software.amazon.awssdk.services.glue.model.UserDefinedFunctionInput;

public class GlueHiveMetastore
implements HiveMetastore {
    private static final Logger log = Logger.get(GlueHiveMetastore.class);
    private static final String PUBLIC_ROLE_NAME = "public";
    private static final String DEFAULT_METASTORE_USER = "trino";
    private static final int GLUE_COLUMN_READ_STAT_PAGE_SIZE = 100;
    private static final int GLUE_COLUMN_WRITE_STAT_PAGE_SIZE = 25;
    private static final int BATCH_GET_PARTITION_MAX_PAGE_SIZE = 1000;
    private static final int AWS_GLUE_GET_PARTITIONS_MAX_RESULTS = 1000;
    private static final int BATCH_UPDATE_PARTITION_MAX_PAGE_SIZE = 100;
    private static final int AWS_GLUE_GET_FUNCTIONS_MAX_RESULTS = 100;
    private final GlueClient glueClient;
    private final GlueContext glueContext;
    private final GlueCache glueCache;
    private final GlueMetastoreStats stats;
    private final TrinoFileSystem fileSystem;
    private final Optional<String> defaultDir;
    private final int partitionSegments;
    private final boolean assumeCanonicalPartitionKeys;
    private final Predicate<Table> tableVisibilityFilter;
    private final ExecutorService executor;

    @Inject
    public GlueHiveMetastore(GlueClient glueClient, GlueContext glueContext, GlueCache glueCache, GlueMetastoreStats glueStats, TrinoFileSystemFactory fileSystemFactory, GlueHiveMetastoreConfig config, CatalogName catalogName, Set<TableKind> visibleTableKinds) {
        this(glueClient, glueContext, glueCache, glueStats, fileSystemFactory.create(ConnectorIdentity.ofUser((String)DEFAULT_METASTORE_USER)), config.getDefaultWarehouseDir(), config.getPartitionSegments(), config.isAssumeCanonicalPartitionKeys(), visibleTableKinds, Executors.newFixedThreadPool(config.getThreads(), Threads.daemonThreadsNamed((String)("glue-" + String.valueOf(catalogName) + "-%s"))));
    }

    private GlueHiveMetastore(GlueClient glueClient, GlueContext glueContext, GlueCache glueCache, GlueMetastoreStats glueStats, TrinoFileSystem fileSystem, Optional<String> defaultDir, int partitionSegments, boolean assumeCanonicalPartitionKeys, Set<TableKind> visibleTableKinds, ExecutorService executor) {
        this.glueClient = Objects.requireNonNull(glueClient, "glueClient is null");
        this.glueContext = Objects.requireNonNull(glueContext, "glueContext is null");
        this.glueCache = glueCache;
        this.stats = Objects.requireNonNull(glueStats, "glueStats is null");
        this.fileSystem = Objects.requireNonNull(fileSystem, "fileSystem is null");
        this.defaultDir = Objects.requireNonNull(defaultDir, "defaultDir is null");
        this.partitionSegments = partitionSegments;
        this.assumeCanonicalPartitionKeys = assumeCanonicalPartitionKeys;
        this.tableVisibilityFilter = GlueHiveMetastore.createTablePredicate(visibleTableKinds);
        this.executor = Context.taskWrapping((ExecutorService)Objects.requireNonNull(executor, "executor is null"));
    }

    @PreDestroy
    public void shutdown() {
        this.executor.shutdownNow();
    }

    @Managed
    @Flatten
    public GlueMetastoreStats getStats() {
        return this.stats;
    }

    @Managed
    @Flatten
    public GlueCache getGlueCache() {
        return this.glueCache;
    }

    public List<String> getAllDatabases() {
        return this.glueCache.getDatabaseNames(this::getDatabasesInternal);
    }

    private List<String> getDatabasesInternal(Consumer<io.trino.metastore.Database> cacheDatabase) {
        try {
            return this.stats.getGetDatabases().call(() -> this.glueClient.getDatabasesPaginator(this.glueContext::configureClient).stream().map(GetDatabasesResponse::databaseList).flatMap(Collection::stream).map(GlueConverter::fromGlueDatabase).peek(cacheDatabase).map(io.trino.metastore.Database::getDatabaseName).toList());
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    public Optional<io.trino.metastore.Database> getDatabase(String databaseName) {
        return this.glueCache.getDatabase(databaseName, () -> this.getDatabaseInternal(databaseName));
    }

    private Optional<io.trino.metastore.Database> getDatabaseInternal(String databaseName) {
        try {
            GetDatabaseResponse response = this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(builder -> ((GetDatabaseRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).name(databaseName)));
            return Optional.of(GlueConverter.fromGlueDatabase(response.database()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    public void createDatabase(io.trino.metastore.Database database) {
        Location location;
        if (database.getLocation().isEmpty() && this.defaultDir.isPresent()) {
            location = Location.of((String)this.defaultDir.get()).appendPath(HiveUtil.escapeSchemaName(database.getDatabaseName()));
            database = io.trino.metastore.Database.builder((io.trino.metastore.Database)database).setLocation(Optional.of(location.toString())).build();
        }
        try {
            DatabaseInput databaseInput = GlueConverter.toGlueDatabaseInput(database);
            this.stats.getCreateDatabase().call(() -> this.glueClient.createDatabase(builder -> ((CreateDatabaseRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseInput(databaseInput)));
        }
        catch (AlreadyExistsException e) {
            String existingQueryId;
            String expectedQueryId = (String)database.getParameters().get("trino_query_id");
            if (expectedQueryId != null && expectedQueryId.equals(existingQueryId = (String)this.getDatabase(database.getDatabaseName()).map(io.trino.metastore.Database::getParameters).map(parameters -> (String)parameters.get("trino_query_id")).orElse(null))) {
                return;
            }
            throw new SchemaAlreadyExistsException(database.getDatabaseName(), (Throwable)e);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidateDatabase(database.getDatabaseName());
            this.glueCache.invalidateDatabaseNames();
        }
        if (database.getLocation().isPresent()) {
            location = Location.of((String)((String)database.getLocation().get()));
            try {
                this.fileSystem.createDirectory(location);
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILESYSTEM_ERROR, "Failed to create directory: " + String.valueOf(location), (Throwable)e);
            }
        }
    }

    public void dropDatabase(String databaseName, boolean deleteData) {
        Optional<Object> location = Optional.empty();
        if (deleteData) {
            location = this.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName)).getLocation().map(Location::of);
        }
        try {
            this.stats.getDeleteDatabase().call(() -> this.glueClient.deleteDatabase(builder -> ((DeleteDatabaseRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).name(databaseName)));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(databaseName, (Throwable)e);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidateDatabase(databaseName);
            this.glueCache.invalidateDatabaseNames();
        }
        location.ifPresent(this::deleteDir);
    }

    public void renameDatabase(String databaseName, String newDatabaseName) {
        try {
            Database database = this.stats.getGetDatabase().call(() -> this.glueClient.getDatabase(builder -> ((GetDatabaseRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).name(databaseName)).database());
            DatabaseInput renamedDatabase = (DatabaseInput)DatabaseInput.builder().name(newDatabaseName).parameters(database.parameters()).description(database.description()).locationUri(database.locationUri()).build();
            this.stats.getUpdateDatabase().call(() -> this.glueClient.updateDatabase(builder -> ((UpdateDatabaseRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).name(databaseName).databaseInput(renamedDatabase)));
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(databaseName, (Throwable)e);
        }
        catch (AlreadyExistsException e) {
            throw new SchemaAlreadyExistsException(newDatabaseName, (Throwable)e);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidateDatabase(databaseName);
            this.glueCache.invalidateDatabase(newDatabaseName);
            this.glueCache.invalidateDatabaseNames();
        }
    }

    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "setting the database owner is not supported by Glue");
    }

    public List<TableInfo> getTables(String databaseName) {
        return this.glueCache.getTables(databaseName, cacheTable -> this.getTablesInternal((Consumer<io.trino.metastore.Table>)cacheTable, databaseName, table -> true));
    }

    public List<String> getTableNamesWithParameters(String databaseName, String parameterKey, ImmutableSet<String> parameterValues) {
        return (List)this.getTablesInternal(table -> {}, databaseName, table -> table.parameters() != null && parameterValues.contains(table.parameters().get(parameterKey))).stream().map(tableInfo -> tableInfo.tableName().getTableName()).collect(ImmutableList.toImmutableList());
    }

    private List<TableInfo> getTablesInternal(Consumer<io.trino.metastore.Table> cacheTable, String databaseName, Predicate<Table> filter) {
        try {
            ImmutableList glueTables = (ImmutableList)this.stats.getGetTables().call(() -> this.glueClient.getTablesPaginator(builder -> ((GetTablesRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName)).stream().map(GetTablesResponse::tableList).flatMap(Collection::stream)).filter(this.tableVisibilityFilter).filter(filter).collect(ImmutableList.toImmutableList());
            for (Table table2 : glueTables) {
                GlueHiveMetastore.convertFromGlueIgnoringErrors(table2, databaseName).ifPresent(cacheTable);
            }
            return glueTables.stream().map(table -> new TableInfo(new SchemaTableName(databaseName, table.name()), TableInfo.ExtendedRelationType.fromTableTypeAndComment((String)GlueConverter.getTableType(table), (String)((String)table.parameters().get("comment"))))).toList();
        }
        catch (EntityNotFoundException glueTables) {
            return ImmutableList.of();
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    private static Optional<io.trino.metastore.Table> convertFromGlueIgnoringErrors(Table glueTable, String databaseName) {
        try {
            return Optional.of(GlueConverter.fromGlueTable(glueTable, databaseName));
        }
        catch (RuntimeException e) {
            GlueHiveMetastore.handleListingError(e, SchemaTableName.schemaTableName((String)glueTable.databaseName(), (String)glueTable.name()));
            return Optional.empty();
        }
    }

    private static void handleListingError(RuntimeException e, SchemaTableName tableName) {
        boolean silent = false;
        if (e instanceof TrinoException) {
            TrinoException trinoException = (TrinoException)((Object)e);
            ErrorCode errorCode = trinoException.getErrorCode();
            boolean bl = silent = errorCode.equals((Object)StandardErrorCode.UNSUPPORTED_TABLE_TYPE.toErrorCode()) || errorCode.equals((Object)StandardErrorCode.TABLE_NOT_FOUND.toErrorCode()) || errorCode.equals((Object)StandardErrorCode.NOT_FOUND.toErrorCode()) || errorCode.getType() == ErrorType.EXTERNAL;
        }
        if (silent) {
            log.debug((Throwable)e, "Failed to get metadata for table: %s", new Object[]{tableName});
        } else {
            log.warn((Throwable)e, "Failed to get metadata for table: %s", new Object[]{tableName});
        }
    }

    public Optional<io.trino.metastore.Table> getTable(String databaseName, String tableName) {
        return this.glueCache.getTable(databaseName, tableName, () -> this.getTableInternal(databaseName, tableName));
    }

    private Optional<io.trino.metastore.Table> getTableInternal(String databaseName, String tableName) {
        try {
            GetTableResponse result = this.stats.getGetTable().call(() -> this.glueClient.getTable(builder -> ((GetTableRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).name(tableName)));
            return Optional.of(GlueConverter.fromGlueTable(result.table(), databaseName));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    public void createTable(io.trino.metastore.Table table, PrincipalPrivileges principalPrivileges) {
        try {
            TableInput input = GlueConverter.toGlueTableInput(table);
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(builder -> ((CreateTableRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(table.getDatabaseName()).tableInput(input)));
        }
        catch (AlreadyExistsException e) {
            String existingQueryId;
            String expectedQueryId = (String)table.getParameters().get("trino_query_id");
            if (expectedQueryId != null && expectedQueryId.equals(existingQueryId = (String)this.getTable(table.getDatabaseName(), table.getTableName()).map(io.trino.metastore.Table::getParameters).map(parameters -> (String)parameters.get("trino_query_id")).orElse(null))) {
                return;
            }
            throw new TableAlreadyExistsException(new SchemaTableName(table.getDatabaseName(), table.getTableName()), (Throwable)e);
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(table.getDatabaseName(), (Throwable)e);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidateTable(table.getDatabaseName(), table.getTableName(), true);
            this.glueCache.invalidateTables(table.getDatabaseName());
        }
    }

    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        io.trino.metastore.Table table;
        Optional<Object> deleteLocation = Optional.empty();
        if (deleteData && (table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)))).getTableType().equals(TableType.MANAGED_TABLE.name())) {
            deleteLocation = table.getStorage().getOptionalLocation().filter(Predicate.not(String::isEmpty)).map(Location::of);
        }
        DeleteTableRequest deleteTableRequest = (DeleteTableRequest)((DeleteTableRequest.Builder)DeleteTableRequest.builder().applyMutation(this.glueContext::configureClient)).databaseName(databaseName).name(tableName).build();
        try {
            this.stats.getDeleteTable().call(() -> this.glueClient.deleteTable(deleteTableRequest));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidateTable(databaseName, tableName, true);
            this.glueCache.invalidateTables(databaseName);
        }
        deleteLocation.ifPresent(this::deleteDir);
    }

    private void deleteDir(Location path) {
        try {
            this.fileSystem.deleteDirectory(path);
        }
        catch (Exception e) {
            log.warn((Throwable)e, "Failed to delete path: %s", new Object[]{path});
        }
    }

    public void replaceTable(String databaseName, String tableName, io.trino.metastore.Table newTable, PrincipalPrivileges principalPrivileges) {
        if (!tableName.equals(newTable.getTableName()) || !databaseName.equals(newTable.getDatabaseName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Table rename is not yet supported by Glue service");
        }
        this.updateTable(databaseName, tableName, table -> newTable);
    }

    private void updateTable(String databaseName, String tableName, UnaryOperator<io.trino.metastore.Table> modifier) {
        io.trino.metastore.Table existingTable = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        io.trino.metastore.Table newTable = (io.trino.metastore.Table)modifier.apply(existingTable);
        if (!existingTable.getDatabaseName().equals(newTable.getDatabaseName()) || !existingTable.getTableName().equals(newTable.getTableName())) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Update cannot be used to change rename a table");
        }
        if (existingTable.getParameters().getOrDefault("table_type", "").equalsIgnoreCase("iceberg") && !Objects.equals(existingTable.getParameters().get("metadata_location"), newTable.getParameters().get("previous_metadata_location"))) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Cannot update Iceberg table: supplied previous location does not match current location");
        }
        try {
            this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(builder -> ((UpdateTableRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableInput(GlueConverter.toGlueTableInput(newTable))));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidateTable(databaseName, tableName, false);
        }
    }

    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        Table table;
        try {
            table = this.stats.getGetTable().call(() -> this.glueClient.getTable(builder -> ((GetTableRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).name(tableName)).table());
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        try {
            CreateTableRequest createTableRequest = (CreateTableRequest)((CreateTableRequest.Builder)CreateTableRequest.builder().applyMutation(this.glueContext::configureClient)).databaseName(newDatabaseName).tableInput((TableInput)GlueHiveMetastore.asTableInputBuilder(table).name(newTableName).build()).build();
            this.stats.getCreateTable().call(() -> this.glueClient.createTable(createTableRequest));
        }
        catch (AlreadyExistsException e) {
            throw new TableAlreadyExistsException(new SchemaTableName(databaseName, tableName));
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        try {
            this.dropTable(databaseName, tableName, false);
        }
        catch (RuntimeException e) {
            block15: {
                try {
                    this.dropTable(databaseName, tableName, false);
                }
                catch (RuntimeException cleanupException) {
                    if (cleanupException.equals(e)) break block15;
                    e.addSuppressed(cleanupException);
                }
            }
            throw e;
        }
        finally {
            this.glueCache.invalidateTable(databaseName, tableName, true);
            this.glueCache.invalidateTable(newDatabaseName, newTableName, true);
            this.glueCache.invalidateTables(databaseName);
            if (!databaseName.equals(newDatabaseName)) {
                this.glueCache.invalidateTables(newDatabaseName);
            }
        }
    }

    public static TableInput.Builder asTableInputBuilder(Table table) {
        return TableInput.builder().name(table.name()).description(table.description()).owner(table.owner()).lastAccessTime(table.lastAccessTime()).lastAnalyzedTime(table.lastAnalyzedTime()).retention(table.retention()).storageDescriptor(table.storageDescriptor()).partitionKeys((Collection)table.partitionKeys()).viewOriginalText(table.viewOriginalText()).viewExpandedText(table.viewExpandedText()).tableType(GlueConverter.getTableTypeNullable(table)).targetTable(table.targetTable()).parameters(table.parameters());
    }

    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        this.updateTable(databaseName, tableName, table -> table.withComment(comment));
    }

    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        this.updateTable(databaseName, tableName, table -> table.withOwner(principal));
    }

    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
        return this.glueCache.getTableColumnStatistics(databaseName, tableName, columnNames, missingColumnNames -> this.getTableColumnStatisticsInternal(databaseName, tableName, (Set<String>)missingColumnNames));
    }

    private Map<String, HiveColumnStatistics> getTableColumnStatisticsInternal(String databaseName, String tableName, Set<String> columnNames) {
        ImmutableList columnStatsTasks = (ImmutableList)Lists.partition((List)ImmutableList.copyOf(columnNames), (int)100).stream().map(partialColumns -> () -> this.stats.getGetColumnStatisticsForTable().call(() -> this.glueClient.getColumnStatisticsForTable(builder -> ((GetColumnStatisticsForTableRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableName(tableName).columnNames((Collection)partialColumns)).columnStatisticsList())).collect(ImmutableList.toImmutableList());
        try {
            return GlueConverter.fromGlueStatistics(this.runParallel((Collection)columnStatsTasks));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed fetching column statistics for %s.%s".formatted(databaseName, tableName), e.getCause());
        }
    }

    public void updateTableStatistics(String databaseName, String tableName, OptionalLong acidWriteId, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate) {
        BasicTableStatisticsResult result;
        Verify.verify((boolean)acidWriteId.isEmpty(), (String)"Glue metastore does not support Hive Acid tables", (Object[])new Object[0]);
        if (mode == StatisticsUpdateMode.MERGE_INCREMENTAL && statisticsUpdate.basicStatistics().getRowCount().equals(OptionalLong.of(0L))) {
            return;
        }
        Object existingColumnStatistics = mode == StatisticsUpdateMode.MERGE_INCREMENTAL ? this.getTableColumnStatistics(databaseName, tableName, statisticsUpdate.columnStatistics().keySet()) : ImmutableMap.of();
        try {
            result = this.updateBasicTableStatistics(databaseName, tableName, mode, statisticsUpdate, (Map<String, HiveColumnStatistics>)existingColumnStatistics);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidateTable(databaseName, tableName, true);
        }
        ArrayList tasks = new ArrayList();
        Lists.partition(GlueConverter.toGlueColumnStatistics(result.updateColumnStatistics()), (int)25).stream().map(chunk -> () -> {
            this.stats.getUpdateColumnStatisticsForTable().call(() -> this.glueClient.updateColumnStatisticsForTable(builder -> ((UpdateColumnStatisticsForTableRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableName(tableName).columnStatisticsList((Collection)chunk)));
            return null;
        }).forEach(tasks::add);
        result.removeColumnStatistics().stream().map(columnName -> () -> {
            this.stats.getDeleteColumnStatisticsForTable().call(() -> this.glueClient.deleteColumnStatisticsForTable(builder -> ((DeleteColumnStatisticsForTableRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableName(tableName).columnName(columnName)));
            return null;
        }).forEach(tasks::add);
        try {
            this.runParallel(tasks);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed updating column statistics for %s.%s".formatted(databaseName, tableName), e.getCause());
        }
        finally {
            this.glueCache.invalidateTableColumnStatistics(databaseName, tableName);
        }
    }

    private BasicTableStatisticsResult updateBasicTableStatistics(String databaseName, String tableName, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate, Map<String, HiveColumnStatistics> existingColumnStatistics) {
        io.trino.metastore.Table table = this.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        PartitionStatistics existingTableStats = new PartitionStatistics(MetastoreUtil.getHiveBasicStatistics(table.getParameters()), existingColumnStatistics);
        PartitionStatistics updatedStatistics = mode.updatePartitionStatistics(existingTableStats, statisticsUpdate);
        this.stats.getUpdateTable().call(() -> this.glueClient.updateTable(builder -> ((UpdateTableRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableInput(GlueConverter.toGlueTableInput(table.withParameters(MetastoreUtil.updateStatisticsParameters(table.getParameters(), updatedStatistics.basicStatistics()))))));
        Map columns = (Map)Stream.concat(table.getDataColumns().stream(), table.getPartitionColumns().stream()).collect(ImmutableMap.toImmutableMap(Column::getName, UnaryOperator.identity()));
        Map updateColumnStatistics = (Map)columns.values().stream().filter(column -> updatedStatistics.columnStatistics().containsKey(column.getName())).collect(ImmutableMap.toImmutableMap(UnaryOperator.identity(), column -> (HiveColumnStatistics)updatedStatistics.columnStatistics().get(column.getName())));
        Object removeColumnStatistics = switch (mode) {
            default -> throw new MatchException(null, null);
            case StatisticsUpdateMode.OVERWRITE_SOME_COLUMNS -> ImmutableSet.of();
            case StatisticsUpdateMode.OVERWRITE_ALL, StatisticsUpdateMode.MERGE_INCREMENTAL -> columns.entrySet().stream().filter(entry -> !updateColumnStatistics.containsKey(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            case StatisticsUpdateMode.UNDO_MERGE_INCREMENTAL, StatisticsUpdateMode.CLEAR_ALL -> columns.keySet();
        };
        return new BasicTableStatisticsResult(updateColumnStatistics, (Set<String>)removeColumnStatistics);
    }

    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Column newColumn = new Column(columnName, columnType, Optional.ofNullable(columnComment), (Map)ImmutableMap.of());
        this.updateTable(databaseName, tableName, table -> table.withAddColumn(newColumn));
    }

    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        this.updateTable(databaseName, tableName, table -> table.withRenameColumn(oldColumnName, newColumnName));
    }

    public void dropColumn(String databaseName, String tableName, String columnName) throws EntityNotFoundException {
        this.updateTable(databaseName, tableName, table -> table.withDropColumn(columnName));
    }

    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) throws EntityNotFoundException {
        this.updateTable(databaseName, tableName, table -> table.withColumnComment(columnName, comment));
    }

    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        if (partitionKeysFilter.isNone()) {
            return Optional.of(ImmutableList.of());
        }
        String glueFilterExpression = GlueExpressionUtil.buildGlueExpression(columnNames, partitionKeysFilter, this.assumeCanonicalPartitionKeys);
        Set<PartitionName> partitionNames = this.glueCache.getPartitionNames(databaseName, tableName, glueFilterExpression, (Consumer<Partition> cachePartition) -> this.getPartitionNames((Consumer<Partition>)cachePartition, databaseName, tableName, glueFilterExpression));
        return Optional.of((List)partitionNames.stream().map(PartitionName::partitionValues).map(partitionValues -> MetastoreUtil.toPartitionName(columnNames, partitionValues)).collect(ImmutableList.toImmutableList()));
    }

    private Set<PartitionName> getPartitionNames(Consumer<Partition> cachePartition, String databaseName, String tableName, String glueExpression) throws EntityNotFoundException {
        if (this.partitionSegments == 1) {
            return this.getPartitionNames(cachePartition, databaseName, tableName, glueExpression, null);
        }
        try {
            return (Set)this.runParallel(IntStream.range(0, this.partitionSegments).mapToObj(segmentNumber -> () -> this.getPartitionNames(cachePartition, databaseName, tableName, glueExpression, (Segment)Segment.builder().segmentNumber(Integer.valueOf(segmentNumber)).totalSegments(Integer.valueOf(this.partitionSegments)).build())).toList()).stream().flatMap(Collection::stream).collect(ImmutableSet.toImmutableSet());
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, e.getCause());
        }
    }

    private Set<PartitionName> getPartitionNames(Consumer<Partition> cachePartition, String databaseName, String tableName, String expression, @Nullable Segment segment) throws EntityNotFoundException {
        try {
            return (Set)this.stats.getGetPartitionNames().call(() -> (ImmutableSet)this.glueClient.getPartitionsPaginator(builder -> ((GetPartitionsRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableName(tableName).expression(expression).segment(segment).maxResults(Integer.valueOf(1000))).stream().map(GetPartitionsResponse::partitions).flatMap(Collection::stream).map(partition -> GlueConverter.fromGluePartition(databaseName, tableName, partition)).peek(cachePartition).map(Partition::getValues).map(PartitionName::new).collect(ImmutableSet.toImmutableSet()));
        }
        catch (EntityNotFoundException e) {
            throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    public Optional<Partition> getPartition(io.trino.metastore.Table table, List<String> partitionValues) {
        String databaseName = table.getDatabaseName();
        String tableName = table.getTableName();
        PartitionName partitionName = new PartitionName(partitionValues);
        return this.glueCache.getPartition(databaseName, tableName, partitionName, () -> this.getPartition(databaseName, tableName, partitionName));
    }

    private Optional<Partition> getPartition(String databaseName, String tableName, PartitionName partitionName) {
        try {
            GetPartitionResponse result = this.stats.getGetPartition().call(() -> this.glueClient.getPartition(builder -> ((GetPartitionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableName(tableName).partitionValues(partitionName.partitionValues())));
            return Optional.of(GlueConverter.fromGluePartition(databaseName, tableName, result.partition()));
        }
        catch (EntityNotFoundException e) {
            return Optional.empty();
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    public Map<String, Optional<Partition>> getPartitionsByNames(io.trino.metastore.Table table, List<String> partitionNames) {
        List names = (List)partitionNames.stream().map(HivePartitionManager::extractPartitionValues).map(PartitionName::new).collect(ImmutableList.toImmutableList());
        return (Map)this.getPartitionsByNames(table.getDatabaseName(), table.getTableName(), names).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> MetastoreUtil.makePartitionName(table.getPartitionColumns(), ((PartitionName)entry.getKey()).partitionValues()), Map.Entry::getValue));
    }

    private Map<PartitionName, Optional<Partition>> getPartitionsByNames(String databaseName, String tableName, Collection<PartitionName> partitionNames) {
        Collection<Partition> partitions = this.glueCache.batchGetPartitions(databaseName, tableName, partitionNames, (cachePartition, missingPartitions) -> this.batchGetPartition(databaseName, tableName, (Collection<PartitionName>)missingPartitions, (Consumer<Partition>)cachePartition));
        Map partitionValuesToPartitionMap = partitions.stream().collect(Collectors.toMap(partition -> new PartitionName(partition.getValues()), UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (PartitionName partitionName : partitionNames) {
            Partition partition2 = (Partition)partitionValuesToPartitionMap.get(partitionName);
            resultBuilder.put((Object)partitionName, Optional.ofNullable(partition2));
        }
        return resultBuilder.buildOrThrow();
    }

    private Collection<Partition> batchGetPartition(String databaseName, String tableName, Collection<PartitionName> partitionNames, Consumer<Partition> cachePartition) throws EntityNotFoundException {
        try {
            List pendingPartitions = partitionNames.stream().map(partitionName -> (PartitionValueList)PartitionValueList.builder().values(partitionName.partitionValues()).build()).collect(Collectors.toCollection(ArrayList::new));
            ImmutableList.Builder resultsBuilder = ImmutableList.builderWithExpectedSize((int)partitionNames.size());
            while (!pendingPartitions.isEmpty()) {
                List responses = this.runParallel(Lists.partition((List)pendingPartitions, (int)1000).stream().map(partitions -> () -> this.stats.getGetPartitions().call(() -> this.glueClient.batchGetPartition(builder -> ((BatchGetPartitionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableName(tableName).partitionsToGet((Collection)partitions)))).toList());
                pendingPartitions.clear();
                for (BatchGetPartitionResponse response : responses) {
                    if (response.partitions().isEmpty() && !response.unprocessedKeys().isEmpty()) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Cannot make progress retrieving partitions. Unable to retrieve partitions: " + String.valueOf(response.unprocessedKeys()));
                    }
                    response.partitions().stream().map(partition -> GlueConverter.fromGluePartition(databaseName, tableName, partition)).peek(cachePartition).forEach(arg_0 -> ((ImmutableList.Builder)resultsBuilder).add(arg_0));
                    pendingPartitions.addAll(response.unprocessedKeys());
                }
            }
            return resultsBuilder.build();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed fetching partitions for %s.%s".formatted(databaseName, tableName), e.getCause());
        }
    }

    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitionsWithStatistics) {
        if (partitionsWithStatistics.isEmpty()) {
            return;
        }
        ((ImmutableList)partitionsWithStatistics.stream().map(PartitionWithStatistics::getPartition).collect(ImmutableList.toImmutableList())).forEach(partition -> {
            if (!partition.getDatabaseName().equals(databaseName) || !partition.getTableName().equals(tableName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "All partitions must belong to the same table");
            }
        });
        List<Partition> updatedPartitions = partitionsWithStatistics.stream().map(partitionWithStatistics -> {
            Partition partition = partitionWithStatistics.getPartition();
            HiveBasicStatistics basicStatistics = partitionWithStatistics.getStatistics().basicStatistics();
            return partition.withParameters(MetastoreUtil.updateStatisticsParameters(partition.getParameters(), basicStatistics));
        }).toList();
        List createPartitionTasks = Lists.partition(updatedPartitions, (int)100).stream().map(partitionBatch -> () -> {
            this.stats.getCreatePartitions().call(() -> this.glueClient.batchCreatePartition(builder -> ((BatchCreatePartitionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableName(tableName).partitionInputList((Collection)partitionBatch.stream().map(GlueConverter::toGluePartitionInput).collect(ImmutableList.toImmutableList()))));
            return null;
        }).toList();
        try {
            this.runParallel(createPartitionTasks);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof AlreadyExistsException) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Partition already exists in table %s.%s: %s".formatted(databaseName, tableName, e.getCause().getMessage()));
            }
            if (e.getCause() instanceof EntityNotFoundException) {
                throw new TableNotFoundException(new SchemaTableName(databaseName, tableName));
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed creating partitions for %s.%s: %s".formatted(databaseName, tableName, e.getCause().getMessage()));
        }
        ImmutableList createStatisticsTasks = (ImmutableList)partitionsWithStatistics.stream().map(partitionWithStatistics -> this.createUpdatePartitionStatisticsTasks(StatisticsUpdateMode.OVERWRITE_ALL, partitionWithStatistics.getPartition(), partitionWithStatistics.getStatistics().columnStatistics())).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        try {
            this.runParallel((Collection)createStatisticsTasks);
        }
        catch (ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed creating partition column statistics for %s.%s".formatted(databaseName, tableName), e.getCause());
        }
    }

    public void dropPartition(String databaseName, String tableName, List<String> partitionValues, boolean deleteData) {
        PartitionName partitionName = new PartitionName(partitionValues);
        Optional<Location> location = Optional.empty();
        if (deleteData) {
            Partition partition = this.getPartition(databaseName, tableName, partitionName).orElseThrow(() -> new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues));
            location = Optional.of(Strings.nullToEmpty((String)partition.getStorage().getLocation())).map(Location::of);
        }
        try {
            this.stats.getDeletePartition().call(() -> this.glueClient.deletePartition(builder -> ((DeletePartitionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableName(tableName).partitionValues((Collection)partitionValues)));
        }
        catch (EntityNotFoundException e) {
            throw new PartitionNotFoundException(new SchemaTableName(databaseName, tableName), partitionValues);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidatePartition(databaseName, tableName, partitionName);
        }
        location.ifPresent(this::deleteDir);
    }

    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partitionWithStatistics) {
        if (!partitionWithStatistics.getPartition().getDatabaseName().equals(databaseName) || !partitionWithStatistics.getPartition().getTableName().equals(tableName)) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Partition names must match table name");
        }
        this.alterPartition(partitionWithStatistics);
    }

    private void alterPartition(PartitionWithStatistics partitionWithStatistics) {
        Partition partition = partitionWithStatistics.getPartition();
        try {
            HiveBasicStatistics basicStatistics = partitionWithStatistics.getStatistics().basicStatistics();
            PartitionInput newPartition = GlueConverter.toGluePartitionInput(partition.withParameters(MetastoreUtil.updateStatisticsParameters(partition.getParameters(), basicStatistics)));
            this.stats.getUpdatePartition().call(() -> this.glueClient.updatePartition(builder -> ((UpdatePartitionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(partition.getDatabaseName()).tableName(partition.getTableName()).partitionInput(newPartition).partitionValueList((Collection)partition.getValues())));
        }
        catch (EntityNotFoundException e) {
            throw new PartitionNotFoundException(partition.getSchemaTableName(), partition.getValues());
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidatePartition(partition.getDatabaseName(), partition.getTableName(), new PartitionName(partition.getValues()));
        }
        try {
            this.runParallel(this.createUpdatePartitionStatisticsTasks(StatisticsUpdateMode.OVERWRITE_ALL, partition, partitionWithStatistics.getStatistics().columnStatistics()));
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                throw new PartitionNotFoundException(new SchemaTableName(partition.getDatabaseName(), partition.getTableName()), partition.getValues());
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed updating partition column statistics for %s %s".formatted(partition.getSchemaTableName(), partition.getValues()), e.getCause());
        }
        finally {
            this.glueCache.invalidatePartition(partition.getDatabaseName(), partition.getTableName(), new PartitionName(partition.getValues()));
        }
    }

    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, Set<String> columnNames) {
        Preconditions.checkArgument((!columnNames.isEmpty() ? 1 : 0) != 0, (Object)"columnNames is empty");
        Map partitionsNameMap = (Map)partitionNames.stream().collect(ImmutableMap.toImmutableMap(partitionName -> new PartitionName(HivePartitionManager.extractPartitionValues(partitionName)), UnaryOperator.identity()));
        return (Map)this.getPartitionColumnStatistics(databaseName, tableName, (Collection<PartitionName>)partitionsNameMap.keySet(), columnNames).entrySet().stream().collect(ImmutableMap.toImmutableMap(entry -> (String)partitionsNameMap.get(entry.getKey()), Map.Entry::getValue));
    }

    private Map<PartitionName, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Collection<PartitionName> partitionNames, Set<String> columnNames) throws EntityNotFoundException {
        Map columnStats;
        try {
            columnStats = (Map)this.runParallel((Collection)partitionNames.stream().map(partitionName -> () -> Map.entry(partitionName, this.glueCache.getPartitionColumnStatistics(databaseName, tableName, (PartitionName)partitionName, columnNames, missingColumnNames -> this.getPartitionColumnStatisticsInternal(databaseName, tableName, (PartitionName)partitionName, (Set<String>)missingColumnNames)))).collect(ImmutableList.toImmutableList())).stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed fetching partition statistics for %s.%s".formatted(databaseName, tableName), e.getCause());
        }
        return (Map)partitionNames.stream().collect(ImmutableMap.toImmutableMap(UnaryOperator.identity(), name -> (Map)columnStats.getOrDefault(name, ImmutableMap.of())));
    }

    private Map<String, HiveColumnStatistics> getPartitionColumnStatisticsInternal(String databaseName, String tableName, PartitionName partitionName, Set<String> columnNames) throws EntityNotFoundException {
        ImmutableList columnStatsTasks = (ImmutableList)Lists.partition((List)ImmutableList.copyOf(columnNames), (int)100).stream().map(partialColumns -> () -> this.stats.getGetColumnStatisticsForPartition().call(() -> this.glueClient.getColumnStatisticsForPartition(builder -> ((GetColumnStatisticsForPartitionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableName(tableName).partitionValues(partitionName.partitionValues()).columnNames((Collection)partialColumns)).columnStatisticsList())).collect(ImmutableList.toImmutableList());
        try {
            List<List<ColumnStatistics>> glueColumnStatistics = this.runParallel((Collection)columnStatsTasks);
            return GlueConverter.fromGlueStatistics(glueColumnStatistics);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof EntityNotFoundException) {
                return ImmutableMap.of();
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed fetching column statistics for %s.%s %s".formatted(databaseName, tableName, partitionName), e.getCause());
        }
    }

    public void updatePartitionStatistics(io.trino.metastore.Table table, StatisticsUpdateMode mode, Map<String, PartitionStatistics> partitionUpdates) {
        this.batchUpdatePartitionStatistics(table.getDatabaseName(), table.getTableName(), mode, (Map)partitionUpdates.entrySet().stream().filter(entry -> mode != StatisticsUpdateMode.MERGE_INCREMENTAL || !((PartitionStatistics)entry.getValue()).basicStatistics().getRowCount().equals(OptionalLong.of(0L))).collect(ImmutableMap.toImmutableMap(entry -> new PartitionName(HivePartitionManager.extractPartitionValues((String)entry.getKey())), Map.Entry::getValue)));
    }

    private void batchUpdatePartitionStatistics(String databaseName, String tableName, StatisticsUpdateMode mode, Map<PartitionName, PartitionStatistics> newStatistics) throws EntityNotFoundException {
        Object existingColumnStatistics;
        Collection<Partition> partitions = this.batchGetPartition(databaseName, tableName, (Collection<PartitionName>)ImmutableList.copyOf(newStatistics.keySet()), partition -> {});
        if (mode == StatisticsUpdateMode.MERGE_INCREMENTAL) {
            try {
                existingColumnStatistics = (Map)this.runParallel((Collection)newStatistics.entrySet().stream().map(entry -> () -> {
                    PartitionName partitionName = (PartitionName)entry.getKey();
                    Map<String, HiveColumnStatistics> columnStatistics = this.getPartitionColumnStatisticsInternal(databaseName, tableName, partitionName, ((PartitionStatistics)entry.getValue()).columnStatistics().keySet());
                    return Map.entry(partitionName, columnStatistics);
                }).collect(ImmutableList.toImmutableList())).stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed fetching current partition statistics for %s.%s".formatted(databaseName, tableName), e.getCause());
            }
        } else {
            existingColumnStatistics = ImmutableMap.of();
        }
        ArrayList<PartitionStatisticsUpdate> partitionStatisticsUpdates = new ArrayList<PartitionStatisticsUpdate>();
        for (Partition partition2 : partitions) {
            PartitionName partitionName = new PartitionName(partition2.getValues());
            PartitionStatistics existingStats = new PartitionStatistics(MetastoreUtil.getHiveBasicStatistics(partition2.getParameters()), (Map)existingColumnStatistics.getOrDefault(partitionName, ImmutableMap.of()));
            PartitionStatistics newStats = newStatistics.get(partitionName);
            PartitionStatistics updatedStatistics = mode.updatePartitionStatistics(existingStats, newStats);
            Partition updatedPartition = partition2.withParameters(MetastoreUtil.updateStatisticsParameters(partition2.getParameters(), updatedStatistics.basicStatistics()));
            boolean basicStatsUpdated = !updatedStatistics.basicStatistics().equals((Object)existingStats.basicStatistics());
            partitionStatisticsUpdates.add(new PartitionStatisticsUpdate(updatedPartition, basicStatsUpdated, updatedStatistics.columnStatistics()));
        }
        ArrayList tasks = new ArrayList();
        partitionStatisticsUpdates.stream().map(update -> this.createUpdatePartitionStatisticsTasks(mode, update.updatedPartition(), update.updatedStatistics())).flatMap(Collection::stream).forEach(tasks::add);
        List updatedPartitions = (List)partitionStatisticsUpdates.stream().filter(PartitionStatisticsUpdate::basicStatsUpdated).map(PartitionStatisticsUpdate::updatedPartition).collect(ImmutableList.toImmutableList());
        Lists.partition((List)updatedPartitions, (int)100).stream().map(partitionBatch -> () -> {
            this.stats.getBatchUpdatePartition().call(() -> this.glueClient.batchUpdatePartition(builder -> ((BatchUpdatePartitionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).tableName(tableName).entries((Collection)partitionBatch.stream().map(partition -> (BatchUpdatePartitionRequestEntry)BatchUpdatePartitionRequestEntry.builder().partitionValueList((Collection)partition.getValues()).partitionInput(GlueConverter.toGluePartitionInput(partition)).build()).collect(ImmutableList.toImmutableList()))));
            return null;
        }).forEach(tasks::add);
        try {
            this.runParallel(tasks);
        }
        catch (ExecutionException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, "Failed updating partition column statistics for %s.%s".formatted(databaseName, tableName), e.getCause());
        }
    }

    private List<Callable<Void>> createUpdatePartitionStatisticsTasks(StatisticsUpdateMode mode, Partition partition, Map<String, HiveColumnStatistics> updatedStatistics) {
        Map columns = (Map)partition.getColumns().stream().collect(ImmutableMap.toImmutableMap(Column::getName, UnaryOperator.identity()));
        Map statisticsByColumn = (Map)columns.values().stream().filter(column -> updatedStatistics.containsKey(column.getName())).collect(ImmutableMap.toImmutableMap(UnaryOperator.identity(), column -> (HiveColumnStatistics)updatedStatistics.get(column.getName())));
        ImmutableSet removeColumnStatistics = switch (mode) {
            default -> throw new MatchException(null, null);
            case StatisticsUpdateMode.OVERWRITE_SOME_COLUMNS -> ImmutableSet.of();
            case StatisticsUpdateMode.OVERWRITE_ALL, StatisticsUpdateMode.MERGE_INCREMENTAL -> columns.entrySet().stream().filter(entry -> !statisticsByColumn.containsKey(entry.getValue())).map(Map.Entry::getKey).collect(Collectors.toSet());
            case StatisticsUpdateMode.UNDO_MERGE_INCREMENTAL, StatisticsUpdateMode.CLEAR_ALL -> columns.keySet();
        };
        ImmutableList.Builder tasks = ImmutableList.builder();
        Lists.partition(GlueConverter.toGlueColumnStatistics(statisticsByColumn), (int)25).stream().map(chunk -> () -> {
            this.stats.getUpdateColumnStatisticsForPartition().call(() -> this.glueClient.updateColumnStatisticsForPartition(builder -> ((UpdateColumnStatisticsForPartitionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(partition.getDatabaseName()).tableName(partition.getTableName()).partitionValues((Collection)partition.getValues()).columnStatisticsList((Collection)chunk)));
            return null;
        }).forEach(arg_0 -> ((ImmutableList.Builder)tasks).add(arg_0));
        removeColumnStatistics.stream().map(columnName -> () -> {
            this.stats.getDeleteColumnStatisticsForPartition().call(() -> this.glueClient.deleteColumnStatisticsForPartition(builder -> ((DeleteColumnStatisticsForPartitionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(partition.getDatabaseName()).tableName(partition.getTableName()).partitionValues((Collection)partition.getValues()).columnName(columnName)));
            return null;
        }).forEach(arg_0 -> ((ImmutableList.Builder)tasks).add(arg_0));
        return tasks.build();
    }

    public boolean functionExists(String databaseName, String functionName, String signatureToken) {
        try {
            this.stats.getUpdateUserDefinedFunction().call(() -> this.glueClient.getUserDefinedFunction(builder -> ((GetUserDefinedFunctionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).functionName(MetastoreUtil.metastoreFunctionName(functionName, signatureToken))));
            return true;
        }
        catch (EntityNotFoundException e) {
            return false;
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    public Collection<LanguageFunction> getAllFunctions(String databaseName) {
        return this.glueCache.getAllFunctions(databaseName, () -> this.getFunctionsByPatternInternal(databaseName, "trino__.*"));
    }

    public Collection<LanguageFunction> getFunctions(String databaseName, String functionName) {
        return this.glueCache.getFunction(databaseName, functionName, () -> this.getFunctionsByPatternInternal(databaseName, "trino__" + Pattern.quote(functionName) + "__.*"));
    }

    private Collection<LanguageFunction> getFunctionsByPatternInternal(String databaseName, String functionNamePattern) {
        try {
            return (Collection)this.stats.getGetUserDefinedFunctions().call(() -> (ImmutableList)this.glueClient.getUserDefinedFunctionsPaginator(builder -> ((GetUserDefinedFunctionsRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).pattern(functionNamePattern).maxResults(Integer.valueOf(100))).stream().map(GetUserDefinedFunctionsResponse::userDefinedFunctions).flatMap(Collection::stream).map(GlueConverter::fromGlueFunction).collect(ImmutableList.toImmutableList()));
        }
        catch (AccessDeniedException | EntityNotFoundException e) {
            log.warn(e, "Failed to get SQL routines for pattern: %s in schema: %s", new Object[]{functionNamePattern, databaseName});
            return ImmutableList.of();
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
    }

    public void createFunction(String databaseName, String functionName, LanguageFunction function) {
        if (functionName.contains("__")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Function names with double underscore are not supported");
        }
        try {
            UserDefinedFunctionInput functionInput = GlueConverter.toGlueFunctionInput(functionName, function);
            this.stats.getCreateUserDefinedFunction().call(() -> this.glueClient.createUserDefinedFunction(builder -> ((CreateUserDefinedFunctionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).functionInput(functionInput)));
        }
        catch (AlreadyExistsException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.ALREADY_EXISTS, "Function already exists: %s.%s".formatted(databaseName, functionName), (Throwable)e);
        }
        catch (EntityNotFoundException e) {
            throw new SchemaNotFoundException(databaseName, (Throwable)e);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidateFunction(databaseName, functionName);
        }
    }

    public void replaceFunction(String databaseName, String functionName, LanguageFunction function) {
        try {
            UserDefinedFunctionInput functionInput = GlueConverter.toGlueFunctionInput(functionName, function);
            this.stats.getUpdateUserDefinedFunction().call(() -> this.glueClient.updateUserDefinedFunction(builder -> ((UpdateUserDefinedFunctionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).functionName(MetastoreUtil.metastoreFunctionName(functionName, function.signatureToken())).functionInput(functionInput)));
        }
        catch (EntityNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "Function not found: %s.%s".formatted(databaseName, functionName), (Throwable)e);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidateFunction(databaseName, functionName);
        }
    }

    public void dropFunction(String databaseName, String functionName, String signatureToken) {
        try {
            this.stats.getDeleteUserDefinedFunction().call(() -> this.glueClient.deleteUserDefinedFunction(builder -> ((DeleteUserDefinedFunctionRequest.Builder)builder.applyMutation(this.glueContext::configureClient)).databaseName(databaseName).functionName(MetastoreUtil.metastoreFunctionName(functionName, signatureToken))));
        }
        catch (EntityNotFoundException e) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_NOT_FOUND, "Function not found: %s.%s".formatted(databaseName, functionName), (Throwable)e);
        }
        catch (SdkException e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_METASTORE_ERROR, (Throwable)e);
        }
        finally {
            this.glueCache.invalidateFunction(databaseName, functionName);
        }
    }

    public void createRole(String role, String grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "createRole is not supported by Glue");
    }

    public void dropRole(String role) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "dropRole is not supported by Glue");
    }

    public Set<String> listRoles() {
        return ImmutableSet.of((Object)PUBLIC_ROLE_NAME);
    }

    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantRoles is not supported by Glue");
    }

    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeRoles is not supported by Glue");
    }

    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        if (principal.getType() == PrincipalType.USER) {
            return ImmutableSet.of((Object)new RoleGrant(principal.toTrinoPrincipal(), PUBLIC_ROLE_NAME, false));
        }
        return ImmutableSet.of();
    }

    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "grantTablePrivileges is not supported by Glue");
    }

    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "revokeTablePrivileges is not supported by Glue");
    }

    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return ImmutableSet.of();
    }

    public void checkSupportsTransactions() {
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Glue does not support ACID tables");
    }

    private <T> List<T> runParallel(Collection<Callable<T>> tasks) throws ExecutionException {
        return ExecutorUtil.processWithAdditionalThreads(tasks, (Executor)this.executor);
    }

    private static Predicate<Table> createTablePredicate(Set<TableKind> visibleTableKinds) {
        if (visibleTableKinds.isEmpty()) {
            return table -> false;
        }
        if (visibleTableKinds.equals(ImmutableSet.copyOf((Object[])TableKind.values()))) {
            return table -> true;
        }
        if (visibleTableKinds.contains((Object)TableKind.OTHER)) {
            EnumSet<TableKind> deniedKinds = EnumSet.complementOf(EnumSet.copyOf(visibleTableKinds));
            Predicate<Table> tableVisibilityFilter = table -> true;
            for (TableKind value : deniedKinds) {
                tableVisibilityFilter = tableVisibilityFilter.and(Predicate.not(GlueHiveMetastore.tableKindPredicate(value)));
            }
            return tableVisibilityFilter;
        }
        Predicate<Table> tableVisibilityFilter = table -> false;
        for (TableKind tableKind : visibleTableKinds) {
            tableVisibilityFilter = tableVisibilityFilter.or(GlueHiveMetastore.tableKindPredicate(tableKind));
        }
        return tableVisibilityFilter;
    }

    private static Predicate<Table> tableKindPredicate(TableKind tableKind) {
        return switch (tableKind.ordinal()) {
            default -> throw new MatchException(null, null);
            case 1 -> table -> HiveUtil.isDeltaLakeTable(table.parameters());
            case 2 -> table -> HiveUtil.isIcebergTable(table.parameters());
            case 3 -> table -> table.storageDescriptor() != null && HiveUtil.isHudiTable(table.storageDescriptor().inputFormat());
            case 0 -> throw new IllegalArgumentException("Predicate can not be created for OTHER");
        };
    }

    private record BasicTableStatisticsResult(Map<Column, HiveColumnStatistics> updateColumnStatistics, Set<String> removeColumnStatistics) {
    }

    private record PartitionStatisticsUpdate(Partition updatedPartition, boolean basicStatsUpdated, Map<String, HiveColumnStatistics> updatedStatistics) {
    }

    public static enum TableKind {
        OTHER,
        DELTA,
        ICEBERG,
        HUDI;

    }
}

