/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.metastore.thrift;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.trino.hive.thrift.metastore.Database;
import io.trino.hive.thrift.metastore.FieldSchema;
import io.trino.hive.thrift.metastore.Partition;
import io.trino.hive.thrift.metastore.Table;
import io.trino.metastore.AcidOperation;
import io.trino.metastore.AcidTransactionOwner;
import io.trino.metastore.HiveColumnStatistics;
import io.trino.metastore.HiveMetastore;
import io.trino.metastore.HivePartition;
import io.trino.metastore.HivePrincipal;
import io.trino.metastore.HivePrivilegeInfo;
import io.trino.metastore.HiveType;
import io.trino.metastore.PartitionStatistics;
import io.trino.metastore.PartitionWithStatistics;
import io.trino.metastore.Partitions;
import io.trino.metastore.PrincipalPrivileges;
import io.trino.metastore.SchemaAlreadyExistsException;
import io.trino.metastore.StatisticsUpdateMode;
import io.trino.metastore.TableAlreadyExistsException;
import io.trino.metastore.TableInfo;
import io.trino.plugin.hive.metastore.MetastoreUtil;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastore;
import io.trino.plugin.hive.metastore.thrift.ThriftMetastoreUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SchemaNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.function.LanguageFunction;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class BridgingHiveMetastore
implements HiveMetastore {
    private final ThriftMetastore delegate;

    public BridgingHiveMetastore(ThriftMetastore delegate) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
    }

    public Optional<io.trino.metastore.Database> getDatabase(String databaseName) {
        return this.delegate.getDatabase(databaseName).map(ThriftMetastoreUtil::fromMetastoreApiDatabase);
    }

    public List<String> getAllDatabases() {
        return this.delegate.getAllDatabases();
    }

    public Optional<io.trino.metastore.Table> getTable(String databaseName, String tableName) {
        return this.delegate.getTable(databaseName, tableName).map(table -> {
            if (ThriftMetastoreUtil.isAvroTableWithSchemaSet(table)) {
                return ThriftMetastoreUtil.fromMetastoreApiTable(table, this.delegate.getFields(databaseName, tableName).orElseThrow());
            }
            if (ThriftMetastoreUtil.isCsvTable(table)) {
                return ThriftMetastoreUtil.fromMetastoreApiTable(table, ThriftMetastoreUtil.csvSchemaFields(table.getSd().getCols()));
            }
            return ThriftMetastoreUtil.fromMetastoreApiTable(table);
        });
    }

    public Map<String, HiveColumnStatistics> getTableColumnStatistics(String databaseName, String tableName, Set<String> columnNames) {
        Preconditions.checkArgument((!columnNames.isEmpty() ? 1 : 0) != 0, (Object)"columnNames is empty");
        return this.delegate.getTableColumnStatistics(databaseName, tableName, columnNames);
    }

    public Map<String, Map<String, HiveColumnStatistics>> getPartitionColumnStatistics(String databaseName, String tableName, Set<String> partitionNames, Set<String> columnNames) {
        Preconditions.checkArgument((!columnNames.isEmpty() ? 1 : 0) != 0, (Object)"columnNames is empty");
        return this.delegate.getPartitionColumnStatistics(databaseName, tableName, partitionNames, columnNames);
    }

    public boolean useSparkTableStatistics() {
        return this.delegate.useSparkTableStatistics();
    }

    public void updateTableStatistics(String databaseName, String tableName, OptionalLong acidWriteId, StatisticsUpdateMode mode, PartitionStatistics statisticsUpdate) {
        this.delegate.updateTableStatistics(databaseName, tableName, acidWriteId, mode, statisticsUpdate);
    }

    public void updatePartitionStatistics(io.trino.metastore.Table table, StatisticsUpdateMode mode, Map<String, PartitionStatistics> partitionUpdates) {
        Table metastoreTable = ThriftMetastoreUtil.toMetastoreApiTable(table);
        partitionUpdates.forEach((partitionName, update) -> this.delegate.updatePartitionStatistics(metastoreTable, (String)partitionName, mode, (PartitionStatistics)update));
    }

    public List<TableInfo> getTables(String databaseName) {
        return (List)this.delegate.getTables(databaseName).stream().map(table -> new TableInfo(new SchemaTableName(table.getDbName(), table.getTableName()), TableInfo.ExtendedRelationType.fromTableTypeAndComment((String)table.getTableType(), (String)table.getComments()))).collect(ImmutableList.toImmutableList());
    }

    public List<String> getTableNamesWithParameters(String databaseName, String parameterKey, ImmutableSet<String> parameterValues) {
        return this.delegate.getTableNamesWithParameters(databaseName, parameterKey, (Set<String>)parameterValues);
    }

    public void createDatabase(io.trino.metastore.Database database) {
        block2: {
            try {
                this.delegate.createDatabase(ThriftMetastoreUtil.toMetastoreApiDatabase(database));
            }
            catch (SchemaAlreadyExistsException e) {
                String existingQueryId;
                String expectedQueryId = (String)database.getParameters().get("trino_query_id");
                if (expectedQueryId == null || expectedQueryId.equals(existingQueryId = (String)this.getDatabase(database.getDatabaseName()).map(io.trino.metastore.Database::getParameters).map(parameters -> (String)parameters.get("trino_query_id")).orElse(null))) break block2;
                throw e;
            }
        }
    }

    public void dropDatabase(String databaseName, boolean deleteData) {
        this.delegate.dropDatabase(databaseName, deleteData);
    }

    public void renameDatabase(String databaseName, String newDatabaseName) {
        Database database = this.delegate.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName));
        database.setName(newDatabaseName);
        this.delegate.alterDatabase(databaseName, database);
        this.delegate.getDatabase(databaseName).ifPresent(newDatabase -> {
            if (newDatabase.getName().equals(databaseName)) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Hive metastore does not support renaming schemas");
            }
        });
    }

    public void setDatabaseOwner(String databaseName, HivePrincipal principal) {
        io.trino.metastore.Database database = ThriftMetastoreUtil.fromMetastoreApiDatabase(this.delegate.getDatabase(databaseName).orElseThrow(() -> new SchemaNotFoundException(databaseName)));
        io.trino.metastore.Database newDatabase = io.trino.metastore.Database.builder((io.trino.metastore.Database)database).setOwnerName(Optional.of(principal.getName())).setOwnerType(Optional.of(principal.getType())).build();
        this.delegate.alterDatabase(databaseName, ThriftMetastoreUtil.toMetastoreApiDatabase(newDatabase));
    }

    public void createTable(io.trino.metastore.Table table, PrincipalPrivileges principalPrivileges) {
        block2: {
            try {
                this.delegate.createTable(ThriftMetastoreUtil.toMetastoreApiTable(table, principalPrivileges));
            }
            catch (TableAlreadyExistsException e) {
                String existingQueryId;
                String expectedQueryId = (String)table.getParameters().get("trino_query_id");
                if (expectedQueryId == null || expectedQueryId.equals(existingQueryId = (String)this.getTable(table.getDatabaseName(), table.getTableName()).map(io.trino.metastore.Table::getParameters).map(parameters -> (String)parameters.get("trino_query_id")).orElse(null))) break block2;
                throw e;
            }
        }
    }

    public void dropTable(String databaseName, String tableName, boolean deleteData) {
        this.delegate.dropTable(databaseName, tableName, deleteData);
    }

    public void replaceTable(String databaseName, String tableName, io.trino.metastore.Table newTable, PrincipalPrivileges principalPrivileges) {
        this.alterTable(databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiTable(newTable, principalPrivileges));
    }

    public void renameTable(String databaseName, String tableName, String newDatabaseName, String newTableName) {
        Table table = this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        table.setDbName(newDatabaseName);
        table.setTableName(newTableName);
        this.alterTable(databaseName, tableName, table);
    }

    public void commentTable(String databaseName, String tableName, Optional<String> comment) {
        Table table = this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        Map<String, String> parameters = table.getParameters().entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("comment")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        comment.ifPresent(value -> parameters.put("comment", (String)value));
        table.setParameters(parameters);
        this.alterTable(databaseName, tableName, table);
    }

    public void setTableOwner(String databaseName, String tableName, HivePrincipal principal) {
        if (principal.getType() != PrincipalType.USER) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Setting table owner type as a role is not supported");
        }
        io.trino.metastore.Table table = ThriftMetastoreUtil.fromMetastoreApiTable(this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName))));
        io.trino.metastore.Table newTable = io.trino.metastore.Table.builder((io.trino.metastore.Table)table).setOwner(Optional.of(principal.getName())).build();
        this.delegate.alterTable(databaseName, tableName, ThriftMetastoreUtil.toMetastoreApiTable(newTable));
    }

    public void commentColumn(String databaseName, String tableName, String columnName, Optional<String> comment) {
        Table table = this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        ImmutableList fieldSchemas = ImmutableList.builder().addAll((Iterable)table.getSd().getCols()).addAll((Iterable)table.getPartitionKeys()).build();
        for (FieldSchema fieldSchema : fieldSchemas) {
            if (!fieldSchema.getName().equals(columnName)) continue;
            if (comment.isPresent()) {
                fieldSchema.setComment(comment.get());
                continue;
            }
            fieldSchema.unsetComment();
        }
        this.alterTable(databaseName, tableName, table);
    }

    public void addColumn(String databaseName, String tableName, String columnName, HiveType columnType, String columnComment) {
        Table table = this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        table.getSd().getCols().add(new FieldSchema(columnName, columnType.getHiveTypeName().toString(), columnComment));
        this.alterTable(databaseName, tableName, table);
    }

    public void renameColumn(String databaseName, String tableName, String oldColumnName, String newColumnName) {
        Table table = this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        for (FieldSchema fieldSchema : table.getPartitionKeys()) {
            if (!fieldSchema.getName().equals(oldColumnName)) continue;
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Renaming partition columns is not supported");
        }
        for (FieldSchema fieldSchema : table.getSd().getCols()) {
            if (!fieldSchema.getName().equals(oldColumnName)) continue;
            fieldSchema.setName(newColumnName);
        }
        this.alterTable(databaseName, tableName, table);
    }

    public void dropColumn(String databaseName, String tableName, String columnName) {
        MetastoreUtil.verifyCanDropColumn(this, databaseName, tableName, columnName);
        Table table = this.delegate.getTable(databaseName, tableName).orElseThrow(() -> new TableNotFoundException(new SchemaTableName(databaseName, tableName)));
        table.getSd().getCols().removeIf(fieldSchema -> fieldSchema.getName().equals(columnName));
        this.alterTable(databaseName, tableName, table);
    }

    private void alterTable(String databaseName, String tableName, Table table) {
        this.delegate.alterTable(databaseName, tableName, table);
    }

    public Optional<io.trino.metastore.Partition> getPartition(io.trino.metastore.Table table, List<String> partitionValues) {
        return this.delegate.getPartition(table.getDatabaseName(), table.getTableName(), partitionValues).map(partition -> BridgingHiveMetastore.fromMetastoreApiPartition(table, partition));
    }

    public Optional<List<String>> getPartitionNamesByFilter(String databaseName, String tableName, List<String> columnNames, TupleDomain<String> partitionKeysFilter) {
        return this.delegate.getPartitionNamesByFilter(databaseName, tableName, columnNames, partitionKeysFilter);
    }

    public Map<String, Optional<io.trino.metastore.Partition>> getPartitionsByNames(io.trino.metastore.Table table, List<String> partitionNames) {
        Objects.requireNonNull(partitionNames, "partitionNames is null");
        if (partitionNames.isEmpty()) {
            return ImmutableMap.of();
        }
        Map partitionNameToPartitionValuesMap = partitionNames.stream().collect(Collectors.toMap(UnaryOperator.identity(), Partitions::toPartitionValues));
        Map partitionValuesToPartitionMap = this.delegate.getPartitionsByNames(table.getDatabaseName(), table.getTableName(), partitionNames).stream().map(partition -> BridgingHiveMetastore.fromMetastoreApiPartition(table, partition)).collect(Collectors.toMap(io.trino.metastore.Partition::getValues, UnaryOperator.identity()));
        ImmutableMap.Builder resultBuilder = ImmutableMap.builder();
        for (Map.Entry entry : partitionNameToPartitionValuesMap.entrySet()) {
            io.trino.metastore.Partition partition2 = (io.trino.metastore.Partition)partitionValuesToPartitionMap.get(entry.getValue());
            resultBuilder.put((Object)((String)entry.getKey()), Optional.ofNullable(partition2));
        }
        return resultBuilder.buildOrThrow();
    }

    private static io.trino.metastore.Partition fromMetastoreApiPartition(io.trino.metastore.Table table, Partition partition) {
        if (ThriftMetastoreUtil.isAvroTableWithSchemaSet(table)) {
            List schema = (List)table.getDataColumns().stream().map(ThriftMetastoreUtil::toMetastoreApiFieldSchema).collect(ImmutableList.toImmutableList());
            return ThriftMetastoreUtil.fromMetastoreApiPartition(partition, schema);
        }
        if (ThriftMetastoreUtil.isCsvPartition(partition)) {
            return ThriftMetastoreUtil.fromMetastoreApiPartition(partition, ThriftMetastoreUtil.csvSchemaFields(partition.getSd().getCols()));
        }
        return ThriftMetastoreUtil.fromMetastoreApiPartition(partition);
    }

    public void addPartitions(String databaseName, String tableName, List<PartitionWithStatistics> partitions) {
        this.delegate.addPartitions(databaseName, tableName, partitions);
    }

    public void dropPartition(String databaseName, String tableName, List<String> parts, boolean deleteData) {
        this.delegate.dropPartition(databaseName, tableName, parts, deleteData);
    }

    public void alterPartition(String databaseName, String tableName, PartitionWithStatistics partition) {
        this.delegate.alterPartition(databaseName, tableName, partition);
    }

    public void createRole(String role, String grantor) {
        this.delegate.createRole(role, grantor);
    }

    public void dropRole(String role) {
        this.delegate.dropRole(role);
    }

    public Set<String> listRoles() {
        return this.delegate.listRoles();
    }

    public void grantRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.delegate.grantRoles(roles, grantees, adminOption, grantor);
    }

    public void revokeRoles(Set<String> roles, Set<HivePrincipal> grantees, boolean adminOption, HivePrincipal grantor) {
        this.delegate.revokeRoles(roles, grantees, adminOption, grantor);
    }

    public Set<RoleGrant> listRoleGrants(HivePrincipal principal) {
        return this.delegate.listRoleGrants(principal);
    }

    public void grantTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.delegate.grantTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
    }

    public void revokeTablePrivileges(String databaseName, String tableName, String tableOwner, HivePrincipal grantee, HivePrincipal grantor, Set<HivePrivilegeInfo.HivePrivilege> privileges, boolean grantOption) {
        this.delegate.revokeTablePrivileges(databaseName, tableName, tableOwner, grantee, grantor, privileges, grantOption);
    }

    public Set<HivePrivilegeInfo> listTablePrivileges(String databaseName, String tableName, Optional<String> tableOwner, Optional<HivePrincipal> principal) {
        return this.delegate.listTablePrivileges(databaseName, tableName, tableOwner, principal);
    }

    public Optional<String> getConfigValue(String name) {
        return this.delegate.getConfigValue(name);
    }

    public void checkSupportsTransactions() {
        this.delegate.checkSupportsTransactions();
    }

    public long openTransaction(AcidTransactionOwner transactionOwner) {
        return this.delegate.openTransaction(transactionOwner);
    }

    public void commitTransaction(long transactionId) {
        this.delegate.commitTransaction(transactionId);
    }

    public void abortTransaction(long transactionId) {
        this.delegate.abortTransaction(transactionId);
    }

    public void sendTransactionHeartbeat(long transactionId) {
        this.delegate.sendTransactionHeartbeat(transactionId);
    }

    public void acquireSharedReadLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, List<SchemaTableName> fullTables, List<HivePartition> partitions) {
        this.delegate.acquireSharedReadLock(transactionOwner, queryId, transactionId, fullTables, partitions);
    }

    public String getValidWriteIds(List<SchemaTableName> tables, long currentTransactionId) {
        return this.delegate.getValidWriteIds(tables, currentTransactionId);
    }

    public long allocateWriteId(String dbName, String tableName, long transactionId) {
        return this.delegate.allocateWriteId(dbName, tableName, transactionId);
    }

    public void acquireTableWriteLock(AcidTransactionOwner transactionOwner, String queryId, long transactionId, String dbName, String tableName, AcidOperation acidOperation, boolean isDynamicPartitionWrite) {
        this.delegate.acquireTableWriteLock(transactionOwner, queryId, transactionId, dbName, tableName, ThriftMetastoreUtil.toDataOperationType(acidOperation), isDynamicPartitionWrite);
    }

    public void updateTableWriteId(String dbName, String tableName, long transactionId, long writeId, OptionalLong rowCountChange) {
        this.delegate.updateTableWriteId(dbName, tableName, transactionId, writeId, rowCountChange);
    }

    public void addDynamicPartitions(String dbName, String tableName, List<String> partitionNames, long transactionId, long writeId, AcidOperation operation) {
        this.delegate.addDynamicPartitions(dbName, tableName, partitionNames, transactionId, writeId, ThriftMetastoreUtil.toDataOperationType(operation));
    }

    public void alterTransactionalTable(io.trino.metastore.Table table, long transactionId, long writeId, PrincipalPrivileges principalPrivileges) {
        this.delegate.alterTransactionalTable(ThriftMetastoreUtil.toMetastoreApiTable(table, principalPrivileges), transactionId, writeId);
    }

    public boolean functionExists(String databaseName, String functionName, String signatureToken) {
        return this.delegate.getFunction(databaseName, MetastoreUtil.metastoreFunctionName(functionName, signatureToken)).isPresent();
    }

    public Collection<LanguageFunction> getAllFunctions(String databaseName) {
        return this.getFunctionsByPattern(databaseName, "trino__*");
    }

    public Collection<LanguageFunction> getFunctions(String databaseName, String functionName) {
        return this.getFunctionsByPattern(databaseName, "trino__" + functionName + "__*");
    }

    private Collection<LanguageFunction> getFunctionsByPattern(String databaseName, String functionNamePattern) {
        return (Collection)this.delegate.getFunctions(databaseName, functionNamePattern).stream().map(name -> this.delegate.getFunction(databaseName, (String)name)).flatMap(Optional::stream).map(ThriftMetastoreUtil::fromMetastoreApiFunction).collect(ImmutableList.toImmutableList());
    }

    public void createFunction(String databaseName, String functionName, LanguageFunction function) {
        if (functionName.contains("__")) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Function names with double underscore are not supported");
        }
        this.delegate.createFunction(ThriftMetastoreUtil.toMetastoreApiFunction(databaseName, functionName, function));
    }

    public void replaceFunction(String databaseName, String functionName, LanguageFunction function) {
        this.delegate.alterFunction(ThriftMetastoreUtil.toMetastoreApiFunction(databaseName, functionName, function));
    }

    public void dropFunction(String databaseName, String functionName, String signatureToken) {
        this.delegate.dropFunction(databaseName, MetastoreUtil.metastoreFunctionName(functionName, signatureToken));
    }
}

