/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.parquet;

import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.reader.ParquetReader;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.metrics.Metrics;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.OptionalLong;

public class ParquetPageSource
implements ConnectorPageSource {
    private final ParquetReader parquetReader;
    private boolean closed;
    private long completedPositions;

    public ParquetPageSource(ParquetReader parquetReader) {
        this.parquetReader = Objects.requireNonNull(parquetReader, "parquetReader is null");
    }

    public long getCompletedBytes() {
        return this.parquetReader.getDataSource().getReadBytes();
    }

    public OptionalLong getCompletedPositions() {
        return OptionalLong.of(this.completedPositions);
    }

    public long getReadTimeNanos() {
        return this.parquetReader.getDataSource().getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public long getMemoryUsage() {
        return this.parquetReader.getMemoryContext().getBytes();
    }

    public SourcePage getNextSourcePage() {
        SourcePage page;
        try {
            page = this.parquetReader.nextPage();
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw ParquetPageSource.handleException(this.parquetReader.getDataSource().getId(), e);
        }
        if (this.closed || page == null) {
            this.close();
            return null;
        }
        this.completedPositions += (long)page.getPositionCount();
        return page;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.parquetReader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public Metrics getMetrics() {
        return this.parquetReader.getMetrics();
    }

    static TrinoException handleException(ParquetDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            return (TrinoException)((Object)exception);
        }
        if (exception instanceof ParquetCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read Parquet file: %s", dataSourceId), (Throwable)exception);
    }
}

