/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveWriterStats;
import io.trino.plugin.hive.PartitionUpdate;
import io.trino.spi.Page;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class HiveWriter {
    private final FileWriter fileWriter;
    private final Optional<String> partitionName;
    private final PartitionUpdate.UpdateMode updateMode;
    private final String fileName;
    private final String writePath;
    private final String targetPath;
    private final HiveWriterStats hiveWriterStats;
    private long rowCount;
    private long inputSizeInBytes;

    public HiveWriter(FileWriter fileWriter, Optional<String> partitionName, PartitionUpdate.UpdateMode updateMode, String fileName, String writePath, String targetPath, HiveWriterStats hiveWriterStats) {
        this.fileWriter = Objects.requireNonNull(fileWriter, "fileWriter is null");
        this.partitionName = Objects.requireNonNull(partitionName, "partitionName is null");
        this.updateMode = Objects.requireNonNull(updateMode, "updateMode is null");
        this.fileName = Objects.requireNonNull(fileName, "fileName is null");
        this.writePath = Objects.requireNonNull(writePath, "writePath is null");
        this.targetPath = Objects.requireNonNull(targetPath, "targetPath is null");
        this.hiveWriterStats = Objects.requireNonNull(hiveWriterStats, "hiveWriterStats is null");
    }

    public FileWriter getFileWriter() {
        return this.fileWriter;
    }

    public long getWrittenBytes() {
        return this.fileWriter.getWrittenBytes();
    }

    public long getMemoryUsage() {
        return this.fileWriter.getMemoryUsage();
    }

    public void append(Page dataPage) {
        this.hiveWriterStats.addInputPageSizesInBytes(dataPage.getRetainedSizeInBytes());
        this.fileWriter.appendRows(dataPage);
        this.rowCount += (long)dataPage.getPositionCount();
        this.inputSizeInBytes += dataPage.getSizeInBytes();
    }

    public Closeable commit() {
        return this.fileWriter.commit();
    }

    long getValidationCpuNanos() {
        return this.fileWriter.getValidationCpuNanos();
    }

    public void rollback() {
        this.fileWriter.rollback();
    }

    public PartitionUpdate getPartitionUpdate() {
        return new PartitionUpdate(this.partitionName.orElse(""), this.updateMode, this.writePath, this.targetPath, (List<String>)ImmutableList.of((Object)this.fileName), this.rowCount, this.inputSizeInBytes, this.fileWriter.getWrittenBytes());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("fileWriter", (Object)this.fileWriter).add("filePath", (Object)(this.writePath + "/" + this.fileName)).toString();
    }
}

