/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;

public class IntegerToBigintCoercer
extends TypeCoercer<IntegerType, BigintType> {
    public IntegerToBigintCoercer() {
        super(IntegerType.INTEGER, BigintType.BIGINT);
    }

    @Override
    public Block apply(Block block) {
        if (block instanceof LongArrayBlock) {
            return block;
        }
        return super.apply(block);
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        BigintType.BIGINT.writeLong(blockBuilder, (long)IntegerType.INTEGER.getInt(block, position));
    }
}

