/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.coercions;

import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.RealType;
import io.trino.spi.type.VarcharType;

public class VarcharToFloatCoercer
extends TypeCoercer<VarcharType, RealType> {
    private final boolean isOrcFile;

    public VarcharToFloatCoercer(VarcharType fromType, boolean isOrcFile) {
        super(fromType, RealType.REAL);
        this.isOrcFile = isOrcFile;
    }

    @Override
    protected void applyCoercedValue(BlockBuilder blockBuilder, Block block, int position) {
        float floatValue;
        try {
            floatValue = Float.parseFloat(((VarcharType)this.fromType).getSlice(block, position).toStringUtf8());
        }
        catch (NumberFormatException e) {
            blockBuilder.appendNull();
            return;
        }
        if (Float.isNaN(floatValue) && this.isOrcFile) {
            blockBuilder.appendNull();
            return;
        }
        RealType.REAL.writeFloat(blockBuilder, floatValue);
    }
}

