/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.slice.SizeOf;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.cache.CacheUtils;
import io.trino.cache.EvictableCacheBuilder;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.metastore.Partition;
import io.trino.metastore.Storage;
import io.trino.metastore.Table;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.fs.RemoteIterator;
import io.trino.plugin.hive.fs.SimpleRemoteIterator;
import io.trino.plugin.hive.fs.TrinoFileStatus;
import io.trino.plugin.hive.fs.TrinoFileStatusRemoteIterator;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.weakref.jmx.Managed;

public class CachingDirectoryLister
implements DirectoryLister {
    private final Cache<Location, ValueHolder> cache;
    private final Predicate<SchemaTableName> tablePredicate;
    private final Predicate<FileEntry> filterPredicate;

    @Inject
    public CachingDirectoryLister(HiveConfig hiveClientConfig) {
        this(hiveClientConfig.getFileStatusCacheExpireAfterWrite(), hiveClientConfig.getFileStatusCacheMaxRetainedSize(), hiveClientConfig.getFileStatusCacheTables(), hiveClientConfig.getS3GlacierFilter().toFileEntryPredicate());
    }

    public CachingDirectoryLister(Duration expireAfterWrite, DataSize maxSize, List<String> tables, Predicate<FileEntry> filterPredicate) {
        Objects.requireNonNull(expireAfterWrite, "expireAfterWrite is null");
        Objects.requireNonNull(maxSize, "maxSize is null");
        Objects.requireNonNull(tables, "tables is null");
        Objects.requireNonNull(filterPredicate, "filterPredicate is null");
        this.cache = EvictableCacheBuilder.newBuilder().maximumWeight(maxSize.toBytes()).weigher((key, value) -> Math.toIntExact(SizeOf.estimatedSizeOf((String)key.toString()) + value.getRetainedSizeInBytes())).expireAfterWrite(expireAfterWrite.toMillis(), TimeUnit.MILLISECONDS).shareNothingWhenDisabled().recordStats().build();
        this.tablePredicate = CachingDirectoryLister.matches(tables);
        this.filterPredicate = filterPredicate;
    }

    private static Predicate<SchemaTableName> matches(List<String> tables) {
        return tables.stream().map(CachingDirectoryLister::parseTableName).map(prefix -> arg_0 -> ((SchemaTablePrefix)prefix).matches(arg_0)).reduce(Predicate::or).orElse(schemaTableName -> false);
    }

    private static SchemaTablePrefix parseTableName(String tableName) {
        if (tableName.equals("*")) {
            return new SchemaTablePrefix();
        }
        String[] parts = tableName.split("\\.");
        Preconditions.checkArgument((parts.length == 2 ? 1 : 0) != 0, (String)"Invalid schemaTableName: %s", (Object)tableName);
        String schema = parts[0];
        String table = parts[1];
        if (table.equals("*")) {
            return new SchemaTablePrefix(schema);
        }
        return new SchemaTablePrefix(schema, table);
    }

    @Override
    public RemoteIterator<TrinoFileStatus> listFilesRecursively(TrinoFileSystem fs, Table table, Location location) throws IOException {
        if (!this.isCacheEnabledFor(table.getSchemaTableName())) {
            return new TrinoFileStatusRemoteIterator(fs.listFiles(location), this.filterPredicate);
        }
        return this.listInternal(fs, location);
    }

    private RemoteIterator<TrinoFileStatus> listInternal(TrinoFileSystem fs, Location location) throws IOException {
        ValueHolder cachedValueHolder = (ValueHolder)CacheUtils.uncheckedCacheGet(this.cache, (Object)location, ValueHolder::new);
        if (cachedValueHolder.getFiles().isPresent()) {
            return new SimpleRemoteIterator(cachedValueHolder.getFiles().get().iterator());
        }
        return this.cachingRemoteIterator(cachedValueHolder, CachingDirectoryLister.createListingRemoteIterator(fs, location, this.filterPredicate), location);
    }

    private static RemoteIterator<TrinoFileStatus> createListingRemoteIterator(TrinoFileSystem fs, Location location, Predicate<FileEntry> filterPredicate) throws IOException {
        return new TrinoFileStatusRemoteIterator(fs.listFiles(location), filterPredicate);
    }

    @Override
    public void invalidate(Location location) {
        this.cache.invalidate((Object)location);
    }

    @Override
    public void invalidate(Table table) {
        if (this.isCacheEnabledFor(table.getSchemaTableName()) && CachingDirectoryLister.isLocationPresent(table.getStorage())) {
            if (table.getPartitionColumns().isEmpty()) {
                this.cache.invalidate((Object)Location.of((String)table.getStorage().getLocation()));
            } else {
                this.cache.invalidateAll();
            }
        }
    }

    @Override
    public void invalidate(Partition partition) {
        if (this.isCacheEnabledFor(partition.getSchemaTableName()) && CachingDirectoryLister.isLocationPresent(partition.getStorage())) {
            this.cache.invalidate((Object)Location.of((String)partition.getStorage().getLocation()));
        }
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    private RemoteIterator<TrinoFileStatus> cachingRemoteIterator(final ValueHolder cachedValueHolder, final RemoteIterator<TrinoFileStatus> iterator, final Location location) {
        return new RemoteIterator<TrinoFileStatus>(this){
            private final List<TrinoFileStatus> files = new ArrayList<TrinoFileStatus>();
            final /* synthetic */ CachingDirectoryLister this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public boolean hasNext() throws IOException {
                boolean hasNext = iterator.hasNext();
                if (!hasNext) {
                    this.this$0.cache.asMap().replace(location, cachedValueHolder, new ValueHolder(this.files));
                }
                return hasNext;
            }

            @Override
            public TrinoFileStatus next() throws IOException {
                TrinoFileStatus next = (TrinoFileStatus)iterator.next();
                this.files.add(next);
                return next;
            }
        };
    }

    @Managed
    public void flushCache() {
        this.cache.invalidateAll();
    }

    @Managed
    public Double getHitRate() {
        return this.cache.stats().hitRate();
    }

    @Managed
    public Double getMissRate() {
        return this.cache.stats().missRate();
    }

    @Managed
    public long getHitCount() {
        return this.cache.stats().hitCount();
    }

    @Managed
    public long getMissCount() {
        return this.cache.stats().missCount();
    }

    @Managed
    public long getRequestCount() {
        return this.cache.stats().requestCount();
    }

    @Override
    public boolean isCached(Location location) {
        ValueHolder cached = (ValueHolder)this.cache.getIfPresent((Object)location);
        return cached != null && cached.getFiles().isPresent();
    }

    private boolean isCacheEnabledFor(SchemaTableName schemaTableName) {
        return this.tablePredicate.test(schemaTableName);
    }

    private static boolean isLocationPresent(Storage storage) {
        return storage.getOptionalLocation().isPresent() && !storage.getLocation().isEmpty();
    }

    private static class ValueHolder {
        private static final long INSTANCE_SIZE = SizeOf.instanceSize(ValueHolder.class);
        private final Optional<List<TrinoFileStatus>> files;

        public ValueHolder() {
            this.files = Optional.empty();
        }

        public ValueHolder(List<TrinoFileStatus> files) {
            this.files = Optional.of(ImmutableList.copyOf((Collection)Objects.requireNonNull(files, "files is null")));
        }

        public Optional<List<TrinoFileStatus>> getFiles() {
            return this.files;
        }

        public long getRetainedSizeInBytes() {
            return INSTANCE_SIZE + SizeOf.sizeOf(this.files, value -> SizeOf.estimatedSizeOf((List)value, TrinoFileStatus::getRetainedSizeInBytes));
        }
    }
}

