/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.fs;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.filesystem.FileEntry;
import io.trino.plugin.hive.fs.BlockLocation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TrinoFileStatus
implements Comparable<TrinoFileStatus> {
    private static final long INSTANCE_SIZE = SizeOf.instanceSize(TrinoFileStatus.class);
    private final List<BlockLocation> blockLocations;
    private final String path;
    private final boolean isDirectory;
    private final long length;
    private final long modificationTime;

    public TrinoFileStatus(FileEntry entry) {
        this((List)entry.blocks().orElseGet(() -> List.of(new FileEntry.Block(List.of(), 0L, entry.length()))).stream().map(BlockLocation::new).collect(ImmutableList.toImmutableList()), entry.location().toString(), false, entry.length(), entry.lastModified().toEpochMilli());
    }

    public TrinoFileStatus(List<BlockLocation> blockLocations, String path, boolean isDirectory, long length, long modificationTime) {
        this.blockLocations = ImmutableList.copyOf((Collection)Objects.requireNonNull(blockLocations, "blockLocations is null"));
        this.path = Objects.requireNonNull(path, "path is null");
        this.isDirectory = isDirectory;
        this.length = length;
        this.modificationTime = modificationTime;
    }

    public List<BlockLocation> getBlockLocations() {
        return this.blockLocations;
    }

    public String getPath() {
        return this.path;
    }

    public long getLength() {
        return this.length;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.blockLocations, BlockLocation::getRetainedSizeInBytes) + SizeOf.estimatedSizeOf((String)this.path);
    }

    @Override
    public int compareTo(TrinoFileStatus other) {
        return this.path.compareTo(other.getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrinoFileStatus that = (TrinoFileStatus)o;
        return this.isDirectory == that.isDirectory && this.length == that.length && this.modificationTime == that.modificationTime && this.blockLocations.equals(that.blockLocations) && this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.blockLocations, this.path, this.isDirectory, this.length, this.modificationTime);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("blockLocations", this.blockLocations).add("path", (Object)this.path).add("isDirectory", this.isDirectory).add("length", this.length).add("modificationTime", this.modificationTime).toString();
    }
}

