/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Closer;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcRecordReader;
import io.trino.orc.metadata.CompressionKind;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.base.metrics.LongCount;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.orc.OrcDeletedRows;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.metrics.Metrics;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class OrcPageSource
implements ConnectorPageSource {
    private static final String ORC_CODEC_METRIC_PREFIX = "OrcReaderCompressionFormat_";
    private final OrcRecordReader recordReader;
    private final OrcDataSource orcDataSource;
    private final Optional<OrcDeletedRows> deletedRows;
    private boolean closed;
    private final AggregatedMemoryContext memoryContext;
    private final LocalMemoryContext localMemoryContext;
    private final FileFormatDataSourceStats stats;
    private final Optional<Long> originalFileRowId;
    private final CompressionKind compressionKind;
    private long completedPositions;
    private Optional<SourcePage> outstandingPage = Optional.empty();

    public OrcPageSource(OrcRecordReader recordReader, OrcDataSource orcDataSource, Optional<OrcDeletedRows> deletedRows, Optional<Long> originalFileRowId, AggregatedMemoryContext memoryContext, FileFormatDataSourceStats stats, CompressionKind compressionKind) {
        this.recordReader = Objects.requireNonNull(recordReader, "recordReader is null");
        this.orcDataSource = Objects.requireNonNull(orcDataSource, "orcDataSource is null");
        this.deletedRows = Objects.requireNonNull(deletedRows, "deletedRows is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
        this.localMemoryContext = memoryContext.newLocalMemoryContext(OrcPageSource.class.getSimpleName());
        this.originalFileRowId = Objects.requireNonNull(originalFileRowId, "originalFileRowId is null");
        this.compressionKind = Objects.requireNonNull(compressionKind, "compressionKind is null");
    }

    public long getCompletedBytes() {
        return this.orcDataSource.getReadBytes();
    }

    public OptionalLong getCompletedPositions() {
        return OptionalLong.of(this.completedPositions);
    }

    public long getReadTimeNanos() {
        return this.orcDataSource.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public SourcePage getNextSourcePage() {
        SourcePage page;
        try {
            if (this.outstandingPage.isPresent()) {
                page = this.outstandingPage.get();
                this.outstandingPage = Optional.empty();
                this.localMemoryContext.setBytes(0L);
            } else {
                page = this.recordReader.nextPage();
            }
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw OrcPageSource.handleException(this.orcDataSource.getId(), e);
        }
        if (page == null) {
            this.close();
            return null;
        }
        this.completedPositions += (long)page.getPositionCount();
        OptionalLong startRowId = this.originalFileRowId.map(rowId -> OptionalLong.of(rowId + this.recordReader.getFilePosition())).orElseGet(OptionalLong::empty);
        if (this.deletedRows.isPresent()) {
            boolean deletedRowsYielded;
            boolean bl = deletedRowsYielded = !this.deletedRows.get().loadOrYield();
            if (deletedRowsYielded) {
                this.outstandingPage = Optional.of(page);
                this.localMemoryContext.setBytes(page.getRetainedSizeInBytes());
                return null;
            }
            page = this.deletedRows.get().maskPage(page, startRowId);
        }
        return page;
    }

    static TrinoException handleException(OrcDataSourceId dataSourceId, Exception exception) {
        if (exception instanceof TrinoException) {
            TrinoException trinoException = (TrinoException)((Object)exception);
            return trinoException;
        }
        if (exception instanceof OrcCorruptionException) {
            return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)exception);
        }
        return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read ORC file: %s", dataSourceId), (Throwable)exception);
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Closer closer = Closer.create();
        closer.register(() -> {
            this.stats.addMaxCombinedBytesPerRow(this.recordReader.getMaxCombinedBytesPerRow());
            this.recordReader.close();
        });
        closer.register(() -> {
            if (this.deletedRows.isPresent()) {
                this.deletedRows.get().close();
            }
        });
        try {
            closer.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("orcReader", (Object)this.recordReader).toString();
    }

    public long getMemoryUsage() {
        return this.memoryContext.getBytes();
    }

    public Metrics getMetrics() {
        return new Metrics((Map)ImmutableMap.of((Object)(ORC_CODEC_METRIC_PREFIX + this.compressionKind.name()), (Object)new LongCount(this.recordReader.getTotalDataLength())));
    }
}

