/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.orc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.MoreCollectors;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.NameBasedFieldMapper;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcPredicate;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcRecordReader;
import io.trino.orc.TupleDomainOrcPredicate;
import io.trino.orc.metadata.OrcType;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.TransformConnectorPageSource;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.coercions.TypeCoercer;
import io.trino.plugin.hive.orc.HdfsOrcDataSource;
import io.trino.plugin.hive.orc.OrcDeleteDeltaPageSourceFactory;
import io.trino.plugin.hive.orc.OrcDeletedRows;
import io.trino.plugin.hive.orc.OrcFileWriter;
import io.trino.plugin.hive.orc.OrcPageSource;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcTypeTranslator;
import io.trino.plugin.hive.orc.OriginalFilesUtils;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.Utils;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.joda.time.DateTimeZone;

public class OrcPageSourceFactory
implements HivePageSourceFactory {
    private static final Block ORIGINAL_FILE_TRANSACTION_ID_BLOCK = Utils.nativeValueToBlock((Type)BigintType.BIGINT, (Object)0L);
    private static final Pattern DEFAULT_HIVE_COLUMN_NAME_PATTERN = Pattern.compile("_col\\d+");
    private final OrcReaderOptions orcReaderOptions;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final FileFormatDataSourceStats stats;
    private final DateTimeZone legacyTimeZone;
    private final int domainCompactionThreshold;

    @Inject
    public OrcPageSourceFactory(OrcReaderConfig config, TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats stats, HiveConfig hiveConfig) {
        this(config.toOrcReaderOptions(), fileSystemFactory, stats, hiveConfig.getOrcLegacyDateTimeZone(), hiveConfig.getDomainCompactionThreshold());
    }

    public OrcPageSourceFactory(OrcReaderOptions orcReaderOptions, TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats stats, DateTimeZone legacyTimeZone) {
        this(orcReaderOptions, fileSystemFactory, stats, legacyTimeZone, 0);
    }

    public OrcPageSourceFactory(OrcReaderOptions orcReaderOptions, TrinoFileSystemFactory fileSystemFactory, FileFormatDataSourceStats stats, DateTimeZone legacyTimeZone, int domainCompactionThreshold) {
        this.orcReaderOptions = Objects.requireNonNull(orcReaderOptions, "orcReaderOptions is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.legacyTimeZone = legacyTimeZone;
        this.domainCompactionThreshold = domainCompactionThreshold;
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
    }

    public static boolean stripUnnecessaryProperties(String serializationLibraryName) {
        return "org.apache.hadoop.hive.ql.io.orc.OrcSerde".equals(serializationLibraryName);
    }

    @Override
    public Optional<ConnectorPageSource> createPageSource(ConnectorSession session, Location path, long start, long length, long estimatedFileSize, long fileModifiedTime, Schema schema, List<HiveColumnHandle> columns, TupleDomain<HiveColumnHandle> effectivePredicate, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction) {
        if (!"org.apache.hadoop.hive.ql.io.orc.OrcSerde".equals(schema.serializationLibraryName())) {
            return Optional.empty();
        }
        return Optional.of(this.createOrcPageSource(session, path, start, length, estimatedFileSize, fileModifiedTime, columns, HiveSessionProperties.isUseOrcColumnNames(session) || schema.isFullAcidTable(), schema.isFullAcidTable(), effectivePredicate, this.legacyTimeZone, this.orcReaderOptions.withMaxMergeDistance(HiveSessionProperties.getOrcMaxMergeDistance(session)).withMaxBufferSize(HiveSessionProperties.getOrcMaxBufferSize(session)).withStreamBufferSize(HiveSessionProperties.getOrcStreamBufferSize(session)).withTinyStripeThreshold(HiveSessionProperties.getOrcTinyStripeThreshold(session)).withMaxReadBlockSize(HiveSessionProperties.getOrcMaxReadBlockSize(session)).withLazyReadSmallRanges(HiveSessionProperties.getOrcLazyReadSmallRanges(session)).withNestedLazy(HiveSessionProperties.isOrcNestedLazy(session)).withBloomFiltersEnabled(HiveSessionProperties.isOrcBloomFiltersEnabled(session)), acidInfo, bucketNumber, originalFile, transaction, this.stats));
    }

    private ConnectorPageSource createOrcPageSource(ConnectorSession session, Location path, long start, long length, long estimatedFileSize, long fileModifiedTime, List<HiveColumnHandle> columns, boolean useOrcColumnNames, boolean isFullAcid, TupleDomain<HiveColumnHandle> effectivePredicate, DateTimeZone legacyFileTimeZone, OrcReaderOptions options, Optional<AcidInfo> acidInfo, OptionalInt bucketNumber, boolean originalFile, AcidTransaction transaction, FileFormatDataSourceStats stats) {
        HdfsOrcDataSource orcDataSource;
        for (HiveColumnHandle column : columns) {
            Preconditions.checkArgument((column.getColumnType() == HiveColumnHandle.ColumnType.REGULAR ? 1 : 0) != 0, (String)"column type must be regular: %s", (Object)column);
        }
        Preconditions.checkArgument((!effectivePredicate.isNone() ? 1 : 0) != 0);
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            TrinoInputFile inputFile = fileSystem.newInputFile(path, estimatedFileSize, Instant.ofEpochMilli(fileModifiedTime));
            orcDataSource = new HdfsOrcDataSource(new OrcDataSourceId(path.toString()), estimatedFileSize, options, inputFile, stats);
        }
        catch (Exception e) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, HiveUtil.splitError(e, path, start, length), (Throwable)e);
        }
        AggregatedMemoryContext memoryUsage = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        try {
            boolean originalFilesPresent;
            Optional optionalOrcReader = OrcReader.createOrcReader((OrcDataSource)orcDataSource, (OrcReaderOptions)options);
            if (optionalOrcReader.isEmpty()) {
                return new EmptyPageSource();
            }
            OrcReader reader = (OrcReader)optionalOrcReader.get();
            if (!originalFile && acidInfo.isPresent() && !acidInfo.get().isOrcAcidVersionValidated()) {
                OrcPageSourceFactory.validateOrcAcidVersion(path, reader);
            }
            List<OrcColumn> fileColumns = reader.getRootColumn().getNestedColumns();
            ArrayList<OrcColumn> fileReadColumns = new ArrayList<OrcColumn>();
            ArrayList<Object> fileReadTypes = new ArrayList<Object>();
            ArrayList<OrcReader.ProjectedLayout> fileReadLayouts = new ArrayList<OrcReader.ProjectedLayout>();
            boolean bl = originalFilesPresent = acidInfo.isPresent() && OrcPageSourceFactory.hasOriginalFiles(acidInfo.get());
            if (isFullAcid && !originalFilesPresent) {
                OrcPageSourceFactory.verifyAcidSchema(reader, path);
                ImmutableMap acidColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
                fileColumns = OrcPageSourceFactory.ensureColumnNameConsistency(Objects.requireNonNull((OrcColumn)acidColumnsByName.get("row".toLowerCase(Locale.ENGLISH))).getNestedColumns(), columns);
                fileReadColumns.add(Objects.requireNonNull((OrcColumn)acidColumnsByName.get("originalTransaction".toLowerCase(Locale.ENGLISH))));
                fileReadTypes.add(BigintType.BIGINT);
                fileReadLayouts.add(OrcReader.fullyProjectedLayout());
                fileReadColumns.add(Objects.requireNonNull((OrcColumn)acidColumnsByName.get("bucket".toLowerCase(Locale.ENGLISH))));
                fileReadTypes.add(IntegerType.INTEGER);
                fileReadLayouts.add(OrcReader.fullyProjectedLayout());
                fileReadColumns.add(Objects.requireNonNull((OrcColumn)acidColumnsByName.get("rowId".toLowerCase(Locale.ENGLISH))));
                fileReadTypes.add(BigintType.BIGINT);
                fileReadLayouts.add(OrcReader.fullyProjectedLayout());
            }
            ImmutableMap fileColumnsByName = ImmutableMap.of();
            if (useOrcColumnNames) {
                OrcPageSourceFactory.verifyFileHasColumnNames(fileColumns, path);
                fileColumnsByName = Maps.uniqueIndex((Iterable)fileColumns, orcColumn -> orcColumn.getColumnName().toLowerCase(Locale.ENGLISH));
            }
            Map projectionsByBaseColumnKey = columns.stream().collect(Collectors.groupingBy(useOrcColumnNames ? HiveColumnHandle::getBaseColumnName : HiveColumnHandle::getBaseHiveColumnIndex, Collectors.mapping(OrcPageSourceFactory::getDereferencesAsList, Collectors.toList())));
            TupleDomainOrcPredicate.TupleDomainOrcPredicateBuilder predicateBuilder = TupleDomainOrcPredicate.builder().setBloomFiltersEnabled(options.isBloomFiltersEnabled()).setDomainCompactionThreshold(this.domainCompactionThreshold);
            Map effectivePredicateDomains = (Map)effectivePredicate.getDomains().orElseThrow(() -> new IllegalArgumentException("Effective predicate is none"));
            TransformConnectorPageSource.Builder transforms = TransformConnectorPageSource.builder();
            HashMap<Object, Integer> baseColumnKeyToOrdinal = new HashMap<Object, Integer>();
            for (HiveColumnHandle column : columns) {
                OrcColumn orcBaseColumn;
                HiveColumnHandle baseColumn = column.getBaseColumn();
                Integer ordinal = (Integer)baseColumnKeyToOrdinal.get(useOrcColumnNames ? column.getBaseColumnName() : Integer.valueOf(column.getBaseHiveColumnIndex()));
                if (ordinal == null) {
                    orcBaseColumn = null;
                    OrcReader.ProjectedLayout projectedLayout = null;
                    Object columnDomains = null;
                    if (useOrcColumnNames) {
                        String columnName = baseColumn.getName().toLowerCase(Locale.ENGLISH);
                        orcBaseColumn = (OrcColumn)fileColumnsByName.get(columnName);
                        if (orcBaseColumn != null) {
                            projectedLayout = OrcReader.NameBasedProjectedLayout.createProjectedLayout((OrcColumn)orcBaseColumn, projectionsByBaseColumnKey.get(columnName));
                            columnDomains = (Map)effectivePredicateDomains.entrySet().stream().filter(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getBaseColumnName().toLowerCase(Locale.ENGLISH).equals(columnName)).collect(ImmutableMap.toImmutableMap(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getHiveColumnProjectionInfo(), Map.Entry::getValue));
                        }
                    } else if (baseColumn.getBaseHiveColumnIndex() < fileColumns.size() && (orcBaseColumn = fileColumns.get(baseColumn.getBaseHiveColumnIndex())) != null) {
                        projectedLayout = OrcReader.NameBasedProjectedLayout.createProjectedLayout((OrcColumn)orcBaseColumn, projectionsByBaseColumnKey.get(baseColumn.getBaseHiveColumnIndex()));
                        columnDomains = (Map)effectivePredicateDomains.entrySet().stream().filter(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getBaseHiveColumnIndex() == baseColumn.getBaseHiveColumnIndex()).collect(ImmutableMap.toImmutableMap(columnDomain -> ((HiveColumnHandle)columnDomain.getKey()).getHiveColumnProjectionInfo(), Map.Entry::getValue));
                    }
                    if (orcBaseColumn == null) {
                        transforms.constantValue((Block)column.getType().createNullBlock());
                        continue;
                    }
                    ordinal = fileReadColumns.size();
                    baseColumnKeyToOrdinal.put(useOrcColumnNames ? column.getBaseColumnName() : Integer.valueOf(column.getBaseHiveColumnIndex()), ordinal);
                    fileReadColumns.add(orcBaseColumn);
                    fileReadLayouts.add(projectedLayout);
                    fileReadTypes.add(OrcTypeTranslator.createCoercer(orcBaseColumn.getColumnType(), orcBaseColumn.getNestedColumns(), baseColumn.getType()).map(TypeCoercer::getFromType).orElse(baseColumn.getType()));
                    for (Map.Entry entry : columnDomains.entrySet()) {
                        OrcColumn nestedColumn = OrcPageSourceFactory.getNestedColumn(orcBaseColumn, (Optional)entry.getKey());
                        if (nestedColumn == null) continue;
                        predicateBuilder.addColumn(nestedColumn.getColumnId(), (Domain)entry.getValue());
                    }
                }
                orcBaseColumn = (OrcColumn)fileReadColumns.get(ordinal);
                if (column.isBaseColumn()) {
                    Optional<TypeCoercer<? extends Type, ? extends Type>> coercer = OrcTypeTranslator.createCoercer(orcBaseColumn.getColumnType(), orcBaseColumn.getNestedColumns(), column.getType());
                    transforms.column(ordinal, coercer.map(Function.identity()));
                    continue;
                }
                OrcColumn orcFieldColumn = orcBaseColumn;
                for (String fieldName : column.getHiveColumnProjectionInfo().orElseThrow().getDereferenceNames()) {
                    Optional optional = (Optional)orcFieldColumn.getNestedColumns().stream().filter(field -> field.getColumnName().equalsIgnoreCase(fieldName)).collect(MoreCollectors.toOptional());
                    if (optional.isEmpty()) {
                        orcFieldColumn = null;
                        break;
                    }
                    orcFieldColumn = (OrcColumn)optional.get();
                }
                if (orcFieldColumn == null) {
                    transforms.constantValue((Block)column.getType().createNullBlock());
                    continue;
                }
                Optional<TypeCoercer<? extends Type, ? extends Type>> coercer = OrcTypeTranslator.createCoercer(orcFieldColumn.getColumnType(), orcFieldColumn.getNestedColumns(), column.getType());
                transforms.dereferenceField((List<Integer>)ImmutableList.builder().add((Object)ordinal).addAll(HivePageSourceProvider.getProjection(column, baseColumn)).build(), coercer.map(Function.identity()));
            }
            Optional<Long> originalFileRowId = acidInfo.filter(OrcPageSourceFactory::hasOriginalFiles).map(acidInfo2 -> OriginalFilesUtils.getPrecedingRowCount(((AcidInfo)acidInfo.get()).getOriginalFiles(), path, this.fileSystemFactory, session.getIdentity(), options, stats));
            boolean appendRowNumberColumn = false;
            if (transaction.isMerge()) {
                if (originalFile) {
                    transforms.transform(new MergedRowAdaptationWithOriginalFiles(originalFileRowId.orElse(0L), bucketNumber.orElse(0)));
                    appendRowNumberColumn = true;
                } else {
                    transforms.transform(new MergedRowPageFunction());
                }
            }
            OrcRecordReader recordReader = reader.createRecordReader(fileReadColumns, fileReadTypes, fileReadLayouts, appendRowNumberColumn, (OrcPredicate)predicateBuilder.build(), start, length, legacyFileTimeZone, memoryUsage, 1, arg_0 -> OrcPageSourceFactory.lambda$createOrcPageSource$9((OrcDataSource)orcDataSource, arg_0), NameBasedFieldMapper::create);
            Optional<OrcDeletedRows> deletedRows = acidInfo.map(info -> new OrcDeletedRows(path.fileName(), new OrcDeleteDeltaPageSourceFactory(options, stats), session.getIdentity(), this.fileSystemFactory, (AcidInfo)info, bucketNumber, memoryUsage));
            OrcPageSource pageSource = new OrcPageSource(recordReader, (OrcDataSource)orcDataSource, deletedRows, originalFileRowId, memoryUsage, stats, reader.getCompressionKind());
            return transforms.build(pageSource);
        }
        catch (Exception e) {
            try {
                orcDataSource.close();
            }
            catch (IOException reader) {
                // empty catch block
            }
            if (e instanceof TrinoException) {
                TrinoException trinoException = (TrinoException)((Object)e);
                throw trinoException;
            }
            if (e instanceof OrcCorruptionException) {
                throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, (Throwable)e);
            }
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, HiveUtil.splitError(e, path, start, length), (Throwable)e);
        }
    }

    private static void validateOrcAcidVersion(Location path, OrcReader reader) {
        if (reader.getFooter().getNumberOfRows() == 0L) {
            return;
        }
        int writerId = (Integer)reader.getFooter().getWriterId().orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, "writerId not set in ORC metadata in " + String.valueOf(path)));
        if (writerId == 4 || writerId == 2) {
            return;
        }
        Optional<Integer> hiveAcidVersion = OrcPageSourceFactory.getHiveAcidVersion(reader);
        if (hiveAcidVersion.isEmpty() || hiveAcidVersion.get() < 2) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Hive transactional tables are supported since Hive 3.0. Expected `hive.acid.version` in ORC metadata in %s to be >=2 but was %s. If you have upgraded from an older version of Hive, make sure a major compaction has been run at least once after the upgrade.", path, hiveAcidVersion.map(String::valueOf).orElse("<empty>")));
        }
    }

    private static Optional<Integer> getHiveAcidVersion(OrcReader reader) {
        Slice slice = (Slice)reader.getFooter().getUserMetadata().get("hive.acid.version");
        if (slice == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(Integer.valueOf(slice.toString(StandardCharsets.UTF_8)));
        }
        catch (RuntimeException runtimeException) {
            return Optional.empty();
        }
    }

    private static List<OrcColumn> ensureColumnNameConsistency(List<OrcColumn> fileColumns, List<HiveColumnHandle> columns) {
        int columnCount = fileColumns.size();
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)columnCount);
        Map baseColumnsByColumnIndex = (Map)columns.stream().map(HiveColumnHandle::getBaseColumn).collect(ImmutableMap.toImmutableMap(HiveColumnHandle::getBaseHiveColumnIndex, Function.identity()));
        for (int index = 0; index < columnCount; ++index) {
            OrcColumn column = fileColumns.get(index);
            HiveColumnHandle handle = (HiveColumnHandle)baseColumnsByColumnIndex.get(index);
            if (handle != null && !column.getColumnName().equals(handle.getName())) {
                column = new OrcColumn(column.getPath(), column.getColumnId(), handle.getName(), column.getColumnType(), column.getOrcDataSourceId(), column.getNestedColumns(), column.getAttributes());
            }
            builder.add((Object)column);
        }
        return builder.build();
    }

    private static boolean hasOriginalFiles(AcidInfo acidInfo) {
        return !acidInfo.getOriginalFiles().isEmpty();
    }

    private static void verifyFileHasColumnNames(List<OrcColumn> columns, Location path) {
        if (!columns.isEmpty() && columns.stream().map(OrcColumn::getColumnName).allMatch(physicalColumnName -> DEFAULT_HIVE_COLUMN_NAME_PATTERN.matcher((CharSequence)physicalColumnName).matches())) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_FILE_MISSING_COLUMN_NAMES, "ORC file does not contain column names in the footer: " + String.valueOf(path));
        }
    }

    static void verifyAcidSchema(OrcReader orcReader, Location path) {
        OrcColumn rootColumn = orcReader.getRootColumn();
        List nestedColumns = rootColumn.getNestedColumns();
        if (nestedColumns.size() != 6) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file should have 6 columns, found %s %s in %s", nestedColumns.size(), nestedColumns.stream().map(column -> String.format("%s (%s)", column.getColumnName(), column.getColumnType())).collect(ImmutableList.toImmutableList()), path));
        }
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 0, "operation", OrcType.OrcTypeKind.INT, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 1, "originalTransaction", OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 2, "bucket", OrcType.OrcTypeKind.INT, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 3, "rowId", OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 4, "currentTransaction", OrcType.OrcTypeKind.LONG, path);
        OrcPageSourceFactory.verifyAcidColumn(orcReader, 5, "row", OrcType.OrcTypeKind.STRUCT, path);
    }

    private static void verifyAcidColumn(OrcReader orcReader, int columnIndex, String columnName, OrcType.OrcTypeKind columnType, Location path) {
        OrcColumn column = (OrcColumn)orcReader.getRootColumn().getNestedColumns().get(columnIndex);
        if (!column.getColumnName().toLowerCase(Locale.ENGLISH).equals(columnName.toLowerCase(Locale.ENGLISH))) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file column %s should be named %s: %s", columnIndex, columnName, path));
        }
        if (column.getColumnType().getOrcTypeKind() != columnType) {
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("ORC ACID file %s column should be type %s: %s", columnName, columnType, path));
        }
    }

    private static OrcColumn getNestedColumn(OrcColumn baseColumn, Optional<HiveColumnProjectionInfo> projectionInfo) {
        if (projectionInfo.isEmpty()) {
            return baseColumn;
        }
        OrcColumn current = baseColumn;
        for (String field : projectionInfo.get().getDereferenceNames()) {
            Optional<OrcColumn> orcColumn = current.getNestedColumns().stream().filter(column -> column.getColumnName().toLowerCase(Locale.ENGLISH).equals(field)).findFirst();
            if (orcColumn.isEmpty()) {
                return null;
            }
            current = orcColumn.get();
        }
        return current;
    }

    private static List<String> getDereferencesAsList(HiveColumnHandle column) {
        return (List)column.getHiveColumnProjectionInfo().map(info -> (ImmutableList)info.getDereferenceNames().stream().map(dereference -> dereference.toLowerCase(Locale.ENGLISH)).collect(ImmutableList.toImmutableList())).orElse(ImmutableList.of());
    }

    private static /* synthetic */ RuntimeException lambda$createOrcPageSource$9(OrcDataSource orcDataSource, Exception exception) {
        return OrcPageSource.handleException(orcDataSource.getId(), exception);
    }

    private static final class MergedRowAdaptationWithOriginalFiles
    implements Function<SourcePage, Block> {
        private final long startingRowId;
        private final Block bucketBlock;

        public MergedRowAdaptationWithOriginalFiles(long startingRowId, int bucketId) {
            this.startingRowId = startingRowId;
            this.bucketBlock = Utils.nativeValueToBlock((Type)IntegerType.INTEGER, (Object)OrcFileWriter.computeBucketValue(bucketId, 0));
        }

        @Override
        public Block apply(SourcePage sourcePage) {
            int positionCount = sourcePage.getPositionCount();
            LongArrayBlock rowNumberBlock = (LongArrayBlock)sourcePage.getBlock(sourcePage.getChannelCount() - 1);
            if (this.startingRowId != 0L) {
                long[] newRowNumbers = new long[rowNumberBlock.getPositionCount()];
                for (int index = 0; index < rowNumberBlock.getPositionCount(); ++index) {
                    newRowNumbers[index] = this.startingRowId + rowNumberBlock.getLong(index);
                }
                rowNumberBlock = new LongArrayBlock(rowNumberBlock.getPositionCount(), Optional.empty(), newRowNumbers);
            }
            return RowBlock.fromFieldBlocks((int)positionCount, (Block[])new Block[]{RunLengthEncodedBlock.create((Block)ORIGINAL_FILE_TRANSACTION_ID_BLOCK, (int)positionCount), RunLengthEncodedBlock.create((Block)this.bucketBlock, (int)positionCount), rowNumberBlock});
        }
    }

    private static final class MergedRowPageFunction
    implements Function<SourcePage, Block> {
        private MergedRowPageFunction() {
        }

        @Override
        public Block apply(SourcePage page) {
            return RowBlock.fromFieldBlocks((int)page.getPositionCount(), (Block[])new Block[]{page.getBlock(0), page.getBlock(1), page.getBlock(2)});
        }
    }
}

