/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.rcfile;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CheckReturnValue;
import io.airlift.units.DataSize;
import io.trino.hive.formats.FileCorruptionException;
import io.trino.hive.formats.rcfile.RcFileReader;
import io.trino.plugin.base.util.Closables;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.ObjLongConsumer;

public class RcFilePageSource
implements ConnectorPageSource {
    private static final long GUESSED_MEMORY_USAGE = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE).toBytes();
    private final RcFileReader rcFileReader;
    private final List<String> columnNames;
    private final List<Type> types;
    private final Block[] constantBlocks;
    private final int[] hiveColumnIndexes;
    private int pageId;
    private boolean closed;

    public RcFilePageSource(RcFileReader rcFileReader, List<HiveColumnHandle> columns) {
        Objects.requireNonNull(rcFileReader, "rcFileReader is null");
        Objects.requireNonNull(columns, "columns is null");
        this.rcFileReader = rcFileReader;
        int size = columns.size();
        this.constantBlocks = new Block[size];
        this.hiveColumnIndexes = new int[size];
        ImmutableList.Builder namesBuilder = ImmutableList.builder();
        ImmutableList.Builder typesBuilder = ImmutableList.builder();
        for (int columnIndex = 0; columnIndex < columns.size(); ++columnIndex) {
            HiveColumnHandle column = columns.get(columnIndex);
            namesBuilder.add((Object)column.getName());
            typesBuilder.add((Object)column.getType());
            this.hiveColumnIndexes[columnIndex] = column.getBaseHiveColumnIndex();
            if (this.hiveColumnIndexes[columnIndex] < rcFileReader.getColumnCount()) continue;
            this.constantBlocks[columnIndex] = column.getType().createNullBlock();
        }
        this.types = typesBuilder.build();
        this.columnNames = namesBuilder.build();
    }

    public long getCompletedBytes() {
        return this.rcFileReader.getBytesRead();
    }

    public long getReadTimeNanos() {
        return this.rcFileReader.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.closed;
    }

    public SourcePage getNextSourcePage() {
        try {
            ++this.pageId;
            int currentPageSize = this.rcFileReader.advance();
            if (currentPageSize < 0) {
                this.close();
                return null;
            }
            return new RcFileSourcePage(currentPageSize);
        }
        catch (TrinoException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw e;
        }
        catch (FileCorruptionException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Corrupted RC file: %s", this.rcFileReader.getFileLocation()), (Throwable)e);
        }
        catch (IOException | RuntimeException e) {
            Closables.closeAllSuppress((Throwable)e, (AutoCloseable[])new AutoCloseable[]{this});
            throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read RC file: %s", this.rcFileReader.getFileLocation()), (Throwable)e);
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.rcFileReader.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("columnNames", this.columnNames).add("types", this.types).toString();
    }

    public long getMemoryUsage() {
        return GUESSED_MEMORY_USAGE;
    }

    private final class RcFileSourcePage
    implements SourcePage {
        private final int expectedBatchId;
        private final Block[] blocks;
        private SelectedPositions selectedPositions;
        private long sizeInBytes;
        private long retainedSizeInBytes;

        public RcFileSourcePage(int positionCount) {
            this.expectedBatchId = RcFilePageSource.this.pageId;
            this.blocks = new Block[RcFilePageSource.this.hiveColumnIndexes.length];
            this.selectedPositions = new SelectedPositions(positionCount, null);
        }

        public int getPositionCount() {
            return this.selectedPositions.positionCount();
        }

        public long getSizeInBytes() {
            return this.sizeInBytes;
        }

        public long getRetainedSizeInBytes() {
            return this.retainedSizeInBytes;
        }

        public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
            for (Block block : this.blocks) {
                if (block == null) continue;
                block.retainedBytesForEachPart(consumer);
            }
        }

        public int getChannelCount() {
            return this.blocks.length;
        }

        public Block getBlock(int channel) {
            Preconditions.checkState((RcFilePageSource.this.pageId == this.expectedBatchId ? 1 : 0) != 0);
            Block block = this.blocks[channel];
            if (block == null) {
                if (RcFilePageSource.this.constantBlocks[channel] != null) {
                    block = RunLengthEncodedBlock.create((Block)RcFilePageSource.this.constantBlocks[channel], (int)this.selectedPositions.positionCount());
                } else {
                    try {
                        block = RcFilePageSource.this.rcFileReader.readBlock(RcFilePageSource.this.hiveColumnIndexes[channel]);
                    }
                    catch (FileCorruptionException e) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_BAD_DATA, String.format("Corrupted RC file: %s", RcFilePageSource.this.rcFileReader.getFileLocation()), (Throwable)e);
                    }
                    catch (IOException | RuntimeException e) {
                        throw new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_CURSOR_ERROR, String.format("Failed to read RC file: %s", RcFilePageSource.this.rcFileReader.getFileLocation()), (Throwable)e);
                    }
                    block = this.selectedPositions.apply(block);
                }
                this.blocks[channel] = block;
                this.sizeInBytes += block.getSizeInBytes();
                this.retainedSizeInBytes += block.getRetainedSizeInBytes();
            }
            return block;
        }

        public Page getPage() {
            for (int i = 0; i < this.blocks.length; ++i) {
                this.getBlock(i);
            }
            return new Page(this.selectedPositions.positionCount(), this.blocks);
        }

        public void selectPositions(int[] positions, int offset, int size) {
            this.selectedPositions = this.selectedPositions.selectPositions(positions, offset, size);
            this.retainedSizeInBytes = 0L;
            for (int i = 0; i < this.blocks.length; ++i) {
                Block block = this.blocks[i];
                if (block == null) continue;
                block = this.selectedPositions.apply(block);
                this.retainedSizeInBytes += block.getRetainedSizeInBytes();
                this.blocks[i] = block;
            }
        }
    }

    private record SelectedPositions(int positionCount, @Nullable int[] positions) {
        @CheckReturnValue
        public Block apply(Block block) {
            if (this.positions == null) {
                return block;
            }
            return block.getPositions(this.positions, 0, this.positionCount);
        }

        @CheckReturnValue
        public SelectedPositions selectPositions(int[] positions, int offset, int size) {
            if (this.positions == null) {
                for (int i = 0; i < size; ++i) {
                    Objects.checkIndex(offset + i, this.positionCount);
                }
                return new SelectedPositions(size, Arrays.copyOfRange(positions, offset, offset + size));
            }
            int[] newPositions = new int[size];
            for (int i = 0; i < size; ++i) {
                newPositions[i] = this.positions[positions[offset + i]];
            }
            return new SelectedPositions(size, newPositions);
        }
    }
}

