/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import io.trino.hive.formats.UnionToRowCoercionUtils;
import io.trino.metastore.HiveType;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.type.Category;
import io.trino.metastore.type.ListTypeInfo;
import io.trino.metastore.type.MapTypeInfo;
import io.trino.metastore.type.PrimitiveCategory;
import io.trino.metastore.type.PrimitiveTypeInfo;
import io.trino.metastore.type.StructTypeInfo;
import io.trino.metastore.type.TypeInfo;
import io.trino.metastore.type.UnionTypeInfo;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import java.util.List;
import java.util.Optional;

public final class HiveTypeUtil {
    private HiveTypeUtil() {
    }

    @Deprecated
    public static TypeSignature getTypeSignature(HiveType type) {
        return HiveTypeUtil.getTypeSignature(type, HiveTimestampPrecision.DEFAULT_PRECISION);
    }

    public static TypeSignature getTypeSignature(HiveType type, HiveTimestampPrecision timestampPrecision) {
        return HiveTypeTranslator.toTypeSignature(type.getTypeInfo(), timestampPrecision);
    }

    public static Type getType(HiveType type, TypeManager typeManager, HiveTimestampPrecision timestampPrecision) {
        return typeManager.getType(HiveTypeUtil.getTypeSignature(type, timestampPrecision));
    }

    public static boolean typeSupported(TypeInfo typeInfo, StorageFormat storageFormat) {
        return switch (typeInfo.getCategory()) {
            default -> throw new MatchException(null, null);
            case Category.PRIMITIVE -> HiveTypeUtil.typeSupported(((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory());
            case Category.MAP -> {
                if (HiveTypeUtil.typeSupported(((MapTypeInfo)typeInfo).getMapKeyTypeInfo(), storageFormat) && HiveTypeUtil.typeSupported(((MapTypeInfo)typeInfo).getMapValueTypeInfo(), storageFormat)) {
                    yield true;
                }
                yield false;
            }
            case Category.LIST -> HiveTypeUtil.typeSupported(((ListTypeInfo)typeInfo).getListElementTypeInfo(), storageFormat);
            case Category.STRUCT -> ((StructTypeInfo)typeInfo).getAllStructFieldTypeInfos().stream().allMatch(fieldTypeInfo -> HiveTypeUtil.typeSupported(fieldTypeInfo, storageFormat));
            case Category.UNION -> storageFormat.getSerde().equalsIgnoreCase(HiveStorageFormat.AVRO.getSerde()) || storageFormat.getSerde().equalsIgnoreCase(HiveStorageFormat.ORC.getSerde()) || ((UnionTypeInfo)typeInfo).getAllUnionObjectTypeInfos().stream().allMatch(fieldTypeInfo -> HiveTypeUtil.typeSupported(fieldTypeInfo, storageFormat));
        };
    }

    private static boolean typeSupported(PrimitiveCategory category) {
        return switch (category) {
            default -> throw new MatchException(null, null);
            case PrimitiveCategory.BOOLEAN, PrimitiveCategory.BYTE, PrimitiveCategory.SHORT, PrimitiveCategory.INT, PrimitiveCategory.LONG, PrimitiveCategory.FLOAT, PrimitiveCategory.DOUBLE, PrimitiveCategory.STRING, PrimitiveCategory.VARCHAR, PrimitiveCategory.CHAR, PrimitiveCategory.DATE, PrimitiveCategory.TIMESTAMP, PrimitiveCategory.TIMESTAMPLOCALTZ, PrimitiveCategory.BINARY, PrimitiveCategory.DECIMAL -> true;
            case PrimitiveCategory.INTERVAL_YEAR_MONTH, PrimitiveCategory.INTERVAL_DAY_TIME, PrimitiveCategory.VOID, PrimitiveCategory.VARIANT, PrimitiveCategory.UNKNOWN -> false;
        };
    }

    public static Optional<HiveType> getHiveTypeForDereferences(HiveType hiveType, List<Integer> dereferences) {
        TypeInfo typeInfo = hiveType.getTypeInfo();
        for (int fieldIndex : dereferences) {
            if (typeInfo instanceof StructTypeInfo) {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                try {
                    typeInfo = (TypeInfo)structTypeInfo.getAllStructFieldTypeInfos().get(fieldIndex);
                    continue;
                }
                catch (RuntimeException e) {
                    return Optional.empty();
                }
            }
            if (typeInfo instanceof UnionTypeInfo) {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                try {
                    if (fieldIndex == 0) {
                        return Optional.of(HiveTypeTranslator.toHiveType(UnionToRowCoercionUtils.UNION_FIELD_TAG_TYPE));
                    }
                    typeInfo = (TypeInfo)unionTypeInfo.getAllUnionObjectTypeInfos().get(fieldIndex - 1);
                    continue;
                }
                catch (RuntimeException e) {
                    return Optional.empty();
                }
            }
            throw new IllegalArgumentException(Strings.lenientFormat((String)"typeInfo: %s should be struct or union type", (Object[])new Object[]{typeInfo}));
        }
        return Optional.of(HiveType.fromTypeInfo((TypeInfo)typeInfo));
    }

    public static List<String> getHiveDereferenceNames(HiveType hiveType, List<Integer> dereferences) {
        ImmutableList.Builder dereferenceNames = ImmutableList.builder();
        TypeInfo typeInfo = hiveType.getTypeInfo();
        for (int i = 0; i < dereferences.size(); ++i) {
            int fieldIndex = dereferences.get(i);
            Preconditions.checkArgument((fieldIndex >= 0 ? 1 : 0) != 0, (Object)"fieldIndex cannot be negative");
            if (typeInfo instanceof StructTypeInfo) {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                Preconditions.checkArgument((fieldIndex < structTypeInfo.getAllStructFieldNames().size() ? 1 : 0) != 0, (Object)"fieldIndex should be less than the number of fields in the struct");
                String fieldName = (String)structTypeInfo.getAllStructFieldNames().get(fieldIndex);
                dereferenceNames.add((Object)fieldName);
                typeInfo = (TypeInfo)structTypeInfo.getAllStructFieldTypeInfos().get(fieldIndex);
                continue;
            }
            if (typeInfo instanceof UnionTypeInfo) {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                Preconditions.checkArgument((fieldIndex - 1 < unionTypeInfo.getAllUnionObjectTypeInfos().size() ? 1 : 0) != 0, (Object)"fieldIndex should be less than the number of fields in the union plus tag field");
                if (fieldIndex == 0) {
                    Preconditions.checkArgument((i == dereferences.size() - 1 ? 1 : 0) != 0, (Object)"Union's tag field should not have more subfields");
                    dereferenceNames.add((Object)"tag");
                    break;
                }
                typeInfo = (TypeInfo)unionTypeInfo.getAllUnionObjectTypeInfos().get(fieldIndex - 1);
                dereferenceNames.add((Object)("field" + (fieldIndex - 1)));
                continue;
            }
            throw new IllegalArgumentException(Strings.lenientFormat((String)"typeInfo: %s should be struct or union type", (Object[])new Object[]{typeInfo}));
        }
        return dereferenceNames.build();
    }
}

