/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive.util;

import com.google.common.collect.AbstractIterator;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcPredicate;
import io.trino.orc.OrcReader;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcRecordReader;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TempFileReader
extends AbstractIterator<Page> {
    private final OrcRecordReader reader;

    public TempFileReader(List<Type> types, OrcDataSource dataSource) {
        Objects.requireNonNull(types, "types is null");
        try {
            OrcReader orcReader = (OrcReader)OrcReader.createOrcReader((OrcDataSource)dataSource, (OrcReaderOptions)new OrcReaderOptions()).orElseThrow(() -> new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Temporary data file is empty"));
            this.reader = orcReader.createRecordReader(orcReader.getRootColumn().getNestedColumns(), types, false, OrcPredicate.TRUE, DateTimeZone.UTC, AggregatedMemoryContext.newSimpleAggregatedMemoryContext(), 1, TempFileReader::handleException);
        }
        catch (IOException e) {
            throw TempFileReader.handleException(e);
        }
    }

    protected Page computeNext() {
        try {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedIOException();
            }
            SourcePage page = this.reader.nextPage();
            if (page == null) {
                return (Page)this.endOfData();
            }
            return page.getPage();
        }
        catch (IOException e) {
            throw TempFileReader.handleException(e);
        }
    }

    private static TrinoException handleException(Exception e) {
        return new TrinoException((ErrorCodeSupplier)HiveErrorCode.HIVE_WRITER_DATA_ERROR, "Failed to read temporary data", (Throwable)e);
    }
}

