/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Fail;
import org.assertj.core.util.CanIgnoreReturnValue;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.NoSuchKeyException;

public class S3Assert {
    private static final Pattern S3_LOCATION_PATTERN = Pattern.compile("s3://(?<bucket>[^/]+)/(?<key>.+)");
    private final S3Client s3;
    private final String bucket;
    private final String key;

    private S3Assert(S3Client s3, String path) {
        this.s3 = Objects.requireNonNull(s3, "s3 is null");
        Objects.requireNonNull(path, "path is null");
        Matcher matcher = S3_LOCATION_PATTERN.matcher(path);
        Preconditions.checkArgument((boolean)matcher.matches(), (String)"Invalid S3 location: %s", (Object)path);
        this.bucket = matcher.group("bucket");
        this.key = matcher.group("key");
    }

    public static AssertProvider<S3Assert> s3Path(S3Client s3, String path) {
        return () -> new S3Assert(s3, path);
    }

    @CanIgnoreReturnValue
    public S3Assert exists() {
        try {
            this.s3.headObject(request -> request.bucket(this.bucket).key(this.key));
        }
        catch (NoSuchKeyException noSuchKeyException) {
            Fail.fail((String)"Specified Object bucket=[%s] key=[%s] does not exist", (Object[])new Object[]{this.bucket, this.key});
        }
        return this;
    }
}

