/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ListMultimap;
import com.google.common.io.Resources;
import io.airlift.concurrent.Threads;
import io.airlift.slice.Slices;
import io.airlift.stats.CounterStat;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.trino.filesystem.FileEntry;
import io.trino.filesystem.FileIterator;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.filesystem.cache.CachingHostAddressProvider;
import io.trino.filesystem.cache.DefaultCachingHostAddressProvider;
import io.trino.filesystem.memory.MemoryFileSystemFactory;
import io.trino.metastore.Column;
import io.trino.metastore.HiveBucketProperty;
import io.trino.metastore.HivePartition;
import io.trino.metastore.HiveType;
import io.trino.metastore.StorageFormat;
import io.trino.metastore.Table;
import io.trino.plugin.hive.AcidInfo;
import io.trino.plugin.hive.BackgroundHiveSplitLoader;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HivePartitionMetadata;
import io.trino.plugin.hive.HiveSplit;
import io.trino.plugin.hive.HiveSplitLoader;
import io.trino.plugin.hive.HiveSplitSource;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTablePartitioning;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.HiveTimestampPrecision;
import io.trino.plugin.hive.InternalHiveSplit;
import io.trino.plugin.hive.TableType;
import io.trino.plugin.hive.fs.CachingDirectoryLister;
import io.trino.plugin.hive.fs.DirectoryLister;
import io.trino.plugin.hive.util.HiveBucketing;
import io.trino.plugin.hive.util.HiveUtil;
import io.trino.plugin.hive.util.InternalHiveSplitFactory;
import io.trino.plugin.hive.util.ValidWriteIdList;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.InternalTypeManager;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestBackgroundHiveSplitLoader {
    private static final int BUCKET_COUNT = 2;
    private static final Location LOCATION = Location.of((String)"memory:///db_name/table_name/000000_0");
    private static final Location FILTERED_LOCATION = Location.of((String)"memory:///db_name/table_name/000000_1");
    private static final TupleDomain<HiveColumnHandle> LOCATION_DOMAIN = TupleDomain.withColumnDomains(Map.of(HiveColumnHandle.pathColumnHandle(), Domain.singleValue((Type)VarcharType.VARCHAR, (Object)Slices.utf8Slice((String)LOCATION.toString()))));
    private static final List<Location> TEST_LOCATIONS = List.of(LOCATION, FILTERED_LOCATION);
    private static final List<Column> PARTITION_COLUMNS = List.of(new Column("partitionColumn", HiveType.HIVE_INT, Optional.empty(), Map.of()));
    private static final List<HiveColumnHandle> BUCKET_COLUMN_HANDLES = List.of(HiveColumnHandle.createBaseColumn((String)"col1", (int)0, (HiveType)HiveType.HIVE_INT, (Type)IntegerType.INTEGER, (HiveColumnHandle.ColumnType)HiveColumnHandle.ColumnType.REGULAR, Optional.empty()));
    private static final String TABLE_PATH = "memory:///db_name/table_name";
    private static final Table SIMPLE_TABLE = TestBackgroundHiveSplitLoader.table("memory:///db_name/table_name", List.of(), Optional.empty(), Map.of());
    private static final Table PARTITIONED_TABLE = TestBackgroundHiveSplitLoader.table("memory:///db_name/table_name", PARTITION_COLUMNS, Optional.of(new HiveBucketProperty(List.of("col1"), 2, List.of())), Map.of());
    private final ExecutorService executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)(this.getClass().getSimpleName() + "-%s")));

    @AfterAll
    public void tearDown() {
        this.executor.shutdownNow();
    }

    @Test
    public void testNoPathFilter() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_LOCATIONS, (TupleDomain<HiveColumnHandle>)TupleDomain.none());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drain(hiveSplitSource)).hasSize(2);
    }

    @Test
    public void testCsv() throws Exception {
        FileEntry file = new FileEntry(LOCATION, DataSize.of((long)2L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes(), Instant.now(), Optional.empty());
        this.assertCsvSplitCount(file, Map.of(), 33);
        this.assertCsvSplitCount(file, Map.of("skip.header.line.count", "1"), 33);
        this.assertCsvSplitCount(file, Map.of("skip.header.line.count", "2"), 1);
        this.assertCsvSplitCount(file, Map.of("skip.footer.line.count", "1"), 1);
        this.assertCsvSplitCount(file, Map.of("skip.header.line.count", "1", "skip.footer.line.count", "1"), 1);
    }

    private void assertCsvSplitCount(FileEntry file, Map<String, String> tableProperties, int expectedSplitCount) throws Exception {
        Table table = TestBackgroundHiveSplitLoader.table(TABLE_PATH, List.of(), Optional.empty(), Map.copyOf(tableProperties), HiveStorageFormat.CSV.toStorageFormat());
        ListSingleFileFileSystemFactory fileSystemFactory = new ListSingleFileFileSystemFactory(file);
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(fileSystemFactory, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.empty());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).hasSize(expectedSplitCount);
    }

    @Test
    public void testPathFilter() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_LOCATIONS, LOCATION_DOMAIN);
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assertions.assertThat(paths).hasSize(1);
        Assertions.assertThat((String)paths.get(0)).isEqualTo(LOCATION.toString());
    }

    @Test
    public void testPathFilterOneBucketMatchPartitionedTable() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_LOCATIONS, LOCATION_DOMAIN, Optional.of(new HiveBucketing.HiveBucketFilter(Set.of(Integer.valueOf(0), Integer.valueOf(1)))), PARTITIONED_TABLE, Optional.of(new HiveTablePartitioning(true, HiveBucketing.BucketingVersion.BUCKETING_V1, 2, BUCKET_COLUMN_HANDLES, false, List.of(), true)));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assertions.assertThat(paths).hasSize(1);
        Assertions.assertThat((String)paths.get(0)).isEqualTo(LOCATION.toString());
    }

    @Test
    public void testPathFilterBucketedPartitionedTable() throws Exception {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_LOCATIONS, LOCATION_DOMAIN, Optional.empty(), PARTITIONED_TABLE, Optional.of(new HiveTablePartitioning(true, HiveBucketing.BucketingVersion.BUCKETING_V1, 2, HiveUtil.getRegularColumnHandles((Table)PARTITIONED_TABLE, (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, (HiveTimestampPrecision)HiveTimestampPrecision.DEFAULT_PRECISION), false, List.of(), true)));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> paths = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assertions.assertThat(paths).hasSize(1);
        Assertions.assertThat((String)paths.get(0)).isEqualTo(LOCATION.toString());
    }

    @Test
    public void testEmptyFileWithNoBlocks() throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test")).newOutputFile(LOCATION).create().close();
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((TrinoFileSystemFactory)fileSystemFactory, (TupleDomain<HiveColumnHandle>)TupleDomain.none(), Optional.empty(), SIMPLE_TABLE, Optional.empty(), Optional.empty());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<HiveSplit> splits = TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
        Assertions.assertThat(splits).isEmpty();
    }

    @Test
    public void testNoHangIfPartitionIsOffline() throws IOException {
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoaderOfflinePartitions();
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drain(hiveSplitSource)).isInstanceOf(TrinoException.class)).hasMessage("OFFLINE");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((HiveSplitSource)hiveSplitSource).isFinished()).isInstanceOf(TrinoException.class)).hasMessage("OFFLINE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=30L)
    public void testIncompleteDynamicFilterTimeout() throws Exception {
        final CompletableFuture<Object> isBlocked = new CompletableFuture<Object>();
        try {
            BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(new DynamicFilter(){

                public Set<ColumnHandle> getColumnsCovered() {
                    return Set.of();
                }

                public CompletableFuture<?> isBlocked() {
                    return isBlocked;
                }

                public boolean isComplete() {
                    return false;
                }

                public boolean isAwaitable() {
                    return true;
                }

                public TupleDomain<ColumnHandle> getCurrentPredicate() {
                    return TupleDomain.all();
                }
            }, new Duration(1.0, TimeUnit.SECONDS));
            HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
            backgroundHiveSplitLoader.start(hiveSplitSource);
            Assertions.assertThat(TestBackgroundHiveSplitLoader.drain(hiveSplitSource)).hasSize(2);
            Assertions.assertThat((boolean)hiveSplitSource.isFinished()).isTrue();
        }
        finally {
            isBlocked.complete(null);
        }
    }

    @Test
    public void testCachedDirectoryLister() throws Exception {
        CachingDirectoryLister cachingDirectoryLister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE), List.of("test_dbname.test_table"), List.of(), (Predicate)Predicates.alwaysTrue());
        Assertions.assertThat((long)cachingDirectoryLister.getRequestCount()).isEqualTo(0L);
        int totalCount = 100;
        CountDownLatch firstVisit = new CountDownLatch(1);
        ArrayList<Future<List>> futures = new ArrayList<Future<List>>();
        futures.add(this.executor.submit(() -> {
            BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_LOCATIONS, (DirectoryLister)cachingDirectoryLister);
            HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
            backgroundHiveSplitLoader.start(hiveSplitSource);
            try {
                List<HiveSplit> list = TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
                return list;
            }
            finally {
                firstVisit.countDown();
            }
        }));
        for (int i = 0; i < totalCount - 1; ++i) {
            futures.add(this.executor.submit(() -> {
                firstVisit.await();
                BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(TEST_LOCATIONS, (DirectoryLister)cachingDirectoryLister);
                HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
                backgroundHiveSplitLoader.start(hiveSplitSource);
                return TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource);
            }));
        }
        for (Future future : futures) {
            Assertions.assertThat((List)((List)future.get())).hasSize(TEST_LOCATIONS.size());
        }
        Assertions.assertThat((long)cachingDirectoryLister.getRequestCount()).isEqualTo((long)totalCount);
        Assertions.assertThat((long)cachingDirectoryLister.getHitCount()).isEqualTo((long)(totalCount - 1));
        Assertions.assertThat((long)cachingDirectoryLister.getMissCount()).isEqualTo(1L);
    }

    @Test
    public void testGetBucketNumber() {
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"20190526_072952_00009_fn7s5_bucket-00234")).isEqualTo((Object)OptionalInt.of(234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"20190526_072952_00009_fn7s5_bucket-00234.txt")).isEqualTo((Object)OptionalInt.of(234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"20190526_235847_87654_fn7s5_bucket-56789")).isEqualTo((Object)OptionalInt.of(56789));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_0")).isEqualTo((Object)OptionalInt.of(234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"000234_0")).isEqualTo((Object)OptionalInt.of(234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_99")).isEqualTo((Object)OptionalInt.of(234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_0.txt")).isEqualTo((Object)OptionalInt.of(234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"0234_0_copy_1")).isEqualTo((Object)OptionalInt.of(234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"234_99")).isEqualTo((Object)OptionalInt.of(234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"1234_0_copy_1")).isEqualTo((Object)OptionalInt.of(1234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"bucket_1234")).isEqualTo((Object)OptionalInt.of(1234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"bucket_01234")).isEqualTo((Object)OptionalInt.of(1234));
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"0234.txt")).isEqualTo((Object)OptionalInt.empty());
        Assertions.assertThat((OptionalInt)BackgroundHiveSplitLoader.getBucketNumber((String)"0234.txt")).isEqualTo((Object)OptionalInt.empty());
    }

    @Test
    public void testGetAttemptId() {
        Assertions.assertThat((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000")).isFalse();
        Assertions.assertThat((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_0")).isTrue();
        Assertions.assertThat((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_10")).isTrue();
        Assertions.assertThat((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_1000")).isTrue();
        Assertions.assertThat((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000__1000")).isFalse();
        Assertions.assertThat((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_a")).isFalse();
        Assertions.assertThat((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"bucket_00000_ad")).isFalse();
        Assertions.assertThat((boolean)BackgroundHiveSplitLoader.hasAttemptId((String)"base_00000_00")).isFalse();
    }

    @Test
    @Timeout(value=60L)
    public void testPropagateException() throws IOException {
        this.testPropagateException(false, 1);
        this.testPropagateException(true, 1);
        this.testPropagateException(false, 2);
        this.testPropagateException(true, 2);
        this.testPropagateException(false, 4);
        this.testPropagateException(true, 4);
    }

    private void testPropagateException(final boolean error, int threads) throws IOException {
        final AtomicBoolean iteratorUsedAfterException = new AtomicBoolean();
        TrinoFileSystemFactory fileSystemFactory = TestBackgroundHiveSplitLoader.createTestingFileSystem(TEST_LOCATIONS);
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = new BackgroundHiveSplitLoader(SIMPLE_TABLE, (Iterator)new Iterator<HivePartitionMetadata>(this){
            private boolean threw;

            @Override
            public boolean hasNext() {
                iteratorUsedAfterException.compareAndSet(false, this.threw);
                return !this.threw;
            }

            @Override
            public HivePartitionMetadata next() {
                iteratorUsedAfterException.compareAndSet(false, this.threw);
                this.threw = true;
                if (error) {
                    throw new Error("loading error occurred");
                }
                throw new RuntimeException("loading error occurred");
            }
        }, TupleDomain.all(), DynamicFilter.EMPTY, new Duration(0.0, TimeUnit.SECONDS), InternalTypeManager.TESTING_TYPE_MANAGER, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(Optional.empty(), Optional.empty()), HiveTestUtils.SESSION, fileSystemFactory, (DirectoryLister)new CachingDirectoryLister(new HiveConfig()), (Executor)this.executor, threads, false, false, Optional.empty(), Optional.empty(), 100);
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drain(hiveSplitSource)).hasMessageEndingWith("loading error occurred");
        Assertions.assertThatThrownBy(() -> ((HiveSplitSource)hiveSplitSource).isFinished()).hasMessageEndingWith("loading error occurred");
        if (threads == 1) {
            Assertions.assertThat((boolean)iteratorUsedAfterException.get()).isFalse();
        }
    }

    @Test
    public void testMultipleSplitsPerBucket() throws Exception {
        ListSingleFileFileSystemFactory fileSystemFactory = new ListSingleFileFileSystemFactory(new FileEntry(LOCATION, DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE).toBytes(), Instant.now(), Optional.empty()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(fileSystemFactory, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), SIMPLE_TABLE, Optional.of(new HiveTablePartitioning(true, HiveBucketing.BucketingVersion.BUCKETING_V1, 2, BUCKET_COLUMN_HANDLES, false, List.of(), true)), Optional.empty());
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).hasSize(17);
    }

    @Test
    public void testSplitsGenerationWithAbortedTransactions() throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        TrinoFileSystem fileSystem = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test"));
        Location tableLocation = Location.of((String)"memory:///my_table");
        Table table = TestBackgroundHiveSplitLoader.table(tableLocation.toString(), List.of(), Optional.empty(), Map.of("transactional", "true", "transactional_properties", "insert_only"));
        List<Location> fileLocations = List.of(tableLocation.appendPath("delta_0000001_0000001_0000/_orc_acid_version"), tableLocation.appendPath("delta_0000001_0000001_0000/bucket_00000"), tableLocation.appendPath("delta_0000002_0000002_0000/_orc_acid_version"), tableLocation.appendPath("delta_0000002_0000002_0000/bucket_00000"), tableLocation.appendPath("delta_0000003_0000003_0000/_orc_acid_version"), tableLocation.appendPath("delta_0000003_0000003_0000/bucket_00000"));
        for (Location fileLocation : fileLocations) {
            TestBackgroundHiveSplitLoader.createOrcAcidFile(fileSystem, fileLocation);
        }
        String validWriteIdsList = String.format("4$%s.%s:3:9223372036854775807::2", table.getDatabaseName(), table.getTableName());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((TrinoFileSystemFactory)fileSystemFactory, (TupleDomain<HiveColumnHandle>)TupleDomain.none(), Optional.empty(), table, Optional.empty(), Optional.of(new ValidWriteIdList(validWriteIdsList)));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> splits = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assertions.assertThat(splits).contains((Object[])new String[]{fileLocations.get(1).toString()});
        Assertions.assertThat(splits).contains((Object[])new String[]{fileLocations.get(5).toString()});
    }

    @Test
    public void testFullAcidTableWithOriginalFiles() throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        TrinoFileSystem fileSystem = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test"));
        Location tableLocation = Location.of((String)"memory:///my_table");
        Table table = TestBackgroundHiveSplitLoader.table(tableLocation.toString(), List.of(), Optional.empty(), Map.of("transactional", "true"));
        Location originalFile = tableLocation.appendPath("000000_1");
        try (OutputStream outputStream = fileSystem.newOutputFile(originalFile).create();){
            outputStream.write("test".getBytes(StandardCharsets.UTF_8));
        }
        List<Location> fileLocations = List.of(tableLocation.appendPath("delta_0000002_0000002_0000/_orc_acid_version"), tableLocation.appendPath("delta_0000002_0000002_0000/bucket_00000"));
        for (Location fileLocation : fileLocations) {
            TestBackgroundHiveSplitLoader.createOrcAcidFile(fileSystem, fileLocation);
        }
        ValidWriteIdList validWriteIdsList = new ValidWriteIdList(String.format("4$%s.%s:3:9223372036854775807::", table.getDatabaseName(), table.getTableName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((TrinoFileSystemFactory)fileSystemFactory, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.of(validWriteIdsList));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        List<String> splits = TestBackgroundHiveSplitLoader.drain(hiveSplitSource);
        Assertions.assertThat(splits).contains((Object[])new String[]{originalFile.toString()});
        Assertions.assertThat(splits).contains((Object[])new String[]{fileLocations.get(1).toString()});
    }

    @Test
    public void testVersionValidationNoOrcAcidVersionFile() throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        TrinoFileSystem fileSystem = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test"));
        Location tableLocation = Location.of((String)"memory:///my_table");
        Table table = TestBackgroundHiveSplitLoader.table(tableLocation.toString(), List.of(), Optional.empty(), Map.of("transactional", "true"));
        List<Location> fileLocations = List.of(tableLocation.appendPath("000000_1"), tableLocation.appendPath("delta_0000002_0000002_0000/bucket_00000"));
        for (Location fileLocation : fileLocations) {
            TestBackgroundHiveSplitLoader.createOrcAcidFile(fileSystem, fileLocation);
        }
        ValidWriteIdList validWriteIdsList = new ValidWriteIdList(String.format("4$%s.%s:3:9223372036854775807::", table.getDatabaseName(), table.getTableName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((TrinoFileSystemFactory)fileSystemFactory, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.of(validWriteIdsList));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        ((AbstractListAssert)Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).extracting(HiveSplit::getAcidInfo).allMatch(Optional::isPresent)).extracting(Optional::get).noneMatch(AcidInfo::isOrcAcidVersionValidated);
    }

    @Test
    public void testVersionValidationOrcAcidVersionFileHasVersion2() throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        TrinoFileSystem fileSystem = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test"));
        Location tableLocation = Location.of((String)"memory:///my_table");
        Table table = TestBackgroundHiveSplitLoader.table(tableLocation.toString(), List.of(), Optional.empty(), Map.of("transactional", "true"));
        List<Location> fileLocations = List.of(tableLocation.appendPath("000000_1"), tableLocation.appendPath("delta_0000002_0000002_0000/_orc_acid_version"), tableLocation.appendPath("delta_0000002_0000002_0000/bucket_00000"));
        for (Location fileLocation : fileLocations) {
            TestBackgroundHiveSplitLoader.createOrcAcidFile(fileSystem, fileLocation, 2);
        }
        ValidWriteIdList validWriteIdsList = new ValidWriteIdList(String.format("4$%s.%s:3:9223372036854775807::", table.getDatabaseName(), table.getTableName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((TrinoFileSystemFactory)fileSystemFactory, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.of(validWriteIdsList));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).extracting(HiveSplit::getAcidInfo).allMatch(acidInfo -> acidInfo.isEmpty() || ((AcidInfo)acidInfo.get()).isOrcAcidVersionValidated());
    }

    @Test
    public void testVersionValidationOrcAcidVersionFileHasVersion1() throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        TrinoFileSystem fileSystem = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test"));
        Location tableLocation = Location.of((String)"memory:///my_table");
        Table table = TestBackgroundHiveSplitLoader.table(tableLocation.toString(), List.of(), Optional.empty(), Map.of("transactional", "true"));
        List<Location> fileLocations = List.of(tableLocation.appendPath("000000_1"), tableLocation.appendPath("delta_0000002_0000002_0000/_orc_acid_version"), tableLocation.appendPath("delta_0000002_0000002_0000/bucket_00000"));
        for (Location fileLocation : fileLocations) {
            TestBackgroundHiveSplitLoader.createOrcAcidFile(fileSystem, fileLocation, 1);
        }
        ValidWriteIdList validWriteIdsList = new ValidWriteIdList(String.format("4$%s.%s:3:9223372036854775807::", table.getDatabaseName(), table.getTableName()));
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader((TrinoFileSystemFactory)fileSystemFactory, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), Optional.empty(), table, Optional.empty(), Optional.of(validWriteIdsList));
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        ((AbstractListAssert)Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).extracting(HiveSplit::getAcidInfo).allMatch(Optional::isPresent)).extracting(Optional::get).noneMatch(AcidInfo::isOrcAcidVersionValidated);
    }

    @Test
    public void testValidateFileBuckets() {
        ArrayListMultimap bucketFiles = ArrayListMultimap.create();
        bucketFiles.put((Object)1, null);
        bucketFiles.put((Object)3, null);
        bucketFiles.put((Object)4, null);
        bucketFiles.put((Object)6, null);
        bucketFiles.put((Object)9, null);
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestBackgroundHiveSplitLoader.lambda$testValidateFileBuckets$0((ListMultimap)bucketFiles)).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_INVALID_BUCKET_FILES}).hasMessage("Hive table 'tableName' is corrupt. The highest bucket number in the directory (9) exceeds the bucket number range defined by the declared bucket count (1) for partition: partitionName");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestBackgroundHiveSplitLoader.lambda$testValidateFileBuckets$1((ListMultimap)bucketFiles)).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_INVALID_BUCKET_FILES}).hasMessage("Hive table 'tableName' is corrupt. The highest bucket number in the directory (9) exceeds the bucket number range defined by the declared bucket count (5) for partition: partitionName");
        TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> TestBackgroundHiveSplitLoader.lambda$testValidateFileBuckets$2((ListMultimap)bucketFiles)).hasErrorCode(new ErrorCodeSupplier[]{HiveErrorCode.HIVE_INVALID_BUCKET_FILES}).hasMessage("Hive table 'tableName' is corrupt. The highest bucket number in the directory (9) exceeds the bucket number range defined by the declared bucket count (9) for partition: partitionName");
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)10, (String)"tableName", (String)"partitionName");
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)20, (String)"tableName", (String)"partitionName");
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)30, (String)"tableName", (String)"partitionName");
    }

    @Test
    public void testBuildManifestFileIterator() throws IOException {
        CachingDirectoryLister directoryLister = new CachingDirectoryLister(new Duration(0.0, TimeUnit.MINUTES), DataSize.ofBytes((long)0L), List.of(), List.of(), (Predicate)Predicates.alwaysTrue());
        ImmutableMap schema = ImmutableMap.builder().put((Object)"file.inputformat", (Object)"org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat").put((Object)"serialization.lib", (Object)HiveStorageFormat.AVRO.getSerde()).buildOrThrow();
        Location firstFilePath = Location.of((String)"memory:///db_name/table_name/file1");
        Location secondFilePath = Location.of((String)"memory:///db_name/table_name/file2");
        List<Location> locations = List.of(firstFilePath, secondFilePath);
        InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory("partition", HiveStorageFormat.AVRO, (Map)schema, List.of(), TupleDomain.all(), () -> true, (Map)ImmutableMap.of(), Optional.empty(), Optional.empty(), DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.empty());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(locations, (DirectoryLister)directoryLister);
        Iterator splitIterator = backgroundHiveSplitLoader.buildManifestFileIterator(splitFactory, Location.of((String)TABLE_PATH), locations, true);
        ImmutableList splits = ImmutableList.copyOf((Iterator)splitIterator);
        Assertions.assertThat((List)splits).hasSize(2);
        Assertions.assertThat((String)((InternalHiveSplit)splits.get(0)).getPath()).isEqualTo(firstFilePath.toString());
        Assertions.assertThat((String)((InternalHiveSplit)splits.get(1)).getPath()).isEqualTo(secondFilePath.toString());
    }

    @Test
    public void testBuildManifestFileIteratorNestedDirectory() throws IOException {
        CachingDirectoryLister directoryLister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), DataSize.of((long)100L, (DataSize.Unit)DataSize.Unit.KILOBYTE), List.of(), List.of(), (Predicate)Predicates.alwaysTrue());
        ImmutableMap schema = ImmutableMap.builder().put((Object)"file.inputformat", (Object)"org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat").put((Object)"serialization.lib", (Object)HiveStorageFormat.AVRO.getSerde()).buildOrThrow();
        Location filePath = Location.of((String)"memory:///db_name/table_name/file1");
        Location directoryPath = Location.of((String)"memory:///db_name/table_name/dir/file2");
        List<Location> locations = List.of(filePath, directoryPath);
        InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory("partition", HiveStorageFormat.AVRO, (Map)schema, List.of(), TupleDomain.all(), () -> true, (Map)ImmutableMap.of(), Optional.empty(), Optional.empty(), DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.empty());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(locations, (DirectoryLister)directoryLister);
        Iterator splitIterator = backgroundHiveSplitLoader.buildManifestFileIterator(splitFactory, Location.of((String)TABLE_PATH), locations, false);
        ImmutableList splits = ImmutableList.copyOf((Iterator)splitIterator);
        Assertions.assertThat((List)splits).hasSize(2);
        Assertions.assertThat((String)((InternalHiveSplit)splits.get(0)).getPath()).isEqualTo(filePath.toString());
        Assertions.assertThat((String)((InternalHiveSplit)splits.get(1)).getPath()).isEqualTo(directoryPath.toString());
    }

    @Test
    public void testBuildManifestFileIteratorWithCacheInvalidation() throws IOException {
        CachingDirectoryLister directoryLister = new CachingDirectoryLister(new Duration(5.0, TimeUnit.MINUTES), DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE), List.of("*"), List.of("*"), (Predicate)Predicates.alwaysTrue());
        ImmutableMap schema = ImmutableMap.builder().put((Object)"file.inputformat", (Object)"org.apache.hadoop.hive.ql.io.SymlinkTextInputFormat").put((Object)"serialization.lib", (Object)HiveStorageFormat.AVRO.getSerde()).buildOrThrow();
        InternalHiveSplitFactory splitFactory = new InternalHiveSplitFactory("partition", HiveStorageFormat.AVRO, (Map)schema, List.of(), TupleDomain.all(), () -> true, (Map)ImmutableMap.of(), Optional.empty(), Optional.empty(), DataSize.of((long)512L, (DataSize.Unit)DataSize.Unit.MEGABYTE), false, Optional.empty());
        Location firstFilePath = Location.of((String)"memory:///db_name/table_name/file1");
        List<Location> locations1 = List.of(firstFilePath);
        BackgroundHiveSplitLoader backgroundHiveSplitLoader1 = this.backgroundHiveSplitLoader(locations1, (DirectoryLister)directoryLister);
        Iterator splitIterator1 = backgroundHiveSplitLoader1.buildManifestFileIterator(splitFactory, Location.of((String)TABLE_PATH), locations1, true);
        ImmutableList splits1 = ImmutableList.copyOf((Iterator)splitIterator1);
        Assertions.assertThat((List)splits1).hasSize(1);
        Assertions.assertThat((String)((InternalHiveSplit)splits1.get(0)).getPath()).isEqualTo(firstFilePath.toString());
        Location secondFilePath = Location.of((String)"memory:///db_name/table_name/file2");
        List<Location> locations2 = List.of(firstFilePath, secondFilePath);
        BackgroundHiveSplitLoader backgroundHiveSplitLoader2 = this.backgroundHiveSplitLoader(locations2, (DirectoryLister)directoryLister);
        Iterator splitIterator2 = backgroundHiveSplitLoader2.buildManifestFileIterator(splitFactory, Location.of((String)TABLE_PATH), locations2, true);
        ImmutableList splits2 = ImmutableList.copyOf((Iterator)splitIterator2);
        Assertions.assertThat((List)splits2).hasSize(2);
        Assertions.assertThat((String)((InternalHiveSplit)splits2.get(0)).getPath()).isEqualTo(firstFilePath.toString());
        Assertions.assertThat((String)((InternalHiveSplit)splits2.get(1)).getPath()).isEqualTo(secondFilePath.toString());
    }

    @Test
    public void testMaxPartitions() throws Exception {
        CachingDirectoryLister directoryLister = new CachingDirectoryLister(new Duration(0.0, TimeUnit.MINUTES), DataSize.ofBytes((long)0L), List.of(), List.of(), (Predicate)Predicates.alwaysTrue());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(List.of(), List.of(), (DirectoryLister)directoryLister, 0);
        HiveSplitSource hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).isEmpty();
        backgroundHiveSplitLoader = this.backgroundHiveSplitLoader(List.of(TestBackgroundHiveSplitLoader.createPartitionMetadata()), TEST_LOCATIONS, (DirectoryLister)directoryLister, 1);
        hiveSplitSource = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader);
        backgroundHiveSplitLoader.start(hiveSplitSource);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource)).hasSize(TEST_LOCATIONS.size());
        int partitionLimit = 0;
        BackgroundHiveSplitLoader backgroundHiveSplitLoader2 = this.backgroundHiveSplitLoader(List.of(TestBackgroundHiveSplitLoader.createPartitionMetadata()), TEST_LOCATIONS, (DirectoryLister)directoryLister, partitionLimit);
        HiveSplitSource hiveSplitSource2 = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader2);
        backgroundHiveSplitLoader2.start(hiveSplitSource2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource2)).isInstanceOf(TrinoException.class)).hasMessage(String.format("Query over table '%s' can potentially read more than %s partitions", SIMPLE_TABLE.getSchemaTableName(), partitionLimit));
        partitionLimit = 3;
        List<HivePartitionMetadata> partitions = List.of(TestBackgroundHiveSplitLoader.createPartitionMetadata(), TestBackgroundHiveSplitLoader.createPartitionMetadata(), TestBackgroundHiveSplitLoader.createPartitionMetadata());
        BackgroundHiveSplitLoader backgroundHiveSplitLoader3 = this.backgroundHiveSplitLoader(partitions, TEST_LOCATIONS, (DirectoryLister)directoryLister, partitionLimit);
        HiveSplitSource hiveSplitSource3 = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader3);
        backgroundHiveSplitLoader3.start(hiveSplitSource3);
        Assertions.assertThat(TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource3)).hasSize(TEST_LOCATIONS.size() * partitions.size());
        partitionLimit = 3;
        backgroundHiveSplitLoader2 = this.backgroundHiveSplitLoader(List.of(TestBackgroundHiveSplitLoader.createPartitionMetadata(), TestBackgroundHiveSplitLoader.createPartitionMetadata(), TestBackgroundHiveSplitLoader.createPartitionMetadata(), TestBackgroundHiveSplitLoader.createPartitionMetadata()), TEST_LOCATIONS, (DirectoryLister)directoryLister, partitionLimit);
        hiveSplitSource2 = this.hiveSplitSource((HiveSplitLoader)backgroundHiveSplitLoader2);
        backgroundHiveSplitLoader2.start(hiveSplitSource2);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestBackgroundHiveSplitLoader.drainSplits(hiveSplitSource2)).isInstanceOf(TrinoException.class)).hasMessage(String.format("Query over table '%s' can potentially read more than %s partitions", SIMPLE_TABLE.getSchemaTableName(), partitionLimit));
    }

    private static HivePartitionMetadata createPartitionMetadata() {
        return new HivePartitionMetadata(new HivePartition(SIMPLE_TABLE.getSchemaTableName()), Optional.empty(), (Map)ImmutableMap.of());
    }

    private static void createOrcAcidFile(TrinoFileSystem fileSystem, Location location) throws IOException {
        TestBackgroundHiveSplitLoader.createOrcAcidFile(fileSystem, location, 2);
    }

    private static void createOrcAcidFile(TrinoFileSystem fileSystem, Location location, int orcAcidVersion) throws IOException {
        try (OutputStream outputStream = fileSystem.newOutputFile(location).create();){
            if (location.fileName().equals("_orc_acid_version")) {
                outputStream.write(String.valueOf(orcAcidVersion).getBytes(StandardCharsets.UTF_8));
                return;
            }
            Resources.copy((URL)Resources.getResource((String)"fullacidNationTableWithOriginalFiles/000000_0"), (OutputStream)outputStream);
        }
    }

    private static List<String> drain(HiveSplitSource source) throws Exception {
        return TestBackgroundHiveSplitLoader.drainSplits(source).stream().map(HiveSplit::getPath).toList();
    }

    private static List<HiveSplit> drainSplits(HiveSplitSource source) throws Exception {
        ImmutableList.Builder splits = ImmutableList.builder();
        while (!source.isFinished()) {
            ConnectorSplitSource.ConnectorSplitBatch batch;
            try {
                batch = (ConnectorSplitSource.ConnectorSplitBatch)source.getNextBatch(100).get();
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked((Throwable)e.getCause());
                throw e;
            }
            batch.getSplits().stream().map(HiveSplit.class::cast).forEach(arg_0 -> ((ImmutableList.Builder)splits).add(arg_0));
        }
        return splits.build();
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(DynamicFilter dynamicFilter, Duration dynamicFilteringProbeBlockingTimeoutMillis) throws IOException {
        TrinoFileSystemFactory fileSystemFactory = TestBackgroundHiveSplitLoader.createTestingFileSystem(TEST_LOCATIONS);
        return this.backgroundHiveSplitLoader(fileSystemFactory, (TupleDomain<HiveColumnHandle>)TupleDomain.all(), dynamicFilter, dynamicFilteringProbeBlockingTimeoutMillis, Optional.empty(), SIMPLE_TABLE, Optional.empty(), Optional.empty());
    }

    private static TrinoFileSystemFactory createTestingFileSystem(Collection<Location> locations) throws IOException {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        TrinoFileSystem fileSystem = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test"));
        for (Location location : locations) {
            OutputStream outputStream = fileSystem.newOutputFile(location).create();
            try {
                outputStream.write(new byte[10]);
            }
            finally {
                if (outputStream == null) continue;
                outputStream.close();
            }
        }
        return fileSystemFactory;
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<Location> locations, TupleDomain<HiveColumnHandle> tupleDomain) throws IOException {
        return this.backgroundHiveSplitLoader(locations, tupleDomain, Optional.empty(), SIMPLE_TABLE, Optional.empty());
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<Location> locations, TupleDomain<HiveColumnHandle> compactEffectivePredicate, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveTablePartitioning> tablePartitioning) throws IOException {
        return this.backgroundHiveSplitLoader(locations, compactEffectivePredicate, hiveBucketFilter, table, tablePartitioning, Optional.empty());
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<Location> locations, TupleDomain<HiveColumnHandle> compactEffectivePredicate, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveTablePartitioning> tablePartitioning, Optional<ValidWriteIdList> validWriteIds) throws IOException {
        TrinoFileSystemFactory fileSystemFactory = TestBackgroundHiveSplitLoader.createTestingFileSystem(locations);
        return this.backgroundHiveSplitLoader(fileSystemFactory, compactEffectivePredicate, hiveBucketFilter, table, tablePartitioning, validWriteIds);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(TrinoFileSystemFactory fileSystemFactory, TupleDomain<HiveColumnHandle> compactEffectivePredicate, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveTablePartitioning> tablePartitioning, Optional<ValidWriteIdList> validWriteIds) {
        return this.backgroundHiveSplitLoader(fileSystemFactory, compactEffectivePredicate, DynamicFilter.EMPTY, new Duration(0.0, TimeUnit.SECONDS), hiveBucketFilter, table, tablePartitioning, validWriteIds);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(TrinoFileSystemFactory fileSystemFactory, TupleDomain<HiveColumnHandle> compactEffectivePredicate, DynamicFilter dynamicFilter, Duration dynamicFilteringProbeBlockingTimeout, Optional<HiveBucketing.HiveBucketFilter> hiveBucketFilter, Table table, Optional<HiveTablePartitioning> tablePartitioning, Optional<ValidWriteIdList> validWriteIds) {
        List<HivePartitionMetadata> hivePartitionMetadatas = List.of(new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), (Map)ImmutableMap.of()));
        return new BackgroundHiveSplitLoader(table, hivePartitionMetadatas.iterator(), compactEffectivePredicate, dynamicFilter, dynamicFilteringProbeBlockingTimeout, InternalTypeManager.TESTING_TYPE_MANAGER, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(tablePartitioning, hiveBucketFilter), HiveTestUtils.SESSION, fileSystemFactory, (DirectoryLister)new CachingDirectoryLister(new HiveConfig()), (Executor)this.executor, 2, false, false, validWriteIds, Optional.empty(), 100);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<Location> locations, DirectoryLister directoryLister) throws IOException {
        List<HivePartitionMetadata> partitions = List.of(new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), (Map)ImmutableMap.of()));
        return this.backgroundHiveSplitLoader(partitions, locations, directoryLister, 100);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoader(List<HivePartitionMetadata> partitions, List<Location> locations, DirectoryLister directoryLister, int maxPartitions) throws IOException {
        ConnectorSession connectorSession = HiveTestUtils.getHiveSession(new HiveConfig().setMaxSplitSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
        TrinoFileSystemFactory fileSystemFactory = TestBackgroundHiveSplitLoader.createTestingFileSystem(locations);
        return new BackgroundHiveSplitLoader(SIMPLE_TABLE, partitions.iterator(), TupleDomain.none(), DynamicFilter.EMPTY, new Duration(0.0, TimeUnit.SECONDS), InternalTypeManager.TESTING_TYPE_MANAGER, Optional.empty(), connectorSession, fileSystemFactory, directoryLister, (Executor)this.executor, 2, false, false, Optional.empty(), Optional.empty(), maxPartitions);
    }

    private BackgroundHiveSplitLoader backgroundHiveSplitLoaderOfflinePartitions() throws IOException {
        ConnectorSession connectorSession = HiveTestUtils.getHiveSession(new HiveConfig().setMaxSplitSize(DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.GIGABYTE)));
        TrinoFileSystemFactory fileSystemFactory = TestBackgroundHiveSplitLoader.createTestingFileSystem(TEST_LOCATIONS);
        return new BackgroundHiveSplitLoader(SIMPLE_TABLE, TestBackgroundHiveSplitLoader.createPartitionMetadataWithOfflinePartitions(), TupleDomain.all(), DynamicFilter.EMPTY, new Duration(0.0, TimeUnit.SECONDS), InternalTypeManager.TESTING_TYPE_MANAGER, BackgroundHiveSplitLoader.BucketSplitInfo.createBucketSplitInfo(Optional.empty(), Optional.empty()), connectorSession, fileSystemFactory, (DirectoryLister)new CachingDirectoryLister(new HiveConfig()), (Executor)this.executor, 2, false, false, Optional.empty(), Optional.empty(), 100);
    }

    private static Iterator<HivePartitionMetadata> createPartitionMetadataWithOfflinePartitions() throws RuntimeException {
        return new AbstractIterator<HivePartitionMetadata>(){
            private int position = -1;

            protected HivePartitionMetadata computeNext() {
                ++this.position;
                return switch (this.position) {
                    case 0 -> new HivePartitionMetadata(new HivePartition(new SchemaTableName("testSchema", "table_name")), Optional.empty(), (Map)ImmutableMap.of());
                    case 1 -> throw new RuntimeException("OFFLINE");
                    default -> (HivePartitionMetadata)this.endOfData();
                };
            }
        };
    }

    private HiveSplitSource hiveSplitSource(HiveSplitLoader hiveSplitLoader) {
        return HiveSplitSource.allAtOnce((ConnectorSession)HiveTestUtils.SESSION, (String)SIMPLE_TABLE.getDatabaseName(), (String)SIMPLE_TABLE.getTableName(), (int)1, (int)1, (DataSize)DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE), (int)Integer.MAX_VALUE, (HiveSplitLoader)hiveSplitLoader, (Executor)this.executor, (CounterStat)new CounterStat(), (CachingHostAddressProvider)new DefaultCachingHostAddressProvider(), (boolean)false);
    }

    private static Table table(String location, List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, Map<String, String> tableParameters) {
        return TestBackgroundHiveSplitLoader.table(location, partitionColumns, bucketProperty, tableParameters, HiveStorageFormat.ORC.toStorageFormat());
    }

    private static Table table(String location, List<Column> partitionColumns, Optional<HiveBucketProperty> bucketProperty, Map<String, String> tableParameters, StorageFormat storageFormat) {
        Table.Builder tableBuilder = Table.builder();
        tableBuilder.getStorageBuilder().setStorageFormat(storageFormat).setLocation(location).setSkewed(false).setBucketProperty(bucketProperty);
        return tableBuilder.setDatabaseName("test_dbname").setOwner(Optional.of("testOwner")).setTableName("test_table").setTableType(TableType.MANAGED_TABLE.name()).setDataColumns(List.of(new Column("col1", HiveType.HIVE_STRING, Optional.empty(), Map.of()))).setParameters(tableParameters).setPartitionColumns(partitionColumns).build();
    }

    private static /* synthetic */ void lambda$testValidateFileBuckets$2(ListMultimap bucketFiles) throws Throwable {
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)9, (String)"tableName", (String)"partitionName");
    }

    private static /* synthetic */ void lambda$testValidateFileBuckets$1(ListMultimap bucketFiles) throws Throwable {
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)5, (String)"tableName", (String)"partitionName");
    }

    private static /* synthetic */ void lambda$testValidateFileBuckets$0(ListMultimap bucketFiles) throws Throwable {
        BackgroundHiveSplitLoader.validateFileBuckets((ListMultimap)bucketFiles, (int)1, (String)"tableName", (String)"partitionName");
    }

    private record ListSingleFileFileSystemFactory(FileEntry fileEntry) implements TrinoFileSystemFactory
    {
        public TrinoFileSystem create(ConnectorIdentity identity) {
            return new TrinoFileSystem(){

                public Optional<Boolean> directoryExists(Location location) {
                    return Optional.empty();
                }

                public FileIterator listFiles(Location location) {
                    final Iterator<FileEntry> iterator = List.of(fileEntry).iterator();
                    return new FileIterator(){

                        public boolean hasNext() {
                            return iterator.hasNext();
                        }

                        public FileEntry next() {
                            return (FileEntry)iterator.next();
                        }
                    };
                }

                public TrinoInputFile newInputFile(Location location) {
                    throw new UnsupportedOperationException();
                }

                public TrinoInputFile newInputFile(Location location, long length) {
                    throw new UnsupportedOperationException();
                }

                public TrinoInputFile newInputFile(Location location, long length, Instant lastModified) {
                    throw new UnsupportedOperationException();
                }

                public TrinoOutputFile newOutputFile(Location location) {
                    throw new UnsupportedOperationException();
                }

                public void deleteFile(Location location) {
                    throw new UnsupportedOperationException();
                }

                public void deleteDirectory(Location location) {
                    throw new UnsupportedOperationException();
                }

                public void renameFile(Location source, Location target) {
                    throw new UnsupportedOperationException();
                }

                public void createDirectory(Location location) {
                    throw new UnsupportedOperationException();
                }

                public void renameDirectory(Location source, Location target) {
                    throw new UnsupportedOperationException();
                }

                public Set<Location> listDirectories(Location location) {
                    throw new UnsupportedOperationException();
                }

                public Optional<Location> createTemporaryDirectory(Location targetPath, String temporaryPrefix, String relativePrefix) {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }
}

