/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.trino.filesystem.tracing.CacheFileSystemTraceUtils;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.DistributedQueryRunner;
import io.trino.testing.MultisetAssertions;
import io.trino.testing.QueryRunner;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.SAME_THREAD)
public class TestHiveAlluxioCacheFileOperations
extends AbstractTestQueryFramework {
    private static final Pattern DATA_FILE_PATTERN = Pattern.compile(".*?/(?<partition>key=[^/]*/)?(?<queryId>\\d{8}_\\d{6}_\\d{5}_\\w{5})_(?<uuid>[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12})");

    protected DistributedQueryRunner createQueryRunner() throws Exception {
        Path cacheDirectory = Files.createTempDirectory("cache", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)cacheDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        Path metastoreDirectory = Files.createTempDirectory("hive", new FileAttribute[0]);
        this.closeAfterClass(() -> MoreFiles.deleteRecursively((Path)metastoreDirectory, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE}));
        ImmutableMap hiveProperties = ImmutableMap.builder().put((Object)"fs.cache.enabled", (Object)"true").put((Object)"fs.cache.directories", (Object)cacheDirectory.toAbsolutePath().toString()).put((Object)"fs.cache.max-sizes", (Object)"100MB").put((Object)"hive.metastore", (Object)"file").put((Object)"hive.metastore.catalog.dir", (Object)metastoreDirectory.toUri().toString()).buildOrThrow();
        return ((HiveQueryRunner.Builder)((HiveQueryRunner.Builder)HiveQueryRunner.builder().setCoordinatorProperties((Map)ImmutableMap.of((Object)"node-scheduler.include-coordinator", (Object)"false"))).setHiveProperties((Map<String, String>)hiveProperties).setWorkerCount(1)).build();
    }

    @Test
    public void testCacheFileOperations() {
        this.assertUpdate("DROP TABLE IF EXISTS test_cache_file_operations");
        this.assertUpdate("CREATE TABLE test_cache_file_operations(data varchar, key varchar) WITH (partitioned_by=ARRAY['key'], format='parquet')");
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('1-abc', 'p1')", 1L);
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('2-xyz', 'p2')", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p1/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p2/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p1/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p2/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p1/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p2/")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p1/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p2/")).build());
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('3-xyz', 'p3')", 1L);
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('4-xyz', 'p4')", 1L);
        this.assertUpdate("INSERT INTO test_cache_file_operations VALUES ('5-xyz', 'p5')", 1L);
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p1/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p2/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p3/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p4/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p5/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p3/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p4/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Input.readFully", "key=p5/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p3/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p4/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.writeCache", "key=p5/")).build());
        this.assertFileSystemAccesses("SELECT * FROM test_cache_file_operations", (Multiset<CacheFileSystemTraceUtils.CacheOperation>)ImmutableMultiset.builder().add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p1/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p2/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p3/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p4/")).add((Object)new CacheFileSystemTraceUtils.CacheOperation("Alluxio.readCached", "key=p5/")).build());
    }

    private void assertFileSystemAccesses(@Language(value="SQL") String query, Multiset<CacheFileSystemTraceUtils.CacheOperation> expectedCacheAccesses) {
        DistributedQueryRunner queryRunner = this.getDistributedQueryRunner();
        queryRunner.executeWithPlan(queryRunner.getDefaultSession(), query);
        MultisetAssertions.assertMultisetsEqual(this.getCacheOperations(), expectedCacheAccesses);
    }

    private Multiset<CacheFileSystemTraceUtils.CacheOperation> getCacheOperations() {
        return (Multiset)CacheFileSystemTraceUtils.getCacheOperationSpans((QueryRunner)this.getQueryRunner()).stream().map(TestHiveAlluxioCacheFileOperations::createCacheOperation).collect(Collectors.toCollection(HashMultiset::create));
    }

    private static CacheFileSystemTraceUtils.CacheOperation createCacheOperation(SpanData span) {
        String operationName = span.getName();
        String path = CacheFileSystemTraceUtils.getFileLocation((SpanData)span);
        String fileName = path.replaceFirst(".*/", "");
        if (!path.contains("/.trino")) {
            Matcher matcher = DATA_FILE_PATTERN.matcher(path);
            if (matcher.matches()) {
                return new CacheFileSystemTraceUtils.CacheOperation(operationName, matcher.group("partition"));
            }
        } else {
            return new CacheFileSystemTraceUtils.CacheOperation(operationName, fileName);
        }
        throw new IllegalArgumentException("File not recognized: " + path);
    }
}

