/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.airlift.units.Duration;
import io.trino.plugin.hive.containers.Hive3MinioDataLake;
import io.trino.plugin.hive.s3.S3HiveQueryRunner;
import io.trino.sql.query.QueryAssertions;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import io.trino.testing.assertions.TrinoExceptionAssert;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.Test;

public class TestHiveAnalyzeCorruptStatistics
extends AbstractTestQueryFramework {
    private Hive3MinioDataLake hiveMinioDataLake;

    protected QueryRunner createQueryRunner() throws Exception {
        this.hiveMinioDataLake = (Hive3MinioDataLake)this.closeAfterClass(new Hive3MinioDataLake("test-analyze"));
        this.hiveMinioDataLake.start();
        return S3HiveQueryRunner.builder(this.hiveMinioDataLake).setThriftMetastoreTimeout(new Duration(5.0, TimeUnit.MINUTES)).build();
    }

    @Test
    public void testAnalyzeCorruptColumnStatisticsOnEmptyTable() {
        String tableName = "test_analyze_corrupt_column_statistics_" + TestingNames.randomNameSuffix();
        this.prepareBrokenColumnStatisticsTable(tableName);
        this.assertQuerySucceeds("SHOW STATS FOR " + tableName);
        ((TrinoExceptionAssert)((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("ANALYZE " + tableName))).failure().hasMessage("Unexpected 2 statistics for 1 columns")).hasStackTraceContaining("ThriftHiveMetastore.setTableColumnStatistics");
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CALL system.drop_stats('tpch', '" + tableName + "')"))).failure().hasMessageContaining("The query returned more than one instance BUT either unique is set to true or only aggregates are to be returned, so should have returned one result maximum");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private void prepareBrokenColumnStatisticsTable(String tableName) {
        this.assertUpdate("CREATE TABLE " + tableName + " AS SELECT 1 col", 1L);
        Assertions.assertThat((String)this.onMetastore("SELECT COUNT(1) FROM TAB_COL_STATS WHERE db_name = 'tpch' AND table_name = '" + tableName + "'")).isEqualTo("1");
        this.onMetastore("INSERT INTO TAB_COL_STATS\nSELECT\n  cs_id + 1,\n  cat_name,\n  db_name,\n  table_name,\n  column_name,\n  column_type,\n  tbl_id,\n  long_low_value,\n  long_high_value,\n  double_high_value,\n  double_low_value,\n  big_decimal_low_value,\n  big_decimal_high_value,\n  num_nulls,\n  num_distincts,\n  bit_vector,\n  avg_col_len,\n  max_col_len,\n  num_trues,\n  num_falses,\n  last_analyzed\nFROM TAB_COL_STATS\nWHERE db_name = 'tpch' AND table_name = '%s'\n".formatted(tableName));
        Assertions.assertThat((String)this.onMetastore("SELECT COUNT(1) FROM TAB_COL_STATS WHERE db_name = 'tpch' AND table_name = '" + tableName + "'")).isEqualTo("2");
    }

    @Test
    public void testAnalyzeCorruptPartitionStatisticsOnEmptyTable() {
        String tableName = "test_analyze_corrupt_partition_statistics_" + TestingNames.randomNameSuffix();
        this.prepareBrokenPartitionStatisticsTable(tableName);
        this.assertQuerySucceeds("SHOW STATS FOR " + tableName);
        this.assertUpdate("ANALYZE " + tableName, 1L);
        ((QueryAssertions.QueryAssert)Assertions.assertThat((AssertProvider)this.query("CALL system.drop_stats('tpch', '" + tableName + "')"))).failure().hasMessageContaining("The query returned more than one instance BUT either unique is set to true or only aggregates are to be returned, so should have returned one result maximum");
        this.assertUpdate("DROP TABLE " + tableName);
    }

    private void prepareBrokenPartitionStatisticsTable(String tableName) {
        this.assertUpdate("CREATE TABLE " + tableName + " WITH(partitioned_by = ARRAY['part']) AS SELECT 1 col, 'test_partition' part", 1L);
        Assertions.assertThat((String)this.onMetastore("SELECT COUNT(1) FROM PART_COL_STATS WHERE db_name = 'tpch' AND table_name = '" + tableName + "'")).isEqualTo("1");
        this.onMetastore("INSERT INTO PART_COL_STATS\nSELECT\n  cs_id + 1,\n  cat_name,\n  db_name,\n  table_name,\n  partition_name,\n  column_name,\n  column_type,\n  part_id,\n  long_low_value,\n  long_high_value,\n  double_high_value,\n  double_low_value,\n  big_decimal_low_value,\n  big_decimal_high_value,\n  num_nulls,\n  num_distincts,\n  bit_vector,\n  avg_col_len,\n  max_col_len,\n  num_trues,\n  num_falses,\n  last_analyzed\nFROM PART_COL_STATS\nWHERE db_name = 'tpch' AND table_name = '%s'\n".formatted(tableName));
        Assertions.assertThat((String)this.onMetastore("SELECT COUNT(1) FROM PART_COL_STATS WHERE db_name = 'tpch' AND table_name = '" + tableName + "'")).isEqualTo("2");
    }

    private String onMetastore(@Language(value="SQL") String sql) {
        return this.hiveMinioDataLake.getHiveHadoop().runOnMetastore(sql);
    }
}

