/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveBooleanParser;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHiveBooleanParser {
    @Test
    public void testParse() {
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("true")).isTrue();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("TRUE")).isTrue();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("tRuE")).isTrue();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("false")).isFalse();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("FALSE")).isFalse();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("fAlSe")).isFalse();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("true ")).isNull();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean(" true")).isNull();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("false ")).isNull();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean(" false")).isNull();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("t")).isNull();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("f")).isNull();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("")).isNull();
        Assertions.assertThat((Boolean)TestHiveBooleanParser.parseBoolean("blah")).isNull();
    }

    private static Boolean parseBoolean(String s) {
        return HiveBooleanParser.parseHiveBoolean((byte[])s.getBytes(StandardCharsets.US_ASCII), (int)0, (int)s.length());
    }
}

