/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.BaseHiveConnectorTest;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import org.junit.jupiter.api.Test;

public class TestHiveConnectorTest
extends BaseHiveConnectorTest {
    protected QueryRunner createQueryRunner() throws Exception {
        return TestHiveConnectorTest.createHiveQueryRunner(HiveQueryRunner.builder());
    }

    @Test
    public void testPredicatePushdownWithLambdaExpression() {
        String table = "test_predicate_pushdown_" + TestingNames.randomNameSuffix();
        this.assertUpdate("CREATE TABLE %s (v, k)\nWITH (partitioned_by = ARRAY['k'])\nAS (VALUES ('value', 'key'))\n".formatted(table), 1L);
        try {
            this.assertQuery("SELECT *\nFROM %s\nWHERE k = 'key' AND regexp_replace(v, '(.*)', x -> x[1]) IS NOT NULL\n".formatted(table), "VALUES ('value', 'key')");
        }
        finally {
            this.assertUpdate("DROP TABLE " + table);
        }
    }
}

