/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestQueryFramework;
import io.trino.testing.QueryRunner;
import io.trino.tpch.TpchTable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.junit.jupiter.api.Test;

public class TestHiveCreateExternalTableDisabled
extends AbstractTestQueryFramework {
    protected QueryRunner createQueryRunner() throws Exception {
        return ((HiveQueryRunner.Builder)((Object)HiveQueryRunner.builder().setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.non-managed-table-writes-enabled", (Object)"true", (Object)"hive.non-managed-table-creates-enabled", (Object)"false")).setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.ORDERS, (Object)TpchTable.CUSTOMER)))).build();
    }

    @Test
    public void testCreateExternalTableWithData() throws Exception {
        Path tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
        String createTableSql = String.format("CREATE TABLE test_create_external WITH (external_location = '%s') AS SELECT * FROM tpch.tiny.nation", tempDir.toUri().toASCIIString());
        this.assertQueryFails(createTableSql, "Creating non-managed Hive tables is disabled");
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }

    @Test
    public void testCreateExternalTable() throws Exception {
        Path tempDir = Files.createTempDirectory(null, new FileAttribute[0]);
        String createTableSql = String.format("CREATE TABLE test_create_external (n TINYINT) WITH (external_location = '%s')", tempDir.toUri().toASCIIString());
        this.assertQueryFails(createTableSql, "Cannot create non-managed Hive table");
        MoreFiles.deleteRecursively((Path)tempDir, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
    }
}

