/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.testing.AbstractTestAggregations;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingNames;
import org.junit.jupiter.api.Test;

public class TestHiveDistributedAggregations
extends AbstractTestAggregations {
    protected QueryRunner createQueryRunner() throws Exception {
        return HiveQueryRunner.builder().setInitialTables(REQUIRED_TPCH_TABLES).build();
    }

    @Test
    public void testDistinctAggregationWithSystemTable() {
        String tableName = "test_dist_aggr_" + TestingNames.randomNameSuffix();
        String createTable = "CREATE TABLE %s\nWITH (\npartitioned_by = ARRAY[ 'regionkey', 'nationkey' ]\n) AS (SELECT name, comment, regionkey, nationkey FROM nation)\n".formatted(tableName);
        this.assertUpdate(this.getSession(), createTable, 25L);
        this.assertQuerySucceeds("SELECT count(distinct regionkey), count(distinct nationkey) FROM \"%s$partitions\"".formatted(tableName));
    }
}

