/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import io.trino.Session;
import io.trino.plugin.hive.HiveQueryRunner;
import io.trino.spi.security.Identity;
import io.trino.testing.QueryRunner;
import io.trino.testing.TestingSession;
import io.trino.tpch.TpchTable;
import java.io.File;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@Execution(value=ExecutionMode.CONCURRENT)
public class TestHiveFileBasedSecurity {
    private QueryRunner queryRunner;

    @BeforeAll
    public void setUp() throws Exception {
        String path = new File(Resources.getResource(this.getClass(), (String)"security.json").toURI()).getPath();
        this.queryRunner = ((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)((Object)((HiveQueryRunner.Builder)HiveQueryRunner.builder().amendSession(session -> session.setIdentity(Identity.ofUser((String)"hive")))).setHiveProperties((Map<String, String>)ImmutableMap.of((Object)"hive.security", (Object)"file", (Object)"security.config-file", (Object)path)))).setInitialTables((Iterable<TpchTable<?>>)ImmutableList.of((Object)TpchTable.NATION)))).build();
    }

    @AfterAll
    public void tearDown() {
        this.queryRunner.close();
        this.queryRunner = null;
    }

    @Test
    public void testAdminCanRead() {
        Session admin = this.getSession("hive");
        this.queryRunner.execute(admin, "SELECT * FROM nation");
    }

    @Test
    public void testNonAdminCannotRead() {
        Session bob = this.getSession("bob");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.queryRunner.execute(bob, "SELECT * FROM nation")).isInstanceOf(RuntimeException.class)).hasMessageMatching(".*Access Denied: Cannot select from table tpch.nation.*");
    }

    @Test
    public void testShowCreateSchemaDoesNotContainAuthorization() {
        Session admin = this.getSession("hive");
        Assertions.assertThat((String)((String)this.queryRunner.execute(admin, "SHOW CREATE SCHEMA tpch").getOnlyValue())).doesNotContain(new CharSequence[]{"AUTHORIZATION"});
    }

    private Session getSession(String user) {
        return TestingSession.testSessionBuilder().setCatalog(this.queryRunner.getDefaultSession().getCatalog()).setSchema(this.queryRunner.getDefaultSession().getSchema()).setIdentity(Identity.ofUser((String)user)).build();
    }
}

