/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.hive;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.memory.MemoryFileSystemFactory;
import io.trino.hive.formats.compression.CompressionKind;
import io.trino.hive.orc.OrcConf;
import io.trino.metastore.HiveType;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.OrcWriterOptions;
import io.trino.plugin.base.metrics.FileFormatDataSourceStats;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.plugin.base.type.TrinoTimestampEncoderFactory;
import io.trino.plugin.hive.FileWriter;
import io.trino.plugin.hive.HiveColumnHandle;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.plugin.hive.HiveCompressionCodec;
import io.trino.plugin.hive.HiveConfig;
import io.trino.plugin.hive.HiveErrorCode;
import io.trino.plugin.hive.HiveFileWriterFactory;
import io.trino.plugin.hive.HivePageSourceFactory;
import io.trino.plugin.hive.HivePageSourceProvider;
import io.trino.plugin.hive.HivePartitionKey;
import io.trino.plugin.hive.HiveSessionProperties;
import io.trino.plugin.hive.HiveStorageFormat;
import io.trino.plugin.hive.HiveTestUtils;
import io.trino.plugin.hive.NodeVersion;
import io.trino.plugin.hive.RcFileFileWriterFactory;
import io.trino.plugin.hive.Schema;
import io.trino.plugin.hive.WriterKind;
import io.trino.plugin.hive.acid.AcidTransaction;
import io.trino.plugin.hive.avro.AvroFileWriterFactory;
import io.trino.plugin.hive.avro.AvroPageSourceFactory;
import io.trino.plugin.hive.line.CsvFileWriterFactory;
import io.trino.plugin.hive.line.CsvPageSourceFactory;
import io.trino.plugin.hive.line.JsonFileWriterFactory;
import io.trino.plugin.hive.line.JsonPageSourceFactory;
import io.trino.plugin.hive.line.OpenXJsonFileWriterFactory;
import io.trino.plugin.hive.line.OpenXJsonPageSourceFactory;
import io.trino.plugin.hive.line.SimpleSequenceFilePageSourceFactory;
import io.trino.plugin.hive.line.SimpleSequenceFileWriterFactory;
import io.trino.plugin.hive.line.SimpleTextFilePageSourceFactory;
import io.trino.plugin.hive.line.SimpleTextFileWriterFactory;
import io.trino.plugin.hive.orc.OrcFileWriterFactory;
import io.trino.plugin.hive.orc.OrcPageSourceFactory;
import io.trino.plugin.hive.orc.OrcReaderConfig;
import io.trino.plugin.hive.orc.OrcWriterConfig;
import io.trino.plugin.hive.parquet.ParquetFileWriterFactory;
import io.trino.plugin.hive.parquet.ParquetPageSourceFactory;
import io.trino.plugin.hive.parquet.ParquetReaderConfig;
import io.trino.plugin.hive.parquet.ParquetWriterConfig;
import io.trino.plugin.hive.rcfile.RcFilePageSourceFactory;
import io.trino.plugin.hive.util.HiveTypeTranslator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.RowBlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.security.ConnectorIdentity;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Int128Math;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.SqlDate;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.MaterializedResult;
import io.trino.testing.MaterializedRow;
import io.trino.testing.StructuralTestUtil;
import io.trino.testing.TestingConnectorSession;
import io.trino.testing.assertions.TrinoExceptionAssert;
import io.trino.type.InternalTypeManager;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Properties;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.type.Date;
import org.apache.hadoop.hive.common.type.HiveChar;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.common.type.HiveVarchar;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.parquet.format.CompressionCodec;
import org.assertj.core.api.AbstractBigDecimalAssert;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractDoubleAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.data.Offset;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(singleThreaded=true)
public final class TestHiveFileFormats {
    private static final DateTimeZone HIVE_STORAGE_TIME_ZONE = DateTimeZone.forID((String)"America/Bahia_Banderas");
    private static final float EPSILON = 0.001f;
    private static final FileFormatDataSourceStats STATS = new FileFormatDataSourceStats();
    private static final ConnectorSession PARQUET_SESSION = HiveTestUtils.getHiveSession(TestHiveFileFormats.createParquetHiveConfig(false));
    private static final ConnectorSession PARQUET_SESSION_USE_NAME = HiveTestUtils.getHiveSession(TestHiveFileFormats.createParquetHiveConfig(true));
    private static final Type VARCHAR_100 = VarcharType.createVarcharType((int)100);
    private static final Type VARCHAR_HIVE_MAX = VarcharType.createVarcharType((int)65535);
    private static final Type CHAR_10 = CharType.createCharType((int)10);
    private static final String VARCHAR_MAX_LENGTH_STRING;
    private static final Date HIVE_DATE;
    private static final long DATE_DAYS;
    private static final String DATE_STRING;
    private static final DateTime TIMESTAMP_VALUE;
    private static final long TIMESTAMP_MICROS_VALUE;
    private static final String TIMESTAMP_STRING_VALUE;
    private static final Timestamp HIVE_TIMESTAMP;
    private static final DecimalType DECIMAL_TYPE_2;
    private static final DecimalType DECIMAL_TYPE_4;
    private static final DecimalType DECIMAL_TYPE_8;
    private static final DecimalType DECIMAL_TYPE_17;
    private static final DecimalType DECIMAL_TYPE_18;
    private static final DecimalType DECIMAL_TYPE_38;
    private static final HiveDecimal WRITE_DECIMAL_2;
    private static final HiveDecimal WRITE_DECIMAL_4;
    private static final HiveDecimal WRITE_DECIMAL_8;
    private static final HiveDecimal WRITE_DECIMAL_17;
    private static final HiveDecimal WRITE_DECIMAL_18;
    private static final HiveDecimal WRITE_DECIMAL_38;
    private static final BigDecimal EXPECTED_DECIMAL_2;
    private static final BigDecimal EXPECTED_DECIMAL_4;
    private static final BigDecimal EXPECTED_DECIMAL_8;
    private static final BigDecimal EXPECTED_DECIMAL_17;
    private static final BigDecimal EXPECTED_DECIMAL_18;
    private static final BigDecimal EXPECTED_DECIMAL_38;
    private static final TypeOperators TYPE_OPERATORS;
    private static final List<TestColumn> TEST_COLUMNS;

    @DataProvider(name="rowCount")
    public static Object[][] rowCountProvider() {
        return new Object[][]{{0}, {1000}};
    }

    @DataProvider(name="validRowAndFileSizePadding")
    public static Object[][] validFileSizePaddingProvider() {
        return new Object[][]{{0, 0L}, {0, 16L}, {10, 1L}, {1000, 64L}};
    }

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        ((AbstractStringAssert)Assertions.assertThat((String)TimeZone.getDefault().getID()).describedAs("Timezone not configured correctly. Add -Duser.timezone=America/Bahia_Banderas to your JVM arguments", new Object[0])).isEqualTo("America/Bahia_Banderas");
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testTextFile(int rowCount, long fileSizePadding) throws Exception {
        List<TestColumn> testColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withFileWriterFactory(fileSystemFactory -> new SimpleTextFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource(fileSystemFactory -> new SimpleTextFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testSequenceFile(int rowCount, long fileSizePadding) throws Exception {
        List<TestColumn> testColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withFileWriterFactory(fileSystemFactory -> new SimpleSequenceFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"))).isReadableByPageSource(fileSystemFactory -> new SimpleSequenceFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testCsvFile(int rowCount, long fileSizePadding) throws Exception {
        List testColumns = (List)TEST_COLUMNS.stream().filter(column -> {
            VarcharType varcharType;
            Type patt0$temp;
            return column.partitionKey() || (patt0$temp = column.type()) instanceof VarcharType && (varcharType = (VarcharType)patt0$temp).isUnbounded() && !column.name().contains("_null_");
        }).collect(ImmutableList.toImmutableList());
        Assertions.assertThat((testColumns.size() > 5 ? 1 : 0) != 0).isTrue();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.CSV).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withFileWriterFactory(fileSystemFactory -> new CsvFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource(fileSystemFactory -> new CsvPageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test
    public void testCsvFileWithNullAndValue() throws Exception {
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.CSV).withColumns((List<TestColumn>)ImmutableList.of((Object)new TestColumn("t_null_string", (Type)VarcharType.VARCHAR, null, Slices.utf8Slice((String)"")), (Object)new TestColumn("t_string", (Type)VarcharType.VARCHAR, "test", Slices.utf8Slice((String)"test")))).withRowsCount(2).withFileWriterFactory(fileSystemFactory -> new CsvFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource(fileSystemFactory -> new CsvPageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testJson(int rowCount, long fileSizePadding) throws Exception {
        List<TestColumn> testColumns = TEST_COLUMNS.stream().filter(column -> !column.name().equals("t_binary")).filter(column -> !column.name().equals("t_map_tinyint")).filter(column -> !column.name().equals("t_map_smallint")).filter(column -> !column.name().equals("t_map_int")).filter(column -> !column.name().equals("t_map_bigint")).filter(column -> !column.name().equals("t_map_float")).filter(column -> !column.name().equals("t_map_double")).filter(TestHiveFileFormats::withoutNullMapKeyTests).filter(column -> !column.name().equals("t_decimal_precision_38")).filter(column -> !column.name().equals("t_map_decimal_precision_38")).filter(column -> !column.name().equals("t_array_decimal_precision_38")).collect(Collectors.toList());
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.JSON).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withFileWriterFactory(fileSystemFactory -> new JsonFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource(fileSystemFactory -> new JsonPageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testOpenXJson(int rowCount, long fileSizePadding) throws Exception {
        List<TestColumn> testColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.OPENX_JSON).withColumns(testColumns).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withSkipGenericWriterTest().withFileWriterFactory(fileSystemFactory -> new OpenXJsonFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource(fileSystemFactory -> new OpenXJsonPageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testRcTextPageSource(int rowCount, long fileSizePadding) throws Exception {
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns(TEST_COLUMNS).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRcTextOptimizedWriter(int rowCount) throws Exception {
        List testColumns = (List)TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(ImmutableList.toImmutableList());
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns(testColumns).withRowsCount(rowCount).withFileWriterFactory(fileSystemFactory -> new RcFileFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE)).isReadableByPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRcBinaryPageSource(int rowCount) throws Exception {
        List<TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.name().equals("t_empty_varchar")).filter(TestHiveFileFormats::withoutTimestamps).collect(Collectors.toList());
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).isReadableByPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRcBinaryOptimizedWriter(int rowCount) throws Exception {
        List<TestColumn> testColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.name().equals("t_empty_varchar")).filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        List<TestColumn> testColumnsNoTimestamps = testColumns.stream().filter(TestHiveFileFormats::withoutTimestamps).collect(Collectors.toList());
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns(testColumns).withRowsCount(rowCount).withSkipGenericWriterTest().withFileWriterFactory(fileSystemFactory -> new RcFileFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE)).isReadableByPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig())).withColumns(testColumnsNoTimestamps);
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testOrc(int rowCount, long fileSizePadding) throws Exception {
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.ORC).withColumns(TEST_COLUMNS).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByPageSource(fileSystemFactory -> new OrcPageSourceFactory(new OrcReaderOptions(), fileSystemFactory, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testOrcOptimizedWriter(int rowCount, long fileSizePadding) throws Exception {
        HiveSessionProperties hiveSessionProperties = new HiveSessionProperties(new HiveConfig(), new OrcReaderConfig(), new OrcWriterConfig().setValidationPercentage(100.0), new ParquetReaderConfig(), new ParquetWriterConfig());
        TestingConnectorSession session = TestingConnectorSession.builder().setPropertyMetadata(hiveSessionProperties.getSessionProperties()).build();
        List<TestColumn> testColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.ORC).withColumns(testColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).withFileSizePadding(fileSizePadding).withFileWriterFactory(fileSystemFactory -> new OrcFileWriterFactory(InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), STATS, new OrcWriterOptions(), fileSystemFactory)).isReadableByPageSource(fileSystemFactory -> new OrcPageSourceFactory(new OrcReaderOptions(), fileSystemFactory, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="rowCount")
    public void testOrcUseColumnNames(int rowCount) throws Exception {
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true));
        List testColumns = (List)TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutTimestamps).collect(ImmutableList.toImmutableList());
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns(testColumns).withRowsCount(rowCount).withReadColumns((List<TestColumn>)testColumns.reversed()).withSession((ConnectorSession)session).isReadableByPageSource(fileSystemFactory -> new OrcPageSourceFactory(new OrcReaderOptions(), fileSystemFactory, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="rowCount")
    public void testOrcUseColumnNameLowerCaseConversion(int rowCount) throws Exception {
        List<TestColumn> testColumnsUpperCase = TEST_COLUMNS.stream().map(testColumn -> testColumn.withName(testColumn.name().toUpperCase(Locale.ENGLISH))).collect(Collectors.toList());
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns(testColumnsUpperCase).withRowsCount(rowCount).withReadColumns(TEST_COLUMNS).withSession((ConnectorSession)session).isReadableByPageSource(fileSystemFactory -> new OrcPageSourceFactory(new OrcReaderOptions(), fileSystemFactory, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testAvro(int rowCount, long fileSizePadding) throws Exception {
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.AVRO).withColumns(TestHiveFileFormats.getTestColumnsSupportedByAvro()).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).withFileWriterFactory(fileSystemFactory -> new AvroFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test_version"))).isReadableByPageSource(AvroPageSourceFactory::new);
    }

    @Test(dataProvider="rowCount")
    public static void testAvroFileInSymlinkTable(int rowCount) throws Exception {
        MemoryFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();
        Location location = Location.of((String)"memory:///avro-test");
        TestHiveFileFormats.createTestFileHive((TrinoFileSystemFactory)fileSystemFactory, location, HiveStorageFormat.AVRO, HiveCompressionCodec.NONE, TestHiveFileFormats.getTestColumnsSupportedByAvro(), rowCount);
        long fileSize = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test")).newInputFile(location).length();
        TestHiveFileFormats.testPageSourceFactory((HivePageSourceFactory)new AvroPageSourceFactory((TrinoFileSystemFactory)fileSystemFactory), location, HiveStorageFormat.AVRO, TestHiveFileFormats.getTestColumnsSupportedByAvro(), HiveTestUtils.SESSION, fileSize, fileSize, rowCount);
    }

    private static List<TestColumn> getTestColumnsSupportedByAvro() {
        return TEST_COLUMNS.stream().filter(column -> !column.name().startsWith("t_map_") || column.name().equals("t_map_string")).filter(column -> !column.name().endsWith("_smallint")).filter(column -> !column.name().endsWith("_tinyint")).collect(Collectors.toList());
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testParquetPageSource(int rowCount, long fileSizePadding) throws Exception {
        List<TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withSession(PARQUET_SESSION).withRowsCount(rowCount).withFileSizePadding(fileSizePadding).isReadableByPageSource(fileSystemFactory -> new ParquetPageSourceFactory(fileSystemFactory, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    @Test(dataProvider="validRowAndFileSizePadding")
    public void testParquetPageSourceGzip(int rowCount, long fileSizePadding) throws Exception {
        List<TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns(testColumns).withSession(PARQUET_SESSION).withCompressionCodec(HiveCompressionCodec.GZIP).withFileSizePadding(fileSizePadding).withRowsCount(rowCount).isReadableByPageSource(fileSystemFactory -> new ParquetPageSourceFactory(fileSystemFactory, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testParquetWriter(int rowCount) throws Exception {
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new ParquetWriterConfig().setValidationPercentage(100.0));
        List<TestColumn> testColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.PARQUET).withSession((ConnectorSession)session).withColumns(testColumns).withRowsCount(rowCount).withFileWriterFactory(fileSystemFactory -> new ParquetFileWriterFactory(fileSystemFactory, new NodeVersion("test-version"), InternalTypeManager.TESTING_TYPE_MANAGER, new HiveConfig(), STATS)).isReadableByPageSource(fileSystemFactory -> new ParquetPageSourceFactory(fileSystemFactory, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testParquetPageSourceSchemaEvolution(int rowCount) throws Exception {
        List<TestColumn> writeColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        SequencedCollection<TestColumn> readColumns = writeColumns.stream().map(column -> column.withName(column.name() + "_new")).collect(Collectors.toList());
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns((List<TestColumn>)readColumns).withSession(PARQUET_SESSION).withRowsCount(rowCount).isReadableByPageSource(fileSystemFactory -> new ParquetPageSourceFactory(fileSystemFactory, STATS, new ParquetReaderConfig(), new HiveConfig()));
        readColumns = writeColumns.reversed();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns(writeColumns).withReadColumns((List<TestColumn>)readColumns).withSession(PARQUET_SESSION_USE_NAME).isReadableByPageSource(fileSystemFactory -> new ParquetPageSourceFactory(fileSystemFactory, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testParquetCaseSensitivity(int rowCount) throws Exception {
        TestColumn writeColumnA = new TestColumn("UPPER_CASE_COLUMN", (Type)VarcharType.createVarcharType((int)5), new HiveVarchar("testA", 5), Slices.utf8Slice((String)"testA"));
        TestColumn writeColumnB = new TestColumn("Upper_Case_Column", (Type)VarcharType.createVarcharType((int)5), new HiveVarchar("testB", 5), Slices.utf8Slice((String)"testB"));
        TestColumn readColumn = new TestColumn("uppeR_casE_columN", (Type)VarcharType.createVarcharType((int)5), new HiveVarchar("testA", 5), Slices.utf8Slice((String)"testA"));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<TestColumn>)ImmutableList.of((Object)writeColumnA, (Object)writeColumnB)).withReadColumns((List<TestColumn>)ImmutableList.of((Object)readColumn)).withSession((ConnectorSession)HiveTestUtils.getHiveSession(TestHiveFileFormats.createParquetHiveConfig(true), new ParquetWriterConfig().setValidationPercentage(0.0))).withRowsCount(rowCount).withFileWriterFactory(fileSystemFactory -> new ParquetFileWriterFactory(fileSystemFactory, new NodeVersion("test-version"), InternalTypeManager.TESTING_TYPE_MANAGER, new HiveConfig(), STATS)).isReadableByPageSource(fileSystemFactory -> new ParquetPageSourceFactory(fileSystemFactory, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    private static List<TestColumn> getTestColumnsSupportedByParquet() {
        return TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutTimestamps).filter(TestHiveFileFormats::withoutNullMapKeyTests).filter(column -> !column.name().equals("t_null_array_int")).filter(column -> !column.name().equals("t_array_empty")).filter(column -> column.partitionKey() || !TestHiveFileFormats.hasType(column.type(), (Type)TinyintType.TINYINT)).collect(Collectors.toList());
    }

    @Test
    public void testTruncateVarcharColumn() throws Exception {
        TestColumn writeColumn = new TestColumn("varchar_column", (Type)VarcharType.createVarcharType((int)4), new HiveVarchar("test", 4), Slices.utf8Slice((String)"test"));
        TestColumn readColumn = new TestColumn("varchar_column", (Type)VarcharType.createVarcharType((int)3), new HiveVarchar("tes", 3), Slices.utf8Slice((String)"tes"));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCTEXT).withWriteColumns((List<TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<TestColumn>)ImmutableList.of((Object)readColumn)).isReadableByPageSource(fileSystemFactory -> new OrcPageSourceFactory(new OrcReaderOptions(), fileSystemFactory, STATS, DateTimeZone.UTC));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<TestColumn>)ImmutableList.of((Object)readColumn)).withSession(PARQUET_SESSION).isReadableByPageSource(fileSystemFactory -> new ParquetPageSourceFactory(fileSystemFactory, STATS, new ParquetReaderConfig(), new HiveConfig()));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.AVRO).withWriteColumns((List<TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<TestColumn>)ImmutableList.of((Object)readColumn)).withFileWriterFactory(fileSystemFactory -> new AvroFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test_version"))).isReadableByPageSource(AvroPageSourceFactory::new);
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withWriteColumns((List<TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<TestColumn>)ImmutableList.of((Object)readColumn)).withFileWriterFactory(fileSystemFactory -> new SimpleSequenceFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"))).isReadableByPageSource(fileSystemFactory -> new SimpleSequenceFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withWriteColumns((List<TestColumn>)ImmutableList.of((Object)writeColumn)).withReadColumns((List<TestColumn>)ImmutableList.of((Object)readColumn)).withFileWriterFactory(fileSystemFactory -> new SimpleTextFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource(fileSystemFactory -> new SimpleTextFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testAvroProjectedColumns(int rowCount) throws Exception {
        List<TestColumn> supportedColumns = TestHiveFileFormats.getTestColumnsSupportedByAvro();
        List<TestColumn> regularColumns = TestHiveFileFormats.getRegularColumns(supportedColumns);
        List<TestColumn> partitionColumns = TestHiveFileFormats.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        TestHiveFileFormats.generateProjectedColumns(regularColumns, (ImmutableList.Builder<TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.AVRO).withWriteColumns((List<TestColumn>)writeColumns).withReadColumns((List<TestColumn>)readColumns).withRowsCount(rowCount).withFileWriterFactory(fileSystemFactory -> new AvroFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test_version"))).isReadableByPageSource(AvroPageSourceFactory::new);
    }

    @Test(dataProvider="rowCount")
    public void testParquetProjectedColumns(int rowCount) throws Exception {
        List<TestColumn> supportedColumns = TestHiveFileFormats.getTestColumnsSupportedByParquet();
        List<TestColumn> regularColumns = TestHiveFileFormats.getRegularColumns(supportedColumns);
        List<TestColumn> partitionColumns = TestHiveFileFormats.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        TestHiveFileFormats.generateProjectedColumns(regularColumns, (ImmutableList.Builder<TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<TestColumn>)writeColumns).withReadColumns((List<TestColumn>)readColumns).withRowsCount(rowCount).withSession(PARQUET_SESSION).isReadableByPageSource(fileSystemFactory -> new ParquetPageSourceFactory(fileSystemFactory, STATS, new ParquetReaderConfig(), new HiveConfig()));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.PARQUET).withWriteColumns((List<TestColumn>)writeColumns).withReadColumns((List<TestColumn>)readColumns).withRowsCount(rowCount).withSession(PARQUET_SESSION_USE_NAME).isReadableByPageSource(fileSystemFactory -> new ParquetPageSourceFactory(fileSystemFactory, STATS, new ParquetReaderConfig(), new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testORCProjectedColumns(int rowCount) throws Exception {
        List<TestColumn> supportedColumns = TEST_COLUMNS;
        List<TestColumn> regularColumns = TestHiveFileFormats.getRegularColumns(supportedColumns);
        List<TestColumn> partitionColumns = TestHiveFileFormats.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        TestHiveFileFormats.generateProjectedColumns(regularColumns, (ImmutableList.Builder<TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        TestingConnectorSession session = HiveTestUtils.getHiveSession(new HiveConfig(), new OrcReaderConfig().setUseColumnNames(true));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<TestColumn>)writeColumns).withReadColumns((List<TestColumn>)readColumns).withRowsCount(rowCount).withSession((ConnectorSession)session).isReadableByPageSource(fileSystemFactory -> new OrcPageSourceFactory(new OrcReaderOptions(), fileSystemFactory, STATS, DateTimeZone.UTC));
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.ORC).withWriteColumns((List<TestColumn>)writeColumns).withReadColumns((List<TestColumn>)readColumns).withRowsCount(rowCount).isReadableByPageSource(fileSystemFactory -> new OrcPageSourceFactory(new OrcReaderOptions(), fileSystemFactory, STATS, DateTimeZone.UTC));
    }

    @Test(dataProvider="rowCount")
    public void testSequenceFileProjectedColumns(int rowCount) throws Exception {
        List<TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(column -> !column.name().equals("t_map_null_key_complex_key_value")).collect(Collectors.toList());
        List<TestColumn> regularColumns = TestHiveFileFormats.getRegularColumns(supportedColumns);
        List<TestColumn> partitionColumns = TestHiveFileFormats.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        TestHiveFileFormats.generateProjectedColumns(regularColumns, (ImmutableList.Builder<TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.SEQUENCEFILE).withWriteColumns((List<TestColumn>)writeColumns).withReadColumns((List<TestColumn>)readColumns).withRowsCount(rowCount).withFileWriterFactory(fileSystemFactory -> new SimpleSequenceFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"))).isReadableByPageSource(fileSystemFactory -> new SimpleSequenceFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testTextFileProjectedColumns(int rowCount) throws Exception {
        List<TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(TestHiveFileFormats::withoutNullMapKeyTests).collect(Collectors.toList());
        List<TestColumn> regularColumns = TestHiveFileFormats.getRegularColumns(supportedColumns);
        List<TestColumn> partitionColumns = TestHiveFileFormats.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        TestHiveFileFormats.generateProjectedColumns(regularColumns, (ImmutableList.Builder<TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.TEXTFILE).withWriteColumns((List<TestColumn>)writeColumns).withReadColumns((List<TestColumn>)readColumns).withRowsCount(rowCount).withFileWriterFactory(fileSystemFactory -> new SimpleTextFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER)).isReadableByPageSource(fileSystemFactory -> new SimpleTextFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRCTextProjectedColumnsPageSource(int rowCount) throws Exception {
        List<TestColumn> supportedColumns = TEST_COLUMNS;
        List<TestColumn> regularColumns = TestHiveFileFormats.getRegularColumns(supportedColumns);
        List<TestColumn> partitionColumns = TestHiveFileFormats.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        TestHiveFileFormats.generateProjectedColumns(regularColumns, (ImmutableList.Builder<TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCTEXT).withWriteColumns((List<TestColumn>)writeColumns).withReadColumns((List<TestColumn>)readColumns).withRowsCount(rowCount).isReadableByPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRCBinaryProjectedColumns(int rowCount) throws Exception {
        List<TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(testColumn -> {
            String name = testColumn.name();
            return !name.equals("t_map_null_key_complex_key_value") && !name.equals("t_empty_varchar");
        }).collect(Collectors.toList());
        List<TestColumn> regularColumns = TestHiveFileFormats.getRegularColumns(supportedColumns);
        List<TestColumn> partitionColumns = TestHiveFileFormats.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        TestHiveFileFormats.generateProjectedColumns(regularColumns, (ImmutableList.Builder<TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<TestColumn>)writeColumns).withReadColumns((List<TestColumn>)readColumns).withRowsCount(rowCount).withSkipGenericWriterTest().withFileWriterFactory(fileSystemFactory -> new RcFileFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE)).isReadableByPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test(dataProvider="rowCount")
    public void testRCBinaryProjectedColumnsPageSource(int rowCount) throws Exception {
        List<TestColumn> supportedColumns = TEST_COLUMNS.stream().filter(testColumn -> !testColumn.name().equals("t_empty_varchar")).collect(Collectors.toList());
        List<TestColumn> regularColumns = TestHiveFileFormats.getRegularColumns(supportedColumns);
        List<TestColumn> partitionColumns = TestHiveFileFormats.getPartitionColumns(supportedColumns);
        ImmutableList.Builder writeColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder readeColumnsBuilder = ImmutableList.builder();
        TestHiveFileFormats.generateProjectedColumns(regularColumns, (ImmutableList.Builder<TestColumn>)writeColumnsBuilder, (ImmutableList.Builder<TestColumn>)readeColumnsBuilder);
        ImmutableList writeColumns = writeColumnsBuilder.addAll(partitionColumns).build();
        ImmutableList readColumns = readeColumnsBuilder.addAll(partitionColumns).build();
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCBINARY).withWriteColumns((List<TestColumn>)writeColumns).withReadColumns((List<TestColumn>)readColumns).withRowsCount(rowCount).withSkipGenericWriterTest().withFileWriterFactory(fileSystemFactory -> new RcFileFileWriterFactory(fileSystemFactory, InternalTypeManager.TESTING_TYPE_MANAGER, new NodeVersion("test"), HIVE_STORAGE_TIME_ZONE)).isReadableByPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig()));
    }

    @Test
    public void testFailForLongVarcharPartitionColumn() {
        TestColumn partitionColumn = new TestColumn("partition_column", (Type)VarcharType.createVarcharType((int)3), "test", Slices.utf8Slice((String)"tes"), true);
        TestColumn varcharColumn = new TestColumn("varchar_column", (Type)VarcharType.createVarcharType((int)3), new HiveVarchar("tes", 3), Slices.utf8Slice((String)"tes"));
        ImmutableList columns = ImmutableList.of((Object)partitionColumn, (Object)varcharColumn);
        HiveErrorCode expectedErrorCode = HiveErrorCode.HIVE_INVALID_PARTITION_VALUE;
        String expectedMessage = "Invalid partition value 'test' for varchar(3) partition key: partition_column";
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCTEXT).withColumns((List<TestColumn>)columns).isFailingForPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig()), expectedErrorCode, expectedMessage);
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.RCBINARY).withColumns((List<TestColumn>)columns).isFailingForPageSource(fileSystemFactory -> new RcFilePageSourceFactory(fileSystemFactory, new HiveConfig()), expectedErrorCode, expectedMessage);
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.ORC).withColumns((List<TestColumn>)columns).isFailingForPageSource(fileSystemFactory -> new OrcPageSourceFactory(new OrcReaderOptions(), fileSystemFactory, STATS, DateTimeZone.UTC), expectedErrorCode, expectedMessage);
        TestHiveFileFormats.assertThatFileFormat(HiveStorageFormat.PARQUET).withColumns((List<TestColumn>)columns).withSession(PARQUET_SESSION).isFailingForPageSource(fileSystemFactory -> new ParquetPageSourceFactory(fileSystemFactory, STATS, new ParquetReaderConfig(), new HiveConfig()), expectedErrorCode, expectedMessage);
    }

    private static void testPageSourceFactory(HivePageSourceFactory sourceFactory, Location location, HiveStorageFormat storageFormat, List<TestColumn> testReadColumns, ConnectorSession session, long fileSize, long paddedFileSize, int rowCount) throws IOException {
        ImmutableList.Builder splitPropertiesColumnNames = ImmutableList.builder();
        ImmutableList.Builder splitPropertiesColumnTypes = ImmutableList.builder();
        HashSet<String> baseColumnNames = new HashSet<String>();
        for (TestColumn testReadColumn : testReadColumns) {
            String name = testReadColumn.baseName();
            if (baseColumnNames.contains(name) || testReadColumn.partitionKey()) continue;
            baseColumnNames.add(name);
            splitPropertiesColumnNames.add((Object)name);
            splitPropertiesColumnTypes.add((Object)HiveTypeTranslator.toHiveType((Type)testReadColumn.baseType()).toString());
        }
        ImmutableMap splitProperties = ImmutableMap.builder().put((Object)"file.inputformat", (Object)storageFormat.getInputFormat()).put((Object)"columns", (Object)String.join((CharSequence)",", (Iterable<? extends CharSequence>)splitPropertiesColumnNames.build())).put((Object)"columns.types", (Object)String.join((CharSequence)",", (Iterable<? extends CharSequence>)splitPropertiesColumnTypes.build())).buildOrThrow();
        List partitionKeys = testReadColumns.stream().filter(TestColumn::partitionKey).map(input -> new HivePartitionKey(input.name(), (String)input.writeValue())).collect(Collectors.toList());
        String partitionName = String.join((CharSequence)"/", (Iterable)partitionKeys.stream().map(partitionKey -> String.format("%s=%s", partitionKey.name(), partitionKey.value())).collect(ImmutableList.toImmutableList()));
        List columnMappings = HivePageSourceProvider.ColumnMapping.buildColumnMappings((String)partitionName, partitionKeys, TestHiveFileFormats.getColumnHandles(testReadColumns), (List)ImmutableList.of(), (Map)ImmutableMap.of(), (String)location.toString(), (OptionalInt)OptionalInt.empty(), (long)paddedFileSize, (long)Instant.now().toEpochMilli());
        ConnectorPageSource pageSource = (ConnectorPageSource)HivePageSourceProvider.createHivePageSource((Set)ImmutableSet.of((Object)sourceFactory), (ConnectorSession)session, (Location)location, (OptionalInt)OptionalInt.empty(), (long)0L, (long)fileSize, (long)paddedFileSize, (long)12345L, (Schema)new Schema(storageFormat.getSerde(), false, (Map)splitProperties), (TupleDomain)TupleDomain.all(), (TypeManager)InternalTypeManager.TESTING_TYPE_MANAGER, Optional.empty(), Optional.empty(), Optional.empty(), (boolean)false, (AcidTransaction)AcidTransaction.NO_ACID_TRANSACTION, (List)columnMappings).orElseThrow();
        TestHiveFileFormats.checkPageSource(pageSource, testReadColumns, rowCount);
    }

    private static List<HiveColumnHandle> getColumnHandles(List<TestColumn> testColumns) {
        ArrayList<HiveColumnHandle> columns = new ArrayList<HiveColumnHandle>(testColumns.size());
        int nextHiveColumnIndex = 0;
        for (TestColumn testColumn : testColumns) {
            int columnIndex = testColumn.partitionKey() ? -1 : nextHiveColumnIndex++;
            columns.add(testColumn.toHiveColumnHandle(columnIndex));
        }
        return columns;
    }

    private static void checkPageSource(ConnectorPageSource pageSource, List<TestColumn> testColumns, int rowCount) throws IOException {
        try (ConnectorPageSource connectorPageSource = pageSource;){
            MaterializedResult result = MaterializedResult.materializeSourceDataStream((ConnectorSession)HiveTestUtils.SESSION, (ConnectorPageSource)pageSource, (List)((List)testColumns.stream().map(TestColumn::type).collect(ImmutableList.toImmutableList())));
            Assertions.assertThat((List)result.getMaterializedRows()).hasSize(rowCount);
            for (MaterializedRow row : result) {
                int testColumnsSize = testColumns.size();
                for (int i = 0; i < testColumnsSize; ++i) {
                    TimestampType timestampType;
                    TestColumn testColumn = testColumns.get(i);
                    Type type = testColumn.type();
                    Object actualValue = row.getField(i);
                    Object expectedValue = testColumn.expectedValue();
                    if (expectedValue instanceof Slice) {
                        expectedValue = ((Slice)expectedValue).toStringUtf8();
                    }
                    if (actualValue == null || expectedValue == null) {
                        ((ObjectAssert)Assertions.assertThat((Object)actualValue).describedAs("Wrong value for column " + testColumn.name(), new Object[0])).isEqualTo(expectedValue);
                        continue;
                    }
                    if (type == RealType.REAL) {
                        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)actualValue).floatValue()).describedAs("Wrong value for column %s", new Object[]{testColumn.name()})).isCloseTo(((Float)expectedValue).floatValue(), Offset.offset((Number)Float.valueOf(0.001f)));
                        continue;
                    }
                    if (type == DoubleType.DOUBLE) {
                        ((AbstractDoubleAssert)Assertions.assertThat((double)((Double)actualValue)).describedAs("Wrong value for column %s", new Object[]{testColumn.name()})).isCloseTo(((Double)expectedValue).doubleValue(), Offset.offset((Number)0.001f));
                        continue;
                    }
                    if (type == DateType.DATE) {
                        SqlDate expectedDate = new SqlDate(Math.toIntExact((Long)expectedValue));
                        ((ObjectAssert)Assertions.assertThat((Object)actualValue).describedAs("Wrong value for column " + testColumn.name(), new Object[0])).isEqualTo((Object)expectedDate);
                        continue;
                    }
                    if (type == BigintType.BIGINT || type == IntegerType.INTEGER || type == SmallintType.SMALLINT || type == TinyintType.TINYINT || type == BooleanType.BOOLEAN) {
                        Assertions.assertThat((Object)actualValue).isEqualTo(expectedValue);
                        continue;
                    }
                    if (type instanceof TimestampType && (timestampType = (TimestampType)type).getPrecision() == 3) {
                        SqlTimestamp expectedTimestamp = DateTimeTestingUtils.sqlTimestampOf((int)3, (long)Math.floorDiv((long)((Long)expectedValue), 1000));
                        ((ObjectAssert)Assertions.assertThat((Object)actualValue).describedAs("Wrong value for column " + testColumn.name(), new Object[0])).isEqualTo((Object)expectedTimestamp);
                        continue;
                    }
                    if (type instanceof CharType) {
                        CharType charType = (CharType)type;
                        ((ObjectAssert)Assertions.assertThat((Object)actualValue).describedAs("Wrong value for column " + testColumn.name(), new Object[0])).isEqualTo((Object)Chars.padSpaces((String)((String)expectedValue), (CharType)charType));
                        continue;
                    }
                    if (type instanceof VarcharType) {
                        ((ObjectAssert)Assertions.assertThat((Object)actualValue).describedAs("Wrong value for column " + testColumn.name(), new Object[0])).isEqualTo(expectedValue);
                        continue;
                    }
                    if (type == VarbinaryType.VARBINARY) {
                        ((AbstractStringAssert)Assertions.assertThat((String)new String(((SqlVarbinary)actualValue).getBytes(), StandardCharsets.UTF_8)).describedAs("Wrong value for column " + testColumn.name(), new Object[0])).isEqualTo(expectedValue);
                        continue;
                    }
                    if (type instanceof DecimalType) {
                        ((AbstractBigDecimalAssert)Assertions.assertThat((BigDecimal)new BigDecimal(actualValue.toString())).describedAs("Wrong value for column " + testColumn.name(), new Object[0])).isEqualTo(expectedValue);
                        continue;
                    }
                    BlockBuilder builder = type.createBlockBuilder(null, 1);
                    type.writeObject(builder, expectedValue);
                    expectedValue = type.getObjectValue(HiveTestUtils.SESSION, builder.build(), 0);
                    ((ObjectAssert)Assertions.assertThat((Object)actualValue).describedAs("Wrong value for column " + testColumn.name(), new Object[0])).isEqualTo(expectedValue);
                }
            }
        }
    }

    private static boolean hasType(Type actualType, Type testType) {
        return actualType.equals((Object)testType) || actualType.getTypeParameters().stream().anyMatch(type -> TestHiveFileFormats.hasType(type, testType));
    }

    private static boolean withoutNullMapKeyTests(TestColumn testColumn) {
        String name = testColumn.name();
        return !name.equals("t_map_null_key") && !name.equals("t_map_null_key_complex_key_value") && !name.equals("t_map_null_key_complex_value");
    }

    private static boolean withoutTimestamps(TestColumn testColumn) {
        String name = testColumn.name();
        return !name.equals("t_timestamp") && !name.equals("t_map_timestamp") && !name.equals("t_array_timestamp");
    }

    private static FileFormatAssertion assertThatFileFormat(HiveStorageFormat hiveStorageFormat) {
        return new FileFormatAssertion(hiveStorageFormat.name()).withStorageFormat(hiveStorageFormat);
    }

    private static HiveConfig createParquetHiveConfig(boolean useParquetColumnNames) {
        return new HiveConfig().setUseParquetColumnNames(useParquetColumnNames);
    }

    private static void generateProjectedColumns(List<TestColumn> testColumns, ImmutableList.Builder<TestColumn> testFullColumnsBuilder, ImmutableList.Builder<TestColumn> testDereferencedColumnsBuilder) {
        for (int i = 0; i < testColumns.size(); ++i) {
            TestColumn testColumn = testColumns.get(i);
            Verify.verify((!testColumn.dereference() ? 1 : 0) != 0);
            TestColumn baseColumn = new TestColumn("new_col" + i, (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"field0", (Type)testColumn.type())}), Collections.singletonList(testColumn.writeValue()), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)testColumn.type()), (Object[])new Object[]{testColumn.expectedValue()}));
            TestColumn projectedColumn = baseColumn.withDereferenceFirstField(testColumn.writeValue(), testColumn.expectedValue());
            testFullColumnsBuilder.add((Object)baseColumn);
            testDereferencedColumnsBuilder.add((Object)projectedColumn);
        }
    }

    private static List<TestColumn> getRegularColumns(List<TestColumn> columns) {
        return (List)columns.stream().filter(column -> !column.partitionKey()).collect(ImmutableList.toImmutableList());
    }

    private static List<TestColumn> getPartitionColumns(List<TestColumn> columns) {
        return (List)columns.stream().filter(TestColumn::partitionKey).collect(ImmutableList.toImmutableList());
    }

    private static void createTestFileTrino(Location location, HiveStorageFormat storageFormat, HiveCompressionCodec compressionCodec, List<TestColumn> testColumns, ConnectorSession session, int numRows, HiveFileWriterFactory fileWriterFactory) {
        testColumns = (List)testColumns.stream().filter(column -> !column.partitionKey()).collect(ImmutableList.toImmutableList());
        List types = testColumns.stream().map(TestColumn::type).collect(Collectors.toList());
        PageBuilder pageBuilder = new PageBuilder(types);
        for (int rowNumber = 0; rowNumber < numRows; ++rowNumber) {
            pageBuilder.declarePosition();
            for (int columnNumber = 0; columnNumber < testColumns.size(); ++columnNumber) {
                TestColumn testColumn = (TestColumn)testColumns.get(columnNumber);
                TestHiveFileFormats.writeValue(testColumn.type(), pageBuilder.getBlockBuilder(columnNumber), testColumn.writeValue());
            }
        }
        Page page = pageBuilder.build();
        ImmutableMap tableProperties = ImmutableMap.builder().put((Object)"columns", (Object)testColumns.stream().map(TestColumn::name).collect(Collectors.joining(","))).put((Object)"columns.types", (Object)testColumns.stream().map(TestColumn::type).map(HiveTypeTranslator::toHiveType).map(HiveType::toString).collect(Collectors.joining(","))).buildOrThrow();
        Optional fileWriter = fileWriterFactory.createFileWriter(location, testColumns.stream().map(TestColumn::name).collect(Collectors.toList()), storageFormat.toStorageFormat(), compressionCodec, (Map)tableProperties, session, OptionalInt.empty(), AcidTransaction.NO_ACID_TRANSACTION, false, WriterKind.INSERT);
        FileWriter hiveFileWriter = (FileWriter)fileWriter.orElseThrow(() -> new IllegalArgumentException("fileWriterFactory"));
        hiveFileWriter.appendRows(page);
        hiveFileWriter.commit();
    }

    private static void writeValue(Type type, BlockBuilder builder, Object object) {
        Objects.requireNonNull(builder, "builder is null");
        if (object == null) {
            builder.appendNull();
        } else if (type == BooleanType.BOOLEAN) {
            BooleanType.BOOLEAN.writeBoolean(builder, ((Boolean)object).booleanValue());
        } else if (type == TinyintType.TINYINT) {
            TinyintType.TINYINT.writeByte(builder, ((Byte)object).byteValue());
        } else if (type == SmallintType.SMALLINT) {
            SmallintType.SMALLINT.writeShort(builder, ((Short)object).shortValue());
        } else if (type == IntegerType.INTEGER) {
            IntegerType.INTEGER.writeInt(builder, ((Integer)object).intValue());
        } else if (type == BigintType.BIGINT) {
            BigintType.BIGINT.writeLong(builder, ((Long)object).longValue());
        } else if (type == RealType.REAL) {
            RealType.REAL.writeFloat(builder, ((Float)object).floatValue());
        } else if (type == DoubleType.DOUBLE) {
            DoubleType.DOUBLE.writeDouble(builder, ((Double)object).doubleValue());
        } else if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            if (object instanceof HiveVarchar) {
                object = ((HiveVarchar)object).getValue();
            }
            varcharType.writeSlice(builder, Slices.utf8Slice((String)((String)object)));
        } else if (type instanceof CharType) {
            CharType charType = (CharType)type;
            if (object instanceof HiveChar) {
                object = ((HiveChar)object).getValue();
            }
            charType.writeSlice(builder, Chars.truncateToLengthAndTrimSpaces((Slice)Slices.utf8Slice((String)((String)object)), (int)charType.getLength()));
        } else if (type == DateType.DATE) {
            long days = ((Date)object).toEpochDay();
            DateType.DATE.writeLong(builder, days);
        } else if (type instanceof TimestampType) {
            TimestampType timestampType = (TimestampType)type;
            Timestamp timestamp = (Timestamp)object;
            long epochSecond = timestamp.toEpochSecond();
            int nanosOfSecond = (int)Timestamps.round((long)timestamp.getNanos(), (int)(9 - timestampType.getPrecision()));
            TrinoTimestampEncoderFactory.createTimestampEncoder((TimestampType)timestampType, (DateTimeZone)DateTimeZone.UTC).write(new DecodedTimestamp(epochSecond, nanosOfSecond), builder);
        } else if (type == VarbinaryType.VARBINARY) {
            VarbinaryType.VARBINARY.writeSlice(builder, Slices.wrappedBuffer((byte[])((byte[])object)));
        } else if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            HiveDecimalWritable hiveDecimal = new HiveDecimalWritable((HiveDecimal)object);
            Int128 value = Int128.fromBigEndian((byte[])hiveDecimal.getInternalStorage());
            value = Int128Math.rescale((Int128)value, (int)(decimalType.getScale() - hiveDecimal.getScale()));
            if (decimalType.isShort()) {
                type.writeLong(builder, value.toLongExact());
            } else {
                type.writeObject(builder, (Object)value);
            }
        } else if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            Type elementType = arrayType.getElementType();
            List list = (List)object;
            ((ArrayBlockBuilder)builder).buildEntry(elementBuilder -> {
                for (Object element : list) {
                    TestHiveFileFormats.writeValue(elementType, elementBuilder, element);
                }
            });
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            Type keyType = mapType.getKeyType();
            Type valueType = mapType.getValueType();
            Map map = (Map)object;
            ((MapBlockBuilder)builder).buildEntry((keyBuilder, valueBuilder) -> {
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getKey() == null) continue;
                    TestHiveFileFormats.writeValue(keyType, keyBuilder, entry.getKey());
                    TestHiveFileFormats.writeValue(valueType, valueBuilder, entry.getValue());
                }
            });
        } else if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            List typeParameters = rowType.getTypeParameters();
            List foo = (List)object;
            ((RowBlockBuilder)builder).buildEntry(fieldBuilders -> {
                for (int i = 0; i < typeParameters.size(); ++i) {
                    TestHiveFileFormats.writeValue((Type)typeParameters.get(i), (BlockBuilder)fieldBuilders.get(i), foo.get(i));
                }
            });
        } else {
            throw new RuntimeException("Unsupported type: " + String.valueOf(type));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createTestFileHive(TrinoFileSystemFactory fileSystemFactory, Location location, HiveStorageFormat storageFormat, HiveCompressionCodec compressionCodec, List<TestColumn> testColumns, int numRows) throws Exception {
        HiveOutputFormat outputFormat = TestHiveFileFormats.newInstance(storageFormat.getOutputFormat(), HiveOutputFormat.class);
        Serializer serializer = TestHiveFileFormats.newInstance(storageFormat.getSerde(), Serializer.class);
        testColumns = (List)testColumns.stream().filter(column -> !column.partitionKey()).collect(ImmutableList.toImmutableList());
        Properties tableProperties = new Properties();
        tableProperties.setProperty("columns", testColumns.stream().map(TestColumn::name).collect(Collectors.joining(",")));
        tableProperties.setProperty("columns.types", testColumns.stream().map(testColumn -> HiveTypeTranslator.toHiveType((Type)testColumn.type()).toString()).collect(Collectors.joining(",")));
        serializer.initialize(new Configuration(false), tableProperties);
        JobConf jobConf = new JobConf(false);
        TestHiveFileFormats.configureCompression((Configuration)jobConf, compressionCodec);
        File file = File.createTempFile("trino_test", "data");
        Verify.verify((boolean)file.delete());
        try {
            FileSinkOperator.RecordWriter recordWriter = outputFormat.getHiveRecordWriter(jobConf, new Path(file.getAbsolutePath()), Text.class, compressionCodec != HiveCompressionCodec.NONE, tableProperties, () -> {});
            serializer.initialize(new Configuration(false), tableProperties);
            StandardStructObjectInspector objectInspector = ObjectInspectorFactory.getStandardStructObjectInspector((List)((List)testColumns.stream().map(TestColumn::name).collect(ImmutableList.toImmutableList())), (List)((List)testColumns.stream().map(TestColumn::type).map(TestHiveFileFormats::getJavaObjectInspector).collect(ImmutableList.toImmutableList())));
            Object row = objectInspector.create();
            ImmutableList fields = ImmutableList.copyOf((Collection)objectInspector.getAllStructFieldRefs());
            for (int rowNumber = 0; rowNumber < numRows; ++rowNumber) {
                for (int i = 0; i < testColumns.size(); ++i) {
                    objectInspector.setStructFieldData(row, (StructField)fields.get(i), ((TestColumn)testColumns.get(i)).writeValue());
                }
                Writable record = serializer.serialize(row, (ObjectInspector)objectInspector);
                recordWriter.write(record);
            }
            recordWriter.close(false);
            TrinoFileSystem fileSystem = fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test"));
            try (OutputStream outputStream = fileSystem.newOutputFile(location).create();){
                outputStream.write(Files.readAllBytes(file.toPath()));
            }
        }
        finally {
            Verify.verify((boolean)file.delete());
        }
    }

    private static void configureCompression(Configuration config, HiveCompressionCodec compressionCodec) {
        boolean compression = compressionCodec != HiveCompressionCodec.NONE;
        config.setBoolean(HiveConf.ConfVars.COMPRESSRESULT.varname, compression);
        config.setBoolean("mapred.output.compress", compression);
        config.setBoolean("mapreduce.output.fileoutputformat.compress", compression);
        OrcConf.COMPRESS.setString(config, compressionCodec.getOrcCompressionKind().name());
        if (compressionCodec.getHiveCompressionKind().isPresent()) {
            config.set("mapred.output.compression.codec", ((CompressionKind)compressionCodec.getHiveCompressionKind().get()).getHadoopClassName());
            config.set("mapreduce.output.fileoutputformat.compress.codec", ((CompressionKind)compressionCodec.getHiveCompressionKind().get()).getHadoopClassName());
        } else {
            config.unset("mapred.output.compression.codec");
            config.unset("mapreduce.output.fileoutputformat.compress.codec");
        }
        config.set("parquet.compression", ((CompressionCodec)compressionCodec.getParquetCompressionCodec().orElseThrow()).name());
        compressionCodec.getAvroCompressionKind().ifPresent(kind -> config.set("avro.output.codec", kind.toString()));
        config.set("mapreduce.output.fileoutputformat.compress.type", SequenceFile.CompressionType.BLOCK.toString());
    }

    private static ObjectInspector getJavaObjectInspector(Type type) {
        if (type.equals((Object)BooleanType.BOOLEAN)) {
            return PrimitiveObjectInspectorFactory.javaBooleanObjectInspector;
        }
        if (type.equals((Object)BigintType.BIGINT)) {
            return PrimitiveObjectInspectorFactory.javaLongObjectInspector;
        }
        if (type.equals((Object)IntegerType.INTEGER)) {
            return PrimitiveObjectInspectorFactory.javaIntObjectInspector;
        }
        if (type.equals((Object)SmallintType.SMALLINT)) {
            return PrimitiveObjectInspectorFactory.javaShortObjectInspector;
        }
        if (type.equals((Object)TinyintType.TINYINT)) {
            return PrimitiveObjectInspectorFactory.javaByteObjectInspector;
        }
        if (type.equals((Object)RealType.REAL)) {
            return PrimitiveObjectInspectorFactory.javaFloatObjectInspector;
        }
        if (type.equals((Object)DoubleType.DOUBLE)) {
            return PrimitiveObjectInspectorFactory.javaDoubleObjectInspector;
        }
        if (type instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)type;
            return (ObjectInspector)varcharType.getLength().map(length -> PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new VarcharTypeInfo(length.intValue()))).orElse((AbstractPrimitiveJavaObjectInspector)PrimitiveObjectInspectorFactory.javaStringObjectInspector);
        }
        if (type instanceof CharType) {
            CharType charType = (CharType)type;
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new CharTypeInfo(charType.getLength()));
        }
        if (type.equals((Object)VarbinaryType.VARBINARY)) {
            return PrimitiveObjectInspectorFactory.javaByteArrayObjectInspector;
        }
        if (type.equals((Object)DateType.DATE)) {
            return PrimitiveObjectInspectorFactory.javaDateObjectInspector;
        }
        if (type instanceof TimestampType) {
            return PrimitiveObjectInspectorFactory.javaTimestampObjectInspector;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            return PrimitiveObjectInspectorFactory.getPrimitiveJavaObjectInspector((PrimitiveTypeInfo)new DecimalTypeInfo(decimalType.getPrecision(), decimalType.getScale()));
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            return ObjectInspectorFactory.getStandardListObjectInspector((ObjectInspector)TestHiveFileFormats.getJavaObjectInspector(arrayType.getElementType()));
        }
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            ObjectInspector keyObjectInspector = TestHiveFileFormats.getJavaObjectInspector(mapType.getKeyType());
            ObjectInspector valueObjectInspector = TestHiveFileFormats.getJavaObjectInspector(mapType.getValueType());
            return ObjectInspectorFactory.getStandardMapObjectInspector((ObjectInspector)keyObjectInspector, (ObjectInspector)valueObjectInspector);
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            return ObjectInspectorFactory.getStandardStructObjectInspector(rowType.getFields().stream().map(RowType.Field::getName).map(Optional::orElseThrow).collect(Collectors.toList()), rowType.getFields().stream().map(RowType.Field::getType).map(TestHiveFileFormats::getJavaObjectInspector).collect(Collectors.toList()));
        }
        throw new IllegalArgumentException("unsupported type: " + String.valueOf(type));
    }

    private static <T> T newInstance(String className, Class<T> superType) throws ReflectiveOperationException {
        return HiveStorageFormat.class.getClassLoader().loadClass(className).asSubclass(superType).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static <K, V> Map<K, V> asMap(K[] keys, V[] values) {
        Preconditions.checkArgument((keys.length == values.length ? 1 : 0) != 0, (Object)"array lengths don't match");
        HashMap<K, V> map = new HashMap<K, V>();
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    static {
        char[] varcharMaxLengthCharArray = new char[65535];
        Arrays.fill(varcharMaxLengthCharArray, 'a');
        VARCHAR_MAX_LENGTH_STRING = new String(varcharMaxLengthCharArray);
        HIVE_DATE = Date.of((int)2011, (int)5, (int)6);
        DATE_DAYS = HIVE_DATE.toEpochDay();
        DATE_STRING = HIVE_DATE.toString();
        TIMESTAMP_VALUE = new DateTime(2011, 5, 6, 7, 8, 9, 123, DateTimeZone.UTC);
        TIMESTAMP_MICROS_VALUE = TIMESTAMP_VALUE.getMillis() * 1000L;
        TIMESTAMP_STRING_VALUE = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss.SSS").withZoneUTC().print(TIMESTAMP_VALUE.getMillis());
        HIVE_TIMESTAMP = Timestamp.ofEpochMilli((long)TIMESTAMP_VALUE.getMillis());
        DECIMAL_TYPE_2 = DecimalType.createDecimalType((int)2, (int)1);
        DECIMAL_TYPE_4 = DecimalType.createDecimalType((int)4, (int)2);
        DECIMAL_TYPE_8 = DecimalType.createDecimalType((int)8, (int)4);
        DECIMAL_TYPE_17 = DecimalType.createDecimalType((int)17, (int)8);
        DECIMAL_TYPE_18 = DecimalType.createDecimalType((int)18, (int)8);
        DECIMAL_TYPE_38 = DecimalType.createDecimalType((int)38, (int)16);
        WRITE_DECIMAL_2 = HiveDecimal.create((BigDecimal)new BigDecimal("-1.2"));
        WRITE_DECIMAL_4 = HiveDecimal.create((BigDecimal)new BigDecimal("12.3"));
        WRITE_DECIMAL_8 = HiveDecimal.create((BigDecimal)new BigDecimal("-1234.5678"));
        WRITE_DECIMAL_17 = HiveDecimal.create((BigDecimal)new BigDecimal("123456789.1234"));
        WRITE_DECIMAL_18 = HiveDecimal.create((BigDecimal)new BigDecimal("-1234567890.12345678"));
        WRITE_DECIMAL_38 = HiveDecimal.create((BigDecimal)new BigDecimal("1234567890123456789012.12345678"));
        EXPECTED_DECIMAL_2 = new BigDecimal("-1.2");
        EXPECTED_DECIMAL_4 = new BigDecimal("12.30");
        EXPECTED_DECIMAL_8 = new BigDecimal("-1234.5678");
        EXPECTED_DECIMAL_17 = new BigDecimal("123456789.12340000");
        EXPECTED_DECIMAL_18 = new BigDecimal("-1234567890.12345678");
        EXPECTED_DECIMAL_38 = new BigDecimal("1234567890123456789012.1234567800000000");
        TYPE_OPERATORS = InternalTypeManager.TESTING_TYPE_MANAGER.getTypeOperators();
        TEST_COLUMNS = ImmutableList.builder().add((Object)new TestColumn("p_empty_string", (Type)VarcharType.VARCHAR, "", Slices.EMPTY_SLICE, true)).add((Object)new TestColumn("p_string", (Type)VarcharType.VARCHAR, "test", Slices.utf8Slice((String)"test"), true)).add((Object)new TestColumn("p_empty_varchar", VARCHAR_100, "", Slices.EMPTY_SLICE, true)).add((Object)new TestColumn("p_varchar", VARCHAR_100, "test", Slices.utf8Slice((String)"test"), true)).add((Object)new TestColumn("p_varchar_max_length", VARCHAR_HIVE_MAX, VARCHAR_MAX_LENGTH_STRING, Slices.utf8Slice((String)VARCHAR_MAX_LENGTH_STRING), true)).add((Object)new TestColumn("p_char_10", CHAR_10, "test", Slices.utf8Slice((String)"test"), true)).add((Object)new TestColumn("p_tinyint", (Type)TinyintType.TINYINT, "1", (byte)1, true)).add((Object)new TestColumn("p_smallint", (Type)SmallintType.SMALLINT, "2", (short)2, true)).add((Object)new TestColumn("p_int", (Type)IntegerType.INTEGER, "3", 3, true)).add((Object)new TestColumn("p_bigint", (Type)BigintType.BIGINT, "4", 4L, true)).add((Object)new TestColumn("p_float", (Type)RealType.REAL, "5.1", Float.valueOf(5.1f), true)).add((Object)new TestColumn("p_double", (Type)DoubleType.DOUBLE, "6.2", 6.2, true)).add((Object)new TestColumn("p_boolean", (Type)BooleanType.BOOLEAN, "true", true, true)).add((Object)new TestColumn("p_date", (Type)DateType.DATE, DATE_STRING, DATE_DAYS, true)).add((Object)new TestColumn("p_timestamp", (Type)TimestampType.TIMESTAMP_MILLIS, TIMESTAMP_STRING_VALUE, TIMESTAMP_MICROS_VALUE, true)).add((Object)new TestColumn("p_decimal_2", (Type)DECIMAL_TYPE_2, WRITE_DECIMAL_2.toString(), EXPECTED_DECIMAL_2, true)).add((Object)new TestColumn("p_decimal_4", (Type)DECIMAL_TYPE_4, WRITE_DECIMAL_4.toString(), EXPECTED_DECIMAL_4, true)).add((Object)new TestColumn("p_decimal_8", (Type)DECIMAL_TYPE_8, WRITE_DECIMAL_8.toString(), EXPECTED_DECIMAL_8, true)).add((Object)new TestColumn("p_decimal_17", (Type)DECIMAL_TYPE_17, WRITE_DECIMAL_17.toString(), EXPECTED_DECIMAL_17, true)).add((Object)new TestColumn("p_decimal_18", (Type)DECIMAL_TYPE_18, WRITE_DECIMAL_18.toString(), EXPECTED_DECIMAL_18, true)).add((Object)new TestColumn("p_decimal_38", (Type)DECIMAL_TYPE_38, WRITE_DECIMAL_38.toString() + "BD", EXPECTED_DECIMAL_38, true)).add((Object)new TestColumn("p_null_string", (Type)VarcharType.VARCHAR, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_varchar", VARCHAR_100, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_char", CHAR_10, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_tinyint", (Type)TinyintType.TINYINT, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_smallint", (Type)SmallintType.SMALLINT, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_int", (Type)IntegerType.INTEGER, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_bigint", (Type)BigintType.BIGINT, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_float", (Type)RealType.REAL, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_double", (Type)DoubleType.DOUBLE, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_boolean", (Type)BooleanType.BOOLEAN, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_date", (Type)DateType.DATE, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_timestamp", (Type)TimestampType.TIMESTAMP_MILLIS, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_2", (Type)DECIMAL_TYPE_2, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_4", (Type)DECIMAL_TYPE_4, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_8", (Type)DECIMAL_TYPE_8, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_17", (Type)DECIMAL_TYPE_17, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_18", (Type)DECIMAL_TYPE_18, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("p_null_decimal_38", (Type)DECIMAL_TYPE_38, "__HIVE_DEFAULT_PARTITION__", null, true)).add((Object)new TestColumn("t_null_string", (Type)VarcharType.VARCHAR, null, null)).add((Object)new TestColumn("t_null_varchar", VARCHAR_100, null, null)).add((Object)new TestColumn("t_null_char", CHAR_10, null, null)).add((Object)new TestColumn("t_null_array_int", (Type)new ArrayType((Type)IntegerType.INTEGER), null, null)).add((Object)new TestColumn("t_null_decimal_2", (Type)DECIMAL_TYPE_2, null, null)).add((Object)new TestColumn("t_null_decimal_4", (Type)DECIMAL_TYPE_4, null, null)).add((Object)new TestColumn("t_null_decimal_8", (Type)DECIMAL_TYPE_8, null, null)).add((Object)new TestColumn("t_null_decimal_17", (Type)DECIMAL_TYPE_17, null, null)).add((Object)new TestColumn("t_null_decimal_18", (Type)DECIMAL_TYPE_18, null, null)).add((Object)new TestColumn("t_null_decimal_38", (Type)DECIMAL_TYPE_38, null, null)).add((Object)new TestColumn("t_empty_string", (Type)VarcharType.VARCHAR, "", Slices.EMPTY_SLICE)).add((Object)new TestColumn("t_string", (Type)VarcharType.VARCHAR, "test", Slices.utf8Slice((String)"test"))).add((Object)new TestColumn("t_empty_varchar", VARCHAR_HIVE_MAX, new HiveVarchar("", 65535), Slices.EMPTY_SLICE)).add((Object)new TestColumn("t_varchar", VARCHAR_HIVE_MAX, new HiveVarchar("test", 65535), Slices.utf8Slice((String)"test"))).add((Object)new TestColumn("t_varchar_max_length", VARCHAR_HIVE_MAX, new HiveVarchar(VARCHAR_MAX_LENGTH_STRING, 65535), Slices.utf8Slice((String)VARCHAR_MAX_LENGTH_STRING))).add((Object)new TestColumn("t_char", CHAR_10, "test", Slices.utf8Slice((String)"test"))).add((Object)new TestColumn("t_tinyint", (Type)TinyintType.TINYINT, (byte)1, (byte)1)).add((Object)new TestColumn("t_smallint", (Type)SmallintType.SMALLINT, (short)2, (short)2)).add((Object)new TestColumn("t_int", (Type)IntegerType.INTEGER, 3, 3)).add((Object)new TestColumn("t_bigint", (Type)BigintType.BIGINT, 4L, 4L)).add((Object)new TestColumn("t_float", (Type)RealType.REAL, Float.valueOf(5.1f), Float.valueOf(5.1f))).add((Object)new TestColumn("t_double", (Type)DoubleType.DOUBLE, 6.2, 6.2)).add((Object)new TestColumn("t_boolean_true", (Type)BooleanType.BOOLEAN, true, true)).add((Object)new TestColumn("t_boolean_false", (Type)BooleanType.BOOLEAN, false, false)).add((Object)new TestColumn("t_date", (Type)DateType.DATE, HIVE_DATE, DATE_DAYS)).add((Object)new TestColumn("t_timestamp", (Type)TimestampType.TIMESTAMP_MILLIS, HIVE_TIMESTAMP, TIMESTAMP_MICROS_VALUE)).add((Object)new TestColumn("t_decimal_2", (Type)DECIMAL_TYPE_2, WRITE_DECIMAL_2, EXPECTED_DECIMAL_2)).add((Object)new TestColumn("t_decimal_4", (Type)DECIMAL_TYPE_4, WRITE_DECIMAL_4, EXPECTED_DECIMAL_4)).add((Object)new TestColumn("t_decimal_8", (Type)DECIMAL_TYPE_8, WRITE_DECIMAL_8, EXPECTED_DECIMAL_8)).add((Object)new TestColumn("t_decimal_17", (Type)DECIMAL_TYPE_17, WRITE_DECIMAL_17, EXPECTED_DECIMAL_17)).add((Object)new TestColumn("t_decimal_18", (Type)DECIMAL_TYPE_18, WRITE_DECIMAL_18, EXPECTED_DECIMAL_18)).add((Object)new TestColumn("t_decimal_38", (Type)DECIMAL_TYPE_38, WRITE_DECIMAL_38, EXPECTED_DECIMAL_38)).add((Object)new TestColumn("t_binary", (Type)VarbinaryType.VARBINARY, Slices.utf8Slice((String)"test2").getBytes(), Slices.utf8Slice((String)"test2"))).add((Object)new TestColumn("t_map_string", (Type)new MapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, TYPE_OPERATORS), ImmutableMap.of((Object)"test", (Object)"test"), StructuralTestUtil.sqlMapOf((Type)VarcharType.createUnboundedVarcharType(), (Type)VarcharType.createUnboundedVarcharType(), (Object)"test", (Object)"test"))).add((Object)new TestColumn("t_map_tinyint", (Type)new MapType((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT, TYPE_OPERATORS), ImmutableMap.of((Object)1, (Object)1), StructuralTestUtil.sqlMapOf((Type)TinyintType.TINYINT, (Type)TinyintType.TINYINT, (Object)1, (Object)1))).add((Object)new TestColumn("t_map_varchar", (Type)new MapType(VARCHAR_HIVE_MAX, VARCHAR_HIVE_MAX, TYPE_OPERATORS), ImmutableMap.of((Object)new HiveVarchar("test", 65535), (Object)new HiveVarchar("test", 65535)), StructuralTestUtil.sqlMapOf((Type)VarcharType.createVarcharType((int)65535), (Type)VarcharType.createVarcharType((int)65535), (Object)"test", (Object)"test"))).add((Object)new TestColumn("t_map_char", (Type)new MapType(CHAR_10, CHAR_10, TYPE_OPERATORS), ImmutableMap.of((Object)new HiveChar("test", 10), (Object)new HiveChar("test", 10)), StructuralTestUtil.sqlMapOf((Type)CharType.createCharType((int)10), (Type)CharType.createCharType((int)10), (Object)"test", (Object)"test"))).add((Object)new TestColumn("t_map_smallint", (Type)new MapType((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT, TYPE_OPERATORS), ImmutableMap.of((Object)2, (Object)2), StructuralTestUtil.sqlMapOf((Type)SmallintType.SMALLINT, (Type)SmallintType.SMALLINT, (Object)2, (Object)2))).add((Object)new TestColumn("t_map_null_key", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, TYPE_OPERATORS), TestHiveFileFormats.asMap(new Long[]{null, 2L}, new Long[]{0L, 3L}), StructuralTestUtil.sqlMapOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, (Object)2, (Object)3))).add((Object)new TestColumn("t_map_int", (Type)new MapType((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, TYPE_OPERATORS), ImmutableMap.of((Object)3, (Object)3), StructuralTestUtil.sqlMapOf((Type)IntegerType.INTEGER, (Type)IntegerType.INTEGER, (Object)3, (Object)3))).add((Object)new TestColumn("t_map_bigint", (Type)new MapType((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, TYPE_OPERATORS), ImmutableMap.of((Object)4L, (Object)4L), StructuralTestUtil.sqlMapOf((Type)BigintType.BIGINT, (Type)BigintType.BIGINT, (Object)4L, (Object)4L))).add((Object)new TestColumn("t_map_float", (Type)new MapType((Type)RealType.REAL, (Type)RealType.REAL, TYPE_OPERATORS), ImmutableMap.of((Object)Float.valueOf(5.0f), (Object)Float.valueOf(5.0f)), StructuralTestUtil.sqlMapOf((Type)RealType.REAL, (Type)RealType.REAL, (Object)Float.valueOf(5.0f), (Object)Float.valueOf(5.0f)))).add((Object)new TestColumn("t_map_double", (Type)new MapType((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE, TYPE_OPERATORS), ImmutableMap.of((Object)6.0, (Object)6.0), StructuralTestUtil.sqlMapOf((Type)DoubleType.DOUBLE, (Type)DoubleType.DOUBLE, (Object)6.0, (Object)6.0))).add((Object)new TestColumn("t_map_boolean", (Type)new MapType((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN, TYPE_OPERATORS), ImmutableMap.of((Object)true, (Object)true), StructuralTestUtil.sqlMapOf((Type)BooleanType.BOOLEAN, (Type)BooleanType.BOOLEAN, (Object)true, (Object)true))).add((Object)new TestColumn("t_map_date", (Type)new MapType((Type)DateType.DATE, (Type)DateType.DATE, TYPE_OPERATORS), ImmutableMap.of((Object)HIVE_DATE, (Object)HIVE_DATE), StructuralTestUtil.sqlMapOf((Type)DateType.DATE, (Type)DateType.DATE, (Object)DATE_DAYS, (Object)DATE_DAYS))).add((Object)new TestColumn("t_map_timestamp", (Type)new MapType((Type)TimestampType.TIMESTAMP_MILLIS, (Type)TimestampType.TIMESTAMP_MILLIS, TYPE_OPERATORS), ImmutableMap.of((Object)HIVE_TIMESTAMP, (Object)HIVE_TIMESTAMP), StructuralTestUtil.sqlMapOf((Type)TimestampType.TIMESTAMP_MILLIS, (Type)TimestampType.TIMESTAMP_MILLIS, (Object)TIMESTAMP_MICROS_VALUE, (Object)TIMESTAMP_MICROS_VALUE))).add((Object)new TestColumn("t_map_decimal_2", (Type)new MapType((Type)DECIMAL_TYPE_2, (Type)DECIMAL_TYPE_2, TYPE_OPERATORS), ImmutableMap.of((Object)WRITE_DECIMAL_2, (Object)WRITE_DECIMAL_2), StructuralTestUtil.decimalSqlMapOf((DecimalType)DECIMAL_TYPE_2, (BigDecimal)EXPECTED_DECIMAL_2))).add((Object)new TestColumn("t_map_decimal_4", (Type)new MapType((Type)DECIMAL_TYPE_4, (Type)DECIMAL_TYPE_4, TYPE_OPERATORS), ImmutableMap.of((Object)WRITE_DECIMAL_4, (Object)WRITE_DECIMAL_4), StructuralTestUtil.decimalSqlMapOf((DecimalType)DECIMAL_TYPE_4, (BigDecimal)EXPECTED_DECIMAL_4))).add((Object)new TestColumn("t_map_decimal_8", (Type)new MapType((Type)DECIMAL_TYPE_8, (Type)DECIMAL_TYPE_8, TYPE_OPERATORS), ImmutableMap.of((Object)WRITE_DECIMAL_8, (Object)WRITE_DECIMAL_8), StructuralTestUtil.decimalSqlMapOf((DecimalType)DECIMAL_TYPE_8, (BigDecimal)EXPECTED_DECIMAL_8))).add((Object)new TestColumn("t_map_decimal_17", (Type)new MapType((Type)DECIMAL_TYPE_17, (Type)DECIMAL_TYPE_17, TYPE_OPERATORS), ImmutableMap.of((Object)WRITE_DECIMAL_17, (Object)WRITE_DECIMAL_17), StructuralTestUtil.decimalSqlMapOf((DecimalType)DECIMAL_TYPE_17, (BigDecimal)EXPECTED_DECIMAL_17))).add((Object)new TestColumn("t_map_decimal_18", (Type)new MapType((Type)DECIMAL_TYPE_18, (Type)DECIMAL_TYPE_18, TYPE_OPERATORS), ImmutableMap.of((Object)WRITE_DECIMAL_18, (Object)WRITE_DECIMAL_18), StructuralTestUtil.decimalSqlMapOf((DecimalType)DECIMAL_TYPE_18, (BigDecimal)EXPECTED_DECIMAL_18))).add((Object)new TestColumn("t_map_decimal_38", (Type)new MapType((Type)DECIMAL_TYPE_38, (Type)DECIMAL_TYPE_38, TYPE_OPERATORS), ImmutableMap.of((Object)WRITE_DECIMAL_38, (Object)WRITE_DECIMAL_38), StructuralTestUtil.decimalSqlMapOf((DecimalType)DECIMAL_TYPE_38, (BigDecimal)EXPECTED_DECIMAL_38))).add((Object)new TestColumn("t_array_empty", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of(), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[0]))).add((Object)new TestColumn("t_array_string", (Type)new ArrayType((Type)VarcharType.VARCHAR), ImmutableList.of((Object)"test"), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"test"}))).add((Object)new TestColumn("t_array_tinyint", (Type)new ArrayType((Type)TinyintType.TINYINT), ImmutableList.of((Object)1), StructuralTestUtil.arrayBlockOf((Type)TinyintType.TINYINT, (Object[])new Object[]{(byte)1}))).add((Object)new TestColumn("t_array_smallint", (Type)new ArrayType((Type)SmallintType.SMALLINT), ImmutableList.of((Object)2), StructuralTestUtil.arrayBlockOf((Type)SmallintType.SMALLINT, (Object[])new Object[]{(short)2}))).add((Object)new TestColumn("t_array_int", (Type)new ArrayType((Type)IntegerType.INTEGER), ImmutableList.of((Object)3), StructuralTestUtil.arrayBlockOf((Type)IntegerType.INTEGER, (Object[])new Object[]{3}))).add((Object)new TestColumn("t_array_bigint", (Type)new ArrayType((Type)BigintType.BIGINT), ImmutableList.of((Object)4L), StructuralTestUtil.arrayBlockOf((Type)BigintType.BIGINT, (Object[])new Object[]{4L}))).add((Object)new TestColumn("t_array_float", (Type)new ArrayType((Type)RealType.REAL), ImmutableList.of((Object)Float.valueOf(5.0f)), StructuralTestUtil.arrayBlockOf((Type)RealType.REAL, (Object[])new Object[]{Float.valueOf(5.0f)}))).add((Object)new TestColumn("t_array_double", (Type)new ArrayType((Type)DoubleType.DOUBLE), ImmutableList.of((Object)6.0), StructuralTestUtil.arrayBlockOf((Type)DoubleType.DOUBLE, (Object[])new Object[]{6.0}))).add((Object)new TestColumn("t_array_boolean", (Type)new ArrayType((Type)BooleanType.BOOLEAN), ImmutableList.of((Object)true), StructuralTestUtil.arrayBlockOf((Type)BooleanType.BOOLEAN, (Object[])new Object[]{true}))).add((Object)new TestColumn("t_array_varchar", (Type)new ArrayType(VARCHAR_HIVE_MAX), ImmutableList.of((Object)new HiveVarchar("test", 65535)), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createVarcharType((int)65535), (Object[])new Object[]{"test"}))).add((Object)new TestColumn("t_array_char", (Type)new ArrayType(CHAR_10), ImmutableList.of((Object)new HiveChar("test", 10)), StructuralTestUtil.arrayBlockOf((Type)CharType.createCharType((int)10), (Object[])new Object[]{"test"}))).add((Object)new TestColumn("t_array_date", (Type)new ArrayType((Type)DateType.DATE), ImmutableList.of((Object)HIVE_DATE), StructuralTestUtil.arrayBlockOf((Type)DateType.DATE, (Object[])new Object[]{DATE_DAYS}))).add((Object)new TestColumn("t_array_timestamp", (Type)new ArrayType((Type)TimestampType.TIMESTAMP_MILLIS), ImmutableList.of((Object)HIVE_TIMESTAMP), StructuralTestUtil.arrayBlockOf((Type)TimestampType.TIMESTAMP_MILLIS, (Object[])new Object[]{TIMESTAMP_MICROS_VALUE}))).add((Object)new TestColumn("t_array_decimal_2", (Type)new ArrayType((Type)DECIMAL_TYPE_2), ImmutableList.of((Object)WRITE_DECIMAL_2), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_2, (BigDecimal)EXPECTED_DECIMAL_2))).add((Object)new TestColumn("t_array_decimal_4", (Type)new ArrayType((Type)DECIMAL_TYPE_4), ImmutableList.of((Object)WRITE_DECIMAL_4), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_4, (BigDecimal)EXPECTED_DECIMAL_4))).add((Object)new TestColumn("t_array_decimal_8", (Type)new ArrayType((Type)DECIMAL_TYPE_8), ImmutableList.of((Object)WRITE_DECIMAL_8), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_8, (BigDecimal)EXPECTED_DECIMAL_8))).add((Object)new TestColumn("t_array_decimal_17", (Type)new ArrayType((Type)DECIMAL_TYPE_17), ImmutableList.of((Object)WRITE_DECIMAL_17), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_17, (BigDecimal)EXPECTED_DECIMAL_17))).add((Object)new TestColumn("t_array_decimal_18", (Type)new ArrayType((Type)DECIMAL_TYPE_18), ImmutableList.of((Object)WRITE_DECIMAL_18), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_18, (BigDecimal)EXPECTED_DECIMAL_18))).add((Object)new TestColumn("t_array_decimal_38", (Type)new ArrayType((Type)DECIMAL_TYPE_38), ImmutableList.of((Object)WRITE_DECIMAL_38), StructuralTestUtil.decimalArrayBlockOf((DecimalType)DECIMAL_TYPE_38, (BigDecimal)EXPECTED_DECIMAL_38))).add((Object)new TestColumn("t_struct_bigint", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"s_bigint", (Type)BigintType.BIGINT)}), ImmutableList.of((Object)1L), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)BigintType.BIGINT), (Object[])new Object[]{1}))).add((Object)new TestColumn("t_complex", (Type)new MapType((Type)VarcharType.VARCHAR, (Type)new ArrayType((Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"s_int", (Type)IntegerType.INTEGER)})), TYPE_OPERATORS), ImmutableMap.of((Object)"test", (Object)ImmutableList.of((Object)ImmutableList.of((Object)1))), StructuralTestUtil.sqlMapOf((Type)VarcharType.createUnboundedVarcharType(), (Type)new ArrayType((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER))), (Object)"test", (Object)StructuralTestUtil.arrayBlockOf((Type)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER)), (Object[])new Object[]{StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER), (Object[])new Object[]{1L})})))).add((Object)new TestColumn("t_map_null_key_complex_value", (Type)new MapType((Type)VarcharType.VARCHAR, (Type)new MapType((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN, TYPE_OPERATORS), TYPE_OPERATORS), TestHiveFileFormats.asMap(new String[]{null, "k"}, new ImmutableMap[]{ImmutableMap.of((Object)15L, (Object)true), ImmutableMap.of((Object)16L, (Object)false)}), StructuralTestUtil.sqlMapOf((Type)VarcharType.createUnboundedVarcharType(), (Type)HiveTestUtils.mapType((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN), (Object)"k", (Object)StructuralTestUtil.sqlMapOf((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN, (Object)16L, (Object)false)))).add((Object)new TestColumn("t_map_null_key_complex_key_value", (Type)new MapType((Type)new ArrayType((Type)VarcharType.VARCHAR), (Type)new MapType((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN, TYPE_OPERATORS), TYPE_OPERATORS), TestHiveFileFormats.asMap(new ImmutableList[]{null, ImmutableList.of((Object)"k", (Object)"ka")}, new ImmutableMap[]{ImmutableMap.of((Object)15L, (Object)true), ImmutableMap.of((Object)16L, (Object)false)}), StructuralTestUtil.sqlMapOf((Type)new ArrayType((Type)VarcharType.createUnboundedVarcharType()), (Type)HiveTestUtils.mapType((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN), (Object)StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"k", "ka"}), (Object)StructuralTestUtil.sqlMapOf((Type)BigintType.BIGINT, (Type)BooleanType.BOOLEAN, (Object)16L, (Object)false)))).add((Object)new TestColumn("t_struct_nested", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"struct_field", (Type)new ArrayType((Type)VarcharType.VARCHAR))}), ImmutableList.of((Object)ImmutableList.of((Object)"1", (Object)"2", (Object)"3")), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)new ArrayType((Type)VarcharType.createUnboundedVarcharType())), (Object[])new Object[]{StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"1", "2", "3"})}))).add((Object)new TestColumn("t_struct_null", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"struct_field_null", (Type)VarcharType.VARCHAR), RowType.field((String)"struct_field_null2", (Type)VarcharType.VARCHAR)}), Arrays.asList(null, null), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)VarcharType.createUnboundedVarcharType(), (Object)VarcharType.createUnboundedVarcharType()), (Object[])new Object[]{null, null}))).add((Object)new TestColumn("t_struct_non_nulls_after_nulls", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"struct_non_nulls_after_nulls1", (Type)IntegerType.INTEGER), RowType.field((String)"struct_non_nulls_after_nulls2", (Type)VarcharType.VARCHAR)}), Arrays.asList(null, "some string"), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createUnboundedVarcharType()), (Object[])new Object[]{null, "some string"}))).add((Object)new TestColumn("t_nested_struct_non_nulls_after_nulls", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"struct_field1", (Type)IntegerType.INTEGER), RowType.field((String)"struct_field2", (Type)VarcharType.VARCHAR), RowType.field((String)"strict_field3", (Type)RowType.rowType((RowType.Field[])new RowType.Field[]{RowType.field((String)"nested_struct_field1", (Type)IntegerType.INTEGER), RowType.field((String)"nested_struct_field2", (Type)VarcharType.VARCHAR)}))}), Arrays.asList(null, "some string", Arrays.asList(null, "nested_string2")), StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createUnboundedVarcharType(), (Object)RowType.anonymous((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createUnboundedVarcharType()))), (Object[])new Object[]{null, "some string", StructuralTestUtil.rowBlockOf((List)ImmutableList.of((Object)IntegerType.INTEGER, (Object)VarcharType.createUnboundedVarcharType()), (Object[])new Object[]{null, "nested_string2"})}))).add((Object)new TestColumn("t_map_null_value", (Type)new MapType((Type)VarcharType.VARCHAR, (Type)VarcharType.VARCHAR, TYPE_OPERATORS), TestHiveFileFormats.asMap(new String[]{"k1", "k2", "k3"}, new String[]{"v1", null, "v3"}), StructuralTestUtil.sqlMapOf((Type)VarcharType.createUnboundedVarcharType(), (Type)VarcharType.createUnboundedVarcharType(), (Object[])new String[]{"k1", "k2", "k3"}, (Object[])new String[]{"v1", null, "v3"}))).add((Object)new TestColumn("t_array_string_starting_with_nulls", (Type)new ArrayType((Type)VarcharType.VARCHAR), Arrays.asList(null, "test"), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{null, "test"}))).add((Object)new TestColumn("t_array_string_with_nulls_in_between", (Type)new ArrayType((Type)VarcharType.VARCHAR), Arrays.asList("test-1", null, "test-2"), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"test-1", null, "test-2"}))).add((Object)new TestColumn("t_array_string_ending_with_nulls", (Type)new ArrayType((Type)VarcharType.VARCHAR), Arrays.asList("test", null), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{"test", null}))).add((Object)new TestColumn("t_array_string_all_nulls", (Type)new ArrayType((Type)VarcharType.VARCHAR), Arrays.asList(null, null, null), StructuralTestUtil.arrayBlockOf((Type)VarcharType.createUnboundedVarcharType(), (Object[])new Object[]{null, null, null}))).build();
    }

    private static class FileFormatAssertion {
        private final String formatName;
        private HiveStorageFormat storageFormat;
        private HiveCompressionCodec compressionCodec = HiveCompressionCodec.NONE;
        private List<TestColumn> writeColumns;
        private List<TestColumn> readColumns;
        private ConnectorSession session = HiveTestUtils.SESSION;
        private int rowsCount = 1000;
        private boolean skipGenericWrite;
        private HiveFileWriterFactory fileWriterFactory;
        private long fileSizePadding;
        private final TrinoFileSystemFactory fileSystemFactory = new MemoryFileSystemFactory();

        private FileFormatAssertion(String formatName) {
            this.formatName = Objects.requireNonNull(formatName, "formatName is null");
        }

        public FileFormatAssertion withStorageFormat(HiveStorageFormat storageFormat) {
            this.storageFormat = Objects.requireNonNull(storageFormat, "storageFormat is null");
            return this;
        }

        public FileFormatAssertion withCompressionCodec(HiveCompressionCodec compressionCodec) {
            this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
            return this;
        }

        public FileFormatAssertion withSkipGenericWriterTest() {
            this.skipGenericWrite = true;
            return this;
        }

        public FileFormatAssertion withFileWriterFactory(Function<TrinoFileSystemFactory, HiveFileWriterFactory> fileWriterFactoryBuilder) {
            this.fileWriterFactory = fileWriterFactoryBuilder.apply(this.fileSystemFactory);
            return this;
        }

        public FileFormatAssertion withColumns(List<TestColumn> inputColumns) {
            this.withWriteColumns(inputColumns);
            this.withReadColumns(inputColumns);
            return this;
        }

        public FileFormatAssertion withWriteColumns(List<TestColumn> writeColumns) {
            this.writeColumns = Objects.requireNonNull(writeColumns, "writeColumns is null");
            return this;
        }

        public FileFormatAssertion withReadColumns(List<TestColumn> readColumns) {
            this.readColumns = Objects.requireNonNull(readColumns, "readColumns is null");
            return this;
        }

        public FileFormatAssertion withRowsCount(int rowsCount) {
            this.rowsCount = rowsCount;
            return this;
        }

        public FileFormatAssertion withSession(ConnectorSession session) {
            this.session = Objects.requireNonNull(session, "session is null");
            return this;
        }

        public FileFormatAssertion withFileSizePadding(long fileSizePadding) {
            this.fileSizePadding = fileSizePadding;
            return this;
        }

        public FileFormatAssertion isReadableByPageSource(Function<TrinoFileSystemFactory, HivePageSourceFactory> pageSourceFactoryBuilder) throws Exception {
            this.assertRead(pageSourceFactoryBuilder.apply(this.fileSystemFactory));
            return this;
        }

        public void isFailingForPageSource(Function<TrinoFileSystemFactory, HivePageSourceFactory> pageSourceFactoryBuilder, HiveErrorCode expectedErrorCode, String expectedMessage) {
            HivePageSourceFactory pageSourceFactory = pageSourceFactoryBuilder.apply(this.fileSystemFactory);
            TrinoExceptionAssert.assertTrinoExceptionThrownBy(() -> this.assertRead(pageSourceFactory)).hasErrorCode(new ErrorCodeSupplier[]{expectedErrorCode}).hasMessage(expectedMessage);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void assertRead(HivePageSourceFactory pageSourceFactory) throws Exception {
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)this.storageFormat).describedAs("storageFormat must be specified", new Object[0])).isNotNull();
            ((ListAssert)Assertions.assertThat(this.writeColumns).describedAs("writeColumns must be specified", new Object[0])).isNotNull();
            ((ListAssert)Assertions.assertThat(this.readColumns).describedAs("readColumns must be specified", new Object[0])).isNotNull();
            ((ObjectAssert)Assertions.assertThat((Object)this.session).describedAs("session must be specified", new Object[0])).isNotNull();
            ((AbstractBooleanAssert)Assertions.assertThat((this.rowsCount >= 0 ? 1 : 0) != 0).describedAs("rowsCount must be non-negative", new Object[0])).isTrue();
            String compressionSuffix = this.compressionCodec.getHiveCompressionKind().map(CompressionKind::getFileExtension).orElse("");
            Location location = Location.of((String)"memory:///%s-test%s".formatted(this.formatName, compressionSuffix));
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(ConnectorIdentity.ofUser((String)"test"));
            UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)false, (Object)true).iterator();
            while (unmodifiableIterator.hasNext()) {
                boolean testFileWriter = (Boolean)unmodifiableIterator.next();
                try {
                    if (testFileWriter) {
                        if (this.fileWriterFactory == null) continue;
                        TestHiveFileFormats.createTestFileTrino(location, this.storageFormat, this.compressionCodec, this.writeColumns, this.session, this.rowsCount, this.fileWriterFactory);
                    } else {
                        if (this.skipGenericWrite) continue;
                        TestHiveFileFormats.createTestFileHive(this.fileSystemFactory, location, this.storageFormat, this.compressionCodec, this.writeColumns, this.rowsCount);
                    }
                    long fileSize = fileSystem.newInputFile(location).length();
                    TestHiveFileFormats.testPageSourceFactory(pageSourceFactory, location, this.storageFormat, this.readColumns, this.session, fileSize, fileSize + this.fileSizePadding, this.rowsCount);
                }
                finally {
                    try {
                        fileSystem.deleteFile(location);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public record TestColumn(String name, Type type, String baseName, Type baseType, boolean dereference, Object writeValue, Object expectedValue, boolean partitionKey) {
        public TestColumn(String name, Type type, Object writeValue, Object expectedValue) {
            this(name, type, writeValue, expectedValue, false);
        }

        public TestColumn(String name, Type type, Object writeValue, Object expectedValue, boolean partitionKey) {
            this(name, type, name, type, false, writeValue, expectedValue, partitionKey);
        }

        public TestColumn {
            Objects.requireNonNull(name, "name is null");
            Objects.requireNonNull(type, "type is null");
            Objects.requireNonNull(baseName, "baseName is null");
            Objects.requireNonNull(baseType, "baseType is null");
        }

        public HiveColumnHandle toHiveColumnHandle(int columnIndex) {
            Preconditions.checkArgument((this.partitionKey == (columnIndex == -1) ? 1 : 0) != 0);
            if (!this.dereference) {
                return HiveColumnHandle.createBaseColumn((String)this.name, (int)columnIndex, (HiveType)HiveTypeTranslator.toHiveType((Type)this.type), (Type)this.type, (HiveColumnHandle.ColumnType)(this.partitionKey ? HiveColumnHandle.ColumnType.PARTITION_KEY : HiveColumnHandle.ColumnType.REGULAR), Optional.empty());
            }
            return new HiveColumnHandle(this.baseName, columnIndex, HiveTypeTranslator.toHiveType((Type)this.baseType), this.baseType, Optional.of(new HiveColumnProjectionInfo((List)ImmutableList.of((Object)0), (List)ImmutableList.of((Object)this.name), HiveTypeTranslator.toHiveType((Type)this.type), this.type)), this.partitionKey ? HiveColumnHandle.ColumnType.PARTITION_KEY : HiveColumnHandle.ColumnType.REGULAR, Optional.empty());
        }

        public TestColumn withDereferenceFirstField(Object writeValue, Object expectedValue) {
            Verify.verify((!this.partitionKey ? 1 : 0) != 0, (String)"dereference not supported for partition key", (Object[])new Object[0]);
            Verify.verify((!this.dereference ? 1 : 0) != 0, (String)"already dereference", (Object[])new Object[0]);
            Type type = this.type;
            if (!(type instanceof RowType)) {
                throw new VerifyException("type is not a row type");
            }
            RowType rowType = (RowType)type;
            RowType.Field field = (RowType.Field)rowType.getFields().get(0);
            return new TestColumn((String)field.getName().orElseThrow(), field.getType(), this.name, this.type, true, writeValue, expectedValue, false);
        }

        public TestColumn withName(String newName) {
            return new TestColumn(newName, this.type, this.baseName, this.baseType, this.dereference, this.writeValue, this.expectedValue, this.partitionKey);
        }
    }
}

